/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.junit.jupiter.api.Test;

public class WebSocketCloseStatusTest {
    private final List<WebSocketCloseStatus> validCodes = Arrays.asList(WebSocketCloseStatus.NORMAL_CLOSURE, WebSocketCloseStatus.ENDPOINT_UNAVAILABLE, WebSocketCloseStatus.PROTOCOL_ERROR, WebSocketCloseStatus.INVALID_MESSAGE_TYPE, WebSocketCloseStatus.INVALID_PAYLOAD_DATA, WebSocketCloseStatus.POLICY_VIOLATION, WebSocketCloseStatus.MESSAGE_TOO_BIG, WebSocketCloseStatus.MANDATORY_EXTENSION, WebSocketCloseStatus.INTERNAL_SERVER_ERROR, WebSocketCloseStatus.SERVICE_RESTART, WebSocketCloseStatus.TRY_AGAIN_LATER, WebSocketCloseStatus.BAD_GATEWAY);

    @Test
    public void testToString() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1000 Bye", (Object)WebSocketCloseStatus.NORMAL_CLOSURE.toString());
    }

    @Test
    public void testKnownStatuses() {
        org.junit.jupiter.api.Assertions.assertSame((Object)WebSocketCloseStatus.NORMAL_CLOSURE, (Object)WebSocketCloseStatus.valueOf((int)1000));
        org.junit.jupiter.api.Assertions.assertSame((Object)WebSocketCloseStatus.ENDPOINT_UNAVAILABLE, (Object)WebSocketCloseStatus.valueOf((int)1001));
        org.junit.jupiter.api.Assertions.assertSame((Object)WebSocketCloseStatus.PROTOCOL_ERROR, (Object)WebSocketCloseStatus.valueOf((int)1002));
        org.junit.jupiter.api.Assertions.assertSame((Object)WebSocketCloseStatus.INVALID_MESSAGE_TYPE, (Object)WebSocketCloseStatus.valueOf((int)1003));
        org.junit.jupiter.api.Assertions.assertSame((Object)WebSocketCloseStatus.EMPTY, (Object)WebSocketCloseStatus.valueOf((int)1005));
        org.junit.jupiter.api.Assertions.assertSame((Object)WebSocketCloseStatus.ABNORMAL_CLOSURE, (Object)WebSocketCloseStatus.valueOf((int)1006));
        org.junit.jupiter.api.Assertions.assertSame((Object)WebSocketCloseStatus.INVALID_PAYLOAD_DATA, (Object)WebSocketCloseStatus.valueOf((int)1007));
        org.junit.jupiter.api.Assertions.assertSame((Object)WebSocketCloseStatus.POLICY_VIOLATION, (Object)WebSocketCloseStatus.valueOf((int)1008));
        org.junit.jupiter.api.Assertions.assertSame((Object)WebSocketCloseStatus.MESSAGE_TOO_BIG, (Object)WebSocketCloseStatus.valueOf((int)1009));
        org.junit.jupiter.api.Assertions.assertSame((Object)WebSocketCloseStatus.MANDATORY_EXTENSION, (Object)WebSocketCloseStatus.valueOf((int)1010));
        org.junit.jupiter.api.Assertions.assertSame((Object)WebSocketCloseStatus.INTERNAL_SERVER_ERROR, (Object)WebSocketCloseStatus.valueOf((int)1011));
        org.junit.jupiter.api.Assertions.assertSame((Object)WebSocketCloseStatus.SERVICE_RESTART, (Object)WebSocketCloseStatus.valueOf((int)1012));
        org.junit.jupiter.api.Assertions.assertSame((Object)WebSocketCloseStatus.TRY_AGAIN_LATER, (Object)WebSocketCloseStatus.valueOf((int)1013));
        org.junit.jupiter.api.Assertions.assertSame((Object)WebSocketCloseStatus.BAD_GATEWAY, (Object)WebSocketCloseStatus.valueOf((int)1014));
        org.junit.jupiter.api.Assertions.assertSame((Object)WebSocketCloseStatus.TLS_HANDSHAKE_FAILED, (Object)WebSocketCloseStatus.valueOf((int)1015));
    }

    @Test
    public void testNaturalOrder() {
        Assertions.assertThat((Comparable)WebSocketCloseStatus.PROTOCOL_ERROR).isGreaterThan((Comparable)WebSocketCloseStatus.NORMAL_CLOSURE);
        Assertions.assertThat((Comparable)WebSocketCloseStatus.PROTOCOL_ERROR).isGreaterThan((Comparable)WebSocketCloseStatus.valueOf((int)1001));
        org.junit.jupiter.api.Assertions.assertEquals((Object)WebSocketCloseStatus.PROTOCOL_ERROR, (Object)WebSocketCloseStatus.valueOf((int)1002));
        Assertions.assertThat((Comparable)WebSocketCloseStatus.PROTOCOL_ERROR).isLessThan((Comparable)WebSocketCloseStatus.INVALID_MESSAGE_TYPE);
        Assertions.assertThat((Comparable)WebSocketCloseStatus.PROTOCOL_ERROR).isLessThan((Comparable)WebSocketCloseStatus.valueOf((int)1007));
    }

    @Test
    public void testUserDefinedStatuses() {
        WebSocketCloseStatus feedTimeot = new WebSocketCloseStatus(6033, "Feed timed out");
        WebSocketCloseStatus untradablePrice = new WebSocketCloseStatus(6034, "Untradable price");
        org.junit.jupiter.api.Assertions.assertNotSame((Object)feedTimeot, (Object)WebSocketCloseStatus.valueOf((int)6033));
        org.junit.jupiter.api.Assertions.assertEquals((int)feedTimeot.code(), (int)6033);
        org.junit.jupiter.api.Assertions.assertEquals((Object)feedTimeot.reasonText(), (Object)"Feed timed out");
        org.junit.jupiter.api.Assertions.assertNotSame((Object)untradablePrice, (Object)WebSocketCloseStatus.valueOf((int)6034));
        org.junit.jupiter.api.Assertions.assertEquals((int)untradablePrice.code(), (int)6034);
        org.junit.jupiter.api.Assertions.assertEquals((Object)untradablePrice.reasonText(), (Object)"Untradable price");
    }

    @Test
    public void testRfc6455CodeValidation() {
        List<Integer> knownCodes = Arrays.asList(WebSocketCloseStatus.NORMAL_CLOSURE.code(), WebSocketCloseStatus.ENDPOINT_UNAVAILABLE.code(), WebSocketCloseStatus.PROTOCOL_ERROR.code(), WebSocketCloseStatus.INVALID_MESSAGE_TYPE.code(), WebSocketCloseStatus.INVALID_PAYLOAD_DATA.code(), WebSocketCloseStatus.POLICY_VIOLATION.code(), WebSocketCloseStatus.MESSAGE_TOO_BIG.code(), WebSocketCloseStatus.MANDATORY_EXTENSION.code(), WebSocketCloseStatus.INTERNAL_SERVER_ERROR.code(), WebSocketCloseStatus.SERVICE_RESTART.code(), WebSocketCloseStatus.TRY_AGAIN_LATER.code(), WebSocketCloseStatus.BAD_GATEWAY.code());
        TreeSet<Integer> invalidCodes = new TreeSet<Integer>();
        for (int statusCode = Short.MIN_VALUE; statusCode < Short.MAX_VALUE; ++statusCode) {
            if (WebSocketCloseStatus.isValidStatusCode((int)statusCode)) continue;
            invalidCodes.add(statusCode);
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)((Integer)invalidCodes.first()));
        org.junit.jupiter.api.Assertions.assertEquals((int)2999, (int)((Integer)invalidCodes.last()));
        org.junit.jupiter.api.Assertions.assertEquals((int)(3000 - this.validCodes.size()), (int)invalidCodes.size());
        invalidCodes.retainAll(knownCodes);
        org.junit.jupiter.api.Assertions.assertEquals(invalidCodes, Collections.emptySet());
    }

    @Test
    public void testValidationEnabled() {
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(new ThrowableAssert.ThrowingCallable(){

            public void call() throws RuntimeException {
                new WebSocketCloseStatus(1006, "validation disabled");
            }
        });
    }

    @Test
    public void testValidationDisabled() {
        WebSocketCloseStatus status = new WebSocketCloseStatus(1006, "validation disabled", false);
        org.junit.jupiter.api.Assertions.assertEquals((int)1006, (int)status.code());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"validation disabled", (Object)status.reasonText());
    }
}

