/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.multipart;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.multipart.AbstractMemoryHttpData;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.PlatformDependent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AbstractMemoryHttpDataTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetContentFromFile() throws Exception {
        TestHttpData test = new TestHttpData("test", CharsetUtil.UTF_8, 0L);
        try {
            File tmpFile = PlatformDependent.createTempFile((String)UUID.randomUUID().toString(), (String)".tmp", null);
            tmpFile.deleteOnExit();
            FileOutputStream fos = new FileOutputStream(tmpFile);
            byte[] bytes = new byte[4096];
            ThreadLocalRandom.current().nextBytes(bytes);
            try {
                fos.write(bytes);
                fos.flush();
            }
            finally {
                fos.close();
            }
            test.setContent(tmpFile);
            ByteBuf buf = test.getByteBuf();
            Assertions.assertEquals((int)buf.readerIndex(), (int)0);
            Assertions.assertEquals((int)buf.writerIndex(), (int)bytes.length);
            Assertions.assertArrayEquals((byte[])bytes, (byte[])test.get());
            Assertions.assertArrayEquals((byte[])bytes, (byte[])ByteBufUtil.getBytes((ByteBuf)buf));
        }
        finally {
            test.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenameTo() throws Exception {
        TestHttpData test = new TestHttpData("test", CharsetUtil.UTF_8, 0L);
        try {
            File tmpFile = PlatformDependent.createTempFile((String)UUID.randomUUID().toString(), (String)".tmp", null);
            tmpFile.deleteOnExit();
            int totalByteCount = 4096;
            byte[] bytes = new byte[4096];
            ThreadLocalRandom.current().nextBytes(bytes);
            ByteBuf content = Unpooled.wrappedBuffer((byte[])bytes);
            test.setContent(content);
            boolean succ = test.renameTo(tmpFile);
            Assertions.assertTrue((boolean)succ);
            try (FileInputStream fis = new FileInputStream(tmpFile);){
                byte[] buf = new byte[4096];
                int count = 0;
                int offset = 0;
                int size = 4096;
                while ((count = fis.read(buf, offset, size)) > 0 && (offset += count) < 4096 && (size -= count) > 0) {
                }
                Assertions.assertArrayEquals((byte[])bytes, (byte[])buf);
                Assertions.assertEquals((int)0, (int)fis.available());
            }
        }
        finally {
            test.delete();
        }
    }

    @Test
    public void testSetContentFromStream() throws Exception {
        TestHttpData test = new TestHttpData("test", CharsetUtil.UTF_8, 0L);
        String contentStr = "foo_test";
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])contentStr.getBytes(CharsetUtil.UTF_8));
        buf.markReaderIndex();
        try (ByteBufInputStream is = new ByteBufInputStream(buf);){
            test.setContent((InputStream)is);
            Assertions.assertFalse((boolean)buf.isReadable());
            Assertions.assertEquals((Object)contentStr, (Object)test.getString(CharsetUtil.UTF_8));
            buf.resetReaderIndex();
            Assertions.assertTrue((boolean)ByteBufUtil.equals((ByteBuf)buf, (ByteBuf)test.getByteBuf()));
        }
        SecureRandom random = new SecureRandom();
        for (int i = 0; i < 20; ++i) {
            int size = random.nextInt(Short.MAX_VALUE);
            byte[] bytes = new byte[size];
            ((Random)random).nextBytes(bytes);
            TestHttpData data = new TestHttpData("name", CharsetUtil.UTF_8, 0L);
            data.setContent(new ByteArrayInputStream(bytes));
            ByteBuf buffer = data.getByteBuf();
            Assertions.assertEquals((int)0, (int)buffer.readerIndex());
            Assertions.assertEquals((int)bytes.length, (int)buffer.writerIndex());
            Assertions.assertArrayEquals((byte[])bytes, (byte[])Arrays.copyOf(buffer.array(), bytes.length));
            Assertions.assertArrayEquals((byte[])bytes, (byte[])data.get());
        }
    }

    private static final class TestHttpData
    extends AbstractMemoryHttpData {
        private TestHttpData(String name, Charset charset, long size) {
            super(name, charset, size);
        }

        public InterfaceHttpData.HttpDataType getHttpDataType() {
            throw TestHttpData.reject();
        }

        public HttpData copy() {
            throw TestHttpData.reject();
        }

        public HttpData duplicate() {
            throw TestHttpData.reject();
        }

        public HttpData retainedDuplicate() {
            throw TestHttpData.reject();
        }

        public HttpData replace(ByteBuf content) {
            return null;
        }

        public int compareTo(InterfaceHttpData o) {
            throw TestHttpData.reject();
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        private static UnsupportedOperationException reject() {
            throw new UnsupportedOperationException("Should never be called.");
        }
    }
}

