/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.multipart;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.http.multipart.AbstractDiskHttpData;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.PlatformDependent;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AbstractDiskHttpDataTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetChunk() throws Exception {
        TestHttpData test = new TestHttpData("test", CharsetUtil.UTF_8, 0L);
        try {
            File tmpFile = PlatformDependent.createTempFile((String)UUID.randomUUID().toString(), (String)".tmp", null);
            tmpFile.deleteOnExit();
            FileOutputStream fos = new FileOutputStream(tmpFile);
            byte[] bytes = new byte[4096];
            ThreadLocalRandom.current().nextBytes(bytes);
            try {
                fos.write(bytes);
                fos.flush();
            }
            finally {
                fos.close();
            }
            test.setContent(tmpFile);
            ByteBuf buf1 = test.getChunk(1024);
            Assertions.assertEquals((int)buf1.readerIndex(), (int)0);
            Assertions.assertEquals((int)buf1.writerIndex(), (int)1024);
            ByteBuf buf2 = test.getChunk(1024);
            Assertions.assertEquals((int)buf2.readerIndex(), (int)0);
            Assertions.assertEquals((int)buf2.writerIndex(), (int)1024);
            Assertions.assertFalse((boolean)Arrays.equals(ByteBufUtil.getBytes((ByteBuf)buf1), ByteBufUtil.getBytes((ByteBuf)buf2)), (String)"Arrays should not be equal");
        }
        finally {
            test.delete();
        }
    }

    private static final class TestHttpData
    extends AbstractDiskHttpData {
        private TestHttpData(String name, Charset charset, long size) {
            super(name, charset, size);
        }

        protected String getDiskFilename() {
            return null;
        }

        protected String getPrefix() {
            return null;
        }

        protected String getBaseDirectory() {
            return null;
        }

        protected String getPostfix() {
            return null;
        }

        protected boolean deleteOnExit() {
            return false;
        }

        public HttpData copy() {
            return null;
        }

        public HttpData duplicate() {
            return null;
        }

        public HttpData retainedDuplicate() {
            return null;
        }

        public HttpData replace(ByteBuf content) {
            return null;
        }

        public InterfaceHttpData.HttpDataType getHttpDataType() {
            return null;
        }

        public int compareTo(InterfaceHttpData o) {
            return 0;
        }
    }
}

