/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.cors;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeadersFactory;
import io.netty.handler.codec.http.HttpHeadersTestUtils;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.cors.CorsConfig;
import io.netty.handler.codec.http.cors.CorsConfigBuilder;
import io.netty.handler.codec.http.cors.CorsHandler;
import io.netty.util.AsciiString;
import io.netty.util.ReferenceCountUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class CorsHandlerTest {
    @Test
    public void nonCorsRequest() {
        HttpResponse response = CorsHandlerTest.simpleRequest(CorsConfigBuilder.forAnyOrigin().build(), null);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)response.headers().contains((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ReferenceCountUtil.release((Object)response));
    }

    @Test
    public void simpleRequestWithAnyOrigin() {
        HttpResponse response = CorsHandlerTest.simpleRequest(CorsConfigBuilder.forAnyOrigin().build(), "http://localhost:7777");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"*", (Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN));
        org.junit.jupiter.api.Assertions.assertNull((Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ReferenceCountUtil.release((Object)response));
    }

    @Test
    public void simpleRequestWithNullOrigin() {
        HttpResponse response = CorsHandlerTest.simpleRequest(CorsConfigBuilder.forOrigin((String)"http://test.com").allowNullOrigin().allowCredentials().build(), "null");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"null", (Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"true", (Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS));
        org.junit.jupiter.api.Assertions.assertNull((Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ReferenceCountUtil.release((Object)response));
    }

    @Test
    public void simpleRequestWithOrigin() {
        String origin = "http://localhost:8888";
        HttpResponse response = CorsHandlerTest.simpleRequest(CorsConfigBuilder.forOrigin((String)"http://localhost:8888").build(), "http://localhost:8888");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"http://localhost:8888", (Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN));
        org.junit.jupiter.api.Assertions.assertNull((Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ReferenceCountUtil.release((Object)response));
    }

    @Test
    public void simpleRequestWithOrigins() {
        String origin1 = "http://localhost:8888";
        String origin2 = "https://localhost:8888";
        String[] origins = new String[]{"http://localhost:8888", "https://localhost:8888"};
        HttpResponse response1 = CorsHandlerTest.simpleRequest(CorsConfigBuilder.forOrigins((String[])origins).build(), "http://localhost:8888");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"http://localhost:8888", (Object)response1.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN));
        org.junit.jupiter.api.Assertions.assertNull((Object)response1.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ReferenceCountUtil.release((Object)response1));
        HttpResponse response2 = CorsHandlerTest.simpleRequest(CorsConfigBuilder.forOrigins((String[])origins).build(), "https://localhost:8888");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"https://localhost:8888", (Object)response2.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN));
        org.junit.jupiter.api.Assertions.assertNull((Object)response2.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ReferenceCountUtil.release((Object)response2));
    }

    @Test
    public void simpleRequestWithNoMatchingOrigin() {
        String origin = "http://localhost:8888";
        HttpResponse response = CorsHandlerTest.simpleRequest(CorsConfigBuilder.forOrigins((String[])new String[]{"https://localhost:8888"}).build(), "http://localhost:8888");
        org.junit.jupiter.api.Assertions.assertNull((Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN));
        org.junit.jupiter.api.Assertions.assertNull((Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ReferenceCountUtil.release((Object)response));
    }

    @Test
    public void preflightDeleteRequestWithCustomHeaders() {
        CorsConfig config = CorsConfigBuilder.forOrigin((String)"http://localhost:8888").allowedRequestMethods(new HttpMethod[]{HttpMethod.GET, HttpMethod.DELETE}).build();
        HttpResponse response = CorsHandlerTest.preflightRequest(config, "http://localhost:8888", "content-type, xheader1");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"http://localhost:8888", (Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN));
        Assertions.assertThat((String)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS)).contains(new CharSequence[]{"GET"});
        Assertions.assertThat((String)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS)).contains(new CharSequence[]{"DELETE"});
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpHeaderNames.ORIGIN.toString(), (Object)response.headers().get((CharSequence)HttpHeaderNames.VARY));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ReferenceCountUtil.release((Object)response));
    }

    @Test
    public void preflightGetRequestWithCustomHeaders() {
        CorsConfig config = CorsConfigBuilder.forOrigin((String)"http://localhost:8888").allowedRequestMethods(new HttpMethod[]{HttpMethod.OPTIONS, HttpMethod.GET, HttpMethod.DELETE}).allowedRequestHeaders(new String[]{"content-type", "xheader1"}).build();
        HttpResponse response = CorsHandlerTest.preflightRequest(config, "http://localhost:8888", "content-type, xheader1");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"http://localhost:8888", (Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN));
        Assertions.assertThat((String)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS)).contains(new CharSequence[]{"OPTIONS"});
        Assertions.assertThat((String)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS)).contains(new CharSequence[]{"GET"});
        Assertions.assertThat((String)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS)).contains(new CharSequence[]{"content-type"});
        Assertions.assertThat((String)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS)).contains(new CharSequence[]{"xheader1"});
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpHeaderNames.ORIGIN.toString(), (Object)response.headers().get((CharSequence)HttpHeaderNames.VARY));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ReferenceCountUtil.release((Object)response));
    }

    @Test
    public void preflightRequestWithDefaultHeaders() {
        CorsConfig config = CorsConfigBuilder.forOrigin((String)"http://localhost:8888").build();
        HttpResponse response = CorsHandlerTest.preflightRequest(config, "http://localhost:8888", "content-type, xheader1");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"0", (Object)response.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)response.headers().get((CharSequence)HttpHeaderNames.DATE));
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpHeaderNames.ORIGIN.toString(), (Object)response.headers().get((CharSequence)HttpHeaderNames.VARY));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ReferenceCountUtil.release((Object)response));
    }

    @Test
    public void preflightRequestWithCustomHeader() {
        CorsConfig config = CorsConfigBuilder.forOrigin((String)"http://localhost:8888").preflightResponseHeader((CharSequence)"CustomHeader", new Object[]{"somevalue"}).build();
        HttpResponse response = CorsHandlerTest.preflightRequest(config, "http://localhost:8888", "content-type, xheader1");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"somevalue", (Object)response.headers().get(HttpHeadersTestUtils.of("CustomHeader")));
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpHeaderNames.ORIGIN.toString(), (Object)response.headers().get((CharSequence)HttpHeaderNames.VARY));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"0", (Object)response.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ReferenceCountUtil.release((Object)response));
    }

    @Test
    public void preflightRequestWithUnauthorizedOrigin() {
        String origin = "http://host";
        CorsConfig config = CorsConfigBuilder.forOrigin((String)"http://localhost").build();
        HttpResponse response = CorsHandlerTest.preflightRequest(config, "http://host", "xheader1");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)response.headers().contains((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ReferenceCountUtil.release((Object)response));
    }

    @Test
    public void preflightRequestWithCustomHeaders() {
        String headerName = "CustomHeader";
        String value1 = "value1";
        String value2 = "value2";
        CorsConfig config = CorsConfigBuilder.forOrigin((String)"http://localhost:8888").preflightResponseHeader((CharSequence)"CustomHeader", new Object[]{"value1", "value2"}).build();
        HttpResponse response = CorsHandlerTest.preflightRequest(config, "http://localhost:8888", "content-type, xheader1");
        CorsHandlerTest.assertValues(response, "CustomHeader", "value1", "value2");
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpHeaderNames.ORIGIN.toString(), (Object)response.headers().get((CharSequence)HttpHeaderNames.VARY));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ReferenceCountUtil.release((Object)response));
    }

    @Test
    public void preflightRequestWithCustomHeadersIterable() {
        String headerName = "CustomHeader";
        String value1 = "value1";
        String value2 = "value2";
        CorsConfig config = CorsConfigBuilder.forOrigin((String)"http://localhost:8888").preflightResponseHeader((CharSequence)"CustomHeader", Arrays.asList("value1", "value2")).build();
        HttpResponse response = CorsHandlerTest.preflightRequest(config, "http://localhost:8888", "content-type, xheader1");
        CorsHandlerTest.assertValues(response, "CustomHeader", "value1", "value2");
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpHeaderNames.ORIGIN.toString(), (Object)response.headers().get((CharSequence)HttpHeaderNames.VARY));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ReferenceCountUtil.release((Object)response));
    }

    @Test
    public void preflightRequestWithValueGenerator() {
        CorsConfig config = CorsConfigBuilder.forOrigin((String)"http://localhost:8888").preflightResponseHeader((CharSequence)"GenHeader", (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return "generatedValue";
            }
        }).build();
        HttpResponse response = CorsHandlerTest.preflightRequest(config, "http://localhost:8888", "content-type, xheader1");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"generatedValue", (Object)response.headers().get(HttpHeadersTestUtils.of("GenHeader")));
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpHeaderNames.ORIGIN.toString(), (Object)response.headers().get((CharSequence)HttpHeaderNames.VARY));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ReferenceCountUtil.release((Object)response));
    }

    @Test
    public void preflightRequestWithNullOrigin() {
        String origin = "null";
        CorsConfig config = CorsConfigBuilder.forOrigin((String)"null").allowNullOrigin().allowCredentials().build();
        HttpResponse response = CorsHandlerTest.preflightRequest(config, "null", "content-type, xheader1");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"null", (Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"true", (Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ReferenceCountUtil.release((Object)response));
    }

    @Test
    public void preflightRequestAllowCredentials() {
        String origin = "null";
        CorsConfig config = CorsConfigBuilder.forOrigin((String)"null").allowCredentials().build();
        HttpResponse response = CorsHandlerTest.preflightRequest(config, "null", "content-type, xheader1");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"true", (Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ReferenceCountUtil.release((Object)response));
    }

    @Test
    public void preflightRequestDoNotAllowCredentials() {
        CorsConfig config = CorsConfigBuilder.forOrigin((String)"http://localhost:8888").build();
        HttpResponse response = CorsHandlerTest.preflightRequest(config, "http://localhost:8888", "");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)response.headers().contains((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ReferenceCountUtil.release((Object)response));
    }

    @Test
    public void simpleRequestCustomHeaders() {
        CorsConfig config = CorsConfigBuilder.forAnyOrigin().exposeHeaders(new String[]{"custom1", "custom2"}).build();
        HttpResponse response = CorsHandlerTest.simpleRequest(config, "http://localhost:7777");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"*", (Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN));
        Assertions.assertThat((String)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_EXPOSE_HEADERS)).contains(new CharSequence[]{"custom1"});
        Assertions.assertThat((String)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_EXPOSE_HEADERS)).contains(new CharSequence[]{"custom2"});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ReferenceCountUtil.release((Object)response));
    }

    @Test
    public void simpleRequestAllowCredentials() {
        CorsConfig config = CorsConfigBuilder.forAnyOrigin().allowCredentials().build();
        HttpResponse response = CorsHandlerTest.simpleRequest(config, "http://localhost:7777");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"true", (Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ReferenceCountUtil.release((Object)response));
    }

    @Test
    public void simpleRequestDoNotAllowCredentials() {
        CorsConfig config = CorsConfigBuilder.forAnyOrigin().build();
        HttpResponse response = CorsHandlerTest.simpleRequest(config, "http://localhost:7777");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)response.headers().contains((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ReferenceCountUtil.release((Object)response));
    }

    @Test
    public void anyOriginAndAllowCredentialsShouldEchoRequestOrigin() {
        CorsConfig config = CorsConfigBuilder.forAnyOrigin().allowCredentials().build();
        HttpResponse response = CorsHandlerTest.simpleRequest(config, "http://localhost:7777");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"true", (Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"http://localhost:7777", (Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN));
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpHeaderNames.ORIGIN.toString(), (Object)response.headers().get((CharSequence)HttpHeaderNames.VARY));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ReferenceCountUtil.release((Object)response));
    }

    @Test
    public void simpleRequestExposeHeaders() {
        CorsConfig config = CorsConfigBuilder.forAnyOrigin().exposeHeaders(new String[]{"one", "two"}).build();
        HttpResponse response = CorsHandlerTest.simpleRequest(config, "http://localhost:7777");
        Assertions.assertThat((String)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_EXPOSE_HEADERS)).contains(new CharSequence[]{"one"});
        Assertions.assertThat((String)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_EXPOSE_HEADERS)).contains(new CharSequence[]{"two"});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ReferenceCountUtil.release((Object)response));
    }

    @Test
    public void simpleRequestShortCircuit() {
        CorsConfig config = CorsConfigBuilder.forOrigin((String)"http://localhost:8080").shortCircuit().build();
        HttpResponse response = CorsHandlerTest.simpleRequest(config, "http://localhost:7777");
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpResponseStatus.FORBIDDEN, (Object)response.status());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"0", (Object)response.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ReferenceCountUtil.release((Object)response));
    }

    @Test
    public void simpleRequestNoShortCircuit() {
        CorsConfig config = CorsConfigBuilder.forOrigin((String)"http://localhost:8080").build();
        HttpResponse response = CorsHandlerTest.simpleRequest(config, "http://localhost:7777");
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpResponseStatus.OK, (Object)response.status());
        org.junit.jupiter.api.Assertions.assertNull((Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ReferenceCountUtil.release((Object)response));
    }

    @Test
    public void shortCircuitNonCorsRequest() {
        CorsConfig config = CorsConfigBuilder.forOrigin((String)"https://localhost").shortCircuit().build();
        HttpResponse response = CorsHandlerTest.simpleRequest(config, null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpResponseStatus.OK, (Object)response.status());
        org.junit.jupiter.api.Assertions.assertNull((Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ReferenceCountUtil.release((Object)response));
    }

    @Test
    public void shortCircuitWithConnectionKeepAliveShouldStayOpen() {
        CorsConfig config = CorsConfigBuilder.forOrigin((String)"http://localhost:8080").shortCircuit().build();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new CorsHandler(config)});
        FullHttpRequest request = CorsHandlerTest.createHttpRequest(HttpMethod.GET);
        request.headers().set((CharSequence)HttpHeaderNames.ORIGIN, (Object)"http://localhost:8888");
        request.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.writeInbound(new Object[]{request}));
        HttpResponse response = (HttpResponse)channel.readOutbound();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HttpUtil.isKeepAlive((HttpMessage)response));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.isOpen());
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpResponseStatus.FORBIDDEN, (Object)response.status());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ReferenceCountUtil.release((Object)response));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void shortCircuitWithoutConnectionShouldStayOpen() {
        CorsConfig config = CorsConfigBuilder.forOrigin((String)"http://localhost:8080").shortCircuit().build();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new CorsHandler(config)});
        FullHttpRequest request = CorsHandlerTest.createHttpRequest(HttpMethod.GET);
        request.headers().set((CharSequence)HttpHeaderNames.ORIGIN, (Object)"http://localhost:8888");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.writeInbound(new Object[]{request}));
        HttpResponse response = (HttpResponse)channel.readOutbound();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HttpUtil.isKeepAlive((HttpMessage)response));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.isOpen());
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpResponseStatus.FORBIDDEN, (Object)response.status());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ReferenceCountUtil.release((Object)response));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void shortCircuitWithConnectionCloseShouldClose() {
        CorsConfig config = CorsConfigBuilder.forOrigin((String)"http://localhost:8080").shortCircuit().build();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new CorsHandler(config)});
        FullHttpRequest request = CorsHandlerTest.createHttpRequest(HttpMethod.GET);
        request.headers().set((CharSequence)HttpHeaderNames.ORIGIN, (Object)"http://localhost:8888");
        request.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.writeInbound(new Object[]{request}));
        HttpResponse response = (HttpResponse)channel.readOutbound();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)HttpUtil.isKeepAlive((HttpMessage)response));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.isOpen());
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpResponseStatus.FORBIDDEN, (Object)response.status());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ReferenceCountUtil.release((Object)response));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void preflightRequestShouldReleaseRequest() {
        CorsConfig config = CorsConfigBuilder.forOrigin((String)"http://localhost:8888").preflightResponseHeader((CharSequence)"CustomHeader", Arrays.asList("value1", "value2")).build();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new CorsHandler(config)});
        FullHttpRequest request = CorsHandlerTest.optionsRequest("http://localhost:8888", "content-type, xheader1", null);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.writeInbound(new Object[]{request}));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)request.refCnt());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ReferenceCountUtil.release((Object)channel.readOutbound()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void preflightRequestWithConnectionKeepAliveShouldStayOpen() throws Exception {
        CorsConfig config = CorsConfigBuilder.forOrigin((String)"http://localhost:8888").build();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new CorsHandler(config)});
        FullHttpRequest request = CorsHandlerTest.optionsRequest("http://localhost:8888", "", HttpHeaderValues.KEEP_ALIVE);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.writeInbound(new Object[]{request}));
        HttpResponse response = (HttpResponse)channel.readOutbound();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HttpUtil.isKeepAlive((HttpMessage)response));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.isOpen());
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpResponseStatus.OK, (Object)response.status());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ReferenceCountUtil.release((Object)response));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void preflightRequestWithoutConnectionShouldStayOpen() throws Exception {
        CorsConfig config = CorsConfigBuilder.forOrigin((String)"http://localhost:8888").build();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new CorsHandler(config)});
        FullHttpRequest request = CorsHandlerTest.optionsRequest("http://localhost:8888", "", null);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.writeInbound(new Object[]{request}));
        HttpResponse response = (HttpResponse)channel.readOutbound();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HttpUtil.isKeepAlive((HttpMessage)response));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.isOpen());
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpResponseStatus.OK, (Object)response.status());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ReferenceCountUtil.release((Object)response));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void preflightRequestWithConnectionCloseShouldClose() throws Exception {
        CorsConfig config = CorsConfigBuilder.forOrigin((String)"http://localhost:8888").build();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new CorsHandler(config)});
        FullHttpRequest request = CorsHandlerTest.optionsRequest("http://localhost:8888", "", HttpHeaderValues.CLOSE);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.writeInbound(new Object[]{request}));
        HttpResponse response = (HttpResponse)channel.readOutbound();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)HttpUtil.isKeepAlive((HttpMessage)response));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.isOpen());
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpResponseStatus.OK, (Object)response.status());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ReferenceCountUtil.release((Object)response));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void forbiddenShouldReleaseRequest() {
        CorsConfig config = CorsConfigBuilder.forOrigin((String)"https://localhost").shortCircuit().build();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new CorsHandler(config), new EchoHandler()});
        FullHttpRequest request = CorsHandlerTest.createHttpRequest(HttpMethod.GET);
        request.headers().set((CharSequence)HttpHeaderNames.ORIGIN, (Object)"http://localhost:8888");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.writeInbound(new Object[]{request}));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)request.refCnt());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ReferenceCountUtil.release((Object)channel.readOutbound()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void differentConfigsPerOrigin() {
        String host1 = "http://host1:80";
        String host2 = "http://host2";
        CorsConfig rule1 = CorsConfigBuilder.forOrigin((String)host1).allowedRequestMethods(new HttpMethod[]{HttpMethod.GET}).build();
        CorsConfig rule2 = CorsConfigBuilder.forOrigin((String)host2).allowedRequestMethods(new HttpMethod[]{HttpMethod.GET, HttpMethod.POST}).allowCredentials().build();
        List<CorsConfig> corsConfigs = Arrays.asList(rule1, rule2);
        HttpResponse preFlightHost1 = CorsHandlerTest.preflightRequest(corsConfigs, host1, "", false);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"GET", (Object)preFlightHost1.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS));
        org.junit.jupiter.api.Assertions.assertNull((Object)preFlightHost1.headers().getAsString((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS));
        HttpResponse preFlightHost2 = CorsHandlerTest.preflightRequest(corsConfigs, host2, "", false);
        CorsHandlerTest.assertValues(preFlightHost2, HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS.toString(), "GET", "POST");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"true", (Object)preFlightHost2.headers().getAsString((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS));
    }

    @Test
    public void specificConfigPrecedenceOverGeneric() {
        String host1 = "http://host1";
        String host2 = "http://host2";
        CorsConfig forHost1 = CorsConfigBuilder.forOrigin((String)host1).allowedRequestMethods(new HttpMethod[]{HttpMethod.GET}).maxAge(3600L).build();
        CorsConfig allowAll = CorsConfigBuilder.forAnyOrigin().allowedRequestMethods(new HttpMethod[]{HttpMethod.POST, HttpMethod.GET, HttpMethod.OPTIONS}).maxAge(1800L).build();
        List<CorsConfig> rules = Arrays.asList(forHost1, allowAll);
        HttpResponse host1Response = CorsHandlerTest.preflightRequest(rules, host1, "", false);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"GET", (Object)host1Response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"3600", (Object)host1Response.headers().getAsString((CharSequence)HttpHeaderNames.ACCESS_CONTROL_MAX_AGE));
        HttpResponse host2Response = CorsHandlerTest.preflightRequest(rules, host2, "", false);
        CorsHandlerTest.assertValues(host2Response, HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS.toString(), "POST", "GET", "OPTIONS");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"*", (Object)host2Response.headers().getAsString((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1800", (Object)host2Response.headers().getAsString((CharSequence)HttpHeaderNames.ACCESS_CONTROL_MAX_AGE));
    }

    @Test
    public void simpleRequestAllowPrivateNetwork() {
        CorsConfig config = CorsConfigBuilder.forOrigin((String)"http://localhost:8888").allowPrivateNetwork().build();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new CorsHandler(config)});
        FullHttpRequest request = CorsHandlerTest.optionsRequest("http://localhost:8888", "", null);
        request.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_REQUEST_PRIVATE_NETWORK, (Object)"true");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.writeInbound(new Object[]{request}));
        HttpResponse response = (HttpResponse)channel.readOutbound();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"true", (Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_PRIVATE_NETWORK));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ReferenceCountUtil.release((Object)response));
    }

    @Test
    public void simpleRequestDoNotAllowPrivateNetwork() {
        CorsConfig config = CorsConfigBuilder.forOrigin((String)"http://localhost:8888").build();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new CorsHandler(config)});
        FullHttpRequest request = CorsHandlerTest.optionsRequest("http://localhost:8888", "", null);
        request.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_REQUEST_PRIVATE_NETWORK, (Object)"true");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.writeInbound(new Object[]{request}));
        HttpResponse response = (HttpResponse)channel.readOutbound();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"false", (Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_PRIVATE_NETWORK));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ReferenceCountUtil.release((Object)response));
    }

    private static HttpResponse simpleRequest(CorsConfig config, String origin) {
        return CorsHandlerTest.simpleRequest(config, origin, null);
    }

    private static HttpResponse simpleRequest(CorsConfig config, String origin, String requestHeaders) {
        return CorsHandlerTest.simpleRequest(config, origin, requestHeaders, HttpMethod.GET);
    }

    private static HttpResponse simpleRequest(CorsConfig config, String origin, String requestHeaders, HttpMethod method) {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new CorsHandler(config), new EchoHandler()});
        FullHttpRequest httpRequest = CorsHandlerTest.createHttpRequest(method);
        if (origin != null) {
            httpRequest.headers().set((CharSequence)HttpHeaderNames.ORIGIN, (Object)origin);
        }
        if (requestHeaders != null) {
            httpRequest.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_REQUEST_HEADERS, (Object)requestHeaders);
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.writeInbound(new Object[]{httpRequest}));
        HttpResponse response = (HttpResponse)channel.readOutbound();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finish());
        return response;
    }

    private static HttpResponse preflightRequest(CorsConfig config, String origin, String requestHeaders) {
        return CorsHandlerTest.preflightRequest(Collections.singletonList(config), origin, requestHeaders, config.isShortCircuit());
    }

    private static HttpResponse preflightRequest(List<CorsConfig> configs, String origin, String requestHeaders, boolean isSHortCircuit) {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new CorsHandler(configs, isSHortCircuit)});
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.writeInbound(new Object[]{CorsHandlerTest.optionsRequest(origin, requestHeaders, null)}));
        HttpResponse response = (HttpResponse)channel.readOutbound();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finish());
        return response;
    }

    private static FullHttpRequest optionsRequest(String origin, String requestHeaders, AsciiString connection) {
        FullHttpRequest httpRequest = CorsHandlerTest.createHttpRequest(HttpMethod.OPTIONS);
        httpRequest.headers().set((CharSequence)HttpHeaderNames.ORIGIN, (Object)origin);
        httpRequest.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_REQUEST_METHOD, (Object)httpRequest.method().toString());
        httpRequest.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_REQUEST_HEADERS, (Object)requestHeaders);
        if (connection != null) {
            httpRequest.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)connection);
        }
        return httpRequest;
    }

    private static FullHttpRequest createHttpRequest(HttpMethod method) {
        return new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, "/info");
    }

    private static void assertValues(HttpResponse response, String headerName, String ... values) {
        String header = response.headers().get(HttpHeadersTestUtils.of(headerName));
        for (String value : values) {
            Assertions.assertThat((String)header).contains(new CharSequence[]{value});
        }
    }

    private static class EchoHandler
    extends SimpleChannelInboundHandler<Object> {
        private EchoHandler() {
        }

        public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
            ctx.writeAndFlush((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.buffer((int)0), (HttpHeadersFactory)DefaultHttpHeadersFactory.headersFactory().withCombiningHeaders(true), (HttpHeadersFactory)DefaultHttpHeadersFactory.trailersFactory().withCombiningHeaders(true)));
        }
    }
}

