/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class HttpHeadersTestUtils {
    public static CharSequence of(String s) {
        return s;
    }

    private HttpHeadersTestUtils() {
    }

    static final class HeaderValue
    extends Enum<HeaderValue> {
        public static final /* enum */ HeaderValue UNKNOWN = new HeaderValue("Unknown", 0);
        public static final /* enum */ HeaderValue ONE = new HeaderValue("One", 1);
        public static final /* enum */ HeaderValue TWO = new HeaderValue("Two", 2);
        public static final /* enum */ HeaderValue THREE = new HeaderValue("Three", 3);
        public static final /* enum */ HeaderValue FOUR = new HeaderValue("Four", 4);
        public static final /* enum */ HeaderValue FIVE = new HeaderValue("Five", 5);
        public static final /* enum */ HeaderValue SIX_QUOTED = new HeaderValue("Six,", 6);
        public static final /* enum */ HeaderValue SEVEN_QUOTED = new HeaderValue("Seven; , GMT", 7);
        public static final /* enum */ HeaderValue EIGHT = new HeaderValue("Eight", 8);
        private final int nr;
        private final String value;
        private List<CharSequence> array;
        private static final Map<Integer, HeaderValue> MAP;
        private static final /* synthetic */ HeaderValue[] $VALUES;

        public static HeaderValue[] values() {
            return (HeaderValue[])$VALUES.clone();
        }

        public static HeaderValue valueOf(String name) {
            return Enum.valueOf(HeaderValue.class, name);
        }

        private HeaderValue(String value, int nr) {
            this.nr = nr;
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public List<CharSequence> asList() {
            if (this.array == null) {
                ArrayList<CharSequence> list = new ArrayList<CharSequence>(this.nr);
                for (int i = 1; i <= this.nr; ++i) {
                    list.add(HeaderValue.of(i).toString());
                }
                this.array = list;
            }
            return this.array;
        }

        public List<CharSequence> subset(int from) {
            assert (from > 0);
            int size = this.nr - --from;
            int end = from + size;
            ArrayList<CharSequence> list = new ArrayList<CharSequence>(size);
            List<CharSequence> fullList = this.asList();
            for (int i = from; i < end; ++i) {
                list.add(fullList.get(i));
            }
            return list;
        }

        public String subsetAsCsvString(int from) {
            List<CharSequence> subset = this.subset(from);
            return this.asCsv(subset);
        }

        public String asCsv(List<CharSequence> arr) {
            if (arr == null || arr.isEmpty()) {
                return "";
            }
            StringBuilder sb = new StringBuilder(arr.size() * 10);
            int end = arr.size() - 1;
            for (int i = 0; i < end; ++i) {
                HeaderValue.quoted(sb, arr.get(i)).append(',');
            }
            HeaderValue.quoted(sb, arr.get(end));
            return sb.toString();
        }

        public CharSequence asCsv() {
            return this.asCsv(this.asList());
        }

        private static StringBuilder quoted(StringBuilder sb, CharSequence value) {
            if (HeaderValue.contains(value, ',') && !HeaderValue.contains(value, '\"')) {
                return sb.append('\"').append(value).append('\"');
            }
            return sb.append(value);
        }

        private static boolean contains(CharSequence value, char c) {
            for (int i = 0; i < value.length(); ++i) {
                if (value.charAt(i) != c) continue;
                return true;
            }
            return false;
        }

        public static HeaderValue of(int nr) {
            HeaderValue v = MAP.get(nr);
            return v == null ? UNKNOWN : v;
        }

        static {
            $VALUES = new HeaderValue[]{UNKNOWN, ONE, TWO, THREE, FOUR, FIVE, SIX_QUOTED, SEVEN_QUOTED, EIGHT};
            HashMap<Integer, HeaderValue> map = new HashMap<Integer, HeaderValue>();
            for (HeaderValue v : HeaderValue.values()) {
                int nr = v.nr;
                map.put(nr, v);
            }
            MAP = map;
        }
    }
}

