/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.compression.Brotli;
import io.netty.handler.codec.compression.Zstd;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.test.DisabledForSlowLeakDetection;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class HttpContentDecompressorTest {
    @Test
    public void testInvokeReadWhenNotProduceMessage() {
        final AtomicInteger readCalled = new AtomicInteger();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelOutboundHandlerAdapter(){

            public void read(ChannelHandlerContext ctx) {
                readCalled.incrementAndGet();
                ctx.read();
            }
        }, new HttpContentDecompressor(0), new ChannelInboundHandlerAdapter(){

            public void channelRead(ChannelHandlerContext ctx, Object msg) {
                ctx.fireChannelRead(msg);
                ctx.read();
            }
        }});
        channel.config().setAutoRead(false);
        readCalled.set(0);
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_ENCODING, (Object)"gzip");
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/json;charset=UTF-8");
        response.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{response}));
        Assertions.assertEquals((int)1, (int)readCalled.get());
        Assertions.assertTrue((boolean)(channel.readInbound() instanceof HttpResponse));
        Assertions.assertFalse((boolean)channel.writeInbound(new Object[]{new DefaultHttpContent(Unpooled.EMPTY_BUFFER)}));
        Assertions.assertEquals((int)2, (int)readCalled.get());
        Assertions.assertFalse((boolean)channel.finishAndReleaseAll());
    }

    static String[] encodings() {
        ArrayList<String> encodings = new ArrayList<String>();
        encodings.add("gzip");
        encodings.add("deflate");
        if (Brotli.isAvailable()) {
            encodings.add("br");
        }
        if (Zstd.isAvailable()) {
            encodings.add("zstd");
        }
        encodings.add("snappy");
        return encodings.toArray(new String[0]);
    }

    @ParameterizedTest
    @MethodSource(value={"encodings"})
    @DisabledForSlowLeakDetection
    public void testZipBomb(String encoding) {
        HttpObject obj;
        int chunkSize = 0x100000;
        int numberOfChunks = 256;
        int memoryLimit = chunkSize * 128;
        EmbeddedChannel compressionChannel = new EmbeddedChannel(new ChannelHandler[]{new HttpContentCompressor()});
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/");
        req.headers().set((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)encoding);
        compressionChannel.writeInbound(new Object[]{req});
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        compressionChannel.writeOutbound(new Object[]{response});
        for (int i = 0; i < numberOfChunks; ++i) {
            ByteBuf buffer = compressionChannel.alloc().buffer(chunkSize);
            buffer.writeZero(chunkSize);
            compressionChannel.writeOutbound(new Object[]{new DefaultHttpContent(buffer)});
        }
        compressionChannel.writeOutbound(new Object[]{LastHttpContent.EMPTY_LAST_CONTENT});
        compressionChannel.finish();
        compressionChannel.releaseInbound();
        ByteBuf compressed = compressionChannel.alloc().buffer();
        HttpMessage message = null;
        while ((obj = (HttpObject)compressionChannel.readOutbound()) != null) {
            if (obj instanceof HttpMessage) {
                message = (HttpMessage)obj;
            }
            if (!(obj instanceof HttpContent)) continue;
            HttpContent content = (HttpContent)obj;
            compressed.writeBytes(content.content());
            content.release();
        }
        PooledByteBufAllocator allocator = new PooledByteBufAllocator(false);
        ZipBombIncomingHandler incomingHandler = new ZipBombIncomingHandler(memoryLimit);
        EmbeddedChannel decompressChannel = new EmbeddedChannel(new ChannelHandler[]{new HttpContentDecompressor(0), incomingHandler});
        decompressChannel.config().setAllocator((ByteBufAllocator)allocator);
        decompressChannel.writeInbound(new Object[]{message});
        decompressChannel.writeInbound(new Object[]{new DefaultLastHttpContent(compressed)});
        Assertions.assertEquals((long)((long)chunkSize * (long)numberOfChunks), (long)incomingHandler.total);
    }

    private static final class ZipBombIncomingHandler
    extends ChannelInboundHandlerAdapter {
        final int memoryLimit;
        long total;

        ZipBombIncomingHandler(int memoryLimit) {
            this.memoryLimit = memoryLimit;
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            PooledByteBufAllocator allocator = (PooledByteBufAllocator)ctx.alloc();
            Assertions.assertTrue((allocator.metric().usedHeapMemory() < (long)this.memoryLimit ? 1 : 0) != 0);
            Assertions.assertTrue((allocator.metric().usedDirectMemory() < (long)this.memoryLimit ? 1 : 0) != 0);
            if (msg instanceof HttpContent) {
                HttpContent buf = (HttpContent)msg;
                this.total += (long)buf.content().readableBytes();
                buf.release();
            }
        }
    }
}

