/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class HttpClientUpgradeHandlerTest {
    @Test
    public void testSuccessfulUpgrade() {
        FakeSourceCodec sourceCodec = new FakeSourceCodec();
        FakeUpgradeCodec upgradeCodec = new FakeUpgradeCodec();
        HttpClientUpgradeHandler handler = new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)sourceCodec, (HttpClientUpgradeHandler.UpgradeCodec)upgradeCodec, 1024);
        UserEventCatcher catcher = new UserEventCatcher();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{catcher});
        DefaultHttpRequest afterUpgradeMessage = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "netty.io");
        ChannelPromise promise = channel.newPromise();
        channel.pipeline().addFirst(new ChannelHandler[]{new ChannelInboundHandlerAdapter((HttpRequest)afterUpgradeMessage, promise){
            final /* synthetic */ HttpRequest val$afterUpgradeMessage;
            final /* synthetic */ ChannelPromise val$promise;
            {
                this.val$afterUpgradeMessage = httpRequest;
                this.val$promise = channelPromise;
            }

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                if (evt == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_SUCCESSFUL) {
                    ctx.writeAndFlush((Object)this.val$afterUpgradeMessage, this.val$promise);
                }
                super.userEventTriggered(ctx, evt);
            }
        }});
        channel.pipeline().addFirst("upgrade", (ChannelHandler)handler);
        Assertions.assertTrue((boolean)channel.writeOutbound(new Object[]{new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "netty.io")}));
        FullHttpRequest request = (FullHttpRequest)channel.readOutbound();
        Assertions.assertEquals((int)2, (int)request.headers().size());
        Assertions.assertTrue((boolean)request.headers().contains((CharSequence)HttpHeaderNames.UPGRADE, (CharSequence)"fancyhttp", false));
        Assertions.assertTrue((boolean)request.headers().contains("connection", "upgrade", false));
        Assertions.assertTrue((boolean)request.release());
        Assertions.assertEquals((Object)HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_ISSUED, (Object)catcher.getUserEvent());
        DefaultHttpResponse upgradeResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SWITCHING_PROTOCOLS);
        upgradeResponse.headers().add((CharSequence)HttpHeaderNames.UPGRADE, (Object)"fancyhttp");
        Assertions.assertFalse((boolean)channel.writeInbound(new Object[]{upgradeResponse}));
        Assertions.assertFalse((boolean)channel.writeInbound(new Object[]{LastHttpContent.EMPTY_LAST_CONTENT}));
        Assertions.assertEquals((Object)HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_SUCCESSFUL, (Object)catcher.getUserEvent());
        Assertions.assertNull((Object)channel.pipeline().get("upgrade"));
        Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK)}));
        FullHttpResponse response = (FullHttpResponse)channel.readInbound();
        Assertions.assertEquals((Object)HttpResponseStatus.OK, (Object)response.status());
        Assertions.assertTrue((boolean)response.release());
        Assertions.assertTrue((boolean)promise.isSuccess());
        Assertions.assertEquals((Object)afterUpgradeMessage, (Object)channel.readOutbound());
        Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testUpgradeRejected() {
        FakeSourceCodec sourceCodec = new FakeSourceCodec();
        FakeUpgradeCodec upgradeCodec = new FakeUpgradeCodec();
        HttpClientUpgradeHandler handler = new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)sourceCodec, (HttpClientUpgradeHandler.UpgradeCodec)upgradeCodec, 1024);
        UserEventCatcher catcher = new UserEventCatcher();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{catcher});
        channel.pipeline().addFirst("upgrade", (ChannelHandler)handler);
        Assertions.assertTrue((boolean)channel.writeOutbound(new Object[]{new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "netty.io")}));
        FullHttpRequest request = (FullHttpRequest)channel.readOutbound();
        Assertions.assertEquals((int)2, (int)request.headers().size());
        Assertions.assertTrue((boolean)request.headers().contains((CharSequence)HttpHeaderNames.UPGRADE, (CharSequence)"fancyhttp", false));
        Assertions.assertTrue((boolean)request.headers().contains("connection", "upgrade", false));
        Assertions.assertTrue((boolean)request.release());
        Assertions.assertEquals((Object)HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_ISSUED, (Object)catcher.getUserEvent());
        DefaultHttpResponse upgradeResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SWITCHING_PROTOCOLS);
        upgradeResponse.headers().add((CharSequence)HttpHeaderNames.UPGRADE, (Object)"fancyhttp");
        Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK)}));
        Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{LastHttpContent.EMPTY_LAST_CONTENT}));
        Assertions.assertEquals((Object)HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_REJECTED, (Object)catcher.getUserEvent());
        Assertions.assertNull((Object)channel.pipeline().get("upgrade"));
        HttpResponse response = (HttpResponse)channel.readInbound();
        Assertions.assertEquals((Object)HttpResponseStatus.OK, (Object)response.status());
        LastHttpContent last = (LastHttpContent)channel.readInbound();
        Assertions.assertEquals((Object)LastHttpContent.EMPTY_LAST_CONTENT, (Object)last);
        Assertions.assertFalse((boolean)last.release());
        Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testEarlyBailout() {
        FakeSourceCodec sourceCodec = new FakeSourceCodec();
        FakeUpgradeCodec upgradeCodec = new FakeUpgradeCodec();
        HttpClientUpgradeHandler handler = new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)sourceCodec, (HttpClientUpgradeHandler.UpgradeCodec)upgradeCodec, 1024);
        UserEventCatcher catcher = new UserEventCatcher();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{catcher});
        channel.pipeline().addFirst("upgrade", (ChannelHandler)handler);
        Assertions.assertTrue((boolean)channel.writeOutbound(new Object[]{new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "netty.io")}));
        FullHttpRequest request = (FullHttpRequest)channel.readOutbound();
        Assertions.assertEquals((int)2, (int)request.headers().size());
        Assertions.assertTrue((boolean)request.headers().contains((CharSequence)HttpHeaderNames.UPGRADE, (CharSequence)"fancyhttp", false));
        Assertions.assertTrue((boolean)request.headers().contains("connection", "upgrade", false));
        Assertions.assertTrue((boolean)request.release());
        Assertions.assertEquals((Object)HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_ISSUED, (Object)catcher.getUserEvent());
        DefaultHttpResponse upgradeResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SWITCHING_PROTOCOLS);
        upgradeResponse.headers().add((CharSequence)HttpHeaderNames.UPGRADE, (Object)"fancyhttp");
        Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK)}));
        Assertions.assertEquals((Object)HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_REJECTED, (Object)catcher.getUserEvent());
        Assertions.assertNull((Object)channel.pipeline().get("upgrade"));
        HttpResponse response = (HttpResponse)channel.readInbound();
        Assertions.assertEquals((Object)HttpResponseStatus.OK, (Object)response.status());
        Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void dontStripConnectionHeaders() {
        FakeSourceCodec sourceCodec = new FakeSourceCodec();
        FakeUpgradeCodec upgradeCodec = new FakeUpgradeCodec();
        HttpClientUpgradeHandler handler = new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)sourceCodec, (HttpClientUpgradeHandler.UpgradeCodec)upgradeCodec, 1024);
        UserEventCatcher catcher = new UserEventCatcher();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{catcher});
        channel.pipeline().addFirst("upgrade", (ChannelHandler)handler);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "netty.io");
        request.headers().add("connection", (Object)"extra");
        request.headers().add("extra", (Object)"value");
        Assertions.assertTrue((boolean)channel.writeOutbound(new Object[]{request}));
        FullHttpRequest readRequest = (FullHttpRequest)channel.readOutbound();
        List connectionHeaders = readRequest.headers().getAll("connection");
        Assertions.assertTrue((boolean)connectionHeaders.contains("extra"));
        Assertions.assertTrue((boolean)readRequest.release());
        Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testMultipleUpgradeRequestsFail() {
        FakeSourceCodec sourceCodec = new FakeSourceCodec();
        FakeUpgradeCodec upgradeCodec = new FakeUpgradeCodec();
        HttpClientUpgradeHandler handler = new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)sourceCodec, (HttpClientUpgradeHandler.UpgradeCodec)upgradeCodec, 1024);
        final EmbeddedChannel channel = new EmbeddedChannel();
        channel.pipeline().addFirst("upgrade", (ChannelHandler)handler);
        Assertions.assertTrue((boolean)channel.writeOutbound(new Object[]{new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "netty.io")}));
        FullHttpRequest request = (FullHttpRequest)channel.readOutbound();
        Assertions.assertTrue((boolean)request.release());
        DefaultFullHttpRequest secondReq = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "netty.io");
        Assertions.assertThrows(IllegalStateException.class, (Executable)new Executable((FullHttpRequest)secondReq){
            final /* synthetic */ FullHttpRequest val$secondReq;
            {
                this.val$secondReq = fullHttpRequest;
            }

            public void execute() throws Throwable {
                channel.writeOutbound(new Object[]{this.val$secondReq});
            }
        });
        Assertions.assertEquals((int)0, (int)secondReq.refCnt());
        Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void forwardOnFailure() {
        FakeSourceCodec sourceCodec = new FakeSourceCodec();
        FakeUpgradeCodec upgradeCodec = new FakeUpgradeCodec();
        HttpClientUpgradeHandler handler = new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)sourceCodec, (HttpClientUpgradeHandler.UpgradeCodec)upgradeCodec, 1024);
        EmbeddedChannel channel = new EmbeddedChannel();
        channel.pipeline().addFirst("upgrade", (ChannelHandler)handler);
        Assertions.assertTrue((boolean)channel.writeOutbound(new Object[]{new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "netty.io")}));
        FullHttpRequest request = (FullHttpRequest)channel.readOutbound();
        Assertions.assertTrue((boolean)request.release());
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SWITCHING_PROTOCOLS);
        response.headers().add((CharSequence)HttpHeaderNames.UPGRADE, (Object)"");
        Assertions.assertFalse((boolean)channel.writeInbound(new Object[]{response}));
        Assertions.assertThrows(IllegalStateException.class, () -> channel.writeInbound(new Object[]{LastHttpContent.EMPTY_LAST_CONTENT}));
        FullHttpResponse full = (FullHttpResponse)channel.readInbound();
        Assertions.assertTrue((boolean)full.release());
        Assertions.assertFalse((boolean)channel.finish());
    }

    private static final class UserEventCatcher
    extends ChannelInboundHandlerAdapter {
        private Object evt;

        private UserEventCatcher() {
        }

        public Object getUserEvent() {
            return this.evt;
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            this.evt = evt;
        }
    }

    private static final class FakeUpgradeCodec
    implements HttpClientUpgradeHandler.UpgradeCodec {
        private FakeUpgradeCodec() {
        }

        public CharSequence protocol() {
            return "fancyhttp";
        }

        public Collection<CharSequence> setUpgradeHeaders(ChannelHandlerContext ctx, HttpRequest upgradeRequest) {
            return Collections.emptyList();
        }

        public void upgradeTo(ChannelHandlerContext ctx, FullHttpResponse upgradeResponse) throws Exception {
        }
    }

    private static final class FakeSourceCodec
    implements HttpClientUpgradeHandler.SourceCodec {
        private FakeSourceCodec() {
        }

        public void prepareUpgradeFrom(ChannelHandlerContext ctx) {
        }

        public void upgradeFrom(ChannelHandlerContext ctx) {
        }
    }
}

