/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.frame;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.util.CharsetUtil;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class LengthFieldPrependerTest {
    private ByteBuf msg;

    @BeforeEach
    public void setUp() throws Exception {
        this.msg = Unpooled.copiedBuffer((CharSequence)"A", (Charset)CharsetUtil.ISO_8859_1);
    }

    @Test
    public void testPrependLength() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new LengthFieldPrepender(4)});
        ch.writeOutbound(new Object[]{this.msg});
        ByteBuf buf = (ByteBuf)ch.readOutbound();
        Assertions.assertEquals((int)4, (int)buf.readableBytes());
        Assertions.assertEquals((int)this.msg.readableBytes(), (int)buf.readInt());
        buf.release();
        buf = (ByteBuf)ch.readOutbound();
        Assertions.assertSame((Object)buf, (Object)this.msg);
        buf.release();
    }

    @Test
    public void testPrependLengthIncludesLengthFieldLength() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new LengthFieldPrepender(4, true)});
        ch.writeOutbound(new Object[]{this.msg});
        ByteBuf buf = (ByteBuf)ch.readOutbound();
        Assertions.assertEquals((int)4, (int)buf.readableBytes());
        Assertions.assertEquals((int)5, (int)buf.readInt());
        buf.release();
        buf = (ByteBuf)ch.readOutbound();
        Assertions.assertSame((Object)buf, (Object)this.msg);
        buf.release();
    }

    @Test
    public void testPrependAdjustedLength() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new LengthFieldPrepender(4, -1)});
        ch.writeOutbound(new Object[]{this.msg});
        ByteBuf buf = (ByteBuf)ch.readOutbound();
        Assertions.assertEquals((int)4, (int)buf.readableBytes());
        Assertions.assertEquals((int)(this.msg.readableBytes() - 1), (int)buf.readInt());
        buf.release();
        buf = (ByteBuf)ch.readOutbound();
        Assertions.assertSame((Object)buf, (Object)this.msg);
        buf.release();
    }

    @Test
    public void testAdjustedLengthLessThanZero() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new LengthFieldPrepender(4, -2)});
        try {
            ch.writeOutbound(new Object[]{this.msg});
            Assertions.fail((String)(EncoderException.class.getSimpleName() + " must be raised."));
        }
        catch (EncoderException encoderException) {
            // empty catch block
        }
    }

    @Test
    public void testPrependLengthInLittleEndian() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new LengthFieldPrepender(ByteOrder.LITTLE_ENDIAN, 4, 0, false)});
        ch.writeOutbound(new Object[]{this.msg});
        ByteBuf buf = (ByteBuf)ch.readOutbound();
        Assertions.assertEquals((int)4, (int)buf.readableBytes());
        byte[] writtenBytes = new byte[buf.readableBytes()];
        buf.getBytes(0, writtenBytes);
        Assertions.assertEquals((int)1, (int)writtenBytes[0]);
        Assertions.assertEquals((int)0, (int)writtenBytes[1]);
        Assertions.assertEquals((int)0, (int)writtenBytes[2]);
        Assertions.assertEquals((int)0, (int)writtenBytes[3]);
        buf.release();
        buf = (ByteBuf)ch.readOutbound();
        Assertions.assertSame((Object)buf, (Object)this.msg);
        buf.release();
        Assertions.assertFalse((boolean)ch.finish(), (String)"The channel must have been completely read");
    }
}

