/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.bytes;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.bytes.ByteArrayDecoder;
import io.netty.util.internal.EmptyArrays;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ByteArrayDecoderTest {
    private EmbeddedChannel ch;

    @BeforeEach
    public void setUp() {
        this.ch = new EmbeddedChannel(new ChannelHandler[]{new ByteArrayDecoder()});
    }

    @Test
    public void testDecode() {
        byte[] b = new byte[2048];
        new Random().nextBytes(b);
        this.ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])b)});
        Assertions.assertArrayEquals((byte[])b, (byte[])((byte[])this.ch.readInbound()));
    }

    @Test
    public void testDecodeEmpty() {
        this.ch.writeInbound(new Object[]{Unpooled.EMPTY_BUFFER});
        Assertions.assertArrayEquals((byte[])EmptyArrays.EMPTY_BYTES, (byte[])((byte[])this.ch.readInbound()));
    }

    @Test
    public void testDecodeOtherType() {
        String str = "Meep!";
        this.ch.writeInbound(new Object[]{str});
        Assertions.assertSame((Object)str, (Object)this.ch.readInbound());
    }
}

