/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.base64;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import io.netty.handler.codec.base64.Base64Dialect;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class Base64Test {
    @Test
    public void testNotAddNewLineWhenEndOnLimit() {
        ByteBuf src = Unpooled.copiedBuffer((CharSequence)"abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcde", (Charset)CharsetUtil.US_ASCII);
        ByteBuf expectedEncoded = Unpooled.copiedBuffer((CharSequence)"YWJjZGVmZ2hpamtsbW5vcHFyc3R1dnd4eXphYmNkZWZnaGlqa2xtbm9wcXJzdHV2d3h5emFiY2Rl", (Charset)CharsetUtil.US_ASCII);
        Base64Test.testEncode(src, expectedEncoded);
    }

    @Test
    public void testAddNewLine() {
        ByteBuf src = Unpooled.copiedBuffer((CharSequence)"abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz12345678", (Charset)CharsetUtil.US_ASCII);
        ByteBuf expectedEncoded = Unpooled.copiedBuffer((CharSequence)"YWJjZGVmZ2hpamtsbW5vcHFyc3R1dnd4eXphYmNkZWZnaGlqa2xtbm9wcXJzdHV2d3h5ejEyMzQ1\nNjc4", (Charset)CharsetUtil.US_ASCII);
        Base64Test.testEncode(src, expectedEncoded);
    }

    @Test
    public void testEncodeEmpty() {
        ByteBuf src = Unpooled.EMPTY_BUFFER;
        ByteBuf expectedEncoded = Unpooled.EMPTY_BUFFER;
        Base64Test.testEncode(src, expectedEncoded);
    }

    @Test
    public void testPaddingNewline() throws Exception {
        String cert = "-----BEGIN CERTIFICATE-----\nMIICqjCCAjGgAwIBAgICI1YwCQYHKoZIzj0EATAmMSQwIgYDVQQDDBtUcnVzdGVk\nIFRoaW4gQ2xpZW50IFJvb3QgQ0EwIhcRMTYwMTI0MTU0OTQ1LTA2MDAXDTE2MDQy\nNTIyNDk0NVowYzEwMC4GA1UEAwwnREMgMGRlYzI0MGYtOTI2OS00MDY5LWE2MTYt\nYjJmNTI0ZjA2ZGE0MREwDwYDVQQLDAhEQyBJUFNFQzEcMBoGA1UECgwTVHJ1c3Rl\nZCBUaGluIENsaWVudDB2MBAGByqGSM49AgEGBSuBBAAiA2IABOB7pZYC24sF5gJm\nOHXhasxmrNYebdtSAiQRgz0M0pIsogsFeTU/W0HTlTOqwDDckphHESAKHVxa6EBL\nd+/8HYZ1AaCmXtG73XpaOyaRr3TipJl2IaJzwuehgDHs0L+qcqOB8TCB7jAwBgYr\nBgEBEAQEJgwkMGRlYzI0MGYtOTI2OS00MDY5LWE2MTYtYjJmNTI0ZjA2ZGE0MCMG\nCisGAQQBjCHbZwEEFQwTNDkwNzUyMjc1NjM3MTE3Mjg5NjAUBgorBgEEAYwh22cC\nBAYMBDIwNTkwCwYDVR0PBAQDAgXgMAkGA1UdEwQCMAAwHQYDVR0OBBYEFGWljaKj\nwiGqW61PgLL/zLxj4iirMB8GA1UdIwQYMBaAFA2FRBtG/dGnl0iXP2uKFwJHmEQI\nMCcGA1UdJQQgMB4GCCsGAQUFBwMCBggrBgEFBQcDAQYIKwYBBQUHAwkwCQYHKoZI\nzj0EAQNoADBlAjAQFP8rMLUxl36u8610LsSCiRG8pP3gjuLaaJMm3tjbVue/TI4C\nz3iL8i96YWK0VxcCMQC7pf6Wk3RhUU2Sg6S9e6CiirFLDyzLkaWxuCnXcOwTvuXT\nHUQSeUCp2Q6ygS5qKyc=\n-----END CERTIFICATE-----";
        String expected = "MIICqjCCAjGgAwIBAgICI1YwCQYHKoZIzj0EATAmMSQwIgYDVQQDDBtUcnVzdGVkIFRoaW4gQ2xp\nZW50IFJvb3QgQ0EwIhcRMTYwMTI0MTU0OTQ1LTA2MDAXDTE2MDQyNTIyNDk0NVowYzEwMC4GA1UE\nAwwnREMgMGRlYzI0MGYtOTI2OS00MDY5LWE2MTYtYjJmNTI0ZjA2ZGE0MREwDwYDVQQLDAhEQyBJ\nUFNFQzEcMBoGA1UECgwTVHJ1c3RlZCBUaGluIENsaWVudDB2MBAGByqGSM49AgEGBSuBBAAiA2IA\nBOB7pZYC24sF5gJmOHXhasxmrNYebdtSAiQRgz0M0pIsogsFeTU/W0HTlTOqwDDckphHESAKHVxa\n6EBLd+/8HYZ1AaCmXtG73XpaOyaRr3TipJl2IaJzwuehgDHs0L+qcqOB8TCB7jAwBgYrBgEBEAQE\nJgwkMGRlYzI0MGYtOTI2OS00MDY5LWE2MTYtYjJmNTI0ZjA2ZGE0MCMGCisGAQQBjCHbZwEEFQwT\nNDkwNzUyMjc1NjM3MTE3Mjg5NjAUBgorBgEEAYwh22cCBAYMBDIwNTkwCwYDVR0PBAQDAgXgMAkG\nA1UdEwQCMAAwHQYDVR0OBBYEFGWljaKjwiGqW61PgLL/zLxj4iirMB8GA1UdIwQYMBaAFA2FRBtG\n/dGnl0iXP2uKFwJHmEQIMCcGA1UdJQQgMB4GCCsGAQUFBwMCBggrBgEFBQcDAQYIKwYBBQUHAwkw\nCQYHKoZIzj0EAQNoADBlAjAQFP8rMLUxl36u8610LsSCiRG8pP3gjuLaaJMm3tjbVue/TI4Cz3iL\n8i96YWK0VxcCMQC7pf6Wk3RhUU2Sg6S9e6CiirFLDyzLkaWxuCnXcOwTvuXTHUQSeUCp2Q6ygS5q\nKyc=";
        ByteBuf src = Unpooled.wrappedBuffer((byte[])Base64Test.certFromString(cert).getEncoded());
        ByteBuf expectedEncoded = Unpooled.copiedBuffer((CharSequence)expected, (Charset)CharsetUtil.US_ASCII);
        Base64Test.testEncode(src, expectedEncoded);
    }

    private static X509Certificate certFromString(String string) throws Exception {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream bin = new ByteArrayInputStream(string.getBytes(CharsetUtil.US_ASCII));
        return (X509Certificate)factory.generateCertificate(bin);
    }

    private static void testEncode(ByteBuf src, ByteBuf expectedEncoded) {
        ByteBuf encoded = Base64.encode((ByteBuf)src, (boolean)true, (Base64Dialect)Base64Dialect.STANDARD);
        try {
            Assertions.assertEquals((Object)expectedEncoded, (Object)encoded);
        }
        finally {
            src.release();
            expectedEncoded.release();
            encoded.release();
        }
    }

    @Test
    public void testEncodeDecodeBE() throws IOException {
        Base64Test.testEncodeDecode(ByteOrder.BIG_ENDIAN);
    }

    @Test
    public void testEncodeDecodeLE() throws IOException {
        Base64Test.testEncodeDecode(ByteOrder.LITTLE_ENDIAN);
    }

    private static void testEncodeDecode(ByteOrder order) throws IOException {
        Base64Test.testEncodeDecode(order, Base64Dialect.STANDARD);
        Base64Test.testEncodeDecode(order, Base64Dialect.URL_SAFE);
    }

    private static void testEncodeDecode(ByteOrder order, Base64Dialect dialect) throws IOException {
        Base64Test.testEncodeDecode(order, dialect, true, true);
        Base64Test.testEncodeDecode(order, dialect, true, false);
        Base64Test.testEncodeDecode(order, dialect, false, true);
        Base64Test.testEncodeDecode(order, dialect, false, false);
    }

    private static void testEncodeDecode(ByteOrder order, Base64Dialect dialect, boolean breakLines, boolean padded) throws IOException {
        Base64Test.testEncodeDecode(64, order, dialect, breakLines, padded);
        Base64Test.testEncodeDecode(128, order, dialect, breakLines, padded);
        Base64Test.testEncodeDecode(512, order, dialect, breakLines, padded);
        Base64Test.testEncodeDecode(1024, order, dialect, breakLines, padded);
        Base64Test.testEncodeDecode(4096, order, dialect, breakLines, padded);
        Base64Test.testEncodeDecode(8192, order, dialect, breakLines, padded);
        Base64Test.testEncodeDecode(16384, order, dialect, breakLines, padded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testEncodeDecode(int size, ByteOrder order, Base64Dialect dialect, boolean breakLines, boolean padded) throws IOException {
        byte[] bytes = new byte[size];
        ThreadLocalRandom.current().nextBytes(bytes);
        Base64.Encoder jdkEncoder = dialect == Base64Dialect.STANDARD ? java.util.Base64.getEncoder() : java.util.Base64.getUrlEncoder();
        jdkEncoder = padded ? jdkEncoder : jdkEncoder.withoutPadding();
        Base64.Decoder jdkDecoder = dialect == Base64Dialect.STANDARD ? java.util.Base64.getDecoder() : java.util.Base64.getUrlDecoder();
        ByteBuf src = null;
        ByteBuf encoded = null;
        ByteBuf decoded = null;
        ByteBuf expectedBuf = null;
        try {
            byte[] jdKEncoded = breakLines ? Base64Test.insertNewLines(jdkEncoder.encode(bytes)) : jdkEncoder.encode(bytes);
            src = Unpooled.wrappedBuffer((byte[])bytes).order(order);
            encoded = Base64.encode((ByteBuf)src, (boolean)breakLines, (Base64Dialect)dialect, (boolean)padded);
            Assertions.assertEquals((Object)Unpooled.wrappedBuffer((byte[])jdKEncoded), (Object)encoded, (String)(StringUtil.NEWLINE + "expected: " + ByteBufUtil.hexDump((byte[])jdKEncoded) + StringUtil.NEWLINE + "actual--: " + ByteBufUtil.hexDump((ByteBuf)encoded)));
            byte[] jdkDecoded = jdkDecoder.decode(Base64Test.stripNewLines(ByteBufUtil.getBytes((ByteBuf)encoded)));
            decoded = Base64.decode((ByteBuf)encoded, (Base64Dialect)dialect);
            expectedBuf = Unpooled.wrappedBuffer((byte[])bytes);
            Assertions.assertEquals((Object)Unpooled.wrappedBuffer((byte[])jdkDecoded), (Object)decoded, (String)(StringUtil.NEWLINE + "expected: " + ByteBufUtil.hexDump((byte[])jdkDecoded) + StringUtil.NEWLINE + "actual--: " + ByteBufUtil.hexDump((ByteBuf)decoded)));
            Assertions.assertEquals((Object)expectedBuf, (Object)decoded, (String)(StringUtil.NEWLINE + "expected: " + ByteBufUtil.hexDump((ByteBuf)expectedBuf) + StringUtil.NEWLINE + "actual--: " + ByteBufUtil.hexDump((ByteBuf)decoded)));
        }
        catch (Throwable throwable) {
            ReferenceCountUtil.safeRelease(src);
            ReferenceCountUtil.safeRelease(encoded);
            ReferenceCountUtil.safeRelease(decoded);
            ReferenceCountUtil.safeRelease(expectedBuf);
            throw throwable;
        }
        ReferenceCountUtil.safeRelease((Object)src);
        ReferenceCountUtil.safeRelease((Object)encoded);
        ReferenceCountUtil.safeRelease((Object)decoded);
        ReferenceCountUtil.safeRelease((Object)expectedBuf);
    }

    private static byte[] insertNewLines(byte[] src) throws IOException {
        if (src == null || src.length == 0) {
            return src;
        }
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            for (int i = 0; i < src.length; ++i) {
                os.write(src[i]);
                if (i + 1 >= src.length || (i + 1) % 76 != 0) continue;
                os.write(10);
            }
            byte[] byArray = os.toByteArray();
            return byArray;
        }
    }

    private static byte[] stripNewLines(byte[] src) throws IOException {
        if (src == null || src.length == 0) {
            return src;
        }
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            for (byte b : src) {
                if (b == 10) continue;
                os.write(b);
            }
            byte[] byArray = os.toByteArray();
            return byArray;
        }
    }

    @Test
    public void testOverflowEncodedBufferSize() {
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)Base64.encodedBufferSize((int)Integer.MAX_VALUE, (boolean)true));
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)Base64.encodedBufferSize((int)Integer.MAX_VALUE, (boolean)false));
    }

    @Test
    public void testOverflowDecodedBufferSize() {
        Assertions.assertEquals((int)0x60000000, (int)Base64.decodedBufferSize((int)Integer.MAX_VALUE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void decodingFailsOnInvalidInputByte() {
        char[] invalidChars;
        for (char invalidChar : invalidChars = new char[]{'\u007f', '\u0080', '\u00bd', '\u00ff'}) {
            ByteBuf buf = Unpooled.copiedBuffer((CharSequence)("eHh4" + invalidChar), (Charset)CharsetUtil.ISO_8859_1);
            try {
                Base64.decode((ByteBuf)buf);
                Assertions.fail((String)("Invalid character in not detected: " + invalidChar));
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            finally {
                Assertions.assertTrue((boolean)buf.release());
            }
        }
    }
}

