/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.DatagramPacketDecoder;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.SocketUtils;
import java.net.InetSocketAddress;
import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DatagramPacketDecoderTest {
    private EmbeddedChannel channel;

    @BeforeEach
    public void setUp() {
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new DatagramPacketDecoder((MessageToMessageDecoder)new StringDecoder(CharsetUtil.UTF_8))});
    }

    @AfterEach
    public void tearDown() {
        Assertions.assertFalse((boolean)this.channel.finish());
    }

    @Test
    public void testDecode() {
        InetSocketAddress recipient = SocketUtils.socketAddress((String)"127.0.0.1", (int)10000);
        InetSocketAddress sender = SocketUtils.socketAddress((String)"127.0.0.1", (int)20000);
        ByteBuf content = Unpooled.wrappedBuffer((byte[])"netty".getBytes(CharsetUtil.UTF_8));
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{new DatagramPacket(content, recipient, sender)}));
        Assertions.assertEquals((Object)"netty", (Object)this.channel.readInbound());
    }

    @Test
    public void testIsNotSharable() {
        DatagramPacketDecoderTest.testIsSharable(false);
    }

    @Test
    public void testIsSharable() {
        DatagramPacketDecoderTest.testIsSharable(true);
    }

    private static void testIsSharable(boolean sharable) {
        TestMessageToMessageDecoder wrapped = new TestMessageToMessageDecoder(sharable);
        DatagramPacketDecoder decoder = new DatagramPacketDecoder((MessageToMessageDecoder)wrapped);
        Assertions.assertEquals((Object)wrapped.isSharable(), (Object)decoder.isSharable());
    }

    private static final class TestMessageToMessageDecoder
    extends MessageToMessageDecoder<ByteBuf> {
        private final boolean sharable;

        TestMessageToMessageDecoder(boolean sharable) {
            this.sharable = sharable;
        }

        protected void decode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
        }

        public boolean isSharable() {
            return this.sharable;
        }
    }
}

