/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer.search;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.buffer.search.AbstractMultiSearchProcessorFactory;
import io.netty.buffer.search.AhoCorasicSearchProcessorFactory;
import io.netty.util.ByteProcessor;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MultiSearchProcessorTest {
    @Test
    public void testSearchForMultiple() {
        ByteBuf haystack = Unpooled.copiedBuffer((CharSequence)"one two three one", (Charset)CharsetUtil.UTF_8);
        int length = haystack.readableBytes();
        AhoCorasicSearchProcessorFactory.Processor processor = AbstractMultiSearchProcessorFactory.newAhoCorasicSearchProcessorFactory((byte[][])new byte[][]{MultiSearchProcessorTest.bytes("one"), MultiSearchProcessorTest.bytes("two"), MultiSearchProcessorTest.bytes("three")}).newSearchProcessor();
        Assertions.assertEquals((int)-1, (int)processor.getFoundNeedleId());
        Assertions.assertEquals((int)2, (int)haystack.forEachByte((ByteProcessor)processor));
        Assertions.assertEquals((int)0, (int)processor.getFoundNeedleId());
        Assertions.assertEquals((int)6, (int)haystack.forEachByte(3, length - 3, (ByteProcessor)processor));
        Assertions.assertEquals((int)1, (int)processor.getFoundNeedleId());
        Assertions.assertEquals((int)12, (int)haystack.forEachByte(7, length - 7, (ByteProcessor)processor));
        Assertions.assertEquals((int)2, (int)processor.getFoundNeedleId());
        Assertions.assertEquals((int)16, (int)haystack.forEachByte(13, length - 13, (ByteProcessor)processor));
        Assertions.assertEquals((int)0, (int)processor.getFoundNeedleId());
        Assertions.assertEquals((int)-1, (int)haystack.forEachByte(17, length - 17, (ByteProcessor)processor));
        haystack.release();
    }

    @Test
    public void testSearchForMultipleOverlapping() {
        ByteBuf haystack = Unpooled.copiedBuffer((CharSequence)"abcd", (Charset)CharsetUtil.UTF_8);
        int length = haystack.readableBytes();
        AhoCorasicSearchProcessorFactory.Processor processor = AbstractMultiSearchProcessorFactory.newAhoCorasicSearchProcessorFactory((byte[][])new byte[][]{MultiSearchProcessorTest.bytes("ab"), MultiSearchProcessorTest.bytes("bc"), MultiSearchProcessorTest.bytes("cd")}).newSearchProcessor();
        Assertions.assertEquals((int)1, (int)haystack.forEachByte((ByteProcessor)processor));
        Assertions.assertEquals((int)0, (int)processor.getFoundNeedleId());
        Assertions.assertEquals((int)2, (int)haystack.forEachByte(2, length - 2, (ByteProcessor)processor));
        Assertions.assertEquals((int)1, (int)processor.getFoundNeedleId());
        Assertions.assertEquals((int)3, (int)haystack.forEachByte(3, length - 3, (ByteProcessor)processor));
        Assertions.assertEquals((int)2, (int)processor.getFoundNeedleId());
        haystack.release();
    }

    @Test
    public void findLongerNeedleInCaseOfSuffixMatch() {
        ByteBuf haystack = Unpooled.copiedBuffer((CharSequence)"xabcx", (Charset)CharsetUtil.UTF_8);
        AhoCorasicSearchProcessorFactory.Processor processor1 = AbstractMultiSearchProcessorFactory.newAhoCorasicSearchProcessorFactory((byte[][])new byte[][]{MultiSearchProcessorTest.bytes("abc"), MultiSearchProcessorTest.bytes("bc")}).newSearchProcessor();
        Assertions.assertEquals((int)3, (int)haystack.forEachByte((ByteProcessor)processor1));
        Assertions.assertEquals((int)0, (int)processor1.getFoundNeedleId());
        AhoCorasicSearchProcessorFactory.Processor processor2 = AbstractMultiSearchProcessorFactory.newAhoCorasicSearchProcessorFactory((byte[][])new byte[][]{MultiSearchProcessorTest.bytes("bc"), MultiSearchProcessorTest.bytes("abc")}).newSearchProcessor();
        Assertions.assertEquals((int)3, (int)haystack.forEachByte((ByteProcessor)processor2));
        Assertions.assertEquals((int)1, (int)processor2.getFoundNeedleId());
        haystack.release();
    }

    private static byte[] bytes(String s) {
        return s.getBytes(CharsetUtil.UTF_8);
    }
}

