/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.BigEndianHeapByteBufTest;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.NoopResourceLeakTracker;
import io.netty.buffer.SimpleLeakAwareByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.ResourceLeakTracker;
import java.util.ArrayDeque;
import java.util.Queue;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public class SimpleLeakAwareByteBufTest
extends BigEndianHeapByteBufTest {
    private final Class<? extends ByteBuf> clazz = this.leakClass();
    private final Queue<NoopResourceLeakTracker<ByteBuf>> trackers = new ArrayDeque<NoopResourceLeakTracker<ByteBuf>>();

    @Override
    protected final ByteBuf newBuffer(int capacity, int maxCapacity) {
        return this.wrap(super.newBuffer(capacity, maxCapacity));
    }

    private ByteBuf wrap(ByteBuf buffer) {
        NoopResourceLeakTracker<ByteBuf> tracker = new NoopResourceLeakTracker<ByteBuf>();
        SimpleLeakAwareByteBuf leakAwareBuf = this.wrap(buffer, tracker);
        this.trackers.add(tracker);
        return leakAwareBuf;
    }

    protected SimpleLeakAwareByteBuf wrap(ByteBuf buffer, ResourceLeakTracker<ByteBuf> tracker) {
        return new SimpleLeakAwareByteBuf(buffer, tracker);
    }

    @Override
    @BeforeEach
    public void init() {
        super.init();
        this.trackers.clear();
    }

    @Override
    @AfterEach
    public void dispose() {
        NoopResourceLeakTracker<ByteBuf> tracker;
        super.dispose();
        while ((tracker = this.trackers.poll()) != null) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)tracker.get());
        }
    }

    protected Class<? extends ByteBuf> leakClass() {
        return SimpleLeakAwareByteBuf.class;
    }

    @Test
    public void testWrapSlice() {
        this.assertWrapped(this.newBuffer(8).slice());
    }

    @Test
    public void testWrapSlice2() {
        this.assertWrapped(this.newBuffer(8).slice(0, 1));
    }

    @Test
    public void testWrapReadSlice() {
        ByteBuf buffer = this.newBuffer(8);
        if (buffer.isReadable()) {
            this.assertWrapped(buffer.readSlice(1));
        } else {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)buffer.release());
        }
    }

    @Test
    public void testWrapRetainedSlice() {
        ByteBuf buffer = this.newBuffer(8);
        this.assertWrapped(buffer.retainedSlice());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)buffer.release());
    }

    @Test
    public void testWrapRetainedSlice2() {
        ByteBuf buffer = this.newBuffer(8);
        if (buffer.isReadable()) {
            this.assertWrapped(buffer.retainedSlice(0, 1));
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)buffer.release());
    }

    @Test
    public void testWrapReadRetainedSlice() {
        ByteBuf buffer = this.newBuffer(8);
        if (buffer.isReadable()) {
            this.assertWrapped(buffer.readRetainedSlice(1));
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)buffer.release());
    }

    @Test
    public void testWrapDuplicate() {
        this.assertWrapped(this.newBuffer(8).duplicate());
    }

    @Test
    public void testWrapRetainedDuplicate() {
        ByteBuf buffer = this.newBuffer(8);
        this.assertWrapped(buffer.retainedDuplicate());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)buffer.release());
    }

    @Test
    public void testWrapReadOnly() {
        this.assertWrapped(this.newBuffer(8).asReadOnly());
    }

    protected final void assertWrapped(ByteBuf buf) {
        try {
            org.junit.jupiter.api.Assertions.assertSame(this.clazz, buf.getClass());
        }
        finally {
            buf.release();
        }
    }

    @ParameterizedTest
    @EnumSource(value=ReleaseMechanism.class)
    void mustAddStackTraceForOriginalCloseMethodOnDoubleFree(ReleaseMechanism mechanism) throws Exception {
        int trackEveryBuffer = 1;
        ResourceLeakDetector detector = new ResourceLeakDetector(ByteBuf.class, trackEveryBuffer);
        ByteBuf origin = Unpooled.buffer();
        SimpleLeakAwareByteBuf buf = this.wrap(origin, (ResourceLeakTracker<ByteBuf>)detector.track((Object)origin));
        SimpleLeakAwareByteBufTest.originalCloseCall((ByteBuf)buf, mechanism);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)buf.isAccessible());
        IllegalReferenceCountException irce = (IllegalReferenceCountException)org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, () -> ((ByteBuf)buf).release());
        Assertions.assertThat((Throwable)irce).hasStackTraceContaining("originalCloseCall");
    }

    private static void originalCloseCall(ByteBuf buf, ReleaseMechanism mechanism) {
        switch (mechanism) {
            case RELEASE: {
                buf.release();
                break;
            }
            case RELEASE_COUNTED: {
                buf.release(1);
                break;
            }
            default: {
                org.junit.jupiter.api.Assertions.fail((String)("Unknown release mechanism: " + (Object)((Object)mechanism)));
            }
        }
    }

    static enum ReleaseMechanism {
        RELEASE,
        RELEASE_COUNTED;

    }
}

