/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ReadOnlyByteBufferBuf;
import io.netty.buffer.ReadOnlyDirectByteBufferBufTest;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.nio.ByteBuffer;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ReadOnlyByteBufferBufTest
extends ReadOnlyDirectByteBufferBufTest {
    @Override
    protected ByteBuffer allocate(int size) {
        return ByteBuffer.allocate(size);
    }

    @Test
    public void testCopyDirect() {
        ReadOnlyByteBufferBufTest.testCopy(true);
    }

    @Test
    public void testCopyHeap() {
        ReadOnlyByteBufferBufTest.testCopy(false);
    }

    private static void testCopy(boolean direct) {
        byte[] bytes = new byte[1024];
        ThreadLocalRandom.current().nextBytes(bytes);
        ByteBuffer nioBuffer = direct ? ByteBuffer.allocateDirect(bytes.length) : ByteBuffer.allocate(bytes.length);
        nioBuffer.put(bytes).flip();
        ReadOnlyByteBufferBuf buf = new ReadOnlyByteBufferBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, nioBuffer.asReadOnlyBuffer());
        ByteBuf copy = buf.copy();
        Assertions.assertEquals((Object)buf, (Object)copy);
        Assertions.assertEquals((Object)buf.alloc(), (Object)copy.alloc());
        Assertions.assertEquals((Object)buf.isDirect(), (Object)copy.isDirect());
        copy.release();
        buf.release();
    }
}

