/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBufAllocatorTest;
import io.netty.buffer.AllocateBufferEvent;
import io.netty.buffer.AllocateChunkEvent;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.FreeBufferEvent;
import io.netty.buffer.PoolArenaMetric;
import io.netty.buffer.PoolChunk;
import io.netty.buffer.PoolChunkListMetric;
import io.netty.buffer.PoolChunkMetric;
import io.netty.buffer.PoolSubpageMetric;
import io.netty.buffer.PooledByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocatorMetric;
import io.netty.buffer.PooledDirectByteBuf;
import io.netty.buffer.PooledHeapByteBuf;
import io.netty.buffer.PooledUnsafeDirectByteBuf;
import io.netty.buffer.PooledUnsafeHeapByteBuf;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.concurrent.FastThreadLocalThread;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordingStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.condition.EnabledForJreRange;
import org.junit.jupiter.api.condition.JRE;

public class PooledByteBufAllocatorTest
extends AbstractByteBufAllocatorTest<PooledByteBufAllocator> {
    @Override
    protected PooledByteBufAllocator newAllocator(boolean preferDirect) {
        return new PooledByteBufAllocator(preferDirect);
    }

    @Override
    protected PooledByteBufAllocator newUnpooledAllocator() {
        return new PooledByteBufAllocator(0, 0, 8192, 1);
    }

    @Override
    protected long expectedUsedMemory(PooledByteBufAllocator allocator, int capacity) {
        return allocator.metric().chunkSize();
    }

    @Override
    protected long expectedUsedMemoryAfterRelease(PooledByteBufAllocator allocator, int capacity) {
        return allocator.metric().chunkSize();
    }

    @Override
    protected void trimCaches(PooledByteBufAllocator allocator) {
        allocator.trimCurrentThreadCache();
    }

    @Test
    public void testTrim() {
        PooledByteBufAllocator allocator = this.newAllocator(true);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)allocator.trimCurrentThreadCache());
        ByteBuf directBuffer = allocator.directBuffer();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)directBuffer.release());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)allocator.trimCurrentThreadCache());
    }

    @Test
    public void testPooledUnsafeHeapBufferAndUnsafeDirectBuffer() {
        PooledByteBufAllocator allocator = this.newAllocator(true);
        ByteBuf directBuffer = allocator.directBuffer();
        PooledByteBufAllocatorTest.assertInstanceOf(directBuffer, PlatformDependent.hasUnsafe() ? PooledUnsafeDirectByteBuf.class : PooledDirectByteBuf.class);
        directBuffer.release();
        ByteBuf heapBuffer = allocator.heapBuffer();
        PooledByteBufAllocatorTest.assertInstanceOf(heapBuffer, PlatformDependent.hasUnsafe() ? PooledUnsafeHeapByteBuf.class : PooledHeapByteBuf.class);
        heapBuffer.release();
    }

    @Test
    public void testIOBuffersAreDirectWhenCleanerAvailableOrDirectBuffersPooled() {
        PooledByteBufAllocator allocator = this.newAllocator(true);
        ByteBuf ioBuffer = allocator.ioBuffer();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ioBuffer.isDirect());
        ioBuffer.release();
        PooledByteBufAllocator unpooledAllocator = this.newUnpooledAllocator();
        ioBuffer = unpooledAllocator.ioBuffer();
        if (PlatformDependent.canReliabilyFreeDirectBuffers()) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)ioBuffer.isDirect());
        } else {
            org.junit.jupiter.api.Assertions.assertFalse((boolean)ioBuffer.isDirect());
        }
        ioBuffer.release();
    }

    @Test
    public void testWithoutUseCacheForAllThreads() {
        Assertions.assertThat((Object)Thread.currentThread()).isNotInstanceOf(FastThreadLocalThread.class);
        PooledByteBufAllocator pool = new PooledByteBufAllocator(false, 1, 1, 8192, 9, 0, 0, 0, false);
        ByteBuf buf = pool.buffer(1);
        buf.release();
    }

    @Test
    public void testArenaMetricsNoCache() {
        PooledByteBufAllocatorTest.testArenaMetrics0(new PooledByteBufAllocator(true, 2, 2, 8192, 9, 0, 0, 0), 100, 0, 100, 100);
    }

    @Test
    public void testArenaMetricsCache() {
        PooledByteBufAllocatorTest.testArenaMetrics0(new PooledByteBufAllocator(true, 2, 2, 8192, 9, 1000, 1000, 1000, true, 0), 100, 1, 1, 0);
    }

    @Test
    public void testArenaMetricsNoCacheAlign() {
        Assumptions.assumeTrue((boolean)PooledByteBufAllocator.isDirectMemoryCacheAlignmentSupported());
        PooledByteBufAllocatorTest.testArenaMetrics0(new PooledByteBufAllocator(true, 2, 2, 8192, 9, 0, 0, 0, true, 64), 100, 0, 100, 100);
    }

    @Test
    public void testArenaMetricsCacheAlign() {
        Assumptions.assumeTrue((boolean)PooledByteBufAllocator.isDirectMemoryCacheAlignmentSupported());
        PooledByteBufAllocatorTest.testArenaMetrics0(new PooledByteBufAllocator(true, 2, 2, 8192, 9, 1000, 1000, 1000, true, 64), 100, 1, 1, 0);
    }

    private static void testArenaMetrics0(PooledByteBufAllocator allocator, int num, int expectedActive, int expectedAlloc, int expectedDealloc) {
        for (int i = 0; i < num; ++i) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)allocator.directBuffer().release());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)allocator.heapBuffer().release());
        }
        PooledByteBufAllocatorTest.assertArenaMetrics(allocator.metric().directArenas(), expectedActive, expectedAlloc, expectedDealloc);
        PooledByteBufAllocatorTest.assertArenaMetrics(allocator.metric().heapArenas(), expectedActive, expectedAlloc, expectedDealloc);
    }

    private static void assertArenaMetrics(List<PoolArenaMetric> arenaMetrics, int expectedActive, int expectedAlloc, int expectedDealloc) {
        long active = 0L;
        long alloc = 0L;
        long dealloc = 0L;
        for (PoolArenaMetric arena : arenaMetrics) {
            active += arena.numActiveAllocations();
            alloc += arena.numAllocations();
            dealloc += arena.numDeallocations();
        }
        org.junit.jupiter.api.Assertions.assertEquals((long)expectedActive, (long)active);
        org.junit.jupiter.api.Assertions.assertEquals((long)expectedAlloc, (long)alloc);
        org.junit.jupiter.api.Assertions.assertEquals((long)expectedDealloc, (long)dealloc);
    }

    @Test
    public void testPoolChunkListMetric() {
        for (PoolArenaMetric arenaMetric : PooledByteBufAllocator.DEFAULT.metric().heapArenas()) {
            PooledByteBufAllocatorTest.assertPoolChunkListMetric(arenaMetric);
        }
    }

    private static void assertPoolChunkListMetric(PoolArenaMetric arenaMetric) {
        List lists = arenaMetric.chunkLists();
        org.junit.jupiter.api.Assertions.assertEquals((int)6, (int)lists.size());
        PooledByteBufAllocatorTest.assertPoolChunkListMetric((PoolChunkListMetric)lists.get(0), 1, 25);
        PooledByteBufAllocatorTest.assertPoolChunkListMetric((PoolChunkListMetric)lists.get(1), 1, 50);
        PooledByteBufAllocatorTest.assertPoolChunkListMetric((PoolChunkListMetric)lists.get(2), 25, 75);
        PooledByteBufAllocatorTest.assertPoolChunkListMetric((PoolChunkListMetric)lists.get(4), 75, 100);
        PooledByteBufAllocatorTest.assertPoolChunkListMetric((PoolChunkListMetric)lists.get(5), 100, 100);
    }

    private static void assertPoolChunkListMetric(PoolChunkListMetric m, int min, int max) {
        org.junit.jupiter.api.Assertions.assertEquals((int)min, (int)m.minUsage());
        org.junit.jupiter.api.Assertions.assertEquals((int)max, (int)m.maxUsage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSmallSubpageMetric() {
        PooledByteBufAllocator allocator = new PooledByteBufAllocator(true, 1, 1, 8192, 9, 0, 0, 0);
        ByteBuf buffer = allocator.heapBuffer(500);
        try {
            PoolArenaMetric metric = (PoolArenaMetric)allocator.metric().heapArenas().get(0);
            PoolSubpageMetric subpageMetric = (PoolSubpageMetric)metric.smallSubpages().get(0);
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)(subpageMetric.maxNumElements() - subpageMetric.numAvailable()));
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testAllocNotNull() {
        PooledByteBufAllocator allocator = new PooledByteBufAllocator(true, 1, 1, 8192, 9, 0, 0, 0);
        PooledByteBufAllocatorTest.testAllocNotNull(allocator, allocator.metric().chunkSize() + 1);
        PooledByteBufAllocatorTest.testAllocNotNull(allocator, 1024);
        PooledByteBufAllocatorTest.testAllocNotNull(allocator, 512);
        PooledByteBufAllocatorTest.testAllocNotNull(allocator, 1);
    }

    private static void testAllocNotNull(PooledByteBufAllocator allocator, int capacity) {
        ByteBuf buffer = allocator.heapBuffer(capacity);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)buffer.alloc());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)buffer.release());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)buffer.alloc());
    }

    @Test
    public void testFreePoolChunk() {
        int chunkSize = 0x1000000;
        PooledByteBufAllocator allocator = new PooledByteBufAllocator(true, 1, 0, 8192, 11, 0, 0, 0);
        ByteBuf buffer = allocator.heapBuffer(chunkSize);
        List arenas = allocator.metric().heapArenas();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)arenas.size());
        List lists = ((PoolArenaMetric)arenas.get(0)).chunkLists();
        org.junit.jupiter.api.Assertions.assertEquals((int)6, (int)lists.size());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((PoolChunkListMetric)lists.get(0)).iterator().hasNext());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((PoolChunkListMetric)lists.get(1)).iterator().hasNext());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((PoolChunkListMetric)lists.get(2)).iterator().hasNext());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((PoolChunkListMetric)lists.get(3)).iterator().hasNext());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((PoolChunkListMetric)lists.get(4)).iterator().hasNext());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((PoolChunkListMetric)lists.get(5)).iterator().hasNext());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)buffer.release());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((PoolChunkListMetric)lists.get(0)).iterator().hasNext());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((PoolChunkListMetric)lists.get(1)).iterator().hasNext());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((PoolChunkListMetric)lists.get(2)).iterator().hasNext());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((PoolChunkListMetric)lists.get(3)).iterator().hasNext());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((PoolChunkListMetric)lists.get(4)).iterator().hasNext());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((PoolChunkListMetric)lists.get(5)).iterator().hasNext());
    }

    @Test
    public void testCollapse() {
        int pageSize = 8192;
        PooledByteBufAllocator allocator = new PooledByteBufAllocator(true, 1, 1, 8192, 9, 0, 0, 0);
        ByteBuf b1 = allocator.buffer(pageSize * 4);
        ByteBuf b2 = allocator.buffer(pageSize * 5);
        ByteBuf b3 = allocator.buffer(pageSize * 6);
        b2.release();
        b3.release();
        ByteBuf b4 = allocator.buffer(pageSize * 10);
        PooledByteBuf b = PooledByteBufAllocatorTest.unwrapIfNeeded(b4);
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)PoolChunk.runOffset((long)b.handle));
        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)PoolChunk.runPages((long)b.handle));
        b1.release();
        b4.release();
        ByteBuf b5 = allocator.buffer(pageSize * 20);
        b = PooledByteBufAllocatorTest.unwrapIfNeeded(b5);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)PoolChunk.runOffset((long)b.handle));
        org.junit.jupiter.api.Assertions.assertEquals((int)20, (int)PoolChunk.runPages((long)b.handle));
        b5.release();
    }

    @Test
    public void testAllocateSmallOffset() {
        PooledByteBuf unwrapedBuf;
        ByteBuf buf;
        int i;
        int pageSize = 8192;
        PooledByteBufAllocator allocator = new PooledByteBufAllocator(true, 1, 1, 8192, 9, 0, 0, 0);
        int size = pageSize * 5;
        ByteBuf[] bufs = new ByteBuf[10];
        for (i = 0; i < 10; ++i) {
            bufs[i] = allocator.buffer(size);
        }
        for (i = 0; i < 5; ++i) {
            bufs[i].release();
        }
        for (i = 0; i < 5; ++i) {
            buf = allocator.buffer(size);
            unwrapedBuf = PooledByteBufAllocatorTest.unwrapIfNeeded(buf);
            org.junit.jupiter.api.Assertions.assertEquals((int)PoolChunk.runOffset((long)unwrapedBuf.handle), (int)(i * 5));
            bufs[i] = buf;
        }
        for (i = 9; i >= 5; --i) {
            bufs[i].release();
        }
        for (i = 5; i < 10; ++i) {
            buf = allocator.buffer(size);
            unwrapedBuf = PooledByteBufAllocatorTest.unwrapIfNeeded(buf);
            org.junit.jupiter.api.Assertions.assertEquals((int)PoolChunk.runOffset((long)unwrapedBuf.handle), (int)(i * 5));
            bufs[i] = buf;
        }
        for (i = 0; i < 10; ++i) {
            bufs[i].release();
        }
    }

    @Test
    @Timeout(value=10L, threadMode=Timeout.ThreadMode.SEPARATE_THREAD)
    public void testThreadCacheDestroyedByThreadCleaner() throws InterruptedException {
        PooledByteBufAllocatorTest.testThreadCacheDestroyed(false);
    }

    @Test
    @Timeout(value=10L, threadMode=Timeout.ThreadMode.SEPARATE_THREAD)
    public void testThreadCacheDestroyedAfterExitRun() throws InterruptedException {
        PooledByteBufAllocatorTest.testThreadCacheDestroyed(true);
    }

    private static void testThreadCacheDestroyed(boolean useRunnable) throws InterruptedException {
        int numArenas = 11;
        final PooledByteBufAllocator allocator = new PooledByteBufAllocator(numArenas, numArenas, 8192, 1);
        final AtomicBoolean threadCachesCreated = new AtomicBoolean(true);
        final Runnable task = new Runnable(){

            @Override
            public void run() {
                ByteBuf buf = allocator.newHeapBuffer(1024, 1024);
                for (int i = 0; i < buf.capacity(); ++i) {
                    buf.writeByte(0);
                }
                if (allocator.metric().numThreadLocalCaches() == 0) {
                    threadCachesCreated.set(false);
                }
                buf.release();
            }
        };
        for (int i = 0; i < numArenas; ++i) {
            FastThreadLocalThread thread;
            if (useRunnable) {
                thread = new FastThreadLocalThread(task);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)thread.willCleanupFastThreadLocals());
            } else {
                thread = new FastThreadLocalThread(){

                    public void run() {
                        task.run();
                    }
                };
                org.junit.jupiter.api.Assertions.assertFalse((boolean)thread.willCleanupFastThreadLocals());
            }
            thread.start();
            thread.join();
        }
        while (allocator.metric().numThreadLocalCaches() > 0) {
            System.gc();
            System.runFinalization();
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(100L));
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)threadCachesCreated.get());
    }

    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testNumThreadCachesWithNoDirectArenas() throws InterruptedException {
        int numHeapArenas = 1;
        PooledByteBufAllocator allocator = new PooledByteBufAllocator(numHeapArenas, 0, 8192, 1);
        ThreadCache tcache0 = PooledByteBufAllocatorTest.createNewThreadCache(allocator, false);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)allocator.metric().numThreadLocalCaches());
        ThreadCache tcache1 = PooledByteBufAllocatorTest.createNewThreadCache(allocator, false);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)allocator.metric().numThreadLocalCaches());
        tcache0.destroy();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)allocator.metric().numThreadLocalCaches());
        tcache1.destroy();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)allocator.metric().numThreadLocalCaches());
    }

    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testNumThreadCachesAccountForDirectAndHeapArenas() throws InterruptedException {
        int numHeapArenas = 1;
        PooledByteBufAllocator allocator = new PooledByteBufAllocator(numHeapArenas, 0, 8192, 1);
        ThreadCache tcache0 = PooledByteBufAllocatorTest.createNewThreadCache(allocator, false);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)allocator.metric().numThreadLocalCaches());
        ThreadCache tcache1 = PooledByteBufAllocatorTest.createNewThreadCache(allocator, true);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)allocator.metric().numThreadLocalCaches());
        tcache0.destroy();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)allocator.metric().numThreadLocalCaches());
        tcache1.destroy();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)allocator.metric().numThreadLocalCaches());
    }

    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testThreadCacheToArenaMappings() throws InterruptedException {
        int numArenas = 2;
        PooledByteBufAllocator allocator = new PooledByteBufAllocator(numArenas, numArenas, 8192, 1);
        ThreadCache tcache0 = PooledByteBufAllocatorTest.createNewThreadCache(allocator, false);
        ThreadCache tcache1 = PooledByteBufAllocatorTest.createNewThreadCache(allocator, false);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)allocator.metric().numThreadLocalCaches());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((PoolArenaMetric)allocator.metric().heapArenas().get(0)).numThreadCaches());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((PoolArenaMetric)allocator.metric().heapArenas().get(1)).numThreadCaches());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((PoolArenaMetric)allocator.metric().directArenas().get(0)).numThreadCaches());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((PoolArenaMetric)allocator.metric().directArenas().get(0)).numThreadCaches());
        tcache1.destroy();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)allocator.metric().numThreadLocalCaches());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((PoolArenaMetric)allocator.metric().heapArenas().get(0)).numThreadCaches());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)((PoolArenaMetric)allocator.metric().heapArenas().get(1)).numThreadCaches());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((PoolArenaMetric)allocator.metric().directArenas().get(0)).numThreadCaches());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)((PoolArenaMetric)allocator.metric().directArenas().get(1)).numThreadCaches());
        ThreadCache tcache2 = PooledByteBufAllocatorTest.createNewThreadCache(allocator, false);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)allocator.metric().numThreadLocalCaches());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((PoolArenaMetric)allocator.metric().heapArenas().get(0)).numThreadCaches());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((PoolArenaMetric)allocator.metric().heapArenas().get(1)).numThreadCaches());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((PoolArenaMetric)allocator.metric().directArenas().get(0)).numThreadCaches());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((PoolArenaMetric)allocator.metric().directArenas().get(1)).numThreadCaches());
        tcache0.destroy();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)allocator.metric().numThreadLocalCaches());
        tcache2.destroy();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)allocator.metric().numThreadLocalCaches());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)((PoolArenaMetric)allocator.metric().heapArenas().get(0)).numThreadCaches());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)((PoolArenaMetric)allocator.metric().heapArenas().get(1)).numThreadCaches());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)((PoolArenaMetric)allocator.metric().directArenas().get(0)).numThreadCaches());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)((PoolArenaMetric)allocator.metric().directArenas().get(1)).numThreadCaches());
    }

    private static ThreadCache createNewThreadCache(final PooledByteBufAllocator allocator, final boolean direct) throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        final CountDownLatch cacheLatch = new CountDownLatch(1);
        FastThreadLocalThread t = new FastThreadLocalThread(new Runnable(){

            @Override
            public void run() {
                ByteBuf buf = direct ? allocator.newDirectBuffer(1024, 1024) : allocator.newHeapBuffer(1024, 1024);
                cacheLatch.countDown();
                buf.writeZero(buf.capacity());
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException(e);
                }
                buf.release();
                FastThreadLocal.removeAll();
            }
        });
        t.start();
        cacheLatch.await();
        return new ThreadCache((Thread)t){
            final /* synthetic */ Thread val$t;
            {
                this.val$t = thread;
            }

            @Override
            public void destroy() throws InterruptedException {
                latch.countDown();
                this.val$t.join();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentUsage() throws Throwable {
        long runningTime = TimeUnit.MILLISECONDS.toNanos(SystemPropertyUtil.getLong((String)"io.netty.buffer.PooledByteBufAllocatorTest.testConcurrentUsageTime", (long)15000L));
        PooledByteBufAllocator allocator = new PooledByteBufAllocator(true, 0, 1, 8192, 9, 0, 0, 0);
        ArrayList<AllocationThread> threads = new ArrayList<AllocationThread>();
        try {
            for (int i = 0; i < 64; ++i) {
                AllocationThread thread = new AllocationThread((ByteBufAllocator)allocator);
                thread.start();
                threads.add(thread);
            }
            long start = System.nanoTime();
            while (!PooledByteBufAllocatorTest.isExpired(start, runningTime)) {
                PooledByteBufAllocatorTest.checkForErrors(threads);
                Thread.sleep(100L);
            }
        }
        finally {
            for (AllocationThread t : threads) {
                t.markAsFinished();
            }
            for (AllocationThread t : threads) {
                t.joinAndCheckForError();
            }
        }
    }

    private static boolean isExpired(long start, long expireTime) {
        return System.nanoTime() - start > expireTime;
    }

    private static void checkForErrors(List<AllocationThread> threads) throws Throwable {
        for (AllocationThread t : threads) {
            if (!t.isFinished()) continue;
            t.checkForError();
        }
    }

    private static <T> PooledByteBuf<T> unwrapIfNeeded(ByteBuf buf) {
        return (PooledByteBuf)(buf instanceof PooledByteBuf ? buf : buf.unwrap());
    }

    @Test
    public void testCacheWorksForNormalAllocations() {
        int maxCachedBufferCapacity = PooledByteBufAllocator.DEFAULT_MAX_CACHED_BUFFER_CAPACITY;
        PooledByteBufAllocator allocator = new PooledByteBufAllocator(true, 0, 1, PooledByteBufAllocator.defaultPageSize(), PooledByteBufAllocator.defaultMaxOrder(), 128, 128, true);
        ByteBuf buffer = allocator.directBuffer(maxCachedBufferCapacity);
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)((PoolArenaMetric)allocator.metric().directArenas().get(0)).numNormalAllocations());
        buffer.release();
        buffer = allocator.directBuffer(maxCachedBufferCapacity);
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)((PoolArenaMetric)allocator.metric().directArenas().get(0)).numNormalAllocations());
        buffer.release();
        buffer = allocator.directBuffer(maxCachedBufferCapacity + 1);
        org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)((PoolArenaMetric)allocator.metric().directArenas().get(0)).numNormalAllocations());
        buffer.release();
        buffer = allocator.directBuffer(maxCachedBufferCapacity + 1);
        org.junit.jupiter.api.Assertions.assertEquals((long)3L, (long)((PoolArenaMetric)allocator.metric().directArenas().get(0)).numNormalAllocations());
        buffer.release();
    }

    @Test
    public void testNormalPoolSubpageRelease() {
        int elemSize = 8192;
        int length = 1024;
        ByteBuf[] byteBufs = new ByteBuf[length];
        PooledByteBufAllocator allocator = new PooledByteBufAllocator(false, 32, 32, 8192, 11, 256, 64, false, 0);
        for (int i = 0; i < length; ++i) {
            byteBufs[i] = allocator.heapBuffer(elemSize, elemSize);
        }
        PoolChunk chunk = PooledByteBufAllocatorTest.unwrapIfNeeded((ByteBuf)byteBufs[0]).chunk;
        int beforeFreeBytes = chunk.freeBytes();
        for (int i = 0; i < length; ++i) {
            byteBufs[i].release();
        }
        int afterFreeBytes = chunk.freeBytes();
        org.junit.jupiter.api.Assertions.assertTrue((beforeFreeBytes < afterFreeBytes ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void testUsedDirectMemory() {
        for (int power = 0; power < 8; ++power) {
            int initialCapacity = 1024 << power;
            this.testUsedDirectMemory(initialCapacity);
        }
    }

    private void testUsedDirectMemory(int initialCapacity) {
        int i;
        PooledByteBufAllocator allocator = this.newAllocator(true);
        PooledByteBufAllocatorMetric metric = allocator.metric();
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)metric.usedDirectMemory());
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)allocator.pinnedDirectMemory());
        ByteBuf buffer = allocator.directBuffer(initialCapacity, 4 * initialCapacity);
        int capacity = buffer.capacity();
        org.junit.jupiter.api.Assertions.assertEquals((long)this.expectedUsedMemory(allocator, capacity), (long)metric.usedDirectMemory());
        Assertions.assertThat((long)allocator.pinnedDirectMemory()).isGreaterThanOrEqualTo((long)capacity).isLessThanOrEqualTo(metric.usedDirectMemory());
        buffer.capacity(capacity << 1);
        capacity = buffer.capacity();
        org.junit.jupiter.api.Assertions.assertEquals((long)this.expectedUsedMemory(allocator, capacity), (long)metric.usedDirectMemory(), (String)buffer.toString());
        Assertions.assertThat((long)allocator.pinnedDirectMemory()).isGreaterThanOrEqualTo((long)capacity).isLessThanOrEqualTo(metric.usedDirectMemory());
        buffer.release();
        org.junit.jupiter.api.Assertions.assertEquals((long)this.expectedUsedMemoryAfterRelease(allocator, capacity), (long)metric.usedDirectMemory());
        Assertions.assertThat((long)allocator.pinnedDirectMemory()).isGreaterThanOrEqualTo(0L).isLessThanOrEqualTo(metric.usedDirectMemory());
        this.trimCaches(allocator);
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)allocator.pinnedDirectMemory());
        int[] capacities = new int[30];
        Random rng = new Random();
        for (int i2 = 0; i2 < capacities.length; ++i2) {
            capacities[i2] = initialCapacity / 4 + rng.nextInt(8 * initialCapacity);
        }
        ByteBuf[] bufs = new ByteBuf[capacities.length];
        for (i = 0; i < 20; ++i) {
            bufs[i] = allocator.directBuffer(capacities[i], 2 * capacities[i]);
        }
        for (i = 0; i < 10; ++i) {
            bufs[i].release();
        }
        for (i = 20; i < 30; ++i) {
            bufs[i] = allocator.directBuffer(capacities[i], 2 * capacities[i]);
        }
        for (i = 0; i < 10; ++i) {
            bufs[i] = allocator.directBuffer(capacities[i], 2 * capacities[i]);
        }
        for (i = 0; i < 30; ++i) {
            bufs[i].release();
        }
        this.trimCaches(allocator);
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)allocator.pinnedDirectMemory());
    }

    @Override
    @Test
    public void testUsedHeapMemory() {
        for (int power = 0; power < 8; ++power) {
            int initialCapacity = 1024 << power;
            this.testUsedHeapMemory(initialCapacity);
        }
    }

    private void testUsedHeapMemory(int initialCapacity) {
        int i;
        PooledByteBufAllocator allocator = this.newAllocator(true);
        PooledByteBufAllocatorMetric metric = allocator.metric();
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)metric.usedHeapMemory());
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)allocator.pinnedDirectMemory());
        ByteBuf buffer = allocator.heapBuffer(initialCapacity, 4 * initialCapacity);
        int capacity = buffer.capacity();
        org.junit.jupiter.api.Assertions.assertEquals((long)this.expectedUsedMemory(allocator, capacity), (long)metric.usedHeapMemory());
        Assertions.assertThat((long)allocator.pinnedHeapMemory()).isGreaterThanOrEqualTo((long)capacity).isLessThanOrEqualTo(metric.usedHeapMemory());
        buffer.capacity(capacity << 1);
        capacity = buffer.capacity();
        org.junit.jupiter.api.Assertions.assertEquals((long)this.expectedUsedMemory(allocator, capacity), (long)metric.usedHeapMemory());
        Assertions.assertThat((long)allocator.pinnedHeapMemory()).isGreaterThanOrEqualTo((long)capacity).isLessThanOrEqualTo(metric.usedHeapMemory());
        buffer.release();
        org.junit.jupiter.api.Assertions.assertEquals((long)this.expectedUsedMemoryAfterRelease(allocator, capacity), (long)metric.usedHeapMemory());
        Assertions.assertThat((long)allocator.pinnedHeapMemory()).isGreaterThanOrEqualTo(0L).isLessThanOrEqualTo(metric.usedHeapMemory());
        this.trimCaches(allocator);
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)allocator.pinnedHeapMemory());
        int[] capacities = new int[30];
        Random rng = new Random();
        for (int i2 = 0; i2 < capacities.length; ++i2) {
            capacities[i2] = initialCapacity / 4 + rng.nextInt(8 * initialCapacity);
        }
        ByteBuf[] bufs = new ByteBuf[capacities.length];
        for (i = 0; i < 20; ++i) {
            bufs[i] = allocator.heapBuffer(capacities[i], 2 * capacities[i]);
        }
        for (i = 0; i < 10; ++i) {
            bufs[i].release();
        }
        for (i = 20; i < 30; ++i) {
            bufs[i] = allocator.heapBuffer(capacities[i], 2 * capacities[i]);
        }
        for (i = 0; i < 10; ++i) {
            bufs[i] = allocator.heapBuffer(capacities[i], 2 * capacities[i]);
        }
        for (i = 0; i < 30; ++i) {
            bufs[i].release();
        }
        this.trimCaches(allocator);
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)allocator.pinnedDirectMemory());
    }

    @Test
    public void pinnedMemoryMustReflectBuffersInUseWithThreadLocalCaching() {
        PooledByteBufAllocatorTest.pinnedMemoryMustReflectBuffersInUse(true);
    }

    @Test
    public void pinnedMemoryMustReflectBuffersInUseWithoutThreadLocalCaching() {
        PooledByteBufAllocatorTest.pinnedMemoryMustReflectBuffersInUse(false);
    }

    private static void pinnedMemoryMustReflectBuffersInUse(boolean useThreadLocalCaching) {
        int normalCacheSize;
        int smallCacheSize;
        if (useThreadLocalCaching) {
            smallCacheSize = PooledByteBufAllocator.defaultSmallCacheSize();
            normalCacheSize = PooledByteBufAllocator.defaultNormalCacheSize();
        } else {
            smallCacheSize = 0;
            normalCacheSize = 0;
        }
        int directMemoryCacheAlignment = 0;
        PooledByteBufAllocator alloc = new PooledByteBufAllocator(PooledByteBufAllocator.defaultPreferDirect(), 1, 1, PooledByteBufAllocator.defaultPageSize(), PooledByteBufAllocator.defaultMaxOrder(), smallCacheSize, normalCacheSize, useThreadLocalCaching, directMemoryCacheAlignment);
        PooledByteBufAllocatorMetric metric = alloc.metric();
        AtomicLong capSum = new AtomicLong();
        for (long index = 0L; index < 10000L; ++index) {
            ByteBuf buf;
            int i;
            ThreadLocalRandom rnd = ThreadLocalRandom.current();
            int bufCount = rnd.nextInt(1, 100);
            ArrayList<ByteBuf> buffers = new ArrayList<ByteBuf>(bufCount);
            if (index % 2L == 0L) {
                for (i = 0; i < bufCount; ++i) {
                    buf = alloc.directBuffer(rnd.nextInt(8, 128));
                    buffers.add(buf);
                    capSum.addAndGet(buf.capacity());
                }
            } else {
                for (i = 0; i < bufCount; ++i) {
                    buf = alloc.directBuffer(rnd.nextInt(1024, 102400));
                    buffers.add(buf);
                    capSum.addAndGet(buf.capacity());
                }
            }
            if (index % 100L == 0L) {
                long used = PooledByteBufAllocatorTest.usedMemory(metric.directArenas());
                long pinned = alloc.pinnedDirectMemory();
                Assertions.assertThat((long)capSum.get()).isLessThanOrEqualTo(pinned);
                Assertions.assertThat((long)pinned).isLessThanOrEqualTo(used);
            }
            for (ByteBuf buffer : buffers) {
                buffer.release();
            }
            capSum.set(0L);
            Assertions.assertThat((long)alloc.pinnedDirectMemory()).isZero();
        }
    }

    private static long usedMemory(List<PoolArenaMetric> arenas) {
        long totalUsed = 0L;
        for (PoolArenaMetric arenaMetrics : arenas) {
            for (PoolChunkListMetric arenaMetric : arenaMetrics.chunkLists()) {
                for (PoolChunkMetric chunkMetric : arenaMetric) {
                    totalUsed += (long)(chunkMetric.chunkSize() - chunkMetric.freeBytes());
                }
            }
        }
        return totalUsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCapacityChangeDoesntThrowAssertionError() throws Exception {
        PooledByteBufAllocator allocator = this.newAllocator(true);
        ArrayList<ByteBuf> buffers = new ArrayList<ByteBuf>();
        try {
            for (int i = 0; i < 31; ++i) {
                buffers.add(allocator.heapBuffer());
            }
            final ByteBuf buf = allocator.heapBuffer();
            buffers.add(buf);
            final AtomicReference assertionRef = new AtomicReference();
            Runnable capacityChangeTask = new Runnable(){

                @Override
                public void run() {
                    try {
                        buf.capacity(512);
                    }
                    catch (AssertionError e) {
                        assertionRef.compareAndSet(null, e);
                        throw e;
                    }
                }
            };
            Thread thread1 = new Thread(capacityChangeTask);
            Thread thread2 = new Thread(capacityChangeTask);
            thread1.start();
            thread2.start();
            thread1.join();
            thread2.join();
            buffers.add(allocator.heapBuffer());
            buffers.add(allocator.heapBuffer());
            AssertionError error = (AssertionError)assertionRef.get();
            if (error != null) {
                throw error;
            }
        }
        finally {
            for (ByteBuf buffer : buffers) {
                buffer.release();
            }
        }
    }

    @Test
    @EnabledForJreRange(min=JRE.JAVA_17)
    @Timeout(value=10L)
    public void jfrChunkAllocation() throws Exception {
        try (RecordingStream stream = new RecordingStream();){
            CompletableFuture allocateFuture = new CompletableFuture();
            stream.enable(AllocateChunkEvent.class);
            stream.onEvent("io.netty.AllocateChunk", allocateFuture::complete);
            stream.startAsync();
            PooledByteBufAllocator alloc = this.newAllocator(true);
            alloc.directBuffer(128).release();
            RecordedEvent allocate = (RecordedEvent)allocateFuture.get();
            org.junit.jupiter.api.Assertions.assertEquals((int)alloc.metric().chunkSize(), (int)allocate.getInt("capacity"));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)allocate.getBoolean("pooled"));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)allocate.getBoolean("threadLocal"));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)allocate.getBoolean("direct"));
        }
    }

    @Test
    @EnabledForJreRange(min=JRE.JAVA_17)
    @Timeout(value=10L)
    public void shouldCreateTwoChunks() throws Exception {
        try (RecordingStream stream = new RecordingStream();){
            CountDownLatch eventsFlushed = new CountDownLatch(2);
            stream.enable(AllocateChunkEvent.class);
            stream.onEvent("io.netty.AllocateChunk", event -> eventsFlushed.countDown());
            stream.startAsync();
            PooledByteBufAllocator allocator = this.newAllocator(false);
            int bufSize = 16896;
            int bufsToAllocate = 1 + allocator.metric().chunkSize() / bufSize;
            ArrayList<ByteBuf> buffers = new ArrayList<ByteBuf>(bufsToAllocate);
            for (int i = 0; i < bufsToAllocate; ++i) {
                buffers.add(allocator.heapBuffer(bufSize, bufSize));
            }
            for (ByteBuf buffer : buffers) {
                buffer.release();
            }
            buffers.clear();
            eventsFlushed.await();
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)eventsFlushed.getCount());
        }
    }

    @Test
    @EnabledForJreRange(min=JRE.JAVA_17)
    @Timeout(value=10L)
    public void shouldReuseTheSameChunk() throws Exception {
        try (RecordingStream stream = new RecordingStream();){
            int i;
            CountDownLatch eventsFlushed = new CountDownLatch(1);
            AtomicInteger chunksAllocations = new AtomicInteger();
            stream.enable(AllocateChunkEvent.class);
            stream.onEvent("io.netty.AllocateChunk", event -> {
                chunksAllocations.incrementAndGet();
                eventsFlushed.countDown();
            });
            stream.startAsync();
            int bufSize = 16896;
            PooledByteBufAllocator allocator = this.newAllocator(false);
            ByteBuf buf = allocator.heapBuffer(bufSize, bufSize);
            int bufPin = Math.toIntExact(allocator.pinnedHeapMemory());
            buf.release();
            int bufsPerChunk = allocator.metric().chunkSize() / bufPin;
            ArrayList<ByteBuf> buffers = new ArrayList<ByteBuf>(bufsPerChunk);
            for (i = 0; i < bufsPerChunk - 2; ++i) {
                buffers.add(allocator.heapBuffer(bufSize, bufSize));
            }
            for (i = 0; i < 128; ++i) {
                allocator.heapBuffer(bufSize, bufSize).release();
            }
            for (ByteBuf buffer : buffers) {
                buffer.release();
            }
            buffers.clear();
            eventsFlushed.await();
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)chunksAllocations.get());
        }
    }

    @Test
    @EnabledForJreRange(min=JRE.JAVA_17)
    @Timeout(value=10L)
    public void jfrBufferAllocation() throws Exception {
        try (RecordingStream stream = new RecordingStream();){
            CompletableFuture allocateFuture = new CompletableFuture();
            CompletableFuture releaseFuture = new CompletableFuture();
            stream.enable(AllocateBufferEvent.class);
            stream.onEvent("io.netty.AllocateBuffer", allocateFuture::complete);
            stream.enable(FreeBufferEvent.class);
            stream.onEvent("io.netty.FreeBuffer", releaseFuture::complete);
            stream.startAsync();
            PooledByteBufAllocator alloc = this.newAllocator(true);
            alloc.directBuffer(128).release();
            RecordedEvent allocate = (RecordedEvent)allocateFuture.get();
            org.junit.jupiter.api.Assertions.assertEquals((int)128, (int)allocate.getInt("size"));
            org.junit.jupiter.api.Assertions.assertEquals((int)128, (int)allocate.getInt("maxFastCapacity"));
            org.junit.jupiter.api.Assertions.assertEquals((int)Integer.MAX_VALUE, (int)allocate.getInt("maxCapacity"));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)allocate.getBoolean("chunkPooled"));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)allocate.getBoolean("chunkThreadLocal"));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)allocate.getBoolean("direct"));
            RecordedEvent release = (RecordedEvent)releaseFuture.get();
            org.junit.jupiter.api.Assertions.assertEquals((int)128, (int)release.getInt("size"));
            org.junit.jupiter.api.Assertions.assertEquals((int)128, (int)release.getInt("maxFastCapacity"));
            org.junit.jupiter.api.Assertions.assertEquals((int)Integer.MAX_VALUE, (int)release.getInt("maxCapacity"));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)release.getBoolean("direct"));
        }
    }

    @Test
    @EnabledForJreRange(min=JRE.JAVA_17)
    @Timeout(value=10L)
    public void jfrBufferAllocationThreadLocal() throws Exception {
        PooledByteBufAllocator alloc = this.newAllocator(true);
        Callable<Void> allocateAndRelease = () -> PooledByteBufAllocatorTest.lambda$jfrBufferAllocationThreadLocal$2((ByteBufAllocator)alloc);
        FutureTask<Void> task = new FutureTask<Void>(allocateAndRelease);
        FastThreadLocalThread thread = new FastThreadLocalThread(task);
        thread.start();
        task.get();
    }

    private static /* synthetic */ Void lambda$jfrBufferAllocationThreadLocal$2(ByteBufAllocator alloc) throws Exception {
        try (RecordingStream stream = new RecordingStream();){
            CompletableFuture allocateFuture = new CompletableFuture();
            CompletableFuture releaseFuture = new CompletableFuture();
            alloc.directBuffer(128).release();
            stream.enable(AllocateBufferEvent.class);
            stream.onEvent("io.netty.AllocateBuffer", allocateFuture::complete);
            stream.enable(FreeBufferEvent.class);
            stream.onEvent("io.netty.FreeBuffer", releaseFuture::complete);
            stream.startAsync();
            alloc.directBuffer(128).release();
            RecordedEvent allocate = (RecordedEvent)allocateFuture.get();
            org.junit.jupiter.api.Assertions.assertEquals((int)128, (int)allocate.getInt("size"));
            org.junit.jupiter.api.Assertions.assertEquals((int)128, (int)allocate.getInt("maxFastCapacity"));
            org.junit.jupiter.api.Assertions.assertEquals((int)Integer.MAX_VALUE, (int)allocate.getInt("maxCapacity"));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)allocate.getBoolean("chunkPooled"));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)allocate.getBoolean("chunkThreadLocal"));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)allocate.getBoolean("direct"));
            RecordedEvent release = (RecordedEvent)releaseFuture.get();
            org.junit.jupiter.api.Assertions.assertEquals((int)128, (int)release.getInt("size"));
            org.junit.jupiter.api.Assertions.assertEquals((int)128, (int)release.getInt("maxFastCapacity"));
            org.junit.jupiter.api.Assertions.assertEquals((int)Integer.MAX_VALUE, (int)release.getInt("maxCapacity"));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)release.getBoolean("direct"));
            Void void_ = null;
            return void_;
        }
    }

    private static final class AllocationThread
    extends Thread {
        private static final int[] ALLOCATION_SIZES = new int[16384];
        private final Queue<ByteBuf> buffers = new ConcurrentLinkedQueue<ByteBuf>();
        private final ByteBufAllocator allocator;
        private final AtomicReference<Object> finish = new AtomicReference();

        AllocationThread(ByteBufAllocator allocator) {
            this.allocator = allocator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                int idx = 0;
                while (this.finish.get() == null) {
                    for (int i = 0; i < 10; ++i) {
                        int len = ALLOCATION_SIZES[Math.abs(idx++ % ALLOCATION_SIZES.length)];
                        ByteBuf buf = this.allocator.directBuffer(len, Integer.MAX_VALUE);
                        org.junit.jupiter.api.Assertions.assertEquals((int)len, (int)buf.writableBytes());
                        while (buf.isWritable()) {
                            buf.writeByte(i);
                        }
                        this.buffers.offer(buf);
                    }
                    this.releaseBuffersAndCheckContent();
                }
            }
            catch (Throwable cause) {
                this.finish.set(cause);
            }
            finally {
                this.releaseBuffersAndCheckContent();
            }
        }

        private void releaseBuffersAndCheckContent() {
            int i = 0;
            while (!this.buffers.isEmpty()) {
                ByteBuf buf = this.buffers.poll();
                while (buf.isReadable()) {
                    org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)buf.readByte());
                }
                buf.release();
                ++i;
            }
        }

        boolean isFinished() {
            return this.finish.get() != null;
        }

        void markAsFinished() {
            this.finish.compareAndSet(null, Boolean.TRUE);
        }

        void joinAndCheckForError() throws Throwable {
            try {
                this.join();
            }
            finally {
                this.releaseBuffersAndCheckContent();
            }
            this.checkForError();
        }

        void checkForError() throws Throwable {
            Object obj = this.finish.get();
            if (obj instanceof Throwable) {
                throw (Throwable)obj;
            }
        }

        static {
            for (int i = 0; i < ALLOCATION_SIZES.length; ++i) {
                AllocationThread.ALLOCATION_SIZES[i] = i;
            }
        }
    }

    private static interface ThreadCache {
        public void destroy() throws InterruptedException;
    }
}

