/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.EmptyByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.buffer.UnpooledHeapByteBuf;
import io.netty.util.CharsetUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EmptyByteBufTest {
    @Test
    public void testIsContiguous() {
        EmptyByteBuf empty = new EmptyByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        Assertions.assertTrue((boolean)empty.isContiguous());
    }

    @Test
    public void testIsWritable() {
        EmptyByteBuf empty = new EmptyByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        Assertions.assertFalse((boolean)empty.isWritable());
        Assertions.assertFalse((boolean)empty.isWritable(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteEmptyByteBuf() {
        EmptyByteBuf empty = new EmptyByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        empty.writeBytes(Unpooled.EMPTY_BUFFER);
        ByteBuf nonEmpty = UnpooledByteBufAllocator.DEFAULT.buffer().writeBoolean(false);
        try {
            empty.writeBytes(nonEmpty);
            Assertions.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        finally {
            nonEmpty.release();
        }
    }

    @Test
    public void testIsReadable() {
        EmptyByteBuf empty = new EmptyByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        Assertions.assertFalse((boolean)empty.isReadable());
        Assertions.assertFalse((boolean)empty.isReadable(1));
    }

    @Test
    public void testArray() {
        EmptyByteBuf empty = new EmptyByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        Assertions.assertTrue((boolean)empty.hasArray());
        Assertions.assertEquals((int)0, (int)empty.array().length);
        Assertions.assertEquals((int)0, (int)empty.arrayOffset());
    }

    @Test
    public void testNioBuffer() {
        EmptyByteBuf empty = new EmptyByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        Assertions.assertEquals((int)1, (int)empty.nioBufferCount());
        Assertions.assertEquals((int)0, (int)empty.nioBuffer().position());
        Assertions.assertEquals((int)0, (int)empty.nioBuffer().limit());
        Assertions.assertSame((Object)empty.nioBuffer(), (Object)empty.internalNioBuffer(empty.readerIndex(), 0));
    }

    @Test
    public void testMemoryAddress() {
        EmptyByteBuf empty = new EmptyByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        if (empty.hasMemoryAddress()) {
            Assertions.assertNotEquals((long)0L, (long)empty.memoryAddress());
        } else {
            try {
                empty.memoryAddress();
                Assertions.fail();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    @Test
    public void consistentEqualsAndHashCodeWithAbstractBytebuf() {
        EmptyByteBuf empty = new EmptyByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        UnpooledHeapByteBuf emptyAbstract = new UnpooledHeapByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, 0, 0);
        Assertions.assertEquals((Object)emptyAbstract, (Object)empty);
        Assertions.assertEquals((int)emptyAbstract.hashCode(), (int)empty.hashCode());
        Assertions.assertEquals((int)1, (int)empty.hashCode());
        Assertions.assertTrue((boolean)emptyAbstract.release());
        Assertions.assertFalse((boolean)empty.release());
    }

    @Test
    public void testGetCharSequence() {
        EmptyByteBuf empty = new EmptyByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        Assertions.assertEquals((Object)"", (Object)empty.readCharSequence(0, CharsetUtil.US_ASCII));
    }

    @Test
    public void testReadString() {
        EmptyByteBuf empty = new EmptyByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        Assertions.assertEquals((Object)"", (Object)empty.readString(0, CharsetUtil.US_ASCII));
    }

    @Test
    public void testReadStringThrowsIndexOutOfBoundsException() {
        EmptyByteBuf empty = new EmptyByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> empty.readString(1, CharsetUtil.US_ASCII));
    }
}

