/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractUnpooledSlicedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.DuplicatedByteBuf;
import io.netty.buffer.ReadOnlyByteBuf;
import io.netty.buffer.SwappedByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteOrder;
import java.util.Random;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class ByteBufDerivationTest {
    @Test
    public void testSlice() throws Exception {
        ByteBuf buf = Unpooled.buffer((int)8).setIndex(1, 7);
        ByteBuf slice = buf.slice(1, 7);
        org.junit.jupiter.api.Assertions.assertInstanceOf(AbstractUnpooledSlicedByteBuf.class, (Object)slice);
        org.junit.jupiter.api.Assertions.assertSame((Object)buf, (Object)slice.unwrap());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)slice.readerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)7, (int)slice.writerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)7, (int)slice.capacity());
        org.junit.jupiter.api.Assertions.assertEquals((int)7, (int)slice.maxCapacity());
        slice.setIndex(1, 6);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)buf.readerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)7, (int)buf.writerIndex());
    }

    @Test
    public void testSliceOfSlice() throws Exception {
        ByteBuf buf = Unpooled.buffer((int)8);
        ByteBuf slice = buf.slice(1, 7);
        ByteBuf slice2 = slice.slice(0, 6);
        org.junit.jupiter.api.Assertions.assertNotSame((Object)slice, (Object)slice2);
        org.junit.jupiter.api.Assertions.assertInstanceOf(AbstractUnpooledSlicedByteBuf.class, (Object)slice2);
        org.junit.jupiter.api.Assertions.assertSame((Object)buf, (Object)slice2.unwrap());
        org.junit.jupiter.api.Assertions.assertEquals((int)6, (int)slice2.writerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)6, (int)slice2.capacity());
    }

    @Test
    public void testDuplicate() throws Exception {
        ByteBuf buf = Unpooled.buffer((int)8).setIndex(1, 7);
        ByteBuf dup = buf.duplicate();
        org.junit.jupiter.api.Assertions.assertInstanceOf(DuplicatedByteBuf.class, (Object)dup);
        org.junit.jupiter.api.Assertions.assertSame((Object)buf, (Object)dup.unwrap());
        org.junit.jupiter.api.Assertions.assertEquals((int)buf.readerIndex(), (int)dup.readerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)buf.writerIndex(), (int)dup.writerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)buf.capacity(), (int)dup.capacity());
        org.junit.jupiter.api.Assertions.assertEquals((int)buf.maxCapacity(), (int)dup.maxCapacity());
        dup.setIndex(2, 6);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)buf.readerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)7, (int)buf.writerIndex());
    }

    @Test
    public void testDuplicateOfDuplicate() throws Exception {
        ByteBuf buf = Unpooled.buffer((int)8).setIndex(1, 7);
        ByteBuf dup = buf.duplicate().setIndex(2, 6);
        ByteBuf dup2 = dup.duplicate();
        org.junit.jupiter.api.Assertions.assertNotSame((Object)dup, (Object)dup2);
        org.junit.jupiter.api.Assertions.assertInstanceOf(DuplicatedByteBuf.class, (Object)dup2);
        org.junit.jupiter.api.Assertions.assertSame((Object)buf, (Object)dup2.unwrap());
        org.junit.jupiter.api.Assertions.assertEquals((int)dup.readerIndex(), (int)dup2.readerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)dup.writerIndex(), (int)dup2.writerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)dup.capacity(), (int)dup2.capacity());
        org.junit.jupiter.api.Assertions.assertEquals((int)dup.maxCapacity(), (int)dup2.maxCapacity());
    }

    @Test
    public void testReadOnly() throws Exception {
        ByteBuf buf = Unpooled.buffer((int)8).setIndex(1, 7);
        ByteBuf ro = Unpooled.unmodifiableBuffer((ByteBuf)buf);
        org.junit.jupiter.api.Assertions.assertInstanceOf(ReadOnlyByteBuf.class, (Object)ro);
        org.junit.jupiter.api.Assertions.assertSame((Object)buf, (Object)ro.unwrap());
        org.junit.jupiter.api.Assertions.assertEquals((int)buf.readerIndex(), (int)ro.readerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)buf.writerIndex(), (int)ro.writerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)buf.capacity(), (int)ro.capacity());
        org.junit.jupiter.api.Assertions.assertEquals((int)buf.maxCapacity(), (int)ro.maxCapacity());
        ro.setIndex(2, 6);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)buf.readerIndex());
    }

    @Test
    public void testReadOnlyOfReadOnly() throws Exception {
        ByteBuf buf = Unpooled.buffer((int)8).setIndex(1, 7);
        ByteBuf ro = Unpooled.unmodifiableBuffer((ByteBuf)buf).setIndex(2, 6);
        ByteBuf ro2 = Unpooled.unmodifiableBuffer((ByteBuf)ro);
        org.junit.jupiter.api.Assertions.assertNotSame((Object)ro, (Object)ro2);
        org.junit.jupiter.api.Assertions.assertInstanceOf(ReadOnlyByteBuf.class, (Object)ro2);
        org.junit.jupiter.api.Assertions.assertSame((Object)buf, (Object)ro2.unwrap());
        org.junit.jupiter.api.Assertions.assertEquals((int)ro.readerIndex(), (int)ro2.readerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)ro.writerIndex(), (int)ro2.writerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)ro.capacity(), (int)ro2.capacity());
        org.junit.jupiter.api.Assertions.assertEquals((int)ro.maxCapacity(), (int)ro2.maxCapacity());
    }

    @Test
    public void testReadOnlyOfDuplicate() throws Exception {
        ByteBuf buf = Unpooled.buffer((int)8).setIndex(1, 7);
        ByteBuf dup = buf.duplicate().setIndex(2, 6);
        ByteBuf ro = Unpooled.unmodifiableBuffer((ByteBuf)dup);
        org.junit.jupiter.api.Assertions.assertInstanceOf(ReadOnlyByteBuf.class, (Object)ro);
        org.junit.jupiter.api.Assertions.assertSame((Object)buf, (Object)ro.unwrap());
        org.junit.jupiter.api.Assertions.assertEquals((int)dup.readerIndex(), (int)ro.readerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)dup.writerIndex(), (int)ro.writerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)dup.capacity(), (int)ro.capacity());
        org.junit.jupiter.api.Assertions.assertEquals((int)dup.maxCapacity(), (int)ro.maxCapacity());
    }

    @Test
    public void testDuplicateOfReadOnly() throws Exception {
        ByteBuf buf = Unpooled.buffer((int)8).setIndex(1, 7);
        ByteBuf ro = Unpooled.unmodifiableBuffer((ByteBuf)buf).setIndex(2, 6);
        ByteBuf dup = ro.duplicate();
        org.junit.jupiter.api.Assertions.assertInstanceOf(ReadOnlyByteBuf.class, (Object)ro);
        org.junit.jupiter.api.Assertions.assertSame((Object)buf, (Object)ro.unwrap());
        org.junit.jupiter.api.Assertions.assertEquals((int)dup.readerIndex(), (int)ro.readerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)dup.writerIndex(), (int)ro.writerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)dup.capacity(), (int)ro.capacity());
        org.junit.jupiter.api.Assertions.assertEquals((int)dup.maxCapacity(), (int)ro.maxCapacity());
    }

    @Test
    public void testSwap() throws Exception {
        ByteBuf buf = Unpooled.buffer((int)8).setIndex(1, 7);
        ByteBuf swapped = buf.order(ByteOrder.LITTLE_ENDIAN);
        org.junit.jupiter.api.Assertions.assertInstanceOf(SwappedByteBuf.class, (Object)swapped);
        org.junit.jupiter.api.Assertions.assertSame((Object)buf, (Object)swapped.unwrap());
        org.junit.jupiter.api.Assertions.assertSame((Object)swapped, (Object)swapped.order(ByteOrder.LITTLE_ENDIAN));
        org.junit.jupiter.api.Assertions.assertSame((Object)buf, (Object)swapped.order(ByteOrder.BIG_ENDIAN));
        buf.setIndex(2, 6);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)swapped.readerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)6, (int)swapped.writerIndex());
    }

    @Test
    public void testMixture() throws Exception {
        ByteBuf buf;
        ByteBuf derived = buf = Unpooled.buffer((int)10000);
        Random rnd = new Random();
        for (int i = 0; i < buf.capacity(); ++i) {
            ByteBuf newDerived;
            int randomNumber = rnd.nextInt(4);
            switch (randomNumber) {
                case 0: {
                    newDerived = derived.slice(1, derived.capacity() - 1);
                    break;
                }
                case 1: {
                    newDerived = derived.duplicate();
                    break;
                }
                case 2: {
                    newDerived = derived.order(derived.order() == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
                    break;
                }
                case 3: {
                    newDerived = Unpooled.unmodifiableBuffer((ByteBuf)derived);
                    break;
                }
                default: {
                    throw new Error("Unexpected random number: " + randomNumber);
                }
            }
            Assertions.assertThat((int)ByteBufDerivationTest.nestLevel(newDerived)).isLessThanOrEqualTo(3);
            Assertions.assertThat((int)ByteBufDerivationTest.nestLevel(newDerived.order(ByteOrder.BIG_ENDIAN))).isLessThanOrEqualTo(2);
            derived = newDerived;
        }
    }

    private static int nestLevel(ByteBuf buf) {
        int depth = 0;
        ByteBuf b = buf.order(ByteOrder.BIG_ENDIAN);
        while (b.unwrap() != null || b instanceof SwappedByteBuf) {
            ++depth;
            if (b instanceof SwappedByteBuf) {
                b = b.order(ByteOrder.BIG_ENDIAN);
                continue;
            }
            b = b.unwrap();
        }
        return depth;
    }
}

