/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PoolSubpage;
import io.netty.buffer.PooledByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocatorTest;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;

public class AlignedPooledByteBufAllocatorTest
extends PooledByteBufAllocatorTest {
    @Override
    protected PooledByteBufAllocator newAllocator(boolean preferDirect) {
        Assumptions.assumeTrue((boolean)PooledByteBufAllocator.isDirectMemoryCacheAlignmentSupported());
        int directMemoryCacheAlignment = 1;
        return new PooledByteBufAllocator(preferDirect, PooledByteBufAllocator.defaultNumHeapArena(), PooledByteBufAllocator.defaultNumDirectArena(), PooledByteBufAllocator.defaultPageSize(), 11, PooledByteBufAllocator.defaultSmallCacheSize(), 64, PooledByteBufAllocator.defaultUseCacheForAllThreads(), directMemoryCacheAlignment);
    }

    @Test
    public void testCorrectElementSize() {
        Assumptions.assumeTrue((boolean)PooledByteBufAllocator.isDirectMemoryCacheAlignmentSupported());
        PooledByteBufAllocator allocator = new PooledByteBufAllocator(true, PooledByteBufAllocator.defaultNumHeapArena(), PooledByteBufAllocator.defaultNumDirectArena(), PooledByteBufAllocator.defaultPageSize(), 11, PooledByteBufAllocator.defaultSmallCacheSize(), 64, PooledByteBufAllocator.defaultUseCacheForAllThreads(), 64);
        ByteBuf a = allocator.directBuffer(0, 16384);
        ByteBuf b = allocator.directBuffer(0, 16384);
        a.capacity(16);
        Assertions.assertEquals((int)16, (int)a.capacity());
        b.capacity(16);
        Assertions.assertEquals((int)16, (int)b.capacity());
        a.capacity(17);
        Assertions.assertEquals((int)17, (int)a.capacity());
        b.capacity(18);
        Assertions.assertEquals((int)18, (int)b.capacity());
        Assertions.assertTrue((boolean)a.release());
        Assertions.assertTrue((boolean)b.release());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDirectSubpageReleaseLock() throws InterruptedException {
        Assumptions.assumeTrue((boolean)PooledByteBufAllocator.isDirectMemoryCacheAlignmentSupported());
        int initialCapacity = 0;
        int directMemoryCacheAlignment = 32;
        PooledByteBufAllocator allocator = new PooledByteBufAllocator(true, 0, 1, PooledByteBufAllocator.defaultPageSize(), PooledByteBufAllocator.defaultMaxOrder(), 0, 0, false, directMemoryCacheAlignment);
        final ByteBuf wrapper = allocator.directBuffer(initialCapacity, 16);
        PooledByteBuf<?> unwrapped = AlignedPooledByteBufAllocatorTest.pooledByteBuf(wrapper);
        PoolSubpage[] smallSubpagePools = unwrapped.chunk.arena.smallSubpagePools;
        PoolSubpage head = null;
        for (PoolSubpage subpage : smallSubpagePools) {
            if (subpage.next == subpage) continue;
            head = subpage;
            break;
        }
        Assertions.assertNotNull(head);
        Thread t1 = new Thread(new Runnable(){

            @Override
            public void run() {
                wrapper.release();
            }
        });
        t1.setDaemon(true);
        head.lock();
        try {
            t1.start();
            long start = System.nanoTime();
            while (!head.lock.hasQueuedThread(t1) && System.nanoTime() - start <= TimeUnit.SECONDS.toNanos(3L)) {
            }
            Assertions.assertTrue((boolean)head.lock.hasQueuedThread(t1), (String)"The t1 thread should still be waiting for the head lock.");
        }
        finally {
            head.unlock();
        }
        t1.join();
    }

    private static PooledByteBuf<?> pooledByteBuf(ByteBuf buffer) {
        while (!(buffer instanceof PooledByteBuf)) {
            buffer = buffer.unwrap();
        }
        return (PooledByteBuf)buffer;
    }
}

