/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AdaptivePoolingAllocator;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class AdaptivePoolingAllocatorTest
implements Supplier<String> {
    private int i;

    AdaptivePoolingAllocatorTest() {
    }

    @BeforeEach
    void setUp() {
        this.i = 0;
    }

    @Override
    public String get() {
        return "i = " + this.i;
    }

    @Test
    void sizeBucketComputations() throws Exception {
        this.assertSizeBucket(0, 16384);
        this.assertSizeBucket(1, 24576);
        this.assertSizeBucket(2, 32768);
        this.assertSizeBucket(3, 49152);
        this.assertSizeBucket(4, 65536);
        this.assertSizeBucket(5, 98304);
        this.assertSizeBucket(6, 131072);
        this.assertSizeBucket(7, 196608);
        this.assertSizeBucket(8, 262144);
        this.assertSizeBucket(9, 393216);
        this.assertSizeBucket(10, 524288);
        this.assertSizeBucket(11, 786432);
        this.assertSizeBucket(12, 0x100000);
        this.assertSizeBucket(13, 0x1C0000);
        this.assertSizeBucket(14, 0x200000);
        this.assertSizeBucket(15, 0x300000);
        this.assertSizeBucket(15, 0x400000);
        this.assertSizeBucket(15, 0x500000);
        this.assertSizeBucket(15, 0x600000);
        this.assertSizeBucket(15, 0x700000);
        this.assertSizeBucket(15, 0x800000);
    }

    @Test
    void sizeClassComputations() throws Exception {
        int[] sizeClasses = AdaptivePoolingAllocator.getSizeClasses();
        for (int sizeClassIndex = 0; sizeClassIndex < sizeClasses.length; ++sizeClassIndex) {
            int previousSizeIncluded = sizeClassIndex == 0 ? 0 : sizeClasses[sizeClassIndex - 1] + 1;
            AdaptivePoolingAllocatorTest.assertSizeClassOf(sizeClassIndex, previousSizeIncluded, sizeClasses[sizeClassIndex]);
        }
        AdaptivePoolingAllocatorTest.assertSizeClassOf(sizeClasses.length, sizeClasses[sizeClasses.length - 1] + 1, sizeClasses[sizeClasses.length - 1] + 1);
    }

    private static void assertSizeClassOf(int expectedSizeClass, int previousSizeIncluded, int maxSizeIncluded) {
        for (int size = previousSizeIncluded; size <= maxSizeIncluded; ++size) {
            int sizeToTest = size;
            Assertions.assertEquals((int)expectedSizeClass, (int)AdaptivePoolingAllocator.sizeClassIndexOf((int)size), () -> "size = " + sizeToTest);
        }
    }

    private void assertSizeBucket(int expectedSizeBucket, int maxSizeIncluded) {
        while (this.i <= maxSizeIncluded) {
            Assertions.assertEquals((int)expectedSizeBucket, (int)AdaptivePoolingAllocator.sizeToBucket((int)this.i), (Supplier)this);
            ++this.i;
        }
    }
}

