/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBufAllocatorTest;
import io.netty.buffer.AdaptiveByteBufAllocator;
import io.netty.buffer.AdaptivePoolingAllocator;
import io.netty.buffer.AllocateBufferEvent;
import io.netty.buffer.AllocateChunkEvent;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufAllocatorMetric;
import io.netty.buffer.FreeBufferEvent;
import io.netty.buffer.SimpleLeakAwareByteBuf;
import io.netty.util.NettyRuntime;
import io.netty.util.concurrent.FastThreadLocalThread;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordingStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.condition.EnabledForJreRange;
import org.junit.jupiter.api.condition.JRE;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class AdaptiveByteBufAllocatorTest
extends AbstractByteBufAllocatorTest<AdaptiveByteBufAllocator> {
    @Override
    protected AdaptiveByteBufAllocator newAllocator(boolean preferDirect) {
        return new AdaptiveByteBufAllocator(preferDirect);
    }

    @Override
    protected AdaptiveByteBufAllocator newUnpooledAllocator() {
        return this.newAllocator(false);
    }

    @Override
    protected long expectedUsedMemory(AdaptiveByteBufAllocator allocator, int capacity) {
        return 131072L;
    }

    @Override
    protected long expectedUsedMemoryAfterRelease(AdaptiveByteBufAllocator allocator, int capacity) {
        return 131072L;
    }

    @Override
    @Test
    public void testUnsafeHeapBufferAndUnsafeDirectBuffer() {
        AdaptiveByteBufAllocator allocator = this.newUnpooledAllocator();
        ByteBuf directBuffer = allocator.directBuffer();
        AdaptiveByteBufAllocatorTest.assertInstanceOf(directBuffer, AdaptivePoolingAllocator.AdaptiveByteBuf.class);
        Assertions.assertTrue((boolean)directBuffer.isDirect());
        directBuffer.release();
        ByteBuf heapBuffer = allocator.heapBuffer();
        AdaptiveByteBufAllocatorTest.assertInstanceOf(heapBuffer, AdaptivePoolingAllocator.AdaptiveByteBuf.class);
        Assertions.assertFalse((boolean)heapBuffer.isDirect());
        heapBuffer.release();
    }

    @Override
    @Test
    public void testUsedDirectMemory() {
        AdaptiveByteBufAllocator allocator = this.newAllocator(true);
        ByteBufAllocatorMetric metric = allocator.metric();
        Assertions.assertEquals((long)0L, (long)metric.usedDirectMemory());
        ByteBuf buffer = allocator.directBuffer(1024, 4096);
        int capacity = buffer.capacity();
        Assertions.assertEquals((long)this.expectedUsedMemory(allocator, capacity), (long)metric.usedDirectMemory());
        buffer.capacity(capacity << 1);
        capacity = buffer.capacity();
        Assertions.assertEquals((long)(2L * this.expectedUsedMemory(allocator, capacity)), (long)metric.usedDirectMemory(), (String)buffer.toString());
        buffer.release();
        Assertions.assertEquals((long)(2L * this.expectedUsedMemory(allocator, capacity)), (long)metric.usedDirectMemory());
    }

    @Override
    @Test
    public void testUsedHeapMemory() {
        AdaptiveByteBufAllocator allocator = this.newAllocator(true);
        ByteBufAllocatorMetric metric = allocator.metric();
        Assertions.assertEquals((long)0L, (long)metric.usedHeapMemory());
        ByteBuf buffer = allocator.heapBuffer(1024, 4096);
        int capacity = buffer.capacity();
        Assertions.assertEquals((long)this.expectedUsedMemory(allocator, capacity), (long)metric.usedHeapMemory());
        buffer.capacity(capacity << 1);
        capacity = buffer.capacity();
        Assertions.assertEquals((long)(2L * this.expectedUsedMemory(allocator, capacity)), (long)metric.usedHeapMemory(), (String)buffer.toString());
        buffer.release();
        Assertions.assertEquals((long)(2L * this.expectedUsedMemory(allocator, capacity)), (long)metric.usedHeapMemory());
    }

    @Test
    void adaptiveChunkMustDeallocateOrReuseWthBufferRelease() throws Exception {
        AdaptiveByteBufAllocator allocator = this.newAllocator(false);
        ByteBuf a = allocator.heapBuffer(28672);
        Assertions.assertEquals((long)262144L, (long)allocator.usedHeapMemory());
        ByteBuf b = allocator.heapBuffer(102400);
        Assertions.assertEquals((long)262144L, (long)allocator.usedHeapMemory());
        b.release();
        a.release();
        Assertions.assertEquals((long)262144L, (long)allocator.usedHeapMemory());
        a = allocator.heapBuffer(28672);
        Assertions.assertEquals((long)262144L, (long)allocator.usedHeapMemory());
        b = allocator.heapBuffer(102400);
        Assertions.assertEquals((long)262144L, (long)allocator.usedHeapMemory());
        a.release();
        ByteBuf c = allocator.heapBuffer(28672);
        Assertions.assertEquals((long)524288L, (long)allocator.usedHeapMemory());
        c.release();
        Assertions.assertEquals((long)524288L, (long)allocator.usedHeapMemory());
        b.release();
        Assertions.assertEquals((long)524288L, (long)allocator.usedHeapMemory());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void sliceOrDuplicateUnwrapLetNotEscapeRootParent(boolean slice) {
        AdaptiveByteBufAllocator allocator = this.newAllocator(false);
        ByteBuf buffer = allocator.buffer(8);
        AdaptiveByteBufAllocatorTest.assertInstanceOf(buffer, AdaptivePoolingAllocator.AdaptiveByteBuf.class);
        if (buffer instanceof SimpleLeakAwareByteBuf) {
            Assertions.assertNull((Object)buffer.unwrap().unwrap());
        } else {
            Assertions.assertNull((Object)buffer.unwrap());
        }
        ByteBuf derived = slice ? buffer.slice(0, 4) : buffer.duplicate();
        ByteBuf unwrapped = derived instanceof SimpleLeakAwareByteBuf ? derived.unwrap().unwrap() : derived.unwrap();
        AdaptiveByteBufAllocatorTest.assertInstanceOf(unwrapped, AdaptivePoolingAllocator.AdaptiveByteBuf.class);
        AdaptiveByteBufAllocatorTest.assertSameBuffer(buffer instanceof SimpleLeakAwareByteBuf ? buffer.unwrap() : buffer, unwrapped);
        ByteBuf retainedDerived = slice ? buffer.retainedSlice(0, 4) : buffer.retainedDuplicate();
        ByteBuf unwrappedRetained = retainedDerived instanceof SimpleLeakAwareByteBuf ? retainedDerived.unwrap().unwrap() : retainedDerived.unwrap();
        AdaptiveByteBufAllocatorTest.assertInstanceOf(unwrappedRetained, AdaptivePoolingAllocator.AdaptiveByteBuf.class);
        AdaptiveByteBufAllocatorTest.assertSameBuffer(buffer instanceof SimpleLeakAwareByteBuf ? buffer.unwrap() : buffer, unwrappedRetained);
        retainedDerived.release();
        Assertions.assertTrue((boolean)buffer.release());
    }

    @Test
    public void testAllocateWithoutLock() throws InterruptedException {
        final AdaptiveByteBufAllocator alloc = new AdaptiveByteBufAllocator();
        int threadCount = NettyRuntime.availableProcessors() * 4;
        final CountDownLatch countDownLatch = new CountDownLatch(threadCount);
        final AtomicReference throwableAtomicReference = new AtomicReference();
        for (int i = 0; i < threadCount; ++i) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    for (int j = 0; j < 1024; ++j) {
                        try {
                            ByteBuf buffer = null;
                            try {
                                buffer = alloc.heapBuffer(128);
                                buffer.ensureWritable(ThreadLocalRandom.current().nextInt(512, 32769));
                                continue;
                            }
                            finally {
                                if (buffer != null) {
                                    buffer.release();
                                }
                            }
                        }
                        catch (Throwable t) {
                            throwableAtomicReference.set(t);
                        }
                    }
                    countDownLatch.countDown();
                }
            }).start();
        }
        countDownLatch.await();
        Throwable throwable = (Throwable)throwableAtomicReference.get();
        if (throwable != null) {
            Assertions.fail((String)"Expected no exception, but got", (Throwable)throwable);
        }
    }

    @Test
    @EnabledForJreRange(min=JRE.JAVA_17)
    @Timeout(value=10L)
    public void jfrChunkAllocation() throws Exception {
        try (RecordingStream stream = new RecordingStream();){
            CompletableFuture allocateFuture = new CompletableFuture();
            stream.enable(AllocateChunkEvent.class);
            stream.onEvent("io.netty.AllocateChunk", allocateFuture::complete);
            stream.startAsync();
            AdaptiveByteBufAllocator alloc = new AdaptiveByteBufAllocator(true, false);
            alloc.directBuffer(128).release();
            RecordedEvent allocate = (RecordedEvent)allocateFuture.get();
            Assertions.assertEquals((int)131072, (int)allocate.getInt("capacity"));
            Assertions.assertTrue((boolean)allocate.getBoolean("pooled"));
            Assertions.assertFalse((boolean)allocate.getBoolean("threadLocal"));
            Assertions.assertTrue((boolean)allocate.getBoolean("direct"));
        }
    }

    @Test
    @EnabledForJreRange(min=JRE.JAVA_17)
    @Timeout(value=10L)
    public void shouldCreateTwoChunks() throws Exception {
        try (RecordingStream stream = new RecordingStream();){
            CountDownLatch eventsFlushed = new CountDownLatch(2);
            stream.enable(AllocateChunkEvent.class);
            stream.onEvent("io.netty.AllocateChunk", event -> eventsFlushed.countDown());
            stream.startAsync();
            AdaptiveByteBufAllocator allocator = this.newAllocator(false);
            int bufSize = 16896;
            int minSegmentsPerChunk = 32;
            int bufsToAllocate = 1 + minSegmentsPerChunk;
            ArrayList<ByteBuf> buffers = new ArrayList<ByteBuf>(bufsToAllocate);
            for (int i = 0; i < bufsToAllocate; ++i) {
                buffers.add(allocator.heapBuffer(bufSize, bufSize));
            }
            for (ByteBuf buffer : buffers) {
                buffer.release();
            }
            buffers.clear();
            eventsFlushed.await();
            Assertions.assertEquals((long)0L, (long)eventsFlushed.getCount());
        }
    }

    @Test
    @EnabledForJreRange(min=JRE.JAVA_17)
    @Timeout(value=10L)
    public void shouldReuseTheSameChunk() throws Exception {
        try (RecordingStream stream = new RecordingStream();){
            int i;
            CountDownLatch eventsFlushed = new CountDownLatch(1);
            AtomicInteger chunksAllocations = new AtomicInteger();
            stream.enable(AllocateChunkEvent.class);
            stream.onEvent("io.netty.AllocateChunk", event -> {
                chunksAllocations.incrementAndGet();
                eventsFlushed.countDown();
            });
            stream.startAsync();
            int bufSize = 16896;
            AdaptiveByteBufAllocator allocator = this.newAllocator(false);
            ArrayList<ByteBuf> buffers = new ArrayList<ByteBuf>(32);
            for (i = 0; i < 30; ++i) {
                buffers.add(allocator.heapBuffer(bufSize, bufSize));
            }
            for (i = 0; i < 128; ++i) {
                allocator.heapBuffer(bufSize, bufSize).release();
            }
            for (ByteBuf buffer : buffers) {
                buffer.release();
            }
            buffers.clear();
            eventsFlushed.await();
            Assertions.assertEquals((int)1, (int)chunksAllocations.get());
        }
    }

    @Test
    @EnabledForJreRange(min=JRE.JAVA_17)
    @Timeout(value=10L)
    public void jfrBufferAllocation() throws Exception {
        try (RecordingStream stream = new RecordingStream();){
            CompletableFuture allocateFuture = new CompletableFuture();
            CompletableFuture releaseFuture = new CompletableFuture();
            stream.enable(AllocateBufferEvent.class);
            stream.onEvent("io.netty.AllocateBuffer", allocateFuture::complete);
            stream.enable(FreeBufferEvent.class);
            stream.onEvent("io.netty.FreeBuffer", releaseFuture::complete);
            stream.startAsync();
            AdaptiveByteBufAllocator alloc = new AdaptiveByteBufAllocator(true, false);
            alloc.directBuffer(128).release();
            RecordedEvent allocate = (RecordedEvent)allocateFuture.get();
            Assertions.assertEquals((int)128, (int)allocate.getInt("size"));
            Assertions.assertEquals((int)128, (int)allocate.getInt("maxFastCapacity"));
            Assertions.assertEquals((int)Integer.MAX_VALUE, (int)allocate.getInt("maxCapacity"));
            Assertions.assertTrue((boolean)allocate.getBoolean("chunkPooled"));
            Assertions.assertFalse((boolean)allocate.getBoolean("chunkThreadLocal"));
            Assertions.assertTrue((boolean)allocate.getBoolean("direct"));
            RecordedEvent release = (RecordedEvent)releaseFuture.get();
            Assertions.assertEquals((int)128, (int)release.getInt("size"));
            Assertions.assertEquals((int)128, (int)release.getInt("maxFastCapacity"));
            Assertions.assertEquals((int)Integer.MAX_VALUE, (int)release.getInt("maxCapacity"));
            Assertions.assertTrue((boolean)release.getBoolean("direct"));
        }
    }

    @Test
    @EnabledForJreRange(min=JRE.JAVA_17)
    @Timeout(value=10L)
    public void jfrBufferAllocationThreadLocal() throws Exception {
        AdaptiveByteBufAllocator alloc = new AdaptiveByteBufAllocator(true, true);
        Callable<Void> allocateAndRelease = () -> AdaptiveByteBufAllocatorTest.lambda$jfrBufferAllocationThreadLocal$2((ByteBufAllocator)alloc);
        FutureTask<Void> task = new FutureTask<Void>(allocateAndRelease);
        FastThreadLocalThread thread = new FastThreadLocalThread(task);
        thread.start();
        task.get();
    }

    private static /* synthetic */ Void lambda$jfrBufferAllocationThreadLocal$2(ByteBufAllocator alloc) throws Exception {
        try (RecordingStream stream = new RecordingStream();){
            CompletableFuture allocateFuture = new CompletableFuture();
            CompletableFuture releaseFuture = new CompletableFuture();
            alloc.directBuffer(128).release();
            stream.enable(AllocateBufferEvent.class);
            stream.onEvent("io.netty.AllocateBuffer", allocateFuture::complete);
            stream.enable(FreeBufferEvent.class);
            stream.onEvent("io.netty.FreeBuffer", releaseFuture::complete);
            stream.startAsync();
            alloc.directBuffer(128).release();
            RecordedEvent allocate = (RecordedEvent)allocateFuture.get();
            Assertions.assertEquals((int)128, (int)allocate.getInt("size"));
            Assertions.assertEquals((int)128, (int)allocate.getInt("maxFastCapacity"));
            Assertions.assertEquals((int)Integer.MAX_VALUE, (int)allocate.getInt("maxCapacity"));
            Assertions.assertTrue((boolean)allocate.getBoolean("chunkPooled"));
            Assertions.assertTrue((boolean)allocate.getBoolean("chunkThreadLocal"));
            Assertions.assertTrue((boolean)allocate.getBoolean("direct"));
            RecordedEvent release = (RecordedEvent)releaseFuture.get();
            Assertions.assertEquals((int)128, (int)release.getInt("size"));
            Assertions.assertEquals((int)128, (int)release.getInt("maxFastCapacity"));
            Assertions.assertEquals((int)Integer.MAX_VALUE, (int)release.getInt("maxCapacity"));
            Assertions.assertTrue((boolean)release.getBoolean("direct"));
            Void void_ = null;
            return void_;
        }
    }
}

