/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.util.AsciiString;
import io.netty.util.ByteProcessor;
import io.netty.util.CharsetUtil;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.PlatformDependent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public abstract class AbstractByteBufTest {
    private static final int CAPACITY = 4096;
    private static final int BLOCK_SIZE = 128;
    private static final int JAVA_BYTEBUFFER_CONSISTENCY_ITERATIONS = 100;
    private long seed;
    private Random random;
    private ByteBuf buffer;
    private static final CharBuffer EXTENDED_ASCII_CHARS;
    private static final CharBuffer ASCII_CHARS;

    protected final ByteBuf newBuffer(int capacity) {
        return this.newBuffer(capacity, Integer.MAX_VALUE);
    }

    protected abstract ByteBuf newBuffer(int var1, int var2);

    protected boolean discardReadBytesDoesNotMoveWritableBytes() {
        return true;
    }

    @BeforeEach
    public void init() {
        this.buffer = this.newBuffer(4096);
        this.seed = System.currentTimeMillis();
        this.random = new Random(this.seed);
    }

    @AfterEach
    public void dispose() {
        if (this.buffer != null) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.buffer.release());
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.buffer.refCnt());
            try {
                this.buffer.release();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.buffer = null;
        }
    }

    @Test
    public void comparableInterfaceNotViolated() {
        Assumptions.assumeFalse((boolean)this.buffer.isReadOnly());
        this.buffer.writerIndex(this.buffer.readerIndex());
        Assumptions.assumeTrue((this.buffer.writableBytes() >= 4 ? 1 : 0) != 0);
        this.buffer.writeLong(0L);
        ByteBuf buffer2 = this.newBuffer(4096);
        Assumptions.assumeFalse((boolean)buffer2.isReadOnly());
        buffer2.writerIndex(buffer2.readerIndex());
        buffer2.writeLong(0xF0000000L);
        org.junit.jupiter.api.Assertions.assertTrue((this.buffer.compareTo(buffer2) < 0 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((buffer2.compareTo(this.buffer) > 0 ? 1 : 0) != 0);
        buffer2.release();
    }

    @Test
    public void initialState() {
        org.junit.jupiter.api.Assertions.assertEquals((int)4096, (int)this.buffer.capacity());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.buffer.readerIndex());
    }

    @Test
    public void readerIndexBoundaryCheck1() {
        try {
            this.buffer.writerIndex(0);
        }
        catch (IndexOutOfBoundsException e) {
            org.junit.jupiter.api.Assertions.fail();
        }
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.buffer.readerIndex(-1);
            }
        });
    }

    @Test
    public void readerIndexBoundaryCheck2() {
        try {
            this.buffer.writerIndex(this.buffer.capacity());
        }
        catch (IndexOutOfBoundsException e) {
            org.junit.jupiter.api.Assertions.fail();
        }
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.buffer.readerIndex(AbstractByteBufTest.this.buffer.capacity() + 1);
            }
        });
    }

    @Test
    public void readerIndexBoundaryCheck3() {
        try {
            this.buffer.writerIndex(2048);
        }
        catch (IndexOutOfBoundsException e) {
            org.junit.jupiter.api.Assertions.fail();
        }
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.buffer.readerIndex(6144);
            }
        });
    }

    @Test
    public void readerIndexBoundaryCheck4() {
        this.buffer.writerIndex(0);
        this.buffer.readerIndex(0);
        this.buffer.writerIndex(this.buffer.capacity());
        this.buffer.readerIndex(this.buffer.capacity());
    }

    @Test
    public void writerIndexBoundaryCheck1() {
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.buffer.writerIndex(-1);
            }
        });
    }

    @Test
    public void writerIndexBoundaryCheck2() {
        try {
            this.buffer.writerIndex(4096);
            this.buffer.readerIndex(4096);
        }
        catch (IndexOutOfBoundsException e) {
            org.junit.jupiter.api.Assertions.fail();
        }
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.buffer.writerIndex(AbstractByteBufTest.this.buffer.capacity() + 1);
            }
        });
    }

    @Test
    public void writerIndexBoundaryCheck3() {
        try {
            this.buffer.writerIndex(4096);
            this.buffer.readerIndex(2048);
        }
        catch (IndexOutOfBoundsException e) {
            org.junit.jupiter.api.Assertions.fail();
        }
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.buffer.writerIndex(1024);
            }
        });
    }

    @Test
    public void writerIndexBoundaryCheck4() {
        this.buffer.writerIndex(0);
        this.buffer.readerIndex(0);
        this.buffer.writerIndex(4096);
        this.buffer.writeBytes(ByteBuffer.wrap(EmptyArrays.EMPTY_BYTES));
    }

    @Test
    public void getBooleanBoundaryCheck1() {
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.buffer.getBoolean(-1);
            }
        });
    }

    @Test
    public void getBooleanBoundaryCheck2() {
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.buffer.getBoolean(AbstractByteBufTest.this.buffer.capacity());
            }
        });
    }

    @Test
    public void getByteBoundaryCheck1() {
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.buffer.getByte(-1);
            }
        });
    }

    @Test
    public void getByteBoundaryCheck2() {
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.buffer.getByte(AbstractByteBufTest.this.buffer.capacity());
            }
        });
    }

    @Test
    public void getShortBoundaryCheck1() {
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.buffer.getShort(-1);
            }
        });
    }

    @Test
    public void getShortBoundaryCheck2() {
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.buffer.getShort(AbstractByteBufTest.this.buffer.capacity() - 1);
            }
        });
    }

    @Test
    public void getMediumBoundaryCheck1() {
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.buffer.getMedium(-1);
            }
        });
    }

    @Test
    public void getMediumBoundaryCheck2() {
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.buffer.getMedium(AbstractByteBufTest.this.buffer.capacity() - 2);
            }
        });
    }

    @Test
    public void getIntBoundaryCheck1() {
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.buffer.getInt(-1);
            }
        });
    }

    @Test
    public void getIntBoundaryCheck2() {
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.buffer.getInt(AbstractByteBufTest.this.buffer.capacity() - 3);
            }
        });
    }

    @Test
    public void getLongBoundaryCheck1() {
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.buffer.getLong(-1);
            }
        });
    }

    @Test
    public void getLongBoundaryCheck2() {
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.buffer.getLong(AbstractByteBufTest.this.buffer.capacity() - 7);
            }
        });
    }

    @Test
    public void getByteArrayBoundaryCheck1() {
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.buffer.getBytes(-1, EmptyArrays.EMPTY_BYTES);
            }
        });
    }

    @Test
    public void getByteArrayBoundaryCheck2() {
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.buffer.getBytes(-1, EmptyArrays.EMPTY_BYTES, 0, 0);
            }
        });
    }

    @Test
    public void getByteArrayBoundaryCheck3() {
        byte[] dst = new byte[4];
        this.buffer.setInt(0, 16909060);
        try {
            this.buffer.getBytes(0, dst, -1, 4);
            org.junit.jupiter.api.Assertions.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)dst[0]);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)dst[1]);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)dst[2]);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)dst[3]);
    }

    @Test
    public void getByteArrayBoundaryCheck4() {
        byte[] dst = new byte[4];
        this.buffer.setInt(0, 16909060);
        try {
            this.buffer.getBytes(0, dst, 1, 4);
            org.junit.jupiter.api.Assertions.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)dst[0]);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)dst[1]);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)dst[2]);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)dst[3]);
    }

    @Test
    public void getByteBufferBoundaryCheck() {
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.buffer.getBytes(-1, ByteBuffer.allocate(0));
            }
        });
    }

    @Test
    public void copyBoundaryCheck1() {
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.buffer.copy(-1, 0);
            }
        });
    }

    @Test
    public void copyBoundaryCheck2() {
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.buffer.copy(0, AbstractByteBufTest.this.buffer.capacity() + 1);
            }
        });
    }

    @Test
    public void copyBoundaryCheck3() {
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.buffer.copy(AbstractByteBufTest.this.buffer.capacity() + 1, 0);
            }
        });
    }

    @Test
    public void copyBoundaryCheck4() {
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.buffer.copy(AbstractByteBufTest.this.buffer.capacity(), 1);
            }
        });
    }

    @Test
    public void setIndexBoundaryCheck1() {
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.buffer.setIndex(-1, 4096);
            }
        });
    }

    @Test
    public void setIndexBoundaryCheck2() {
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.buffer.setIndex(2048, 1024);
            }
        });
    }

    @Test
    public void setIndexBoundaryCheck3() {
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.buffer.setIndex(0, 4097);
            }
        });
    }

    @Test
    public void getByteBufferState() {
        ByteBuffer dst = ByteBuffer.allocate(4);
        dst.position(1);
        dst.limit(3);
        this.buffer.setByte(0, 1);
        this.buffer.setByte(1, 2);
        this.buffer.setByte(2, 3);
        this.buffer.setByte(3, 4);
        this.buffer.getBytes(1, dst);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)dst.position());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)dst.limit());
        dst.clear();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)dst.get(0));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)dst.get(1));
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)dst.get(2));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)dst.get(3));
    }

    @Test
    public void getDirectByteBufferBoundaryCheck() {
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.buffer.getBytes(-1, ByteBuffer.allocateDirect(0));
            }
        });
    }

    @Test
    public void getDirectByteBufferState() {
        ByteBuffer dst = ByteBuffer.allocateDirect(4);
        dst.position(1);
        dst.limit(3);
        this.buffer.setByte(0, 1);
        this.buffer.setByte(1, 2);
        this.buffer.setByte(2, 3);
        this.buffer.setByte(3, 4);
        this.buffer.getBytes(1, dst);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)dst.position());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)dst.limit());
        dst.clear();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)dst.get(0));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)dst.get(1));
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)dst.get(2));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)dst.get(3));
    }

    @Test
    public void testRandomByteAccess() {
        byte value;
        int i;
        for (i = 0; i < this.buffer.capacity(); ++i) {
            value = (byte)this.random.nextInt();
            this.buffer.setByte(i, (int)value);
        }
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity(); ++i) {
            value = (byte)this.random.nextInt();
            org.junit.jupiter.api.Assertions.assertEquals((byte)value, (byte)this.buffer.getByte(i));
        }
    }

    @Test
    public void testRandomUnsignedByteAccess() {
        int value;
        int i;
        for (i = 0; i < this.buffer.capacity(); ++i) {
            value = this.random.nextInt();
            this.buffer.setByte(i, value);
        }
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity(); ++i) {
            value = this.random.nextInt() & 0xFF;
            org.junit.jupiter.api.Assertions.assertEquals((int)value, (int)this.buffer.getUnsignedByte(i));
        }
    }

    @Test
    public void testRandomShortAccess() {
        this.testRandomShortAccess(true);
    }

    @Test
    public void testRandomShortLEAccess() {
        this.testRandomShortAccess(false);
    }

    private void testRandomShortAccess(boolean testBigEndian) {
        short value;
        int i;
        for (i = 0; i < this.buffer.capacity() - 1; i += 2) {
            value = (short)this.random.nextInt();
            if (testBigEndian) {
                this.buffer.setShort(i, (int)value);
                continue;
            }
            this.buffer.setShortLE(i, (int)value);
        }
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity() - 1; i += 2) {
            value = (short)this.random.nextInt();
            if (testBigEndian) {
                org.junit.jupiter.api.Assertions.assertEquals((short)value, (short)this.buffer.getShort(i));
                continue;
            }
            org.junit.jupiter.api.Assertions.assertEquals((short)value, (short)this.buffer.getShortLE(i));
        }
    }

    @Test
    public void testShortConsistentWithByteBuffer() {
        this.testShortConsistentWithByteBuffer(true, true);
        this.testShortConsistentWithByteBuffer(true, false);
        this.testShortConsistentWithByteBuffer(false, true);
        this.testShortConsistentWithByteBuffer(false, false);
    }

    private void testShortConsistentWithByteBuffer(boolean direct, boolean testBigEndian) {
        for (int i = 0; i < 100; ++i) {
            ByteBuffer javaBuffer;
            ByteBuffer byteBuffer = javaBuffer = direct ? ByteBuffer.allocateDirect(this.buffer.capacity()) : ByteBuffer.allocate(this.buffer.capacity());
            if (!testBigEndian) {
                javaBuffer = javaBuffer.order(ByteOrder.LITTLE_ENDIAN);
            }
            short expected = (short)(this.random.nextInt() & 0xFFFF);
            javaBuffer.putShort(expected);
            int bufferIndex = this.buffer.capacity() - 2;
            if (testBigEndian) {
                this.buffer.setShort(bufferIndex, (int)expected);
            } else {
                this.buffer.setShortLE(bufferIndex, (int)expected);
            }
            javaBuffer.flip();
            short javaActual = javaBuffer.getShort();
            org.junit.jupiter.api.Assertions.assertEquals((short)expected, (short)javaActual);
            org.junit.jupiter.api.Assertions.assertEquals((short)javaActual, (short)(testBigEndian ? this.buffer.getShort(bufferIndex) : this.buffer.getShortLE(bufferIndex)));
        }
    }

    @Test
    public void testRandomUnsignedShortAccess() {
        this.testRandomUnsignedShortAccess(true);
    }

    @Test
    public void testRandomUnsignedShortLEAccess() {
        this.testRandomUnsignedShortAccess(false);
    }

    private void testRandomUnsignedShortAccess(boolean testBigEndian) {
        int value;
        int i;
        for (i = 0; i < this.buffer.capacity() - 1; i += 2) {
            value = this.random.nextInt();
            if (testBigEndian) {
                this.buffer.setShort(i, value);
                continue;
            }
            this.buffer.setShortLE(i, value);
        }
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity() - 1; i += 2) {
            value = this.random.nextInt() & 0xFFFF;
            if (testBigEndian) {
                org.junit.jupiter.api.Assertions.assertEquals((int)value, (int)this.buffer.getUnsignedShort(i));
                continue;
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)value, (int)this.buffer.getUnsignedShortLE(i));
        }
    }

    @Test
    public void testRandomMediumAccess() {
        this.testRandomMediumAccess(true);
    }

    @Test
    public void testRandomMediumLEAccess() {
        this.testRandomMediumAccess(false);
    }

    private void testRandomMediumAccess(boolean testBigEndian) {
        int value;
        int i;
        for (i = 0; i < this.buffer.capacity() - 2; i += 3) {
            value = this.random.nextInt();
            if (testBigEndian) {
                this.buffer.setMedium(i, value);
                continue;
            }
            this.buffer.setMediumLE(i, value);
        }
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity() - 2; i += 3) {
            value = this.random.nextInt() << 8 >> 8;
            if (testBigEndian) {
                org.junit.jupiter.api.Assertions.assertEquals((int)value, (int)this.buffer.getMedium(i));
                continue;
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)value, (int)this.buffer.getMediumLE(i));
        }
    }

    @Test
    public void testRandomUnsignedMediumAccess() {
        this.testRandomUnsignedMediumAccess(true);
    }

    @Test
    public void testRandomUnsignedMediumLEAccess() {
        this.testRandomUnsignedMediumAccess(false);
    }

    private void testRandomUnsignedMediumAccess(boolean testBigEndian) {
        int value;
        int i;
        for (i = 0; i < this.buffer.capacity() - 2; i += 3) {
            value = this.random.nextInt();
            if (testBigEndian) {
                this.buffer.setMedium(i, value);
                continue;
            }
            this.buffer.setMediumLE(i, value);
        }
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity() - 2; i += 3) {
            value = this.random.nextInt() & 0xFFFFFF;
            if (testBigEndian) {
                org.junit.jupiter.api.Assertions.assertEquals((int)value, (int)this.buffer.getUnsignedMedium(i));
                continue;
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)value, (int)this.buffer.getUnsignedMediumLE(i));
        }
    }

    @Test
    public void testMediumConsistentWithByteBuffer() {
        this.testMediumConsistentWithByteBuffer(true, true);
        this.testMediumConsistentWithByteBuffer(true, false);
        this.testMediumConsistentWithByteBuffer(false, true);
        this.testMediumConsistentWithByteBuffer(false, false);
    }

    private void testMediumConsistentWithByteBuffer(boolean direct, boolean testBigEndian) {
        for (int i = 0; i < 100; ++i) {
            ByteBuffer javaBuffer;
            ByteBuffer byteBuffer = javaBuffer = direct ? ByteBuffer.allocateDirect(this.buffer.capacity()) : ByteBuffer.allocate(this.buffer.capacity());
            if (!testBigEndian) {
                javaBuffer = javaBuffer.order(ByteOrder.LITTLE_ENDIAN);
            }
            int expected = this.random.nextInt() & 0xFFFFFF;
            javaBuffer.putInt(expected);
            int bufferIndex = this.buffer.capacity() - 3;
            if (testBigEndian) {
                this.buffer.setMedium(bufferIndex, expected);
            } else {
                this.buffer.setMediumLE(bufferIndex, expected);
            }
            javaBuffer.flip();
            int javaActual = javaBuffer.getInt();
            org.junit.jupiter.api.Assertions.assertEquals((int)expected, (int)javaActual);
            org.junit.jupiter.api.Assertions.assertEquals((int)javaActual, (int)(testBigEndian ? this.buffer.getUnsignedMedium(bufferIndex) : this.buffer.getUnsignedMediumLE(bufferIndex)));
        }
    }

    @Test
    public void testRandomIntAccess() {
        this.testRandomIntAccess(true);
    }

    @Test
    public void testRandomIntLEAccess() {
        this.testRandomIntAccess(false);
    }

    private void testRandomIntAccess(boolean testBigEndian) {
        int value;
        int i;
        for (i = 0; i < this.buffer.capacity() - 3; i += 4) {
            value = this.random.nextInt();
            if (testBigEndian) {
                this.buffer.setInt(i, value);
                continue;
            }
            this.buffer.setIntLE(i, value);
        }
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity() - 3; i += 4) {
            value = this.random.nextInt();
            if (testBigEndian) {
                org.junit.jupiter.api.Assertions.assertEquals((int)value, (int)this.buffer.getInt(i));
                continue;
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)value, (int)this.buffer.getIntLE(i));
        }
    }

    @Test
    public void testIntConsistentWithByteBuffer() {
        this.testIntConsistentWithByteBuffer(true, true);
        this.testIntConsistentWithByteBuffer(true, false);
        this.testIntConsistentWithByteBuffer(false, true);
        this.testIntConsistentWithByteBuffer(false, false);
    }

    private void testIntConsistentWithByteBuffer(boolean direct, boolean testBigEndian) {
        for (int i = 0; i < 100; ++i) {
            ByteBuffer javaBuffer;
            ByteBuffer byteBuffer = javaBuffer = direct ? ByteBuffer.allocateDirect(this.buffer.capacity()) : ByteBuffer.allocate(this.buffer.capacity());
            if (!testBigEndian) {
                javaBuffer = javaBuffer.order(ByteOrder.LITTLE_ENDIAN);
            }
            int expected = this.random.nextInt();
            javaBuffer.putInt(expected);
            int bufferIndex = this.buffer.capacity() - 4;
            if (testBigEndian) {
                this.buffer.setInt(bufferIndex, expected);
            } else {
                this.buffer.setIntLE(bufferIndex, expected);
            }
            javaBuffer.flip();
            int javaActual = javaBuffer.getInt();
            org.junit.jupiter.api.Assertions.assertEquals((int)expected, (int)javaActual);
            org.junit.jupiter.api.Assertions.assertEquals((int)javaActual, (int)(testBigEndian ? this.buffer.getInt(bufferIndex) : this.buffer.getIntLE(bufferIndex)));
        }
    }

    @Test
    public void testRandomUnsignedIntAccess() {
        this.testRandomUnsignedIntAccess(true);
    }

    @Test
    public void testRandomUnsignedIntLEAccess() {
        this.testRandomUnsignedIntAccess(false);
    }

    private void testRandomUnsignedIntAccess(boolean testBigEndian) {
        int i;
        for (i = 0; i < this.buffer.capacity() - 3; i += 4) {
            int value = this.random.nextInt();
            if (testBigEndian) {
                this.buffer.setInt(i, value);
                continue;
            }
            this.buffer.setIntLE(i, value);
        }
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity() - 3; i += 4) {
            long value = (long)this.random.nextInt() & 0xFFFFFFFFL;
            if (testBigEndian) {
                org.junit.jupiter.api.Assertions.assertEquals((long)value, (long)this.buffer.getUnsignedInt(i));
                continue;
            }
            org.junit.jupiter.api.Assertions.assertEquals((long)value, (long)this.buffer.getUnsignedIntLE(i));
        }
    }

    @Test
    public void testRandomLongAccess() {
        this.testRandomLongAccess(true);
    }

    @Test
    public void testRandomLongLEAccess() {
        this.testRandomLongAccess(false);
    }

    private void testRandomLongAccess(boolean testBigEndian) {
        long value;
        int i;
        for (i = 0; i < this.buffer.capacity() - 7; i += 8) {
            value = this.random.nextLong();
            if (testBigEndian) {
                this.buffer.setLong(i, value);
                continue;
            }
            this.buffer.setLongLE(i, value);
        }
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity() - 7; i += 8) {
            value = this.random.nextLong();
            if (testBigEndian) {
                org.junit.jupiter.api.Assertions.assertEquals((long)value, (long)this.buffer.getLong(i));
                continue;
            }
            org.junit.jupiter.api.Assertions.assertEquals((long)value, (long)this.buffer.getLongLE(i));
        }
    }

    @Test
    public void testLongConsistentWithByteBuffer() {
        this.testLongConsistentWithByteBuffer(true, true);
        this.testLongConsistentWithByteBuffer(true, false);
        this.testLongConsistentWithByteBuffer(false, true);
        this.testLongConsistentWithByteBuffer(false, false);
    }

    private void testLongConsistentWithByteBuffer(boolean direct, boolean testBigEndian) {
        for (int i = 0; i < 100; ++i) {
            ByteBuffer javaBuffer;
            ByteBuffer byteBuffer = javaBuffer = direct ? ByteBuffer.allocateDirect(this.buffer.capacity()) : ByteBuffer.allocate(this.buffer.capacity());
            if (!testBigEndian) {
                javaBuffer = javaBuffer.order(ByteOrder.LITTLE_ENDIAN);
            }
            long expected = this.random.nextLong();
            javaBuffer.putLong(expected);
            int bufferIndex = this.buffer.capacity() - 8;
            if (testBigEndian) {
                this.buffer.setLong(bufferIndex, expected);
            } else {
                this.buffer.setLongLE(bufferIndex, expected);
            }
            javaBuffer.flip();
            long javaActual = javaBuffer.getLong();
            org.junit.jupiter.api.Assertions.assertEquals((long)expected, (long)javaActual);
            org.junit.jupiter.api.Assertions.assertEquals((long)javaActual, (long)(testBigEndian ? this.buffer.getLong(bufferIndex) : this.buffer.getLongLE(bufferIndex)));
        }
    }

    @Test
    public void testRandomFloatAccess() {
        this.testRandomFloatAccess(true);
    }

    @Test
    public void testRandomFloatLEAccess() {
        this.testRandomFloatAccess(false);
    }

    private void testRandomFloatAccess(boolean testBigEndian) {
        int i;
        for (i = 0; i < this.buffer.capacity() - 7; i += 8) {
            float value = this.random.nextFloat();
            if (testBigEndian) {
                this.buffer.setFloat(i, value);
                continue;
            }
            this.buffer.setFloatLE(i, value);
        }
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity() - 7; i += 8) {
            float expected = this.random.nextFloat();
            float actual = testBigEndian ? this.buffer.getFloat(i) : this.buffer.getFloatLE(i);
            org.junit.jupiter.api.Assertions.assertEquals((double)expected, (double)actual, (double)0.01);
        }
    }

    @Test
    public void testRandomDoubleAccess() {
        this.testRandomDoubleAccess(true);
    }

    @Test
    public void testRandomDoubleLEAccess() {
        this.testRandomDoubleAccess(false);
    }

    private void testRandomDoubleAccess(boolean testBigEndian) {
        int i;
        for (i = 0; i < this.buffer.capacity() - 7; i += 8) {
            double value = this.random.nextDouble();
            if (testBigEndian) {
                this.buffer.setDouble(i, value);
                continue;
            }
            this.buffer.setDoubleLE(i, value);
        }
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity() - 7; i += 8) {
            double expected = this.random.nextDouble();
            double actual = testBigEndian ? this.buffer.getDouble(i) : this.buffer.getDoubleLE(i);
            org.junit.jupiter.api.Assertions.assertEquals((double)expected, (double)actual, (double)0.01);
        }
    }

    @Test
    public void testSetZero() {
        int i;
        int length;
        this.buffer.clear();
        while (this.buffer.isWritable()) {
            this.buffer.writeByte(-1);
        }
        for (i = 0; i < this.buffer.capacity(); i += length) {
            length = Math.min(this.buffer.capacity() - i, this.random.nextInt(32));
            this.buffer.setZero(i, length);
        }
        for (i = 0; i < this.buffer.capacity(); ++i) {
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.buffer.getByte(i));
        }
    }

    @Test
    public void testSequentialByteAccess() {
        byte value;
        int i;
        this.buffer.writerIndex(0);
        for (i = 0; i < this.buffer.capacity(); ++i) {
            value = (byte)this.random.nextInt();
            org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)this.buffer.writerIndex());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.buffer.isWritable());
            this.buffer.writeByte((int)value);
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.buffer.readerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)this.buffer.capacity(), (int)this.buffer.writerIndex());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.buffer.isWritable());
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity(); ++i) {
            value = (byte)this.random.nextInt();
            org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)this.buffer.readerIndex());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.buffer.isReadable());
            org.junit.jupiter.api.Assertions.assertEquals((byte)value, (byte)this.buffer.readByte());
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)this.buffer.capacity(), (int)this.buffer.readerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)this.buffer.capacity(), (int)this.buffer.writerIndex());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.buffer.isReadable());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.buffer.isWritable());
    }

    @Test
    public void testSequentialUnsignedByteAccess() {
        int value;
        int i;
        this.buffer.writerIndex(0);
        for (i = 0; i < this.buffer.capacity(); ++i) {
            value = this.random.nextInt();
            org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)this.buffer.writerIndex());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.buffer.isWritable());
            this.buffer.writeByte(value);
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.buffer.readerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)this.buffer.capacity(), (int)this.buffer.writerIndex());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.buffer.isWritable());
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity(); ++i) {
            value = this.random.nextInt() & 0xFF;
            org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)this.buffer.readerIndex());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.buffer.isReadable());
            org.junit.jupiter.api.Assertions.assertEquals((int)value, (int)this.buffer.readUnsignedByte());
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)this.buffer.capacity(), (int)this.buffer.readerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)this.buffer.capacity(), (int)this.buffer.writerIndex());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.buffer.isReadable());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.buffer.isWritable());
    }

    @Test
    public void testSequentialShortAccess() {
        this.testSequentialShortAccess(true);
    }

    @Test
    public void testSequentialShortLEAccess() {
        this.testSequentialShortAccess(false);
    }

    private void testSequentialShortAccess(boolean testBigEndian) {
        short value;
        int i;
        this.buffer.writerIndex(0);
        for (i = 0; i < this.buffer.capacity(); i += 2) {
            value = (short)this.random.nextInt();
            org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)this.buffer.writerIndex());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.buffer.isWritable());
            if (testBigEndian) {
                this.buffer.writeShort((int)value);
                continue;
            }
            this.buffer.writeShortLE((int)value);
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.buffer.readerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)this.buffer.capacity(), (int)this.buffer.writerIndex());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.buffer.isWritable());
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity(); i += 2) {
            value = (short)this.random.nextInt();
            org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)this.buffer.readerIndex());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.buffer.isReadable());
            if (testBigEndian) {
                org.junit.jupiter.api.Assertions.assertEquals((short)value, (short)this.buffer.readShort());
                continue;
            }
            org.junit.jupiter.api.Assertions.assertEquals((short)value, (short)this.buffer.readShortLE());
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)this.buffer.capacity(), (int)this.buffer.readerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)this.buffer.capacity(), (int)this.buffer.writerIndex());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.buffer.isReadable());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.buffer.isWritable());
    }

    @Test
    public void testSequentialUnsignedShortAccess() {
        this.testSequentialUnsignedShortAccess(true);
    }

    @Test
    public void testSequentialUnsignedShortLEAccess() {
        this.testSequentialUnsignedShortAccess(true);
    }

    private void testSequentialUnsignedShortAccess(boolean testBigEndian) {
        int value;
        int i;
        this.buffer.writerIndex(0);
        for (i = 0; i < this.buffer.capacity(); i += 2) {
            value = this.random.nextInt();
            org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)this.buffer.writerIndex());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.buffer.isWritable());
            if (testBigEndian) {
                this.buffer.writeShort(value);
                continue;
            }
            this.buffer.writeShortLE(value);
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.buffer.readerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)this.buffer.capacity(), (int)this.buffer.writerIndex());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.buffer.isWritable());
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity(); i += 2) {
            value = this.random.nextInt() & 0xFFFF;
            org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)this.buffer.readerIndex());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.buffer.isReadable());
            if (testBigEndian) {
                org.junit.jupiter.api.Assertions.assertEquals((int)value, (int)this.buffer.readUnsignedShort());
                continue;
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)value, (int)this.buffer.readUnsignedShortLE());
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)this.buffer.capacity(), (int)this.buffer.readerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)this.buffer.capacity(), (int)this.buffer.writerIndex());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.buffer.isReadable());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.buffer.isWritable());
    }

    @Test
    public void testSequentialMediumAccess() {
        this.testSequentialMediumAccess(true);
    }

    @Test
    public void testSequentialMediumLEAccess() {
        this.testSequentialMediumAccess(false);
    }

    private void testSequentialMediumAccess(boolean testBigEndian) {
        int value;
        int i;
        this.buffer.writerIndex(0);
        for (i = 0; i < this.buffer.capacity() / 3 * 3; i += 3) {
            value = this.random.nextInt();
            org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)this.buffer.writerIndex());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.buffer.isWritable());
            if (testBigEndian) {
                this.buffer.writeMedium(value);
                continue;
            }
            this.buffer.writeMediumLE(value);
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.buffer.readerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)(this.buffer.capacity() / 3 * 3), (int)this.buffer.writerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)(this.buffer.capacity() % 3), (int)this.buffer.writableBytes());
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity() / 3 * 3; i += 3) {
            value = this.random.nextInt() << 8 >> 8;
            org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)this.buffer.readerIndex());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.buffer.isReadable());
            if (testBigEndian) {
                org.junit.jupiter.api.Assertions.assertEquals((int)value, (int)this.buffer.readMedium());
                continue;
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)value, (int)this.buffer.readMediumLE());
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)(this.buffer.capacity() / 3 * 3), (int)this.buffer.readerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)(this.buffer.capacity() / 3 * 3), (int)this.buffer.writerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.buffer.readableBytes());
        org.junit.jupiter.api.Assertions.assertEquals((int)(this.buffer.capacity() % 3), (int)this.buffer.writableBytes());
    }

    @Test
    public void testSequentialUnsignedMediumAccess() {
        this.testSequentialUnsignedMediumAccess(true);
    }

    @Test
    public void testSequentialUnsignedMediumLEAccess() {
        this.testSequentialUnsignedMediumAccess(false);
    }

    private void testSequentialUnsignedMediumAccess(boolean testBigEndian) {
        int value;
        int i;
        this.buffer.writerIndex(0);
        for (i = 0; i < this.buffer.capacity() / 3 * 3; i += 3) {
            value = this.random.nextInt() & 0xFFFFFF;
            org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)this.buffer.writerIndex());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.buffer.isWritable());
            if (testBigEndian) {
                this.buffer.writeMedium(value);
                continue;
            }
            this.buffer.writeMediumLE(value);
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.buffer.readerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)(this.buffer.capacity() / 3 * 3), (int)this.buffer.writerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)(this.buffer.capacity() % 3), (int)this.buffer.writableBytes());
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity() / 3 * 3; i += 3) {
            value = this.random.nextInt() & 0xFFFFFF;
            org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)this.buffer.readerIndex());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.buffer.isReadable());
            if (testBigEndian) {
                org.junit.jupiter.api.Assertions.assertEquals((int)value, (int)this.buffer.readUnsignedMedium());
                continue;
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)value, (int)this.buffer.readUnsignedMediumLE());
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)(this.buffer.capacity() / 3 * 3), (int)this.buffer.readerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)(this.buffer.capacity() / 3 * 3), (int)this.buffer.writerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.buffer.readableBytes());
        org.junit.jupiter.api.Assertions.assertEquals((int)(this.buffer.capacity() % 3), (int)this.buffer.writableBytes());
    }

    @Test
    public void testSequentialIntAccess() {
        this.testSequentialIntAccess(true);
    }

    @Test
    public void testSequentialIntLEAccess() {
        this.testSequentialIntAccess(false);
    }

    private void testSequentialIntAccess(boolean testBigEndian) {
        int value;
        int i;
        this.buffer.writerIndex(0);
        for (i = 0; i < this.buffer.capacity(); i += 4) {
            value = this.random.nextInt();
            org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)this.buffer.writerIndex());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.buffer.isWritable());
            if (testBigEndian) {
                this.buffer.writeInt(value);
                continue;
            }
            this.buffer.writeIntLE(value);
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.buffer.readerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)this.buffer.capacity(), (int)this.buffer.writerIndex());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.buffer.isWritable());
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity(); i += 4) {
            value = this.random.nextInt();
            org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)this.buffer.readerIndex());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.buffer.isReadable());
            if (testBigEndian) {
                org.junit.jupiter.api.Assertions.assertEquals((int)value, (int)this.buffer.readInt());
                continue;
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)value, (int)this.buffer.readIntLE());
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)this.buffer.capacity(), (int)this.buffer.readerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)this.buffer.capacity(), (int)this.buffer.writerIndex());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.buffer.isReadable());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.buffer.isWritable());
    }

    @Test
    public void testSequentialUnsignedIntAccess() {
        this.testSequentialUnsignedIntAccess(true);
    }

    @Test
    public void testSequentialUnsignedIntLEAccess() {
        this.testSequentialUnsignedIntAccess(false);
    }

    private void testSequentialUnsignedIntAccess(boolean testBigEndian) {
        int i;
        this.buffer.writerIndex(0);
        for (i = 0; i < this.buffer.capacity(); i += 4) {
            int value = this.random.nextInt();
            org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)this.buffer.writerIndex());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.buffer.isWritable());
            if (testBigEndian) {
                this.buffer.writeInt(value);
                continue;
            }
            this.buffer.writeIntLE(value);
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.buffer.readerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)this.buffer.capacity(), (int)this.buffer.writerIndex());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.buffer.isWritable());
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity(); i += 4) {
            long value = (long)this.random.nextInt() & 0xFFFFFFFFL;
            org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)this.buffer.readerIndex());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.buffer.isReadable());
            if (testBigEndian) {
                org.junit.jupiter.api.Assertions.assertEquals((long)value, (long)this.buffer.readUnsignedInt());
                continue;
            }
            org.junit.jupiter.api.Assertions.assertEquals((long)value, (long)this.buffer.readUnsignedIntLE());
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)this.buffer.capacity(), (int)this.buffer.readerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)this.buffer.capacity(), (int)this.buffer.writerIndex());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.buffer.isReadable());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.buffer.isWritable());
    }

    @Test
    public void testSequentialLongAccess() {
        this.testSequentialLongAccess(true);
    }

    @Test
    public void testSequentialLongLEAccess() {
        this.testSequentialLongAccess(false);
    }

    private void testSequentialLongAccess(boolean testBigEndian) {
        long value;
        int i;
        this.buffer.writerIndex(0);
        for (i = 0; i < this.buffer.capacity(); i += 8) {
            value = this.random.nextLong();
            org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)this.buffer.writerIndex());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.buffer.isWritable());
            if (testBigEndian) {
                this.buffer.writeLong(value);
                continue;
            }
            this.buffer.writeLongLE(value);
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.buffer.readerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)this.buffer.capacity(), (int)this.buffer.writerIndex());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.buffer.isWritable());
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity(); i += 8) {
            value = this.random.nextLong();
            org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)this.buffer.readerIndex());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.buffer.isReadable());
            if (testBigEndian) {
                org.junit.jupiter.api.Assertions.assertEquals((long)value, (long)this.buffer.readLong());
                continue;
            }
            org.junit.jupiter.api.Assertions.assertEquals((long)value, (long)this.buffer.readLongLE());
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)this.buffer.capacity(), (int)this.buffer.readerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)this.buffer.capacity(), (int)this.buffer.writerIndex());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.buffer.isReadable());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.buffer.isWritable());
    }

    @Test
    public void testByteArrayTransfer() {
        byte[] value = new byte[256];
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(value);
            this.buffer.setBytes(i, value, this.random.nextInt(128), 128);
        }
        this.random.setSeed(this.seed);
        byte[] expectedValue = new byte[256];
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValue);
            int valueOffset = this.random.nextInt(128);
            this.buffer.getBytes(i, value, valueOffset, 128);
            for (int j = valueOffset; j < valueOffset + 128; ++j) {
                org.junit.jupiter.api.Assertions.assertEquals((byte)expectedValue[j], (byte)value[j]);
            }
        }
    }

    @Test
    public void testRandomByteArrayTransfer1() {
        byte[] value = new byte[128];
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(value);
            this.buffer.setBytes(i, value);
        }
        this.random.setSeed(this.seed);
        byte[] expectedValueContent = new byte[128];
        ByteBuf expectedValue = Unpooled.wrappedBuffer((byte[])expectedValueContent);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValueContent);
            this.buffer.getBytes(i, value);
            for (int j = 0; j < 128; ++j) {
                org.junit.jupiter.api.Assertions.assertEquals((byte)expectedValue.getByte(j), (byte)value[j]);
            }
        }
    }

    @Test
    public void testRandomByteArrayTransfer2() {
        byte[] value = new byte[256];
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(value);
            this.buffer.setBytes(i, value, this.random.nextInt(128), 128);
        }
        this.random.setSeed(this.seed);
        byte[] expectedValueContent = new byte[256];
        ByteBuf expectedValue = Unpooled.wrappedBuffer((byte[])expectedValueContent);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValueContent);
            int valueOffset = this.random.nextInt(128);
            this.buffer.getBytes(i, value, valueOffset, 128);
            for (int j = valueOffset; j < valueOffset + 128; ++j) {
                org.junit.jupiter.api.Assertions.assertEquals((byte)expectedValue.getByte(j), (byte)value[j]);
            }
        }
    }

    @Test
    public void testRandomHeapBufferTransfer1() {
        byte[] valueContent = new byte[128];
        ByteBuf value = Unpooled.wrappedBuffer((byte[])valueContent);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(valueContent);
            value.setIndex(0, 128);
            this.buffer.setBytes(i, value);
            org.junit.jupiter.api.Assertions.assertEquals((int)128, (int)value.readerIndex());
            org.junit.jupiter.api.Assertions.assertEquals((int)128, (int)value.writerIndex());
        }
        this.random.setSeed(this.seed);
        byte[] expectedValueContent = new byte[128];
        ByteBuf expectedValue = Unpooled.wrappedBuffer((byte[])expectedValueContent);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValueContent);
            value.clear();
            this.buffer.getBytes(i, value);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)value.readerIndex());
            org.junit.jupiter.api.Assertions.assertEquals((int)128, (int)value.writerIndex());
            for (int j = 0; j < 128; ++j) {
                org.junit.jupiter.api.Assertions.assertEquals((byte)expectedValue.getByte(j), (byte)value.getByte(j));
            }
        }
    }

    @Test
    public void testRandomHeapBufferTransfer2() {
        byte[] valueContent = new byte[256];
        ByteBuf value = Unpooled.wrappedBuffer((byte[])valueContent);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(valueContent);
            this.buffer.setBytes(i, value, this.random.nextInt(128), 128);
        }
        this.random.setSeed(this.seed);
        byte[] expectedValueContent = new byte[256];
        ByteBuf expectedValue = Unpooled.wrappedBuffer((byte[])expectedValueContent);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValueContent);
            int valueOffset = this.random.nextInt(128);
            this.buffer.getBytes(i, value, valueOffset, 128);
            for (int j = valueOffset; j < valueOffset + 128; ++j) {
                org.junit.jupiter.api.Assertions.assertEquals((byte)expectedValue.getByte(j), (byte)value.getByte(j));
            }
        }
    }

    @Test
    public void testRandomDirectBufferTransfer() {
        byte[] tmp = new byte[256];
        ByteBuf value = Unpooled.directBuffer((int)256);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(tmp);
            value.setBytes(0, tmp, 0, value.capacity());
            this.buffer.setBytes(i, value, this.random.nextInt(128), 128);
        }
        this.random.setSeed(this.seed);
        ByteBuf expectedValue = Unpooled.directBuffer((int)256);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(tmp);
            expectedValue.setBytes(0, tmp, 0, expectedValue.capacity());
            int valueOffset = this.random.nextInt(128);
            this.buffer.getBytes(i, value, valueOffset, 128);
            for (int j = valueOffset; j < valueOffset + 128; ++j) {
                org.junit.jupiter.api.Assertions.assertEquals((byte)expectedValue.getByte(j), (byte)value.getByte(j));
            }
        }
        value.release();
        expectedValue.release();
    }

    @Test
    public void testRandomByteBufferTransfer() {
        ByteBuffer value = ByteBuffer.allocate(256);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(value.array());
            value.clear().position(this.random.nextInt(128));
            value.limit(value.position() + 128);
            this.buffer.setBytes(i, value);
        }
        this.random.setSeed(this.seed);
        ByteBuffer expectedValue = ByteBuffer.allocate(256);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValue.array());
            int valueOffset = this.random.nextInt(128);
            value.clear().position(valueOffset).limit(valueOffset + 128);
            this.buffer.getBytes(i, value);
            org.junit.jupiter.api.Assertions.assertEquals((int)(valueOffset + 128), (int)value.position());
            for (int j = valueOffset; j < valueOffset + 128; ++j) {
                org.junit.jupiter.api.Assertions.assertEquals((byte)expectedValue.get(j), (byte)value.get(j));
            }
        }
    }

    @Test
    public void testSequentialByteArrayTransfer1() {
        byte[] value = new byte[128];
        this.buffer.writerIndex(0);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(value);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.buffer.readerIndex());
            org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)this.buffer.writerIndex());
            this.buffer.writeBytes(value);
        }
        this.random.setSeed(this.seed);
        byte[] expectedValue = new byte[128];
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValue);
            org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)this.buffer.readerIndex());
            org.junit.jupiter.api.Assertions.assertEquals((int)4096, (int)this.buffer.writerIndex());
            this.buffer.readBytes(value);
            for (int j = 0; j < 128; ++j) {
                org.junit.jupiter.api.Assertions.assertEquals((byte)expectedValue[j], (byte)value[j]);
            }
        }
    }

    @Test
    public void testSequentialByteArrayTransfer2() {
        byte[] value = new byte[256];
        this.buffer.writerIndex(0);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(value);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.buffer.readerIndex());
            org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)this.buffer.writerIndex());
            int readerIndex = this.random.nextInt(128);
            this.buffer.writeBytes(value, readerIndex, 128);
        }
        this.random.setSeed(this.seed);
        byte[] expectedValue = new byte[256];
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValue);
            int valueOffset = this.random.nextInt(128);
            org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)this.buffer.readerIndex());
            org.junit.jupiter.api.Assertions.assertEquals((int)4096, (int)this.buffer.writerIndex());
            this.buffer.readBytes(value, valueOffset, 128);
            for (int j = valueOffset; j < valueOffset + 128; ++j) {
                org.junit.jupiter.api.Assertions.assertEquals((byte)expectedValue[j], (byte)value[j]);
            }
        }
    }

    @Test
    public void testSequentialHeapBufferTransfer1() {
        byte[] valueContent = new byte[256];
        ByteBuf value = Unpooled.wrappedBuffer((byte[])valueContent);
        this.buffer.writerIndex(0);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(valueContent);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.buffer.readerIndex());
            org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)this.buffer.writerIndex());
            this.buffer.writeBytes(value, this.random.nextInt(128), 128);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)value.readerIndex());
            org.junit.jupiter.api.Assertions.assertEquals((int)valueContent.length, (int)value.writerIndex());
        }
        this.random.setSeed(this.seed);
        byte[] expectedValueContent = new byte[256];
        ByteBuf expectedValue = Unpooled.wrappedBuffer((byte[])expectedValueContent);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValueContent);
            int valueOffset = this.random.nextInt(128);
            org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)this.buffer.readerIndex());
            org.junit.jupiter.api.Assertions.assertEquals((int)4096, (int)this.buffer.writerIndex());
            this.buffer.readBytes(value, valueOffset, 128);
            for (int j = valueOffset; j < valueOffset + 128; ++j) {
                org.junit.jupiter.api.Assertions.assertEquals((byte)expectedValue.getByte(j), (byte)value.getByte(j));
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)value.readerIndex());
            org.junit.jupiter.api.Assertions.assertEquals((int)valueContent.length, (int)value.writerIndex());
        }
    }

    @Test
    public void testSequentialHeapBufferTransfer2() {
        byte[] valueContent = new byte[256];
        ByteBuf value = Unpooled.wrappedBuffer((byte[])valueContent);
        this.buffer.writerIndex(0);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(valueContent);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.buffer.readerIndex());
            org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)this.buffer.writerIndex());
            int readerIndex = this.random.nextInt(128);
            value.readerIndex(readerIndex);
            value.writerIndex(readerIndex + 128);
            this.buffer.writeBytes(value);
            org.junit.jupiter.api.Assertions.assertEquals((int)(readerIndex + 128), (int)value.writerIndex());
            org.junit.jupiter.api.Assertions.assertEquals((int)value.writerIndex(), (int)value.readerIndex());
        }
        this.random.setSeed(this.seed);
        byte[] expectedValueContent = new byte[256];
        ByteBuf expectedValue = Unpooled.wrappedBuffer((byte[])expectedValueContent);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValueContent);
            int valueOffset = this.random.nextInt(128);
            org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)this.buffer.readerIndex());
            org.junit.jupiter.api.Assertions.assertEquals((int)4096, (int)this.buffer.writerIndex());
            value.readerIndex(valueOffset);
            value.writerIndex(valueOffset);
            this.buffer.readBytes(value, 128);
            for (int j = valueOffset; j < valueOffset + 128; ++j) {
                org.junit.jupiter.api.Assertions.assertEquals((byte)expectedValue.getByte(j), (byte)value.getByte(j));
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)valueOffset, (int)value.readerIndex());
            org.junit.jupiter.api.Assertions.assertEquals((int)(valueOffset + 128), (int)value.writerIndex());
        }
    }

    @Test
    public void testSequentialDirectBufferTransfer1() {
        byte[] valueContent = new byte[256];
        ByteBuf value = Unpooled.directBuffer((int)256);
        this.buffer.writerIndex(0);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(valueContent);
            value.setBytes(0, valueContent);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.buffer.readerIndex());
            org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)this.buffer.writerIndex());
            this.buffer.writeBytes(value, this.random.nextInt(128), 128);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)value.readerIndex());
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)value.writerIndex());
        }
        this.random.setSeed(this.seed);
        byte[] expectedValueContent = new byte[256];
        ByteBuf expectedValue = Unpooled.wrappedBuffer((byte[])expectedValueContent);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValueContent);
            int valueOffset = this.random.nextInt(128);
            value.setBytes(0, valueContent);
            org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)this.buffer.readerIndex());
            org.junit.jupiter.api.Assertions.assertEquals((int)4096, (int)this.buffer.writerIndex());
            this.buffer.readBytes(value, valueOffset, 128);
            for (int j = valueOffset; j < valueOffset + 128; ++j) {
                org.junit.jupiter.api.Assertions.assertEquals((byte)expectedValue.getByte(j), (byte)value.getByte(j));
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)value.readerIndex());
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)value.writerIndex());
        }
        value.release();
        expectedValue.release();
    }

    @Test
    public void testSequentialDirectBufferTransfer2() {
        byte[] valueContent = new byte[256];
        ByteBuf value = Unpooled.directBuffer((int)256);
        this.buffer.writerIndex(0);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(valueContent);
            value.setBytes(0, valueContent);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.buffer.readerIndex());
            org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)this.buffer.writerIndex());
            int readerIndex = this.random.nextInt(128);
            value.readerIndex(0);
            value.writerIndex(readerIndex + 128);
            value.readerIndex(readerIndex);
            this.buffer.writeBytes(value);
            org.junit.jupiter.api.Assertions.assertEquals((int)(readerIndex + 128), (int)value.writerIndex());
            org.junit.jupiter.api.Assertions.assertEquals((int)value.writerIndex(), (int)value.readerIndex());
        }
        this.random.setSeed(this.seed);
        byte[] expectedValueContent = new byte[256];
        ByteBuf expectedValue = Unpooled.wrappedBuffer((byte[])expectedValueContent);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValueContent);
            value.setBytes(0, valueContent);
            int valueOffset = this.random.nextInt(128);
            org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)this.buffer.readerIndex());
            org.junit.jupiter.api.Assertions.assertEquals((int)4096, (int)this.buffer.writerIndex());
            value.readerIndex(valueOffset);
            value.writerIndex(valueOffset);
            this.buffer.readBytes(value, 128);
            for (int j = valueOffset; j < valueOffset + 128; ++j) {
                org.junit.jupiter.api.Assertions.assertEquals((byte)expectedValue.getByte(j), (byte)value.getByte(j));
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)valueOffset, (int)value.readerIndex());
            org.junit.jupiter.api.Assertions.assertEquals((int)(valueOffset + 128), (int)value.writerIndex());
        }
        value.release();
        expectedValue.release();
    }

    @Test
    public void testSequentialByteBufferBackedHeapBufferTransfer1() {
        byte[] valueContent = new byte[256];
        ByteBuf value = Unpooled.wrappedBuffer((ByteBuffer)ByteBuffer.allocate(256));
        value.writerIndex(0);
        this.buffer.writerIndex(0);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(valueContent);
            value.setBytes(0, valueContent);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.buffer.readerIndex());
            org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)this.buffer.writerIndex());
            this.buffer.writeBytes(value, this.random.nextInt(128), 128);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)value.readerIndex());
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)value.writerIndex());
        }
        this.random.setSeed(this.seed);
        byte[] expectedValueContent = new byte[256];
        ByteBuf expectedValue = Unpooled.wrappedBuffer((byte[])expectedValueContent);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValueContent);
            int valueOffset = this.random.nextInt(128);
            value.setBytes(0, valueContent);
            org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)this.buffer.readerIndex());
            org.junit.jupiter.api.Assertions.assertEquals((int)4096, (int)this.buffer.writerIndex());
            this.buffer.readBytes(value, valueOffset, 128);
            for (int j = valueOffset; j < valueOffset + 128; ++j) {
                org.junit.jupiter.api.Assertions.assertEquals((byte)expectedValue.getByte(j), (byte)value.getByte(j));
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)value.readerIndex());
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)value.writerIndex());
        }
    }

    @Test
    public void testSequentialByteBufferBackedHeapBufferTransfer2() {
        byte[] valueContent = new byte[256];
        ByteBuf value = Unpooled.wrappedBuffer((ByteBuffer)ByteBuffer.allocate(256));
        value.writerIndex(0);
        this.buffer.writerIndex(0);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(valueContent);
            value.setBytes(0, valueContent);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.buffer.readerIndex());
            org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)this.buffer.writerIndex());
            int readerIndex = this.random.nextInt(128);
            value.readerIndex(0);
            value.writerIndex(readerIndex + 128);
            value.readerIndex(readerIndex);
            this.buffer.writeBytes(value);
            org.junit.jupiter.api.Assertions.assertEquals((int)(readerIndex + 128), (int)value.writerIndex());
            org.junit.jupiter.api.Assertions.assertEquals((int)value.writerIndex(), (int)value.readerIndex());
        }
        this.random.setSeed(this.seed);
        byte[] expectedValueContent = new byte[256];
        ByteBuf expectedValue = Unpooled.wrappedBuffer((byte[])expectedValueContent);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValueContent);
            value.setBytes(0, valueContent);
            int valueOffset = this.random.nextInt(128);
            org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)this.buffer.readerIndex());
            org.junit.jupiter.api.Assertions.assertEquals((int)4096, (int)this.buffer.writerIndex());
            value.readerIndex(valueOffset);
            value.writerIndex(valueOffset);
            this.buffer.readBytes(value, 128);
            for (int j = valueOffset; j < valueOffset + 128; ++j) {
                org.junit.jupiter.api.Assertions.assertEquals((byte)expectedValue.getByte(j), (byte)value.getByte(j));
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)valueOffset, (int)value.readerIndex());
            org.junit.jupiter.api.Assertions.assertEquals((int)(valueOffset + 128), (int)value.writerIndex());
        }
    }

    @Test
    public void testSequentialByteBufferTransfer() {
        this.buffer.writerIndex(0);
        ByteBuffer value = ByteBuffer.allocate(256);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(value.array());
            value.clear().position(this.random.nextInt(128));
            value.limit(value.position() + 128);
            this.buffer.writeBytes(value);
        }
        this.random.setSeed(this.seed);
        ByteBuffer expectedValue = ByteBuffer.allocate(256);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValue.array());
            int valueOffset = this.random.nextInt(128);
            value.clear().position(valueOffset).limit(valueOffset + 128);
            this.buffer.readBytes(value);
            org.junit.jupiter.api.Assertions.assertEquals((int)(valueOffset + 128), (int)value.position());
            for (int j = valueOffset; j < valueOffset + 128; ++j) {
                org.junit.jupiter.api.Assertions.assertEquals((byte)expectedValue.get(j), (byte)value.get(j));
            }
        }
    }

    @Test
    public void testSequentialCopiedBufferTransfer1() {
        this.buffer.writerIndex(0);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            byte[] value = new byte[128];
            this.random.nextBytes(value);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.buffer.readerIndex());
            org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)this.buffer.writerIndex());
            this.buffer.writeBytes(value);
        }
        this.random.setSeed(this.seed);
        byte[] expectedValue = new byte[128];
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValue);
            org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)this.buffer.readerIndex());
            org.junit.jupiter.api.Assertions.assertEquals((int)4096, (int)this.buffer.writerIndex());
            ByteBuf actualValue = this.buffer.readBytes(128);
            org.junit.jupiter.api.Assertions.assertEquals((Object)Unpooled.wrappedBuffer((byte[])expectedValue), (Object)actualValue);
            actualValue.setByte(0, (int)((byte)(actualValue.getByte(0) + 1)));
            org.junit.jupiter.api.Assertions.assertFalse((this.buffer.getByte(i) == actualValue.getByte(0) ? 1 : 0) != 0);
            actualValue.release();
        }
    }

    @Test
    public void testSequentialSlice1() {
        this.buffer.writerIndex(0);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            byte[] value = new byte[128];
            this.random.nextBytes(value);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.buffer.readerIndex());
            org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)this.buffer.writerIndex());
            this.buffer.writeBytes(value);
        }
        this.random.setSeed(this.seed);
        byte[] expectedValue = new byte[128];
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValue);
            org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)this.buffer.readerIndex());
            org.junit.jupiter.api.Assertions.assertEquals((int)4096, (int)this.buffer.writerIndex());
            ByteBuf actualValue = this.buffer.readSlice(128);
            org.junit.jupiter.api.Assertions.assertEquals((Object)this.buffer.order(), (Object)actualValue.order());
            org.junit.jupiter.api.Assertions.assertEquals((Object)Unpooled.wrappedBuffer((byte[])expectedValue), (Object)actualValue);
            actualValue.setByte(0, (int)((byte)(actualValue.getByte(0) + 1)));
            org.junit.jupiter.api.Assertions.assertEquals((byte)this.buffer.getByte(i), (byte)actualValue.getByte(0));
        }
    }

    @Test
    public void testWriteZero() {
        int i;
        int length;
        try {
            this.buffer.writeZero(-1);
            org.junit.jupiter.api.Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.buffer.clear();
        while (this.buffer.isWritable()) {
            this.buffer.writeByte(-1);
        }
        this.buffer.clear();
        for (i = 0; i < this.buffer.capacity(); i += length) {
            length = Math.min(this.buffer.capacity() - i, this.random.nextInt(32));
            this.buffer.writeZero(length);
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.buffer.readerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)this.buffer.capacity(), (int)this.buffer.writerIndex());
        for (i = 0; i < this.buffer.capacity(); ++i) {
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.buffer.getByte(i));
        }
    }

    @Test
    public void testDiscardReadBytes() {
        this.buffer.writerIndex(0);
        for (int i = 0; i < this.buffer.capacity(); i += 4) {
            this.buffer.writeInt(i);
        }
        ByteBuf copy = Unpooled.copiedBuffer((ByteBuf)this.buffer);
        this.buffer.readerIndex(1024);
        this.buffer.markReaderIndex();
        this.buffer.writerIndex(1365);
        this.buffer.markWriterIndex();
        this.buffer.readerIndex(0);
        this.buffer.writerIndex(2048);
        this.buffer.discardReadBytes();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.buffer.readerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)2048, (int)this.buffer.writerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((Object)copy.slice(0, 2048), (Object)this.buffer.slice(0, 2048));
        this.buffer.resetReaderIndex();
        org.junit.jupiter.api.Assertions.assertEquals((int)1024, (int)this.buffer.readerIndex());
        this.buffer.resetWriterIndex();
        org.junit.jupiter.api.Assertions.assertEquals((int)1365, (int)this.buffer.writerIndex());
        this.buffer.readerIndex(1);
        this.buffer.writerIndex(2048);
        this.buffer.discardReadBytes();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.buffer.readerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)2047, (int)this.buffer.writerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((Object)copy.slice(1, 2047), (Object)this.buffer.slice(0, 2047));
        if (this.discardReadBytesDoesNotMoveWritableBytes()) {
            org.junit.jupiter.api.Assertions.assertFalse((boolean)copy.slice(2048, 2048).equals((Object)this.buffer.slice(2047, 2048)));
        } else {
            org.junit.jupiter.api.Assertions.assertEquals((Object)copy.slice(2048, 2048), (Object)this.buffer.slice(2047, 2048));
        }
        this.buffer.resetReaderIndex();
        org.junit.jupiter.api.Assertions.assertEquals((int)1023, (int)this.buffer.readerIndex());
        this.buffer.resetWriterIndex();
        org.junit.jupiter.api.Assertions.assertEquals((int)1364, (int)this.buffer.writerIndex());
        copy.release();
    }

    @Test
    public void testDiscardReadBytes2() {
        this.buffer.writerIndex(0);
        for (int i = 0; i < this.buffer.capacity(); ++i) {
            this.buffer.writeByte((int)((byte)i));
        }
        ByteBuf copy = Unpooled.copiedBuffer((ByteBuf)this.buffer);
        this.buffer.setIndex(2047, 4095);
        this.buffer.discardReadBytes();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.buffer.readerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)2048, (int)this.buffer.writerIndex());
        for (int i = 0; i < 2048; ++i) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)copy.slice(2047 + i, 2048 - i), (Object)this.buffer.slice(i, 2048 - i));
        }
        copy.release();
    }

    @Test
    public void testStreamTransfer1() throws Exception {
        byte[] expected = new byte[this.buffer.capacity()];
        this.random.nextBytes(expected);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            ByteArrayInputStream in = new ByteArrayInputStream(expected, i, 128);
            org.junit.jupiter.api.Assertions.assertEquals((int)128, (int)this.buffer.setBytes(i, (InputStream)in, 128));
            org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)this.buffer.setBytes(i, (InputStream)in, 0));
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.buffer.getBytes(i, (OutputStream)out, 128);
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Arrays.equals(expected, out.toByteArray()));
    }

    @Test
    public void testStreamTransfer2() throws Exception {
        byte[] expected = new byte[this.buffer.capacity()];
        this.random.nextBytes(expected);
        this.buffer.clear();
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            ByteArrayInputStream in = new ByteArrayInputStream(expected, i, 128);
            org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)this.buffer.writerIndex());
            this.buffer.writeBytes((InputStream)in, 128);
            org.junit.jupiter.api.Assertions.assertEquals((int)(i + 128), (int)this.buffer.writerIndex());
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)this.buffer.readerIndex());
            this.buffer.readBytes((OutputStream)out, 128);
            org.junit.jupiter.api.Assertions.assertEquals((int)(i + 128), (int)this.buffer.readerIndex());
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Arrays.equals(expected, out.toByteArray()));
    }

    @Test
    public void testCopy() {
        for (int i = 0; i < this.buffer.capacity(); ++i) {
            byte value = (byte)this.random.nextInt();
            this.buffer.setByte(i, (int)value);
        }
        int readerIndex = 1365;
        int writerIndex = 2730;
        this.buffer.setIndex(1365, 2730);
        ByteBuf copy = this.buffer.copy();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)copy.readerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)this.buffer.readableBytes(), (int)copy.writerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)this.buffer.readableBytes(), (int)copy.capacity());
        org.junit.jupiter.api.Assertions.assertSame((Object)this.buffer.order(), (Object)copy.order());
        for (int i = 0; i < copy.capacity(); ++i) {
            org.junit.jupiter.api.Assertions.assertEquals((byte)this.buffer.getByte(i + 1365), (byte)copy.getByte(i));
        }
        this.buffer.setByte(1365, (int)((byte)(this.buffer.getByte(1365) + 1)));
        org.junit.jupiter.api.Assertions.assertTrue((this.buffer.getByte(1365) != copy.getByte(0) ? 1 : 0) != 0);
        copy.setByte(1, (int)((byte)(copy.getByte(1) + 1)));
        org.junit.jupiter.api.Assertions.assertTrue((this.buffer.getByte(1366) != copy.getByte(1) ? 1 : 0) != 0);
        copy.release();
    }

    @Test
    public void testDuplicate() {
        for (int i = 0; i < this.buffer.capacity(); ++i) {
            byte value = (byte)this.random.nextInt();
            this.buffer.setByte(i, (int)value);
        }
        int readerIndex = 1365;
        int writerIndex = 2730;
        this.buffer.setIndex(1365, 2730);
        ByteBuf duplicate = this.buffer.duplicate();
        org.junit.jupiter.api.Assertions.assertSame((Object)this.buffer.order(), (Object)duplicate.order());
        org.junit.jupiter.api.Assertions.assertEquals((int)this.buffer.readableBytes(), (int)duplicate.readableBytes());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.buffer.compareTo(duplicate));
        this.buffer.setByte(1365, (int)((byte)(this.buffer.getByte(1365) + 1)));
        org.junit.jupiter.api.Assertions.assertEquals((byte)this.buffer.getByte(1365), (byte)duplicate.getByte(duplicate.readerIndex()));
        duplicate.setByte(duplicate.readerIndex(), (int)((byte)(duplicate.getByte(duplicate.readerIndex()) + 1)));
        org.junit.jupiter.api.Assertions.assertEquals((byte)this.buffer.getByte(1365), (byte)duplicate.getByte(duplicate.readerIndex()));
    }

    @Test
    public void testSliceEndianness() throws Exception {
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.buffer.order(), (Object)this.buffer.slice(0, this.buffer.capacity()).order());
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.buffer.order(), (Object)this.buffer.slice(0, this.buffer.capacity() - 1).order());
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.buffer.order(), (Object)this.buffer.slice(1, this.buffer.capacity() - 1).order());
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.buffer.order(), (Object)this.buffer.slice(1, this.buffer.capacity() - 2).order());
    }

    @Test
    public void testSliceIndex() throws Exception {
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.buffer.slice(0, this.buffer.capacity()).readerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.buffer.slice(0, this.buffer.capacity() - 1).readerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.buffer.slice(1, this.buffer.capacity() - 1).readerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.buffer.slice(1, this.buffer.capacity() - 2).readerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)this.buffer.capacity(), (int)this.buffer.slice(0, this.buffer.capacity()).writerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)(this.buffer.capacity() - 1), (int)this.buffer.slice(0, this.buffer.capacity() - 1).writerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)(this.buffer.capacity() - 1), (int)this.buffer.slice(1, this.buffer.capacity() - 1).writerIndex());
        org.junit.jupiter.api.Assertions.assertEquals((int)(this.buffer.capacity() - 2), (int)this.buffer.slice(1, this.buffer.capacity() - 2).writerIndex());
    }

    @Test
    public void testRetainedSliceIndex() throws Exception {
        ByteBuf retainedSlice = this.buffer.retainedSlice(0, this.buffer.capacity());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)retainedSlice.readerIndex());
        retainedSlice.release();
        retainedSlice = this.buffer.retainedSlice(0, this.buffer.capacity() - 1);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)retainedSlice.readerIndex());
        retainedSlice.release();
        retainedSlice = this.buffer.retainedSlice(1, this.buffer.capacity() - 1);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)retainedSlice.readerIndex());
        retainedSlice.release();
        retainedSlice = this.buffer.retainedSlice(1, this.buffer.capacity() - 2);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)retainedSlice.readerIndex());
        retainedSlice.release();
        retainedSlice = this.buffer.retainedSlice(0, this.buffer.capacity());
        org.junit.jupiter.api.Assertions.assertEquals((int)this.buffer.capacity(), (int)retainedSlice.writerIndex());
        retainedSlice.release();
        retainedSlice = this.buffer.retainedSlice(0, this.buffer.capacity() - 1);
        org.junit.jupiter.api.Assertions.assertEquals((int)(this.buffer.capacity() - 1), (int)retainedSlice.writerIndex());
        retainedSlice.release();
        retainedSlice = this.buffer.retainedSlice(1, this.buffer.capacity() - 1);
        org.junit.jupiter.api.Assertions.assertEquals((int)(this.buffer.capacity() - 1), (int)retainedSlice.writerIndex());
        retainedSlice.release();
        retainedSlice = this.buffer.retainedSlice(1, this.buffer.capacity() - 2);
        org.junit.jupiter.api.Assertions.assertEquals((int)(this.buffer.capacity() - 2), (int)retainedSlice.writerIndex());
        retainedSlice.release();
    }

    @Test
    public void testDuplicateOfSliceHasTheSameCapacityAsTheSlice() {
        ByteBuf slice = this.buffer.slice();
        ByteBuf duplicate = slice.duplicate();
        org.junit.jupiter.api.Assertions.assertEquals((int)slice.capacity(), (int)duplicate.capacity());
        slice = this.buffer.slice(0, this.buffer.capacity() - 2);
        duplicate = slice.duplicate();
        org.junit.jupiter.api.Assertions.assertEquals((int)slice.capacity(), (int)duplicate.capacity());
        slice = this.buffer.slice();
        duplicate = slice.retainedDuplicate();
        org.junit.jupiter.api.Assertions.assertEquals((int)slice.capacity(), (int)duplicate.capacity());
        duplicate.release();
        slice = this.buffer.slice(0, this.buffer.capacity() - 2);
        duplicate = slice.retainedDuplicate();
        org.junit.jupiter.api.Assertions.assertEquals((int)slice.capacity(), (int)duplicate.capacity());
        duplicate.release();
    }

    @Test
    public void testDuplicateOfRetainedSliceHasTheSameCapacityAsTheSlice() {
        ByteBuf slice = this.buffer.retainedSlice();
        ByteBuf duplicate = slice.duplicate();
        org.junit.jupiter.api.Assertions.assertEquals((int)slice.capacity(), (int)duplicate.capacity());
        slice.release();
        slice = this.buffer.retainedSlice(0, this.buffer.capacity() - 2);
        duplicate = slice.duplicate();
        org.junit.jupiter.api.Assertions.assertEquals((int)slice.capacity(), (int)duplicate.capacity());
        slice.release();
        slice = this.buffer.retainedSlice();
        duplicate = slice.retainedDuplicate();
        org.junit.jupiter.api.Assertions.assertEquals((int)slice.capacity(), (int)duplicate.capacity());
        slice.release();
        duplicate.release();
        slice = this.buffer.retainedSlice(0, this.buffer.capacity() - 2);
        duplicate = slice.retainedDuplicate();
        org.junit.jupiter.api.Assertions.assertEquals((int)slice.capacity(), (int)duplicate.capacity());
        slice.release();
        duplicate.release();
    }

    @Test
    public void testEquals() {
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.buffer.equals(null));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.buffer.equals(new Object()));
        byte[] value = new byte[32];
        this.buffer.setIndex(0, value.length);
        this.random.nextBytes(value);
        this.buffer.setBytes(0, value);
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.buffer, (Object)Unpooled.wrappedBuffer((byte[])value));
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.buffer, (Object)Unpooled.wrappedBuffer((byte[])value).order(Unpooled.LITTLE_ENDIAN));
        value[0] = (byte)(value[0] + 1);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.buffer.equals((Object)Unpooled.wrappedBuffer((byte[])value)));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.buffer.equals((Object)Unpooled.wrappedBuffer((byte[])value).order(Unpooled.LITTLE_ENDIAN)));
    }

    @Test
    public void testCompareTo() {
        try {
            this.buffer.compareTo(null);
            org.junit.jupiter.api.Assertions.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        byte[] value = new byte[32];
        this.random.nextBytes(value);
        if (value[0] == 0) {
            value[0] = (byte)(value[0] + 1);
        } else if (value[0] == -1) {
            value[0] = (byte)(value[0] - 1);
        }
        this.buffer.setIndex(0, value.length);
        this.buffer.setBytes(0, value);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.buffer.compareTo(Unpooled.wrappedBuffer((byte[])value)));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.buffer.compareTo(Unpooled.wrappedBuffer((byte[])value).order(Unpooled.LITTLE_ENDIAN)));
        value[0] = (byte)(value[0] + 1);
        org.junit.jupiter.api.Assertions.assertTrue((this.buffer.compareTo(Unpooled.wrappedBuffer((byte[])value)) < 0 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((this.buffer.compareTo(Unpooled.wrappedBuffer((byte[])value).order(Unpooled.LITTLE_ENDIAN)) < 0 ? 1 : 0) != 0);
        value[0] = (byte)(value[0] - 2);
        org.junit.jupiter.api.Assertions.assertTrue((this.buffer.compareTo(Unpooled.wrappedBuffer((byte[])value)) > 0 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((this.buffer.compareTo(Unpooled.wrappedBuffer((byte[])value).order(Unpooled.LITTLE_ENDIAN)) > 0 ? 1 : 0) != 0);
        value[0] = (byte)(value[0] + 1);
        org.junit.jupiter.api.Assertions.assertTrue((this.buffer.compareTo(Unpooled.wrappedBuffer((byte[])value, (int)0, (int)31)) > 0 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((this.buffer.compareTo(Unpooled.wrappedBuffer((byte[])value, (int)0, (int)31).order(Unpooled.LITTLE_ENDIAN)) > 0 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((this.buffer.slice(0, 31).compareTo(Unpooled.wrappedBuffer((byte[])value)) < 0 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((this.buffer.slice(0, 31).compareTo(Unpooled.wrappedBuffer((byte[])value).order(Unpooled.LITTLE_ENDIAN)) < 0 ? 1 : 0) != 0);
        ByteBuf retainedSlice = this.buffer.retainedSlice(0, 31);
        org.junit.jupiter.api.Assertions.assertTrue((retainedSlice.compareTo(Unpooled.wrappedBuffer((byte[])value)) < 0 ? 1 : 0) != 0);
        retainedSlice.release();
        retainedSlice = this.buffer.retainedSlice(0, 31);
        org.junit.jupiter.api.Assertions.assertTrue((retainedSlice.compareTo(Unpooled.wrappedBuffer((byte[])value).order(Unpooled.LITTLE_ENDIAN)) < 0 ? 1 : 0) != 0);
        retainedSlice.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompareTo2() {
        byte[] bytes = new byte[]{1, 2, 3, 4};
        byte[] bytesReversed = new byte[]{4, 3, 2, 1};
        ByteBuf buf1 = this.newBuffer(4).clear().writeBytes(bytes).order(ByteOrder.LITTLE_ENDIAN);
        ByteBuf buf2 = this.newBuffer(4).clear().writeBytes(bytesReversed).order(ByteOrder.LITTLE_ENDIAN);
        ByteBuf buf3 = this.newBuffer(4).clear().writeBytes(bytes).order(ByteOrder.BIG_ENDIAN);
        ByteBuf buf4 = this.newBuffer(4).clear().writeBytes(bytesReversed).order(ByteOrder.BIG_ENDIAN);
        try {
            org.junit.jupiter.api.Assertions.assertEquals((int)buf1.compareTo(buf2), (int)buf3.compareTo(buf4));
            org.junit.jupiter.api.Assertions.assertEquals((int)buf2.compareTo(buf1), (int)buf4.compareTo(buf3));
            org.junit.jupiter.api.Assertions.assertEquals((int)buf1.compareTo(buf3), (int)buf2.compareTo(buf4));
            org.junit.jupiter.api.Assertions.assertEquals((int)buf3.compareTo(buf1), (int)buf4.compareTo(buf2));
        }
        finally {
            buf1.release();
            buf2.release();
            buf3.release();
            buf4.release();
        }
    }

    @Test
    public void testToString() {
        ByteBuf copied = Unpooled.copiedBuffer((CharSequence)"Hello, World!", (Charset)CharsetUtil.ISO_8859_1);
        this.buffer.clear();
        this.buffer.writeBytes(copied);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Hello, World!", (Object)this.buffer.toString(CharsetUtil.ISO_8859_1));
        copied.release();
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testToStringMultipleThreads() throws Throwable {
        this.buffer.clear();
        this.buffer.writeBytes("Hello, World!".getBytes(CharsetUtil.ISO_8859_1));
        AbstractByteBufTest.testToStringMultipleThreads0(this.buffer);
    }

    static void testToStringMultipleThreads0(final ByteBuf buffer) throws Throwable {
        final String expected = buffer.toString(CharsetUtil.ISO_8859_1);
        final AtomicInteger counter = new AtomicInteger(30000);
        final AtomicReference errorRef = new AtomicReference();
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (int i = 0; i < 10; ++i) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (errorRef.get() == null && counter.decrementAndGet() > 0) {
                            org.junit.jupiter.api.Assertions.assertEquals((Object)expected, (Object)buffer.toString(CharsetUtil.ISO_8859_1));
                        }
                    }
                    catch (Throwable cause) {
                        errorRef.compareAndSet(null, cause);
                    }
                }
            });
            threads.add(thread);
        }
        for (Thread thread : threads) {
            thread.start();
        }
        for (Thread thread : threads) {
            thread.join();
        }
        Throwable error = (Throwable)errorRef.get();
        if (error != null) {
            throw error;
        }
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testCopyMultipleThreads0() throws Throwable {
        byte[] bytes = new byte[8];
        this.random.nextBytes(bytes);
        this.buffer.clear();
        this.buffer.writeBytes(bytes);
        AbstractByteBufTest.testCopyMultipleThreads0(this.buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void testCopyMultipleThreads0(final ByteBuf buffer) throws Throwable {
        final ByteBuf expected = buffer.copy();
        try {
            final AtomicInteger counter = new AtomicInteger(30000);
            final AtomicReference errorRef = new AtomicReference();
            ArrayList<Thread> threads = new ArrayList<Thread>();
            for (int i = 0; i < 10; ++i) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            while (errorRef.get() == null && counter.decrementAndGet() > 0) {
                                ByteBuf copy = buffer.copy();
                                try {
                                    org.junit.jupiter.api.Assertions.assertEquals((Object)expected, (Object)copy);
                                }
                                finally {
                                    copy.release();
                                }
                            }
                        }
                        catch (Throwable cause) {
                            errorRef.compareAndSet(null, cause);
                        }
                    }
                });
                threads.add(thread);
            }
            for (Thread thread : threads) {
                thread.start();
            }
            for (Thread thread : threads) {
                thread.join();
            }
            Throwable error = (Throwable)errorRef.get();
            if (error != null) {
                throw error;
            }
        }
        finally {
            expected.release();
        }
    }

    @Test
    public void testSWARIndexOf() {
        ByteBuf buffer = this.newBuffer(16);
        buffer.clear();
        buffer.setZero(0, buffer.capacity());
        buffer.writeByte(0);
        buffer.writeByte(0);
        buffer.writeByte(0);
        buffer.writeByte(0);
        buffer.writeByte(0);
        buffer.writeByte(0);
        buffer.writeByte(0);
        buffer.writeByte(0);
        buffer.writeByte(0);
        buffer.writeByte(0);
        buffer.writeByte(0);
        buffer.writeByte(1);
        buffer.writeByte(2);
        buffer.writeByte(3);
        buffer.writeByte(4);
        buffer.writeByte(1);
        org.junit.jupiter.api.Assertions.assertEquals((int)11, (int)buffer.indexOf(0, 12, (byte)1));
        org.junit.jupiter.api.Assertions.assertEquals((int)12, (int)buffer.indexOf(0, 16, (byte)2));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)buffer.indexOf(0, 11, (byte)1));
        org.junit.jupiter.api.Assertions.assertEquals((int)11, (int)buffer.indexOf(0, 16, (byte)1));
        org.junit.jupiter.api.Assertions.assertEquals((int)15, (int)buffer.indexOf(16, 0, (byte)1));
        org.junit.jupiter.api.Assertions.assertEquals((int)12, (int)buffer.indexOf(16, 0, (byte)2));
        org.junit.jupiter.api.Assertions.assertEquals((int)11, (int)buffer.indexOf(15, 0, (byte)1));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)buffer.indexOf(11, 0, (byte)1));
        buffer.release();
    }

    @Test
    public void testUnrolledSWARIndexOf() {
        int i;
        ByteBuf buffer = this.newBuffer(15);
        buffer.clear();
        buffer.setZero(0, buffer.capacity());
        buffer.writeByte(0);
        buffer.writeByte(1);
        buffer.writeByte(2);
        buffer.writeByte(3);
        buffer.writeByte(4);
        buffer.writeByte(5);
        buffer.writeByte(6);
        buffer.writeByte(7);
        buffer.writeByte(8);
        buffer.writeByte(9);
        buffer.writeByte(10);
        buffer.writeByte(11);
        buffer.writeByte(12);
        buffer.writeByte(13);
        buffer.writeByte(14);
        org.junit.jupiter.api.Assertions.assertEquals((int)15, (int)buffer.capacity());
        for (i = 0; i < 14; ++i) {
            org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)buffer.indexOf(i, buffer.capacity(), (byte)i));
        }
        for (i = 0; i < 14; ++i) {
            org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)buffer.indexOf(buffer.capacity(), 0, (byte)i));
        }
        buffer.release();
    }

    @Test
    public void testIndexOf() {
        this.buffer.clear();
        this.buffer.setZero(0, this.buffer.capacity());
        this.buffer.writeByte(1);
        this.buffer.writeByte(2);
        this.buffer.writeByte(3);
        this.buffer.writeByte(2);
        this.buffer.writeByte(1);
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)this.buffer.indexOf(1, 4, (byte)1));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)this.buffer.indexOf(4, 1, (byte)1));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.buffer.indexOf(1, 4, (byte)2));
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)this.buffer.indexOf(4, 1, (byte)2));
        try {
            this.buffer.indexOf(0, this.buffer.capacity() + 1, (byte)0);
            org.junit.jupiter.api.Assertions.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            this.buffer.indexOf(this.buffer.capacity(), -1, (byte)0);
            org.junit.jupiter.api.Assertions.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)this.buffer.indexOf(this.buffer.capacity() + 1, 0, (byte)1));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.buffer.indexOf(-1, this.buffer.capacity(), (byte)1));
    }

    @Test
    public void testIndexOfReleaseBuffer() {
        ByteBuf buffer = this.releasedBuffer();
        if (buffer.capacity() != 0) {
            try {
                buffer.indexOf(0, 1, (byte)1);
                org.junit.jupiter.api.Assertions.fail();
            }
            catch (IllegalReferenceCountException illegalReferenceCountException) {}
        } else {
            org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)buffer.indexOf(0, 1, (byte)1));
        }
    }

    @Test
    public void testNioBuffer1() {
        Assumptions.assumeTrue((this.buffer.nioBufferCount() == 1 ? 1 : 0) != 0);
        byte[] value = new byte[this.buffer.capacity()];
        this.random.nextBytes(value);
        this.buffer.clear();
        this.buffer.writeBytes(value);
        AbstractByteBufTest.assertRemainingEquals(ByteBuffer.wrap(value), this.buffer.nioBuffer());
    }

    @Test
    public void testToByteBuffer2() {
        Assumptions.assumeTrue((this.buffer.nioBufferCount() == 1 ? 1 : 0) != 0);
        byte[] value = new byte[this.buffer.capacity()];
        this.random.nextBytes(value);
        this.buffer.clear();
        this.buffer.writeBytes(value);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            AbstractByteBufTest.assertRemainingEquals(ByteBuffer.wrap(value, i, 128), this.buffer.nioBuffer(i, 128));
        }
    }

    private static void assertRemainingEquals(ByteBuffer expected, ByteBuffer actual) {
        int remaining = expected.remaining();
        int remaining2 = actual.remaining();
        org.junit.jupiter.api.Assertions.assertEquals((int)remaining, (int)remaining2);
        byte[] array1 = new byte[remaining];
        byte[] array2 = new byte[remaining2];
        expected.get(array1);
        actual.get(array2);
        org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])array1, (byte[])array2);
    }

    @Test
    public void testToByteBuffer3() {
        Assumptions.assumeTrue((this.buffer.nioBufferCount() == 1 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.buffer.order(), (Object)this.buffer.nioBuffer().order());
    }

    @Test
    public void testSkipBytes1() {
        this.buffer.setIndex(1024, 2048);
        this.buffer.skipBytes(1024);
        org.junit.jupiter.api.Assertions.assertEquals((int)2048, (int)this.buffer.readerIndex());
        try {
            this.buffer.skipBytes(1025);
            org.junit.jupiter.api.Assertions.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)2048, (int)this.buffer.readerIndex());
    }

    @Test
    public void testHashCode() {
        ByteBuf elemA = Unpooled.buffer((int)15);
        ByteBuf elemB = Unpooled.directBuffer((int)15);
        elemA.writeBytes(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5});
        elemB.writeBytes(new byte[]{6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 9});
        HashSet<ByteBuf> set = new HashSet<ByteBuf>();
        set.add(elemA);
        set.add(elemB);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)set.size());
        ByteBuf elemACopy = elemA.copy();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)set.contains(elemACopy));
        ByteBuf elemBCopy = elemB.copy();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)set.contains(elemBCopy));
        this.buffer.clear();
        this.buffer.writeBytes(elemA.duplicate());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)set.remove(this.buffer));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)set.contains(elemA));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)set.size());
        this.buffer.clear();
        this.buffer.writeBytes(elemB.duplicate());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)set.remove(this.buffer));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)set.contains(elemB));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)set.size());
        elemA.release();
        elemB.release();
        elemACopy.release();
        elemBCopy.release();
    }

    @Test
    public void testDiscardAllReadBytes() {
        this.buffer.writerIndex(this.buffer.capacity());
        this.buffer.readerIndex(this.buffer.writerIndex());
        this.buffer.discardReadBytes();
    }

    @Test
    public void testForEachByte() {
        this.buffer.clear();
        for (int i = 0; i < 4096; ++i) {
            this.buffer.writeByte(i + 1);
        }
        final AtomicInteger lastIndex = new AtomicInteger();
        this.buffer.setIndex(1024, 3072);
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)this.buffer.forEachByte(new ByteProcessor(){
            int i = 1024;

            public boolean process(byte value) throws Exception {
                org.junit.jupiter.api.Assertions.assertEquals((byte)((byte)(this.i + 1)), (byte)value);
                lastIndex.set(this.i);
                ++this.i;
                return true;
            }
        }));
        org.junit.jupiter.api.Assertions.assertEquals((int)3071, (int)lastIndex.get());
    }

    @Test
    public void testForEachByteAbort() {
        this.buffer.clear();
        for (int i = 0; i < 4096; ++i) {
            this.buffer.writeByte(i + 1);
        }
        int stop = 2048;
        org.junit.jupiter.api.Assertions.assertEquals((int)2048, (int)this.buffer.forEachByte(1365, 1365, new ByteProcessor(){
            int i = 1365;

            public boolean process(byte value) throws Exception {
                org.junit.jupiter.api.Assertions.assertEquals((byte)((byte)(this.i + 1)), (byte)value);
                if (this.i == 2048) {
                    return false;
                }
                ++this.i;
                return true;
            }
        }));
    }

    @Test
    public void testForEachByteDesc() {
        this.buffer.clear();
        for (int i = 0; i < 4096; ++i) {
            this.buffer.writeByte(i + 1);
        }
        final AtomicInteger lastIndex = new AtomicInteger();
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)this.buffer.forEachByteDesc(1024, 2048, new ByteProcessor(){
            int i = 3071;

            public boolean process(byte value) throws Exception {
                org.junit.jupiter.api.Assertions.assertEquals((byte)((byte)(this.i + 1)), (byte)value);
                lastIndex.set(this.i);
                --this.i;
                return true;
            }
        }));
        org.junit.jupiter.api.Assertions.assertEquals((int)1024, (int)lastIndex.get());
    }

    @Test
    public void testInternalNioBuffer() {
        this.testInternalNioBuffer(128);
        this.testInternalNioBuffer(1024);
        this.testInternalNioBuffer(4096);
        this.testInternalNioBuffer(65536);
        this.testInternalNioBuffer(0x2000000);
        this.testInternalNioBuffer(0x4000000);
    }

    private void testInternalNioBuffer(int a) {
        ByteBuf buffer = this.newBuffer(2);
        ByteBuffer buf = buffer.internalNioBuffer(buffer.readerIndex(), 1);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)buf.remaining());
        byte[] data = new byte[a];
        ThreadLocalRandom.current().nextBytes(data);
        buffer.writeBytes(data);
        buf = buffer.internalNioBuffer(buffer.readerIndex(), a);
        org.junit.jupiter.api.Assertions.assertEquals((int)a, (int)buf.remaining());
        for (int i = 0; i < a; ++i) {
            org.junit.jupiter.api.Assertions.assertEquals((byte)data[i], (byte)buf.get());
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)buf.hasRemaining());
        buffer.release();
    }

    @Test
    public void testDuplicateReadGatheringByteChannelMultipleThreads() throws Exception {
        byte[] bytes = new byte[8];
        this.random.nextBytes(bytes);
        ByteBuf buffer = this.newBuffer(8);
        buffer.writeBytes(bytes);
        try {
            AbstractByteBufTest.testReadGatheringByteChannelMultipleThreads(buffer, bytes, false);
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testSliceReadGatheringByteChannelMultipleThreads() throws Exception {
        byte[] bytes = new byte[8];
        this.random.nextBytes(bytes);
        ByteBuf buffer = this.newBuffer(8);
        buffer.writeBytes(bytes);
        try {
            AbstractByteBufTest.testReadGatheringByteChannelMultipleThreads(buffer, bytes, true);
        }
        finally {
            buffer.release();
        }
    }

    static void testReadGatheringByteChannelMultipleThreads(final ByteBuf buffer, final byte[] expectedBytes, final boolean slice) throws Exception {
        org.junit.jupiter.api.Assertions.assertEquals((int)buffer.readableBytes(), (int)expectedBytes.length);
        final CountDownLatch latch = new CountDownLatch(60000);
        final CyclicBarrier barrier = new CyclicBarrier(11);
        for (int i = 0; i < 10; ++i) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    while (latch.getCount() > 0L) {
                        ByteBuf buf = slice ? buffer.slice() : buffer.duplicate();
                        TestGatheringByteChannel channel = new TestGatheringByteChannel();
                        while (buf.isReadable()) {
                            try {
                                buf.readBytes((GatheringByteChannel)channel, buf.readableBytes());
                            }
                            catch (IOException e) {
                                return;
                            }
                        }
                        org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])expectedBytes, (byte[])channel.writtenBytes());
                        latch.countDown();
                    }
                    try {
                        barrier.await();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
        }
        latch.await(10L, TimeUnit.SECONDS);
        barrier.await(5L, TimeUnit.SECONDS);
    }

    @Test
    public void testDuplicateReadOutputStreamMultipleThreads() throws Exception {
        byte[] bytes = new byte[8];
        this.random.nextBytes(bytes);
        ByteBuf buffer = this.newBuffer(8);
        buffer.writeBytes(bytes);
        try {
            AbstractByteBufTest.testReadOutputStreamMultipleThreads(buffer, bytes, false);
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testSliceReadOutputStreamMultipleThreads() throws Exception {
        byte[] bytes = new byte[8];
        this.random.nextBytes(bytes);
        ByteBuf buffer = this.newBuffer(8);
        buffer.writeBytes(bytes);
        try {
            AbstractByteBufTest.testReadOutputStreamMultipleThreads(buffer, bytes, true);
        }
        finally {
            buffer.release();
        }
    }

    static void testReadOutputStreamMultipleThreads(final ByteBuf buffer, final byte[] expectedBytes, final boolean slice) throws Exception {
        final CountDownLatch latch = new CountDownLatch(60000);
        final CyclicBarrier barrier = new CyclicBarrier(11);
        for (int i = 0; i < 10; ++i) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    while (latch.getCount() > 0L) {
                        ByteBuf buf = slice ? buffer.slice() : buffer.duplicate();
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        while (buf.isReadable()) {
                            try {
                                buf.readBytes((OutputStream)out, buf.readableBytes());
                            }
                            catch (IOException e) {
                                return;
                            }
                        }
                        org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])expectedBytes, (byte[])out.toByteArray());
                        latch.countDown();
                    }
                    try {
                        barrier.await();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
        }
        latch.await(10L, TimeUnit.SECONDS);
        barrier.await(5L, TimeUnit.SECONDS);
    }

    @Test
    public void testDuplicateBytesInArrayMultipleThreads() throws Exception {
        byte[] bytes = new byte[8];
        this.random.nextBytes(bytes);
        ByteBuf buffer = this.newBuffer(8);
        buffer.writeBytes(bytes);
        try {
            AbstractByteBufTest.testBytesInArrayMultipleThreads(buffer, bytes, false);
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testSliceBytesInArrayMultipleThreads() throws Exception {
        byte[] bytes = new byte[8];
        this.random.nextBytes(bytes);
        ByteBuf buffer = this.newBuffer(8);
        buffer.writeBytes(bytes);
        try {
            AbstractByteBufTest.testBytesInArrayMultipleThreads(buffer, bytes, true);
        }
        finally {
            buffer.release();
        }
    }

    static void testBytesInArrayMultipleThreads(final ByteBuf buffer, final byte[] expectedBytes, final boolean slice) throws Exception {
        final AtomicReference cause = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(60000);
        final CyclicBarrier barrier = new CyclicBarrier(11);
        for (int i = 0; i < 10; ++i) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    while (cause.get() == null && latch.getCount() > 0L) {
                        ByteBuf buf = slice ? buffer.slice() : buffer.duplicate();
                        byte[] array = new byte[8];
                        buf.readBytes(array);
                        org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])expectedBytes, (byte[])array);
                        Arrays.fill(array, (byte)0);
                        buf.getBytes(0, array);
                        org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])expectedBytes, (byte[])array);
                        latch.countDown();
                    }
                    try {
                        barrier.await();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
        }
        latch.await(10L, TimeUnit.SECONDS);
        barrier.await(5L, TimeUnit.SECONDS);
        org.junit.jupiter.api.Assertions.assertNull(cause.get());
    }

    public static Stream<Arguments> setCharSequenceCombinations() {
        Stream.Builder<Arguments> builder = Stream.builder();
        List<Charset> charsets = Arrays.asList(StandardCharsets.UTF_8, StandardCharsets.US_ASCII, StandardCharsets.ISO_8859_1);
        for (Charset charset : charsets) {
            for (CharSequenceType charSequenceType : CharSequenceType.values()) {
                builder.add(Arguments.of((Object[])new Object[]{charset, charSequenceType}));
            }
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"setCharSequenceCombinations"})
    void testSetCharSequenceMultipleThreads(Charset charset, CharSequenceType charSeqType) throws Exception {
        int bufSize = 32;
        ByteBuf[] bufs = new ByteBuf[16];
        for (int i = 0; i < bufs.length; ++i) {
            bufs[i] = this.newBuffer(bufSize);
        }
        int iterations = 256;
        Semaphore start = new Semaphore(0);
        Semaphore finish = new Semaphore(0);
        char[] cs = new char[(int)((float)bufSize / charset.newEncoder().maxBytesPerChar())];
        Arrays.fill(cs, 'a');
        CharSequence str = charSeqType.create(cs);
        ExecutorService executor = Executors.newFixedThreadPool(bufs.length);
        try {
            Future[] futures = new Future[bufs.length];
            for (int i = 0; i < bufs.length; ++i) {
                ByteBuf buf = bufs[i];
                futures[i] = executor.submit(() -> {
                    finish.release();
                    start.acquire();
                    for (int j = 0; j < iterations; ++j) {
                        buf.setCharSequence(0, str, charset);
                    }
                    return null;
                });
            }
            finish.acquire(bufs.length);
            start.release(bufs.length);
            ExecutionException e = null;
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (InterruptedException ex) {
                    if (e != null) {
                        ex.addSuppressed(e);
                    }
                    throw ex;
                }
                catch (ExecutionException ex) {
                    if (e != null) {
                        e = ex;
                        continue;
                    }
                    e.addSuppressed(ex);
                }
            }
            if (e != null) {
                org.junit.jupiter.api.Assertions.fail((String)"Worker threads failed", e);
            }
        }
        finally {
            executor.shutdown();
            for (ByteBuf buf : bufs) {
                buf.release();
            }
        }
    }

    @Test
    public void readByteThrowsIndexOutOfBoundsException() {
        final ByteBuf buffer = this.newBuffer(8);
        try {
            org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

                public void execute() {
                    buffer.writeByte(0);
                    org.junit.jupiter.api.Assertions.assertEquals((byte)0, (byte)buffer.readByte());
                    buffer.readByte();
                }
            });
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testNioBufferExposeOnlyRegion() {
        ByteBuf buffer = this.newBuffer(8);
        byte[] data = new byte[8];
        this.random.nextBytes(data);
        buffer.writeBytes(data);
        ByteBuffer nioBuf = buffer.nioBuffer(1, data.length - 2);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)nioBuf.position());
        org.junit.jupiter.api.Assertions.assertEquals((int)6, (int)nioBuf.remaining());
        int i = 1;
        while (nioBuf.hasRemaining()) {
            org.junit.jupiter.api.Assertions.assertEquals((byte)data[i], (byte)nioBuf.get());
            ++i;
        }
        buffer.release();
    }

    @Test
    public void ensureWritableWithForceDoesNotThrow() {
        this.ensureWritableDoesNotThrow(true);
    }

    @Test
    public void ensureWritableWithOutForceDoesNotThrow() {
        this.ensureWritableDoesNotThrow(false);
    }

    private void ensureWritableDoesNotThrow(boolean force) {
        ByteBuf buffer = this.newBuffer(8);
        buffer.writerIndex(buffer.capacity());
        buffer.ensureWritable(8, force);
        buffer.release();
    }

    @Test
    public void ensureWritableWithForceAsReadyOnly() {
        this.ensureWritableReadOnly(true);
    }

    @Test
    public void ensureWritableWithOutForceAsReadOnly() {
        this.ensureWritableReadOnly(false);
    }

    private void ensureWritableReadOnly(boolean force) {
        ByteBuf buffer = this.newBuffer(8);
        buffer.writerIndex(buffer.capacity());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)buffer.asReadOnly().ensureWritable(8, force));
        buffer.release();
    }

    @Test
    public void testLittleEndianWithExpand() {
        ByteBuf buffer = this.newBuffer(0).order(Unpooled.LITTLE_ENDIAN);
        buffer.writeInt(305419896);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"78563412", (Object)ByteBufUtil.hexDump((ByteBuf)buffer));
        buffer.release();
    }

    private ByteBuf releasedBuffer() {
        ByteBuf buffer = this.newBuffer(8);
        buffer.clear();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)buffer.release());
        return buffer;
    }

    @Test
    public void testDiscardReadBytesAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().discardReadBytes();
            }
        });
    }

    @Test
    public void testDiscardSomeReadBytesAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().discardSomeReadBytes();
            }
        });
    }

    @Test
    public void testEnsureWritableAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().ensureWritable(16);
            }
        });
    }

    @Test
    public void testGetBooleanAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().getBoolean(0);
            }
        });
    }

    @Test
    public void testGetByteAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().getByte(0);
            }
        });
    }

    @Test
    public void testGetUnsignedByteAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().getUnsignedByte(0);
            }
        });
    }

    @Test
    public void testGetShortAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().getShort(0);
            }
        });
    }

    @Test
    public void testGetShortLEAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().getShortLE(0);
            }
        });
    }

    @Test
    public void testGetUnsignedShortAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().getUnsignedShort(0);
            }
        });
    }

    @Test
    public void testGetUnsignedShortLEAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().getUnsignedShortLE(0);
            }
        });
    }

    @Test
    public void testGetMediumAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().getMedium(0);
            }
        });
    }

    @Test
    public void testGetMediumLEAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().getMediumLE(0);
            }
        });
    }

    @Test
    public void testGetUnsignedMediumAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().getUnsignedMedium(0);
            }
        });
    }

    @Test
    public void testGetIntAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().getInt(0);
            }
        });
    }

    @Test
    public void testGetIntLEAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().getIntLE(0);
            }
        });
    }

    @Test
    public void testGetUnsignedIntAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().getUnsignedInt(0);
            }
        });
    }

    @Test
    public void testGetUnsignedIntLEAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().getUnsignedIntLE(0);
            }
        });
    }

    @Test
    public void testGetLongAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().getLong(0);
            }
        });
    }

    @Test
    public void testGetLongLEAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().getLongLE(0);
            }
        });
    }

    @Test
    public void testGetCharAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().getChar(0);
            }
        });
    }

    @Test
    public void testGetFloatAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().getFloat(0);
            }
        });
    }

    @Test
    public void testGetFloatLEAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().getFloatLE(0);
            }
        });
    }

    @Test
    public void testGetDoubleAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().getDouble(0);
            }
        });
    }

    @Test
    public void testGetDoubleLEAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().getDoubleLE(0);
            }
        });
    }

    @Test
    public void testGetBytesAfterRelease() {
        final ByteBuf buffer = Unpooled.buffer((int)8);
        try {
            org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

                public void execute() {
                    AbstractByteBufTest.this.releasedBuffer().getBytes(0, buffer);
                }
            });
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testGetBytesAfterRelease2() {
        final ByteBuf buffer = Unpooled.buffer();
        try {
            org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

                public void execute() {
                    AbstractByteBufTest.this.releasedBuffer().getBytes(0, buffer, 1);
                }
            });
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testGetBytesAfterRelease3() {
        final ByteBuf buffer = Unpooled.buffer();
        try {
            org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

                public void execute() {
                    AbstractByteBufTest.this.releasedBuffer().getBytes(0, buffer, 0, 1);
                }
            });
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testGetBytesAfterRelease4() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().getBytes(0, new byte[8]);
            }
        });
    }

    @Test
    public void testGetBytesAfterRelease5() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().getBytes(0, new byte[8], 0, 1);
            }
        });
    }

    @Test
    public void testGetBytesAfterRelease6() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().getBytes(0, ByteBuffer.allocate(8));
            }
        });
    }

    @Test
    public void testGetBytesAfterRelease7() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() throws IOException {
                AbstractByteBufTest.this.releasedBuffer().getBytes(0, (OutputStream)new ByteArrayOutputStream(), 1);
            }
        });
    }

    @Test
    public void testGetBytesAfterRelease8() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() throws IOException {
                AbstractByteBufTest.this.releasedBuffer().getBytes(0, (GatheringByteChannel)new DevNullGatheringByteChannel(), 1);
            }
        });
    }

    @Test
    public void testSetBooleanAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().setBoolean(0, true);
            }
        });
    }

    @Test
    public void testSetByteAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().setByte(0, 1);
            }
        });
    }

    @Test
    public void testSetShortAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().setShort(0, 1);
            }
        });
    }

    @Test
    public void testSetShortLEAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().setShortLE(0, 1);
            }
        });
    }

    @Test
    public void testSetMediumAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().setMedium(0, 1);
            }
        });
    }

    @Test
    public void testSetMediumLEAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().setMediumLE(0, 1);
            }
        });
    }

    @Test
    public void testSetIntAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().setInt(0, 1);
            }
        });
    }

    @Test
    public void testSetIntLEAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().setIntLE(0, 1);
            }
        });
    }

    @Test
    public void testSetLongAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().setLong(0, 1L);
            }
        });
    }

    @Test
    public void testSetLongLEAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().setLongLE(0, 1L);
            }
        });
    }

    @Test
    public void testSetCharAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().setChar(0, 1);
            }
        });
    }

    @Test
    public void testSetFloatAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().setFloat(0, 1.0f);
            }
        });
    }

    @Test
    public void testSetDoubleAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().setDouble(0, 1.0);
            }
        });
    }

    @Test
    public void testSetBytesAfterRelease() {
        final ByteBuf buffer = Unpooled.buffer();
        try {
            org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

                public void execute() {
                    AbstractByteBufTest.this.releasedBuffer().setBytes(0, buffer);
                }
            });
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testSetBytesAfterRelease2() {
        final ByteBuf buffer = Unpooled.buffer();
        try {
            org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

                public void execute() {
                    AbstractByteBufTest.this.releasedBuffer().setBytes(0, buffer, 1);
                }
            });
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testSetBytesAfterRelease3() {
        final ByteBuf buffer = Unpooled.buffer();
        try {
            org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

                public void execute() {
                    AbstractByteBufTest.this.releasedBuffer().setBytes(0, buffer, 0, 1);
                }
            });
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testSetUsAsciiCharSequenceAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.testSetCharSequenceAfterRelease0(CharsetUtil.US_ASCII);
            }
        });
    }

    @Test
    public void testSetIso88591CharSequenceAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.testSetCharSequenceAfterRelease0(CharsetUtil.ISO_8859_1);
            }
        });
    }

    @Test
    public void testSetUtf8CharSequenceAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.testSetCharSequenceAfterRelease0(CharsetUtil.UTF_8);
            }
        });
    }

    @Test
    public void testSetUtf16CharSequenceAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.testSetCharSequenceAfterRelease0(CharsetUtil.UTF_16);
            }
        });
    }

    private void testSetCharSequenceAfterRelease0(Charset charset) {
        this.releasedBuffer().setCharSequence(0, (CharSequence)"x", charset);
    }

    @Test
    public void testSetBytesAfterRelease4() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().setBytes(0, new byte[8]);
            }
        });
    }

    @Test
    public void testSetBytesAfterRelease5() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().setBytes(0, new byte[8], 0, 1);
            }
        });
    }

    @Test
    public void testSetBytesAfterRelease6() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().setBytes(0, ByteBuffer.allocate(8));
            }
        });
    }

    @Test
    public void testSetBytesAfterRelease7() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() throws IOException {
                AbstractByteBufTest.this.releasedBuffer().setBytes(0, (InputStream)new ByteArrayInputStream(new byte[8]), 1);
            }
        });
    }

    @Test
    public void testSetBytesAfterRelease8() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() throws IOException {
                AbstractByteBufTest.this.releasedBuffer().setBytes(0, (ScatteringByteChannel)new TestScatteringByteChannel(), 1);
            }
        });
    }

    @Test
    public void testSetZeroAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().setZero(0, 1);
            }
        });
    }

    @Test
    public void testReadBooleanAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().readBoolean();
            }
        });
    }

    @Test
    public void testReadByteAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().readByte();
            }
        });
    }

    @Test
    public void testReadUnsignedByteAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().readUnsignedByte();
            }
        });
    }

    @Test
    public void testReadShortAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().readShort();
            }
        });
    }

    @Test
    public void testReadShortLEAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().readShortLE();
            }
        });
    }

    @Test
    public void testReadUnsignedShortAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().readUnsignedShort();
            }
        });
    }

    @Test
    public void testReadUnsignedShortLEAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().readUnsignedShortLE();
            }
        });
    }

    @Test
    public void testReadMediumAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().readMedium();
            }
        });
    }

    @Test
    public void testReadMediumLEAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().readMediumLE();
            }
        });
    }

    @Test
    public void testReadUnsignedMediumAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().readUnsignedMedium();
            }
        });
    }

    @Test
    public void testReadUnsignedMediumLEAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().readUnsignedMediumLE();
            }
        });
    }

    @Test
    public void testReadIntAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().readInt();
            }
        });
    }

    @Test
    public void testReadIntLEAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().readIntLE();
            }
        });
    }

    @Test
    public void testReadUnsignedIntAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().readUnsignedInt();
            }
        });
    }

    @Test
    public void testReadUnsignedIntLEAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().readUnsignedIntLE();
            }
        });
    }

    @Test
    public void testReadLongAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().readLong();
            }
        });
    }

    @Test
    public void testReadLongLEAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().readLongLE();
            }
        });
    }

    @Test
    public void testReadCharAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().readChar();
            }
        });
    }

    @Test
    public void testReadFloatAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().readFloat();
            }
        });
    }

    @Test
    public void testReadFloatLEAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().readFloatLE();
            }
        });
    }

    @Test
    public void testReadDoubleAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().readDouble();
            }
        });
    }

    @Test
    public void testReadDoubleLEAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().readDoubleLE();
            }
        });
    }

    @Test
    public void testReadBytesAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().readBytes(1);
            }
        });
    }

    @Test
    public void testReadBytesAfterRelease2() {
        final ByteBuf buffer = Unpooled.buffer((int)8);
        try {
            org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

                public void execute() {
                    AbstractByteBufTest.this.releasedBuffer().readBytes(buffer);
                }
            });
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testReadBytesAfterRelease3() {
        final ByteBuf buffer = Unpooled.buffer((int)8);
        try {
            org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

                public void execute() {
                    AbstractByteBufTest.this.releasedBuffer().readBytes(buffer);
                }
            });
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testReadBytesAfterRelease4() {
        final ByteBuf buffer = Unpooled.buffer((int)8);
        try {
            org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

                public void execute() {
                    AbstractByteBufTest.this.releasedBuffer().readBytes(buffer, 0, 1);
                }
            });
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testReadBytesAfterRelease5() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().readBytes(new byte[8]);
            }
        });
    }

    @Test
    public void testReadBytesAfterRelease6() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().readBytes(new byte[8], 0, 1);
            }
        });
    }

    @Test
    public void testReadBytesAfterRelease7() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().readBytes(ByteBuffer.allocate(8));
            }
        });
    }

    @Test
    public void testReadBytesAfterRelease8() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() throws IOException {
                AbstractByteBufTest.this.releasedBuffer().readBytes((OutputStream)new ByteArrayOutputStream(), 1);
            }
        });
    }

    @Test
    public void testReadBytesAfterRelease9() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() throws IOException {
                AbstractByteBufTest.this.releasedBuffer().readBytes((OutputStream)new ByteArrayOutputStream(), 1);
            }
        });
    }

    @Test
    public void testReadBytesAfterRelease10() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() throws IOException {
                AbstractByteBufTest.this.releasedBuffer().readBytes((GatheringByteChannel)new DevNullGatheringByteChannel(), 1);
            }
        });
    }

    @Test
    public void testWriteBooleanAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().writeBoolean(true);
            }
        });
    }

    @Test
    public void testWriteByteAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().writeByte(1);
            }
        });
    }

    @Test
    public void testWriteShortAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().writeShort(1);
            }
        });
    }

    @Test
    public void testWriteShortLEAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().writeShortLE(1);
            }
        });
    }

    @Test
    public void testWriteMediumAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().writeMedium(1);
            }
        });
    }

    @Test
    public void testWriteMediumLEAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().writeMediumLE(1);
            }
        });
    }

    @Test
    public void testWriteIntAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().writeInt(1);
            }
        });
    }

    @Test
    public void testWriteIntLEAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().writeIntLE(1);
            }
        });
    }

    @Test
    public void testWriteLongAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().writeLong(1L);
            }
        });
    }

    @Test
    public void testWriteLongLEAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().writeLongLE(1L);
            }
        });
    }

    @Test
    public void testWriteCharAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().writeChar(1);
            }
        });
    }

    @Test
    public void testWriteFloatAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().writeFloat(1.0f);
            }
        });
    }

    @Test
    public void testWriteFloatLEAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().writeFloatLE(1.0f);
            }
        });
    }

    @Test
    public void testWriteDoubleAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().writeDouble(1.0);
            }
        });
    }

    @Test
    public void testWriteDoubleLEAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().writeDoubleLE(1.0);
            }
        });
    }

    @Test
    public void testWriteBytesAfterRelease() {
        final ByteBuf buffer = Unpooled.buffer((int)8);
        try {
            org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

                public void execute() {
                    AbstractByteBufTest.this.releasedBuffer().writeBytes(buffer);
                }
            });
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testWriteBytesAfterRelease2() {
        final ByteBuf buffer = Unpooled.copiedBuffer((byte[])new byte[8]);
        try {
            org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

                public void execute() {
                    AbstractByteBufTest.this.releasedBuffer().writeBytes(buffer, 1);
                }
            });
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testWriteBytesAfterRelease3() {
        final ByteBuf buffer = Unpooled.buffer((int)8);
        try {
            org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

                public void execute() {
                    AbstractByteBufTest.this.releasedBuffer().writeBytes(buffer, 0, 1);
                }
            });
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testWriteBytesAfterRelease4() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().writeBytes(new byte[8]);
            }
        });
    }

    @Test
    public void testWriteBytesAfterRelease5() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().writeBytes(new byte[8], 0, 1);
            }
        });
    }

    @Test
    public void testWriteBytesAfterRelease6() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().writeBytes(ByteBuffer.allocate(8));
            }
        });
    }

    @Test
    public void testWriteBytesAfterRelease7() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() throws IOException {
                AbstractByteBufTest.this.releasedBuffer().writeBytes((InputStream)new ByteArrayInputStream(new byte[8]), 1);
            }
        });
    }

    @Test
    public void testWriteBytesAfterRelease8() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() throws IOException {
                AbstractByteBufTest.this.releasedBuffer().writeBytes((ScatteringByteChannel)new TestScatteringByteChannel(), 1);
            }
        });
    }

    @Test
    public void testWriteZeroAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().writeZero(1);
            }
        });
    }

    @Test
    public void testWriteUsAsciiCharSequenceAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.testWriteCharSequenceAfterRelease0(CharsetUtil.US_ASCII);
            }
        });
    }

    @Test
    public void testWriteIso88591CharSequenceAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.testWriteCharSequenceAfterRelease0(CharsetUtil.ISO_8859_1);
            }
        });
    }

    @Test
    public void testWriteUtf8CharSequenceAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.testWriteCharSequenceAfterRelease0(CharsetUtil.UTF_8);
            }
        });
    }

    @Test
    public void testWriteUtf16CharSequenceAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.testWriteCharSequenceAfterRelease0(CharsetUtil.UTF_16);
            }
        });
    }

    private void testWriteCharSequenceAfterRelease0(Charset charset) {
        this.releasedBuffer().writeCharSequence((CharSequence)"x", charset);
    }

    @Test
    public void testForEachByteAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().forEachByte((ByteProcessor)new TestByteProcessor());
            }
        });
    }

    @Test
    public void testForEachByteAfterRelease1() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().forEachByte(0, 1, (ByteProcessor)new TestByteProcessor());
            }
        });
    }

    @Test
    public void testForEachByteDescAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().forEachByteDesc((ByteProcessor)new TestByteProcessor());
            }
        });
    }

    @Test
    public void testForEachByteDescAfterRelease1() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().forEachByteDesc(0, 1, (ByteProcessor)new TestByteProcessor());
            }
        });
    }

    @Test
    public void testCopyAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().copy();
            }
        });
    }

    @Test
    public void testCopyAfterRelease1() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().copy();
            }
        });
    }

    @Test
    public void testNioBufferAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().nioBuffer();
            }
        });
    }

    @Test
    public void testNioBufferAfterRelease1() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().nioBuffer(0, 1);
            }
        });
    }

    @Test
    public void testInternalNioBufferAfterRelease() {
        this.testInternalNioBufferAfterRelease0(IllegalReferenceCountException.class);
    }

    protected void testInternalNioBufferAfterRelease0(Class<? extends Throwable> expectedException) {
        final ByteBuf releasedBuffer = this.releasedBuffer();
        org.junit.jupiter.api.Assertions.assertThrows(expectedException, (Executable)new Executable(){

            public void execute() {
                releasedBuffer.internalNioBuffer(releasedBuffer.readerIndex(), 1);
            }
        });
    }

    @Test
    public void testNioBuffersAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().nioBuffers();
            }
        });
    }

    @Test
    public void testNioBuffersAfterRelease2() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().nioBuffers(0, 1);
            }
        });
    }

    @Test
    public void testArrayAfterRelease() {
        ByteBuf buf = this.releasedBuffer();
        if (buf.hasArray()) {
            try {
                buf.array();
                org.junit.jupiter.api.Assertions.fail();
            }
            catch (IllegalReferenceCountException illegalReferenceCountException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testMemoryAddressAfterRelease() {
        ByteBuf buf = this.releasedBuffer();
        if (buf.hasMemoryAddress()) {
            try {
                buf.memoryAddress();
                org.junit.jupiter.api.Assertions.fail();
            }
            catch (IllegalReferenceCountException illegalReferenceCountException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testSliceAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().slice();
            }
        });
    }

    @Test
    public void testSliceAfterRelease2() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().slice(0, 1);
            }
        });
    }

    private static void assertSliceFailAfterRelease(ByteBuf ... bufs) {
        for (ByteBuf buf : bufs) {
            if (buf.refCnt() <= 0) continue;
            buf.release();
        }
        for (ByteBuf buf : bufs) {
            try {
                org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)buf.refCnt());
                buf.slice();
                org.junit.jupiter.api.Assertions.fail();
            }
            catch (IllegalReferenceCountException illegalReferenceCountException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testSliceAfterReleaseRetainedSlice() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.retainedSlice(0, 1);
        AbstractByteBufTest.assertSliceFailAfterRelease(buf, buf2);
    }

    @Test
    public void testSliceAfterReleaseRetainedSliceDuplicate() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.retainedSlice(0, 1);
        ByteBuf buf3 = buf2.duplicate();
        AbstractByteBufTest.assertSliceFailAfterRelease(buf, buf2, buf3);
    }

    @Test
    public void testSliceAfterReleaseRetainedSliceRetainedDuplicate() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.retainedSlice(0, 1);
        ByteBuf buf3 = buf2.retainedDuplicate();
        AbstractByteBufTest.assertSliceFailAfterRelease(buf, buf2, buf3);
    }

    @Test
    public void testSliceAfterReleaseRetainedDuplicate() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.retainedDuplicate();
        AbstractByteBufTest.assertSliceFailAfterRelease(buf, buf2);
    }

    @Test
    public void testSliceAfterReleaseRetainedDuplicateSlice() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.retainedDuplicate();
        ByteBuf buf3 = buf2.slice(0, 1);
        AbstractByteBufTest.assertSliceFailAfterRelease(buf, buf2, buf3);
    }

    @Test
    public void testRetainedSliceAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().retainedSlice();
            }
        });
    }

    @Test
    public void testRetainedSliceAfterRelease2() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().retainedSlice(0, 1);
            }
        });
    }

    private static void assertRetainedSliceFailAfterRelease(ByteBuf ... bufs) {
        for (ByteBuf buf : bufs) {
            if (buf.refCnt() <= 0) continue;
            buf.release();
        }
        for (ByteBuf buf : bufs) {
            try {
                org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)buf.refCnt());
                buf.retainedSlice();
                org.junit.jupiter.api.Assertions.fail();
            }
            catch (IllegalReferenceCountException illegalReferenceCountException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testRetainedSliceAfterReleaseRetainedSlice() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.retainedSlice(0, 1);
        AbstractByteBufTest.assertRetainedSliceFailAfterRelease(buf, buf2);
    }

    @Test
    public void testRetainedSliceAfterReleaseRetainedSliceDuplicate() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.retainedSlice(0, 1);
        ByteBuf buf3 = buf2.duplicate();
        AbstractByteBufTest.assertRetainedSliceFailAfterRelease(buf, buf2, buf3);
    }

    @Test
    public void testRetainedSliceAfterReleaseRetainedSliceRetainedDuplicate() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.retainedSlice(0, 1);
        ByteBuf buf3 = buf2.retainedDuplicate();
        AbstractByteBufTest.assertRetainedSliceFailAfterRelease(buf, buf2, buf3);
    }

    @Test
    public void testRetainedSliceAfterReleaseRetainedDuplicate() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.retainedDuplicate();
        AbstractByteBufTest.assertRetainedSliceFailAfterRelease(buf, buf2);
    }

    @Test
    public void testRetainedSliceAfterReleaseRetainedDuplicateSlice() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.retainedDuplicate();
        ByteBuf buf3 = buf2.slice(0, 1);
        AbstractByteBufTest.assertRetainedSliceFailAfterRelease(buf, buf2, buf3);
    }

    @Test
    public void testDuplicateAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().duplicate();
            }
        });
    }

    @Test
    public void testRetainedDuplicateAfterRelease() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.releasedBuffer().retainedDuplicate();
            }
        });
    }

    private static void assertDuplicateFailAfterRelease(ByteBuf ... bufs) {
        for (ByteBuf buf : bufs) {
            if (buf.refCnt() <= 0) continue;
            buf.release();
        }
        for (ByteBuf buf : bufs) {
            try {
                org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)buf.refCnt());
                buf.duplicate();
                org.junit.jupiter.api.Assertions.fail();
            }
            catch (IllegalReferenceCountException illegalReferenceCountException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testDuplicateAfterReleaseRetainedSliceDuplicate() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.retainedSlice(0, 1);
        ByteBuf buf3 = buf2.duplicate();
        AbstractByteBufTest.assertDuplicateFailAfterRelease(buf, buf2, buf3);
    }

    @Test
    public void testDuplicateAfterReleaseRetainedDuplicate() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.retainedDuplicate();
        AbstractByteBufTest.assertDuplicateFailAfterRelease(buf, buf2);
    }

    @Test
    public void testDuplicateAfterReleaseRetainedDuplicateSlice() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.retainedDuplicate();
        ByteBuf buf3 = buf2.slice(0, 1);
        AbstractByteBufTest.assertDuplicateFailAfterRelease(buf, buf2, buf3);
    }

    private static void assertRetainedDuplicateFailAfterRelease(ByteBuf ... bufs) {
        for (ByteBuf buf : bufs) {
            if (buf.refCnt() <= 0) continue;
            buf.release();
        }
        for (ByteBuf buf : bufs) {
            try {
                org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)buf.refCnt());
                buf.retainedDuplicate();
                org.junit.jupiter.api.Assertions.fail();
            }
            catch (IllegalReferenceCountException illegalReferenceCountException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testRetainedDuplicateAfterReleaseRetainedDuplicate() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.retainedDuplicate();
        AbstractByteBufTest.assertRetainedDuplicateFailAfterRelease(buf, buf2);
    }

    @Test
    public void testRetainedDuplicateAfterReleaseDuplicate() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.duplicate();
        AbstractByteBufTest.assertRetainedDuplicateFailAfterRelease(buf, buf2);
    }

    @Test
    public void testRetainedDuplicateAfterReleaseRetainedSlice() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.retainedSlice(0, 1);
        AbstractByteBufTest.assertRetainedDuplicateFailAfterRelease(buf, buf2);
    }

    @Test
    public void testSliceRelease() {
        ByteBuf buf = this.newBuffer(8);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)buf.refCnt());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)buf.slice().release());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)buf.refCnt());
    }

    @Test
    public void testReadSliceOutOfBounds() {
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.testReadSliceOutOfBounds(false);
            }
        });
    }

    @Test
    public void testReadRetainedSliceOutOfBounds() {
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.testReadSliceOutOfBounds(true);
            }
        });
    }

    private void testReadSliceOutOfBounds(boolean retainedSlice) {
        ByteBuf buf = this.newBuffer(100);
        try {
            buf.writeZero(50);
            if (retainedSlice) {
                buf.readRetainedSlice(51);
            } else {
                buf.readSlice(51);
            }
            org.junit.jupiter.api.Assertions.fail();
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void testWriteUsAsciiCharSequenceExpand() {
        this.testWriteCharSequenceExpand(CharsetUtil.US_ASCII);
    }

    @Test
    public void testWriteUtf8CharSequenceExpand() {
        this.testWriteCharSequenceExpand(CharsetUtil.UTF_8);
    }

    @Test
    public void testWriteIso88591CharSequenceExpand() {
        this.testWriteCharSequenceExpand(CharsetUtil.ISO_8859_1);
    }

    @Test
    public void testWriteUtf16CharSequenceExpand() {
        this.testWriteCharSequenceExpand(CharsetUtil.UTF_16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testWriteCharSequenceExpand(Charset charset) {
        ByteBuf buf = this.newBuffer(1);
        try {
            int writerIndex = buf.capacity() - 1;
            buf.writerIndex(writerIndex);
            int written = buf.writeCharSequence((CharSequence)"AB", charset);
            org.junit.jupiter.api.Assertions.assertEquals((int)writerIndex, (int)(buf.writerIndex() - written));
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void testSetUsAsciiCharSequenceNoExpand() {
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.testSetCharSequenceNoExpand(CharsetUtil.US_ASCII);
            }
        });
    }

    @Test
    public void testSetUtf8CharSequenceNoExpand() {
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.testSetCharSequenceNoExpand(CharsetUtil.UTF_8);
            }
        });
    }

    @Test
    public void testSetIso88591CharSequenceNoExpand() {
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.testSetCharSequenceNoExpand(CharsetUtil.ISO_8859_1);
            }
        });
    }

    @Test
    public void testSetUtf16CharSequenceNoExpand() {
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.testSetCharSequenceNoExpand(CharsetUtil.UTF_16);
            }
        });
    }

    private void testSetCharSequenceNoExpand(Charset charset) {
        ByteBuf buf = this.newBuffer(1);
        try {
            buf.setCharSequence(0, (CharSequence)"AB", charset);
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void testSetUsAsciiCharSequence() {
        this.testSetGetCharSequence(CharsetUtil.US_ASCII);
    }

    @Test
    public void testSetUtf8CharSequence() {
        this.testSetGetCharSequence(CharsetUtil.UTF_8);
    }

    @Test
    public void testSetIso88591CharSequence() {
        this.testSetGetCharSequence(CharsetUtil.ISO_8859_1);
    }

    @Test
    public void testSetUtf16CharSequence() {
        this.testSetGetCharSequence(CharsetUtil.UTF_16);
    }

    private void testSetGetCharSequence(Charset charset) {
        ByteBuf buf = this.newBuffer(1024);
        CharBuffer sequence = CharsetUtil.US_ASCII.equals(charset) ? ASCII_CHARS : EXTENDED_ASCII_CHARS;
        int bytes = buf.setCharSequence(1, (CharSequence)sequence, charset);
        org.junit.jupiter.api.Assertions.assertEquals((Object)sequence, (Object)CharBuffer.wrap(buf.getCharSequence(1, bytes, charset)));
        buf.release();
    }

    @Test
    public void testWriteReadUsAsciiCharSequence() {
        this.testWriteReadCharSequence(CharsetUtil.US_ASCII);
    }

    @Test
    public void testWriteReadUtf8CharSequence() {
        this.testWriteReadCharSequence(CharsetUtil.UTF_8);
    }

    @Test
    public void testWriteReadIso88591CharSequence() {
        this.testWriteReadCharSequence(CharsetUtil.ISO_8859_1);
    }

    @Test
    public void testWriteReadUtf16CharSequence() {
        this.testWriteReadCharSequence(CharsetUtil.UTF_16);
    }

    private void testWriteReadCharSequence(Charset charset) {
        ByteBuf buf = this.newBuffer(1024);
        CharBuffer sequence = CharsetUtil.US_ASCII.equals(charset) ? ASCII_CHARS : EXTENDED_ASCII_CHARS;
        buf.writerIndex(1);
        int bytes = buf.writeCharSequence((CharSequence)sequence, charset);
        buf.readerIndex(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)sequence, (Object)CharBuffer.wrap(buf.readCharSequence(bytes, charset)));
        buf.release();
    }

    @Test
    public void testWriteReadUsAsciiString() {
        this.testWriteReadString(CharsetUtil.US_ASCII);
    }

    @Test
    public void testWriteReadUtf8String() {
        this.testWriteReadString(CharsetUtil.UTF_8);
    }

    @Test
    public void testWriteReadIso88591String() {
        this.testWriteReadString(CharsetUtil.ISO_8859_1);
    }

    @Test
    public void testWriteReadUtf16String() {
        this.testWriteReadString(CharsetUtil.UTF_16);
    }

    private void testWriteReadString(Charset charset) {
        ByteBuf buf = this.newBuffer(1024);
        CharBuffer sequence = CharsetUtil.US_ASCII.equals(charset) ? ASCII_CHARS : EXTENDED_ASCII_CHARS;
        buf.writerIndex(1);
        int bytes = buf.writeCharSequence((CharSequence)sequence, charset);
        buf.readerIndex(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)sequence, (Object)CharBuffer.wrap(buf.readString(bytes, charset)));
        buf.release();
    }

    @Test
    public void testRetainedSliceIndexOutOfBounds() {
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.testSliceOutOfBounds(true, true, true);
            }
        });
    }

    @Test
    public void testRetainedSliceLengthOutOfBounds() {
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.testSliceOutOfBounds(true, true, false);
            }
        });
    }

    @Test
    public void testMixedSliceAIndexOutOfBounds() {
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.testSliceOutOfBounds(true, false, true);
            }
        });
    }

    @Test
    public void testMixedSliceALengthOutOfBounds() {
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.testSliceOutOfBounds(true, false, false);
            }
        });
    }

    @Test
    public void testMixedSliceBIndexOutOfBounds() {
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.testSliceOutOfBounds(false, true, true);
            }
        });
    }

    @Test
    public void testMixedSliceBLengthOutOfBounds() {
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.testSliceOutOfBounds(false, true, false);
            }
        });
    }

    @Test
    public void testSliceIndexOutOfBounds() {
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.testSliceOutOfBounds(false, false, true);
            }
        });
    }

    @Test
    public void testSliceLengthOutOfBounds() {
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.testSliceOutOfBounds(false, false, false);
            }
        });
    }

    @Test
    public void testRetainedSliceAndRetainedDuplicateContentIsExpected() {
        ByteBuf buf = this.newBuffer(8).resetWriterIndex();
        ByteBuf expected1 = this.newBuffer(6).resetWriterIndex();
        ByteBuf expected2 = this.newBuffer(5).resetWriterIndex();
        ByteBuf expected3 = this.newBuffer(4).resetWriterIndex();
        ByteBuf expected4 = this.newBuffer(3).resetWriterIndex();
        buf.writeBytes(new byte[]{1, 2, 3, 4, 5, 6, 7, 8});
        expected1.writeBytes(new byte[]{2, 3, 4, 5, 6, 7});
        expected2.writeBytes(new byte[]{3, 4, 5, 6, 7});
        expected3.writeBytes(new byte[]{4, 5, 6, 7});
        expected4.writeBytes(new byte[]{5, 6, 7});
        ByteBuf slice1 = buf.retainedSlice(buf.readerIndex() + 1, 6);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)slice1.compareTo(expected1));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)slice1.compareTo(buf.slice(buf.readerIndex() + 1, 6)));
        buf.release();
        slice1.readByte();
        ByteBuf dup1 = slice1.retainedDuplicate();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)dup1.compareTo(expected2));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)dup1.compareTo(slice1.duplicate()));
        dup1.readByte();
        ByteBuf dup2 = dup1.duplicate();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)dup2.compareTo(expected3));
        dup2.readByte();
        ByteBuf slice2 = dup2.retainedSlice(dup2.readerIndex(), 3);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)slice2.compareTo(expected4));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)slice2.compareTo(dup2.slice(dup2.readerIndex(), 3)));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)expected1.release());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)expected2.release());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)expected3.release());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)expected4.release());
        slice2.release();
        dup2.release();
        org.junit.jupiter.api.Assertions.assertEquals((int)slice2.refCnt(), (int)dup2.refCnt());
        org.junit.jupiter.api.Assertions.assertEquals((int)dup2.refCnt(), (int)dup1.refCnt());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)slice1.release());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)buf.refCnt());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)slice1.refCnt());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)slice2.refCnt());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)dup1.refCnt());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)dup2.refCnt());
    }

    @Test
    public void testRetainedDuplicateAndRetainedSliceContentIsExpected() {
        ByteBuf buf = this.newBuffer(8).resetWriterIndex();
        ByteBuf expected1 = this.newBuffer(6).resetWriterIndex();
        ByteBuf expected2 = this.newBuffer(5).resetWriterIndex();
        ByteBuf expected3 = this.newBuffer(4).resetWriterIndex();
        buf.writeBytes(new byte[]{1, 2, 3, 4, 5, 6, 7, 8});
        expected1.writeBytes(new byte[]{2, 3, 4, 5, 6, 7});
        expected2.writeBytes(new byte[]{3, 4, 5, 6, 7});
        expected3.writeBytes(new byte[]{5, 6, 7});
        ByteBuf dup1 = buf.retainedDuplicate();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)dup1.compareTo(buf));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)dup1.compareTo(buf.slice()));
        buf.release();
        dup1.readByte();
        ByteBuf slice1 = dup1.retainedSlice(dup1.readerIndex(), 6);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)slice1.compareTo(expected1));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)slice1.compareTo(slice1.duplicate()));
        slice1.readByte();
        ByteBuf dup2 = slice1.duplicate();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)dup2.compareTo(slice1));
        dup2.readByte();
        ByteBuf slice2 = dup2.retainedSlice(dup2.readerIndex() + 1, 3);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)slice2.compareTo(expected3));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)slice2.compareTo(dup2.slice(dup2.readerIndex() + 1, 3)));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)expected1.release());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)expected2.release());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)expected3.release());
        slice2.release();
        slice1.release();
        org.junit.jupiter.api.Assertions.assertEquals((int)slice2.refCnt(), (int)dup2.refCnt());
        org.junit.jupiter.api.Assertions.assertEquals((int)dup2.refCnt(), (int)slice1.refCnt());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)dup1.release());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)buf.refCnt());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)slice1.refCnt());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)slice2.refCnt());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)dup1.refCnt());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)dup2.refCnt());
    }

    @Test
    public void testRetainedSliceContents() {
        this.testSliceContents(true);
    }

    @Test
    public void testMultipleLevelRetainedSlice1() {
        this.testMultipleLevelRetainedSliceWithNonRetained(true, true);
    }

    @Test
    public void testMultipleLevelRetainedSlice2() {
        this.testMultipleLevelRetainedSliceWithNonRetained(true, false);
    }

    @Test
    public void testMultipleLevelRetainedSlice3() {
        this.testMultipleLevelRetainedSliceWithNonRetained(false, true);
    }

    @Test
    public void testMultipleLevelRetainedSlice4() {
        this.testMultipleLevelRetainedSliceWithNonRetained(false, false);
    }

    @Test
    public void testRetainedSliceReleaseOriginal1() {
        this.testSliceReleaseOriginal(true, true);
    }

    @Test
    public void testRetainedSliceReleaseOriginal2() {
        this.testSliceReleaseOriginal(true, false);
    }

    @Test
    public void testRetainedSliceReleaseOriginal3() {
        this.testSliceReleaseOriginal(false, true);
    }

    @Test
    public void testRetainedSliceReleaseOriginal4() {
        this.testSliceReleaseOriginal(false, false);
    }

    @Test
    public void testRetainedDuplicateReleaseOriginal1() {
        this.testDuplicateReleaseOriginal(true, true);
    }

    @Test
    public void testRetainedDuplicateReleaseOriginal2() {
        this.testDuplicateReleaseOriginal(true, false);
    }

    @Test
    public void testRetainedDuplicateReleaseOriginal3() {
        this.testDuplicateReleaseOriginal(false, true);
    }

    @Test
    public void testRetainedDuplicateReleaseOriginal4() {
        this.testDuplicateReleaseOriginal(false, false);
    }

    @Test
    public void testMultipleRetainedSliceReleaseOriginal1() {
        this.testMultipleRetainedSliceReleaseOriginal(true, true);
    }

    @Test
    public void testMultipleRetainedSliceReleaseOriginal2() {
        this.testMultipleRetainedSliceReleaseOriginal(true, false);
    }

    @Test
    public void testMultipleRetainedSliceReleaseOriginal3() {
        this.testMultipleRetainedSliceReleaseOriginal(false, true);
    }

    @Test
    public void testMultipleRetainedSliceReleaseOriginal4() {
        this.testMultipleRetainedSliceReleaseOriginal(false, false);
    }

    @Test
    public void testMultipleRetainedDuplicateReleaseOriginal1() {
        this.testMultipleRetainedDuplicateReleaseOriginal(true, true);
    }

    @Test
    public void testMultipleRetainedDuplicateReleaseOriginal2() {
        this.testMultipleRetainedDuplicateReleaseOriginal(true, false);
    }

    @Test
    public void testMultipleRetainedDuplicateReleaseOriginal3() {
        this.testMultipleRetainedDuplicateReleaseOriginal(false, true);
    }

    @Test
    public void testMultipleRetainedDuplicateReleaseOriginal4() {
        this.testMultipleRetainedDuplicateReleaseOriginal(false, false);
    }

    @Test
    public void testSliceContents() {
        this.testSliceContents(false);
    }

    @Test
    public void testRetainedDuplicateContents() {
        this.testDuplicateContents(true);
    }

    @Test
    public void testDuplicateContents() {
        this.testDuplicateContents(false);
    }

    @Test
    public void testDuplicateCapacityChange() {
        this.testDuplicateCapacityChange(false);
    }

    @Test
    public void testRetainedDuplicateCapacityChange() {
        this.testDuplicateCapacityChange(true);
    }

    @Test
    public void testSliceCapacityChange() {
        org.junit.jupiter.api.Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.testSliceCapacityChange(false);
            }
        });
    }

    @Test
    public void testRetainedSliceCapacityChange() {
        org.junit.jupiter.api.Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

            public void execute() {
                AbstractByteBufTest.this.testSliceCapacityChange(true);
            }
        });
    }

    @Test
    public void testRetainedSliceUnreleasable1() {
        this.testRetainedSliceUnreleasable(true, true);
    }

    @Test
    public void testRetainedSliceUnreleasable2() {
        this.testRetainedSliceUnreleasable(true, false);
    }

    @Test
    public void testRetainedSliceUnreleasable3() {
        this.testRetainedSliceUnreleasable(false, true);
    }

    @Test
    public void testRetainedSliceUnreleasable4() {
        this.testRetainedSliceUnreleasable(false, false);
    }

    @Test
    public void testReadRetainedSliceUnreleasable1() {
        this.testReadRetainedSliceUnreleasable(true, true);
    }

    @Test
    public void testReadRetainedSliceUnreleasable2() {
        this.testReadRetainedSliceUnreleasable(true, false);
    }

    @Test
    public void testReadRetainedSliceUnreleasable3() {
        this.testReadRetainedSliceUnreleasable(false, true);
    }

    @Test
    public void testReadRetainedSliceUnreleasable4() {
        this.testReadRetainedSliceUnreleasable(false, false);
    }

    @Test
    public void testRetainedDuplicateUnreleasable1() {
        this.testRetainedDuplicateUnreleasable(true, true);
    }

    @Test
    public void testRetainedDuplicateUnreleasable2() {
        this.testRetainedDuplicateUnreleasable(true, false);
    }

    @Test
    public void testRetainedDuplicateUnreleasable3() {
        this.testRetainedDuplicateUnreleasable(false, true);
    }

    @Test
    public void testRetainedDuplicateUnreleasable4() {
        this.testRetainedDuplicateUnreleasable(false, false);
    }

    private void testRetainedSliceUnreleasable(boolean initRetainedSlice, boolean finalRetainedSlice) {
        ByteBuf buf = this.newBuffer(8);
        ByteBuf buf1 = initRetainedSlice ? buf.retainedSlice() : buf.slice().retain();
        ByteBuf buf2 = Unpooled.unreleasableBuffer((ByteBuf)buf1);
        ByteBuf buf3 = finalRetainedSlice ? buf2.retainedSlice() : buf2.slice().retain();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)buf3.release());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)buf2.release());
        buf1.release();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)buf.release());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)buf1.refCnt());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)buf.refCnt());
    }

    private void testReadRetainedSliceUnreleasable(boolean initRetainedSlice, boolean finalRetainedSlice) {
        ByteBuf buf = this.newBuffer(8);
        ByteBuf buf1 = initRetainedSlice ? buf.retainedSlice() : buf.slice().retain();
        ByteBuf buf2 = Unpooled.unreleasableBuffer((ByteBuf)buf1);
        ByteBuf buf3 = finalRetainedSlice ? buf2.readRetainedSlice(buf2.readableBytes()) : buf2.readSlice(buf2.readableBytes()).retain();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)buf3.release());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)buf2.release());
        buf1.release();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)buf.release());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)buf1.refCnt());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)buf.refCnt());
    }

    private void testRetainedDuplicateUnreleasable(boolean initRetainedDuplicate, boolean finalRetainedDuplicate) {
        ByteBuf buf = this.newBuffer(8);
        ByteBuf buf1 = initRetainedDuplicate ? buf.retainedDuplicate() : buf.duplicate().retain();
        ByteBuf buf2 = Unpooled.unreleasableBuffer((ByteBuf)buf1);
        ByteBuf buf3 = finalRetainedDuplicate ? buf2.retainedDuplicate() : buf2.duplicate().retain();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)buf3.release());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)buf2.release());
        buf1.release();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)buf.release());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)buf1.refCnt());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)buf.refCnt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDuplicateCapacityChange(boolean retainedDuplicate) {
        ByteBuf buf = this.newBuffer(8);
        ByteBuf dup = retainedDuplicate ? buf.retainedDuplicate() : buf.duplicate();
        try {
            dup.capacity(10);
            org.junit.jupiter.api.Assertions.assertEquals((int)buf.capacity(), (int)dup.capacity());
            dup.capacity(5);
            org.junit.jupiter.api.Assertions.assertEquals((int)buf.capacity(), (int)dup.capacity());
        }
        finally {
            if (retainedDuplicate) {
                dup.release();
            }
            buf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSliceCapacityChange(boolean retainedSlice) {
        ByteBuf buf = this.newBuffer(8);
        ByteBuf slice = retainedSlice ? buf.retainedSlice(buf.readerIndex() + 1, 3) : buf.slice(buf.readerIndex() + 1, 3);
        try {
            slice.capacity(10);
        }
        finally {
            if (retainedSlice) {
                slice.release();
            }
            buf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSliceOutOfBounds(boolean initRetainedSlice, boolean finalRetainedSlice, boolean indexOutOfBounds) {
        ByteBuf buf = this.newBuffer(8);
        ByteBuf slice = initRetainedSlice ? buf.retainedSlice(buf.readerIndex() + 1, 2) : buf.slice(buf.readerIndex() + 1, 2);
        try {
            int length;
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)slice.capacity());
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)slice.maxCapacity());
            int index = indexOutOfBounds ? 3 : 0;
            int n = length = indexOutOfBounds ? 0 : 3;
            if (finalRetainedSlice) {
                slice.retainedSlice(index, length);
            } else {
                slice.slice(index, length);
            }
        }
        finally {
            if (initRetainedSlice) {
                slice.release();
            }
            buf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSliceContents(boolean retainedSlice) {
        ByteBuf buf = this.newBuffer(8).resetWriterIndex();
        ByteBuf expected = this.newBuffer(3).resetWriterIndex();
        buf.writeBytes(new byte[]{1, 2, 3, 4, 5, 6, 7, 8});
        expected.writeBytes(new byte[]{4, 5, 6});
        ByteBuf slice = retainedSlice ? buf.retainedSlice(buf.readerIndex() + 3, 3) : buf.slice(buf.readerIndex() + 3, 3);
        try {
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)slice.compareTo(expected));
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)slice.compareTo(slice.duplicate()));
            ByteBuf b = slice.retainedDuplicate();
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)slice.compareTo(b));
            b.release();
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)slice.compareTo(slice.slice(0, slice.capacity())));
        }
        finally {
            if (retainedSlice) {
                slice.release();
            }
            buf.release();
            expected.release();
        }
    }

    private void testSliceReleaseOriginal(boolean retainedSlice1, boolean retainedSlice2) {
        ByteBuf buf = this.newBuffer(8).resetWriterIndex();
        ByteBuf expected1 = this.newBuffer(3).resetWriterIndex();
        ByteBuf expected2 = this.newBuffer(2).resetWriterIndex();
        buf.writeBytes(new byte[]{1, 2, 3, 4, 5, 6, 7, 8});
        expected1.writeBytes(new byte[]{6, 7, 8});
        expected2.writeBytes(new byte[]{7, 8});
        ByteBuf slice1 = retainedSlice1 ? buf.retainedSlice(buf.readerIndex() + 5, 3) : buf.slice(buf.readerIndex() + 5, 3).retain();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)slice1.compareTo(expected1));
        buf.release();
        ByteBuf slice2 = retainedSlice2 ? slice1.retainedSlice(slice1.readerIndex() + 1, 2) : slice1.slice(slice1.readerIndex() + 1, 2).retain();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)slice2.compareTo(expected2));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)expected1.release());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)expected2.release());
        slice2.release();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)slice1.release());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)buf.refCnt());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)slice1.refCnt());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)slice2.refCnt());
    }

    private void testMultipleLevelRetainedSliceWithNonRetained(boolean doSlice1, boolean doSlice2) {
        ByteBuf slice4;
        ByteBuf slice3;
        ByteBuf buf = this.newBuffer(8).resetWriterIndex();
        ByteBuf expected1 = this.newBuffer(6).resetWriterIndex();
        ByteBuf expected2 = this.newBuffer(4).resetWriterIndex();
        ByteBuf expected3 = this.newBuffer(2).resetWriterIndex();
        ByteBuf expected4SliceSlice = this.newBuffer(1).resetWriterIndex();
        ByteBuf expected4DupSlice = this.newBuffer(1).resetWriterIndex();
        buf.writeBytes(new byte[]{1, 2, 3, 4, 5, 6, 7, 8});
        expected1.writeBytes(new byte[]{2, 3, 4, 5, 6, 7});
        expected2.writeBytes(new byte[]{3, 4, 5, 6});
        expected3.writeBytes(new byte[]{4, 5});
        expected4SliceSlice.writeBytes(new byte[]{5});
        expected4DupSlice.writeBytes(new byte[]{4});
        ByteBuf slice1 = buf.retainedSlice(buf.readerIndex() + 1, 6);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)slice1.compareTo(expected1));
        buf.release();
        ByteBuf slice2 = slice1.retainedSlice(slice1.readerIndex() + 1, 4);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)slice2.compareTo(expected2));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)slice2.compareTo(slice2.duplicate()));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)slice2.compareTo(slice2.slice()));
        ByteBuf tmpBuf = slice2.retainedDuplicate();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)slice2.compareTo(tmpBuf));
        tmpBuf.release();
        tmpBuf = slice2.retainedSlice();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)slice2.compareTo(tmpBuf));
        tmpBuf.release();
        ByteBuf byteBuf = slice3 = doSlice1 ? slice2.slice(slice2.readerIndex() + 1, 2) : slice2.duplicate();
        if (doSlice1) {
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)slice3.compareTo(expected3));
        } else {
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)slice3.compareTo(expected2));
        }
        ByteBuf byteBuf2 = slice4 = doSlice2 ? slice3.slice(slice3.readerIndex() + 1, 1) : slice3.duplicate();
        if (doSlice1 && doSlice2) {
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)slice4.compareTo(expected4SliceSlice));
        } else if (doSlice2) {
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)slice4.compareTo(expected4DupSlice));
        } else {
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)slice3.compareTo(slice4));
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)expected1.release());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)expected2.release());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)expected3.release());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)expected4SliceSlice.release());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)expected4DupSlice.release());
        slice4.release();
        org.junit.jupiter.api.Assertions.assertEquals((int)slice3.refCnt(), (int)slice2.refCnt());
        org.junit.jupiter.api.Assertions.assertEquals((int)slice3.refCnt(), (int)slice4.refCnt());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)slice1.release());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)buf.refCnt());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)slice1.refCnt());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)slice2.refCnt());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)slice3.refCnt());
    }

    private void testDuplicateReleaseOriginal(boolean retainedDuplicate1, boolean retainedDuplicate2) {
        ByteBuf buf = this.newBuffer(8).resetWriterIndex();
        ByteBuf expected = this.newBuffer(8).resetWriterIndex();
        buf.writeBytes(new byte[]{1, 2, 3, 4, 5, 6, 7, 8});
        expected.writeBytes(buf, buf.readerIndex(), buf.readableBytes());
        ByteBuf dup1 = retainedDuplicate1 ? buf.retainedDuplicate() : buf.duplicate().retain();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)dup1.compareTo(expected));
        buf.release();
        ByteBuf dup2 = retainedDuplicate2 ? dup1.retainedDuplicate() : dup1.duplicate().retain();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)dup2.compareTo(expected));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)expected.release());
        dup2.release();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)dup1.release());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)buf.refCnt());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)dup1.refCnt());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)dup2.refCnt());
    }

    private void testMultipleRetainedSliceReleaseOriginal(boolean retainedSlice1, boolean retainedSlice2) {
        ByteBuf buf = this.newBuffer(8).resetWriterIndex();
        ByteBuf expected1 = this.newBuffer(3).resetWriterIndex();
        ByteBuf expected2 = this.newBuffer(2).resetWriterIndex();
        ByteBuf expected3 = this.newBuffer(2).resetWriterIndex();
        buf.writeBytes(new byte[]{1, 2, 3, 4, 5, 6, 7, 8});
        expected1.writeBytes(new byte[]{6, 7, 8});
        expected2.writeBytes(new byte[]{7, 8});
        expected3.writeBytes(new byte[]{6, 7});
        ByteBuf slice1 = retainedSlice1 ? buf.retainedSlice(buf.readerIndex() + 5, 3) : buf.slice(buf.readerIndex() + 5, 3).retain();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)slice1.compareTo(expected1));
        buf.release();
        ByteBuf slice2 = retainedSlice2 ? slice1.retainedSlice(slice1.readerIndex() + 1, 2) : slice1.slice(slice1.readerIndex() + 1, 2).retain();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)slice2.compareTo(expected2));
        slice2.release();
        ByteBuf slice3 = slice1.retainedSlice(slice1.readerIndex(), 2);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)slice3.compareTo(expected3));
        slice3.release();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)slice1.release());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)expected1.release());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)expected2.release());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)expected3.release());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)buf.refCnt());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)slice1.refCnt());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)slice2.refCnt());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)slice3.refCnt());
    }

    private void testMultipleRetainedDuplicateReleaseOriginal(boolean retainedDuplicate1, boolean retainedDuplicate2) {
        ByteBuf buf = this.newBuffer(8).resetWriterIndex();
        ByteBuf expected = this.newBuffer(8).resetWriterIndex();
        buf.writeBytes(new byte[]{1, 2, 3, 4, 5, 6, 7, 8});
        expected.writeBytes(buf, buf.readerIndex(), buf.readableBytes());
        ByteBuf dup1 = retainedDuplicate1 ? buf.retainedDuplicate() : buf.duplicate().retain();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)dup1.compareTo(expected));
        buf.release();
        ByteBuf dup2 = retainedDuplicate2 ? dup1.retainedDuplicate() : dup1.duplicate().retain();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)dup2.compareTo(expected));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)dup2.compareTo(dup2.duplicate()));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)dup2.compareTo(dup2.slice()));
        ByteBuf tmpBuf = dup2.retainedDuplicate();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)dup2.compareTo(tmpBuf));
        tmpBuf.release();
        tmpBuf = dup2.retainedSlice();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)dup2.compareTo(tmpBuf));
        tmpBuf.release();
        dup2.release();
        ByteBuf dup3 = dup1.retainedDuplicate();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)dup3.compareTo(expected));
        dup3.release();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)dup1.release());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)expected.release());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)buf.refCnt());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)dup1.refCnt());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)dup2.refCnt());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)dup3.refCnt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDuplicateContents(boolean retainedDuplicate) {
        ByteBuf buf = this.newBuffer(8).resetWriterIndex();
        buf.writeBytes(new byte[]{1, 2, 3, 4, 5, 6, 7, 8});
        ByteBuf dup = retainedDuplicate ? buf.retainedDuplicate() : buf.duplicate();
        try {
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)dup.compareTo(buf));
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)dup.compareTo(dup.duplicate()));
            ByteBuf b = dup.retainedDuplicate();
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)dup.compareTo(b));
            b.release();
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)dup.compareTo(dup.slice(dup.readerIndex(), dup.readableBytes())));
        }
        finally {
            if (retainedDuplicate) {
                dup.release();
            }
            buf.release();
        }
    }

    @Test
    public void testDuplicateRelease() {
        ByteBuf buf = this.newBuffer(8);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)buf.refCnt());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)buf.duplicate().release());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)buf.refCnt());
    }

    @Test
    public void testReadOnlyRelease() {
        ByteBuf buf = this.newBuffer(8);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)buf.refCnt());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)buf.asReadOnly().release());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)buf.refCnt());
    }

    @Test
    public void testRefCnt() throws Exception {
        this.testRefCnt0(false);
    }

    @Test
    public void testRefCnt2() throws Exception {
        this.testRefCnt0(true);
    }

    @Test
    public void testEmptyNioBuffers() throws Exception {
        ByteBuf buffer = this.newBuffer(8);
        buffer.clear();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)buffer.isReadable());
        ByteBuffer[] nioBuffers = buffer.nioBuffers();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)nioBuffers.length);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)nioBuffers[0].hasRemaining());
        buffer.release();
    }

    @Test
    public void testGetReadOnlyDirectDst() {
        this.testGetReadOnlyDst(true);
    }

    @Test
    public void testGetReadOnlyHeapDst() {
        this.testGetReadOnlyDst(false);
    }

    private void testGetReadOnlyDst(boolean direct) {
        byte[] bytes = new byte[]{97, 98, 99, 100};
        ByteBuf buffer = this.newBuffer(bytes.length);
        buffer.writeBytes(bytes);
        ByteBuffer dst = direct ? ByteBuffer.allocateDirect(bytes.length) : ByteBuffer.allocate(bytes.length);
        ByteBuffer readOnlyDst = dst.asReadOnlyBuffer();
        try {
            buffer.getBytes(0, readOnlyDst);
            org.junit.jupiter.api.Assertions.fail();
        }
        catch (ReadOnlyBufferException readOnlyBufferException) {
            // empty catch block
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)readOnlyDst.position());
        buffer.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadBytesAndWriteBytesWithFileChannel() throws IOException {
        File file = PlatformDependent.createTempFile((String)"file-channel", (String)".tmp", null);
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "rw");
            FileChannel channel = randomAccessFile.getChannel();
            long channelPosition = channel.position();
            byte[] bytes = new byte[]{97, 98, 99, 100};
            int len = bytes.length;
            ByteBuf buffer = this.newBuffer(len);
            buffer.resetReaderIndex();
            buffer.resetWriterIndex();
            buffer.writeBytes(bytes);
            int oldReaderIndex = buffer.readerIndex();
            org.junit.jupiter.api.Assertions.assertEquals((int)len, (int)buffer.readBytes(channel, 10L, len));
            org.junit.jupiter.api.Assertions.assertEquals((int)(oldReaderIndex + len), (int)buffer.readerIndex());
            org.junit.jupiter.api.Assertions.assertEquals((long)channelPosition, (long)channel.position());
            ByteBuf buffer2 = this.newBuffer(len);
            buffer2.resetReaderIndex();
            buffer2.resetWriterIndex();
            int oldWriterIndex = buffer2.writerIndex();
            org.junit.jupiter.api.Assertions.assertEquals((int)len, (int)buffer2.writeBytes(channel, 10L, len));
            org.junit.jupiter.api.Assertions.assertEquals((long)channelPosition, (long)channel.position());
            org.junit.jupiter.api.Assertions.assertEquals((int)(oldWriterIndex + len), (int)buffer2.writerIndex());
            org.junit.jupiter.api.Assertions.assertEquals((int)97, (int)buffer2.getByte(0));
            org.junit.jupiter.api.Assertions.assertEquals((int)98, (int)buffer2.getByte(1));
            org.junit.jupiter.api.Assertions.assertEquals((int)99, (int)buffer2.getByte(2));
            org.junit.jupiter.api.Assertions.assertEquals((int)100, (int)buffer2.getByte(3));
            buffer.release();
            buffer2.release();
        }
        finally {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetBytesAndSetBytesWithFileChannel() throws IOException {
        File file = PlatformDependent.createTempFile((String)"file-channel", (String)".tmp", null);
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "rw");
            FileChannel channel = randomAccessFile.getChannel();
            long channelPosition = channel.position();
            byte[] bytes = new byte[]{97, 98, 99, 100};
            int len = bytes.length;
            ByteBuf buffer = this.newBuffer(len);
            buffer.resetReaderIndex();
            buffer.resetWriterIndex();
            buffer.writeBytes(bytes);
            int oldReaderIndex = buffer.readerIndex();
            org.junit.jupiter.api.Assertions.assertEquals((int)len, (int)buffer.getBytes(oldReaderIndex, channel, 10L, len));
            org.junit.jupiter.api.Assertions.assertEquals((int)oldReaderIndex, (int)buffer.readerIndex());
            org.junit.jupiter.api.Assertions.assertEquals((long)channelPosition, (long)channel.position());
            ByteBuf buffer2 = this.newBuffer(len);
            buffer2.resetReaderIndex();
            buffer2.resetWriterIndex();
            int oldWriterIndex = buffer2.writerIndex();
            org.junit.jupiter.api.Assertions.assertEquals((int)buffer2.setBytes(oldWriterIndex, channel, 10L, len), (int)len);
            org.junit.jupiter.api.Assertions.assertEquals((long)channelPosition, (long)channel.position());
            org.junit.jupiter.api.Assertions.assertEquals((int)oldWriterIndex, (int)buffer2.writerIndex());
            org.junit.jupiter.api.Assertions.assertEquals((int)97, (int)buffer2.getByte(oldWriterIndex));
            org.junit.jupiter.api.Assertions.assertEquals((int)98, (int)buffer2.getByte(oldWriterIndex + 1));
            org.junit.jupiter.api.Assertions.assertEquals((int)99, (int)buffer2.getByte(oldWriterIndex + 2));
            org.junit.jupiter.api.Assertions.assertEquals((int)100, (int)buffer2.getByte(oldWriterIndex + 3));
            buffer.release();
            buffer2.release();
        }
        finally {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
            file.delete();
        }
    }

    @Test
    public void testReadBytes() {
        ByteBuf buffer = this.newBuffer(8);
        byte[] bytes = new byte[8];
        buffer.writeBytes(bytes);
        ByteBuf buffer2 = buffer.readBytes(4);
        org.junit.jupiter.api.Assertions.assertSame((Object)buffer.alloc(), (Object)buffer2.alloc());
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)buffer.readerIndex());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)buffer.release());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)buffer.refCnt());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)buffer2.release());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)buffer2.refCnt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testForEachByteDesc2() {
        byte[] expected = new byte[]{1, 2, 3, 4};
        ByteBuf buf = this.newBuffer(expected.length);
        try {
            buf.writeBytes(expected);
            final byte[] bytes = new byte[expected.length];
            int i = buf.forEachByteDesc(new ByteProcessor(){
                private int index;
                {
                    this.index = bytes.length - 1;
                }

                public boolean process(byte value) throws Exception {
                    bytes[this.index--] = value;
                    return true;
                }
            });
            org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)i);
            org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])expected, (byte[])bytes);
        }
        finally {
            buf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testForEachByte2() {
        byte[] expected = new byte[]{1, 2, 3, 4};
        ByteBuf buf = this.newBuffer(expected.length);
        try {
            buf.writeBytes(expected);
            final byte[] bytes = new byte[expected.length];
            int i = buf.forEachByte(new ByteProcessor(){
                private int index;

                public boolean process(byte value) throws Exception {
                    bytes[this.index++] = value;
                    return true;
                }
            });
            org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)i);
            org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])expected, (byte[])bytes);
        }
        finally {
            buf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetBytesByteBuffer() {
        byte[] bytes = new byte[]{97, 98, 99, 100, 101, 102, 103};
        final ByteBuffer nioBuffer = ByteBuffer.allocate(bytes.length + 1);
        final ByteBuf buffer = this.newBuffer(bytes.length);
        try {
            buffer.writeBytes(bytes);
            org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

                public void execute() {
                    buffer.getBytes(buffer.readerIndex(), nioBuffer);
                }
            });
        }
        finally {
            buffer.release();
        }
    }

    private void testRefCnt0(final boolean parameter) throws Exception {
        for (int i = 0; i < 10; ++i) {
            final CountDownLatch latch = new CountDownLatch(1);
            final CountDownLatch innerLatch = new CountDownLatch(1);
            final ByteBuf buffer = this.newBuffer(4);
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)buffer.refCnt());
            final AtomicInteger cnt = new AtomicInteger(Integer.MAX_VALUE);
            Thread t1 = new Thread(new Runnable(){

                @Override
                public void run() {
                    boolean released = parameter ? buffer.release(buffer.refCnt()) : buffer.release();
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)released);
                    Thread t2 = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            cnt.set(buffer.refCnt());
                            latch.countDown();
                        }
                    });
                    t2.start();
                    try {
                        innerLatch.await();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
            t1.start();
            latch.await();
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)cnt.get());
            innerLatch.countDown();
        }
    }

    @Test
    public void testCapacityEnforceMaxCapacity() {
        final ByteBuf buffer = this.newBuffer(3, 13);
        org.junit.jupiter.api.Assertions.assertEquals((int)13, (int)buffer.maxCapacity());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)buffer.capacity());
        try {
            org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

                public void execute() {
                    buffer.capacity(14);
                }
            });
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testCapacityNegative() {
        final ByteBuf buffer = this.newBuffer(3, 13);
        org.junit.jupiter.api.Assertions.assertEquals((int)13, (int)buffer.maxCapacity());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)buffer.capacity());
        try {
            org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

                public void execute() {
                    buffer.capacity(-1);
                }
            });
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testCapacityDecrease() {
        ByteBuf buffer = this.newBuffer(3, 13);
        org.junit.jupiter.api.Assertions.assertEquals((int)13, (int)buffer.maxCapacity());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)buffer.capacity());
        try {
            buffer.capacity(2);
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)buffer.capacity());
            org.junit.jupiter.api.Assertions.assertEquals((int)13, (int)buffer.maxCapacity());
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testCapacityIncrease() {
        ByteBuf buffer = this.newBuffer(3, 13);
        org.junit.jupiter.api.Assertions.assertEquals((int)13, (int)buffer.maxCapacity());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)buffer.capacity());
        try {
            buffer.capacity(4);
            org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)buffer.capacity());
            org.junit.jupiter.api.Assertions.assertEquals((int)13, (int)buffer.maxCapacity());
        }
        finally {
            buffer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReaderIndexLargerThanWriterIndex() {
        String content1 = "hello";
        String content2 = "world";
        int length = content1.length() + content2.length();
        final ByteBuf buffer = this.newBuffer(length);
        buffer.setIndex(0, 0);
        buffer.writeCharSequence((CharSequence)content1, CharsetUtil.US_ASCII);
        buffer.markWriterIndex();
        buffer.skipBytes(content1.length());
        buffer.writeCharSequence((CharSequence)content2, CharsetUtil.US_ASCII);
        buffer.skipBytes(content2.length());
        org.junit.jupiter.api.Assertions.assertTrue((buffer.readerIndex() <= buffer.writerIndex() ? 1 : 0) != 0);
        try {
            org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

                public void execute() {
                    buffer.resetWriterIndex();
                }
            });
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testMaxFastWritableBytes() {
        ByteBuf buffer = this.newBuffer(150, 500).writerIndex(100);
        org.junit.jupiter.api.Assertions.assertEquals((int)50, (int)buffer.writableBytes());
        org.junit.jupiter.api.Assertions.assertEquals((int)150, (int)buffer.capacity());
        org.junit.jupiter.api.Assertions.assertEquals((int)500, (int)buffer.maxCapacity());
        org.junit.jupiter.api.Assertions.assertEquals((int)400, (int)buffer.maxWritableBytes());
        org.junit.jupiter.api.Assertions.assertEquals((int)50, (int)buffer.maxFastWritableBytes());
        buffer.release();
    }

    @Test
    public void testEnsureWritableIntegerOverflow() {
        ByteBuf buffer = this.newBuffer(4096);
        buffer.writerIndex(buffer.readerIndex());
        buffer.writeByte(1);
        try {
            buffer.ensureWritable(Integer.MAX_VALUE);
            org.junit.jupiter.api.Assertions.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testEndiannessIndexOf() {
        this.buffer.clear();
        int v = 33751553;
        this.buffer.writeIntLE(33751553);
        this.buffer.writeByte(1);
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)this.buffer.indexOf(1, 4, (byte)1));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)this.buffer.indexOf(4, 1, (byte)1));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.buffer.indexOf(1, 4, (byte)2));
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)this.buffer.indexOf(4, 1, (byte)2));
    }

    @Test
    public void explicitLittleEndianReadMethodsMustAlwaysUseLittleEndianByteOrder() {
        this.buffer.clear();
        this.buffer.writeBytes(new byte[]{1, 2, 3, 4, 5, 6, 7, 8});
        org.junit.jupiter.api.Assertions.assertEquals((int)513, (int)this.buffer.readShortLE());
        this.buffer.readerIndex(0);
        org.junit.jupiter.api.Assertions.assertEquals((int)513, (int)this.buffer.readUnsignedShortLE());
        this.buffer.readerIndex(0);
        org.junit.jupiter.api.Assertions.assertEquals((int)197121, (int)this.buffer.readMediumLE());
        this.buffer.readerIndex(0);
        org.junit.jupiter.api.Assertions.assertEquals((int)197121, (int)this.buffer.readUnsignedMediumLE());
        this.buffer.readerIndex(0);
        org.junit.jupiter.api.Assertions.assertEquals((int)67305985, (int)this.buffer.readIntLE());
        this.buffer.readerIndex(0);
        org.junit.jupiter.api.Assertions.assertEquals((long)67305985L, (long)this.buffer.readUnsignedIntLE());
        this.buffer.readerIndex(0);
        org.junit.jupiter.api.Assertions.assertEquals((int)67305985, (int)Float.floatToRawIntBits(this.buffer.readFloatLE()));
        this.buffer.readerIndex(0);
        org.junit.jupiter.api.Assertions.assertEquals((long)578437695752307201L, (long)this.buffer.readLongLE());
        this.buffer.readerIndex(0);
        org.junit.jupiter.api.Assertions.assertEquals((long)578437695752307201L, (long)Double.doubleToRawLongBits(this.buffer.readDoubleLE()));
        this.buffer.readerIndex(0);
        org.junit.jupiter.api.Assertions.assertEquals((int)513, (int)this.buffer.getShortLE(0));
        org.junit.jupiter.api.Assertions.assertEquals((int)513, (int)this.buffer.getUnsignedShortLE(0));
        org.junit.jupiter.api.Assertions.assertEquals((int)197121, (int)this.buffer.getMediumLE(0));
        org.junit.jupiter.api.Assertions.assertEquals((int)197121, (int)this.buffer.getUnsignedMediumLE(0));
        org.junit.jupiter.api.Assertions.assertEquals((int)67305985, (int)this.buffer.getIntLE(0));
        org.junit.jupiter.api.Assertions.assertEquals((long)67305985L, (long)this.buffer.getUnsignedIntLE(0));
        org.junit.jupiter.api.Assertions.assertEquals((int)67305985, (int)Float.floatToRawIntBits(this.buffer.getFloatLE(0)));
        org.junit.jupiter.api.Assertions.assertEquals((long)578437695752307201L, (long)this.buffer.getLongLE(0));
        org.junit.jupiter.api.Assertions.assertEquals((long)578437695752307201L, (long)Double.doubleToRawLongBits(this.buffer.getDoubleLE(0)));
    }

    @Test
    public void explicitLittleEndianWriteMethodsMustAlwaysUseLittleEndianByteOrder() {
        this.buffer.clear();
        this.buffer.writeShortLE(258);
        org.junit.jupiter.api.Assertions.assertEquals((int)258, (int)this.buffer.readShortLE());
        this.buffer.clear();
        this.buffer.writeMediumLE(66051);
        org.junit.jupiter.api.Assertions.assertEquals((int)66051, (int)this.buffer.readMediumLE());
        this.buffer.clear();
        this.buffer.writeIntLE(16909060);
        org.junit.jupiter.api.Assertions.assertEquals((int)16909060, (int)this.buffer.readIntLE());
        this.buffer.clear();
        this.buffer.writeFloatLE(Float.intBitsToFloat(16909060));
        org.junit.jupiter.api.Assertions.assertEquals((int)16909060, (int)Float.floatToRawIntBits(this.buffer.readFloatLE()));
        this.buffer.clear();
        this.buffer.writeLongLE(72623859790382856L);
        org.junit.jupiter.api.Assertions.assertEquals((long)72623859790382856L, (long)this.buffer.readLongLE());
        this.buffer.clear();
        this.buffer.writeDoubleLE(Double.longBitsToDouble(72623859790382856L));
        org.junit.jupiter.api.Assertions.assertEquals((long)72623859790382856L, (long)Double.doubleToRawLongBits(this.buffer.readDoubleLE()));
        this.buffer.setShortLE(0, 258);
        org.junit.jupiter.api.Assertions.assertEquals((int)258, (int)this.buffer.getShortLE(0));
        this.buffer.setMediumLE(0, 66051);
        org.junit.jupiter.api.Assertions.assertEquals((int)66051, (int)this.buffer.getMediumLE(0));
        this.buffer.setIntLE(0, 16909060);
        org.junit.jupiter.api.Assertions.assertEquals((int)16909060, (int)this.buffer.getIntLE(0));
        this.buffer.setFloatLE(0, Float.intBitsToFloat(16909060));
        org.junit.jupiter.api.Assertions.assertEquals((int)16909060, (int)Float.floatToRawIntBits(this.buffer.getFloatLE(0)));
        this.buffer.setLongLE(0, 72623859790382856L);
        org.junit.jupiter.api.Assertions.assertEquals((long)72623859790382856L, (long)this.buffer.getLongLE(0));
        this.buffer.setDoubleLE(0, Double.longBitsToDouble(72623859790382856L));
        org.junit.jupiter.api.Assertions.assertEquals((long)72623859790382856L, (long)Double.doubleToRawLongBits(this.buffer.getDoubleLE(0)));
    }

    @Test
    public void testReadyOnlyNioBuffer() {
        AbstractByteBufTest.assertReadyOnlyNioBuffer(this.buffer.asReadOnly());
    }

    @Test
    public void testReadyOnlySliceNioBuffer() {
        AbstractByteBufTest.assertReadyOnlyNioBuffer(this.buffer.asReadOnly().slice());
    }

    @Test
    public void testReadyOnlyDuplicateNioBuffer() {
        AbstractByteBufTest.assertReadyOnlyNioBuffer(this.buffer.asReadOnly().duplicate());
    }

    static void assertReadyOnlyNioBuffer(ByteBuf buffer) {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)buffer.isReadOnly());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)buffer.nioBuffer().isReadOnly());
    }

    @Test
    public void testReadyOnlyNioBufferWithPositionLength() {
        AbstractByteBufTest.assertReadyOnlyNioBufferWithPositionLength(this.buffer.asReadOnly());
    }

    @Test
    public void testReadyOnlySliceNioBufferWithPositionLength() {
        AbstractByteBufTest.assertReadyOnlyNioBufferWithPositionLength(this.buffer.asReadOnly().slice());
    }

    @Test
    public void testReadyOnlyDuplicateNioBufferWithPositionLength() {
        AbstractByteBufTest.assertReadyOnlyNioBufferWithPositionLength(this.buffer.asReadOnly().duplicate());
    }

    static void assertReadyOnlyNioBufferWithPositionLength(ByteBuf buffer) {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)buffer.isReadOnly());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)buffer.nioBuffer(0, buffer.capacity()).isReadOnly());
    }

    @Test
    public void testReadyOnlyNioBuffers() {
        AbstractByteBufTest.assertReadyOnlyNioBuffers(this.buffer.asReadOnly());
    }

    @Test
    public void testReadyOnlySliceNioBuffers() {
        AbstractByteBufTest.assertReadyOnlyNioBuffers(this.buffer.asReadOnly().slice());
    }

    @Test
    public void testReadyOnlyDuplicateNioBuffers() {
        AbstractByteBufTest.assertReadyOnlyNioBuffers(this.buffer.asReadOnly().duplicate());
    }

    static void assertReadyOnlyNioBuffers(ByteBuf buffer) {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)buffer.isReadOnly());
        for (ByteBuffer nioBuffer : buffer.nioBuffers()) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)nioBuffer.isReadOnly());
        }
    }

    @Test
    public void testReadyOnlyNioBuffersWithPositionLength() {
        AbstractByteBufTest.assertReadyOnlyNioBuffersWithPositionLength(this.buffer.asReadOnly());
    }

    @Test
    public void testReadyOnlySliceNioBuffersWithPositionLength() {
        AbstractByteBufTest.assertReadyOnlyNioBuffersWithPositionLength(this.buffer.asReadOnly().slice());
    }

    @Test
    public void testReadyOnlyDuplicateNioBuffersWithPositionLength() {
        AbstractByteBufTest.assertReadyOnlyNioBuffersWithPositionLength(this.buffer.asReadOnly().duplicate());
    }

    static void assertReadyOnlyNioBuffersWithPositionLength(ByteBuf buffer) {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)buffer.isReadOnly());
        for (ByteBuffer nioBuffer : buffer.asReadOnly().nioBuffers(0, buffer.capacity())) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)nioBuffer.isReadOnly());
        }
    }

    @Test
    public void testMaxFastWritableBytesTracksWrittenBytes() {
        ByteBuf buf = this.newBuffer(4, 10);
        int max = buf.maxFastWritableBytes();
        buf.writeByte(1);
        org.junit.jupiter.api.Assertions.assertEquals((int)(max - 1), (int)buf.maxFastWritableBytes());
        buf.release();
    }

    @Test
    public void testSetCharSequenceWithTooLongSequence() {
        ByteBuf buffer = Unpooled.buffer((int)4, (int)128);
        String sequence = "\u00d6\u00c4\u00dc\u20ac";
        int maxBytes = ByteBufUtil.utf8MaxBytes((CharSequence)sequence);
        Assertions.assertThat((int)buffer.writableBytes()).isLessThan(maxBytes);
        org.junit.jupiter.api.Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.setCharSequence(0, sequence, StandardCharsets.UTF_8));
        buffer.release();
    }

    @Test
    public void testWriteCharSequence() {
        ByteBuf buffer = Unpooled.buffer((int)4, (int)128);
        String sequence = "\u00d6\u00c4\u00dc\u20ac";
        int maxBytes = ByteBufUtil.utf8MaxBytes((CharSequence)sequence);
        Assertions.assertThat((int)buffer.writableBytes()).isLessThan(maxBytes);
        int capacity = buffer.capacity();
        buffer.writeCharSequence((CharSequence)sequence, StandardCharsets.UTF_8);
        org.junit.jupiter.api.Assertions.assertNotSame((Object)capacity, (Object)buffer.capacity());
        buffer.release();
    }

    static {
        char[] chars = new char[256];
        for (int c = 0; c < chars.length; c = (int)((char)(c + 1))) {
            chars[c] = c;
        }
        EXTENDED_ASCII_CHARS = CharBuffer.wrap(chars);
        ASCII_CHARS = CharBuffer.wrap(chars, 0, 128);
    }

    private static final class TestByteProcessor
    implements ByteProcessor {
        private TestByteProcessor() {
        }

        public boolean process(byte value) throws Exception {
            return true;
        }
    }

    private static final class TestScatteringByteChannel
    implements ScatteringByteChannel {
        private TestScatteringByteChannel() {
        }

        @Override
        public long read(ByteBuffer[] dsts, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long read(ByteBuffer[] dsts) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int read(ByteBuffer dst) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isOpen() {
            return false;
        }

        @Override
        public void close() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class DevNullGatheringByteChannel
    implements GatheringByteChannel {
        private DevNullGatheringByteChannel() {
        }

        @Override
        public long write(ByteBuffer[] srcs, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long write(ByteBuffer[] srcs) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int write(ByteBuffer src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isOpen() {
            return false;
        }

        @Override
        public void close() {
            throw new UnsupportedOperationException();
        }
    }

    static final class TestGatheringByteChannel
    implements GatheringByteChannel {
        private final ByteArrayOutputStream out = new ByteArrayOutputStream();
        private final WritableByteChannel channel = Channels.newChannel(this.out);
        private final int limit;

        TestGatheringByteChannel(int limit) {
            this.limit = limit;
        }

        TestGatheringByteChannel() {
            this(Integer.MAX_VALUE);
        }

        @Override
        public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
            long written = 0L;
            while (offset < length && (written += (long)this.write(srcs[offset])) < (long)this.limit) {
                ++offset;
            }
            return written;
        }

        @Override
        public long write(ByteBuffer[] srcs) throws IOException {
            return this.write(srcs, 0, srcs.length);
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            int oldLimit = src.limit();
            if (this.limit < src.remaining()) {
                src.limit(src.position() + this.limit);
            }
            int w = this.channel.write(src);
            src.limit(oldLimit);
            return w;
        }

        @Override
        public boolean isOpen() {
            return this.channel.isOpen();
        }

        @Override
        public void close() throws IOException {
            this.channel.close();
        }

        public byte[] writtenBytes() {
            return this.out.toByteArray();
        }
    }

    static enum CharSequenceType {
        STRING,
        ASCII_STRING;


        public CharSequence create(char[] cs) {
            switch (this) {
                case STRING: {
                    return new String(cs);
                }
                case ASCII_STRING: {
                    return new AsciiString(cs);
                }
            }
            throw new UnsupportedOperationException("Unknown type: " + (Object)((Object)this));
        }
    }
}

