/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBufAllocator;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocatorMetric;
import io.netty.buffer.ByteBufAllocatorMetricProvider;
import io.netty.buffer.ByteBufAllocatorTest;
import io.netty.buffer.SimpleLeakAwareByteBuf;
import io.netty.buffer.UnpooledDirectByteBuf;
import io.netty.buffer.UnpooledHeapByteBuf;
import io.netty.buffer.UnpooledUnsafeDirectByteBuf;
import io.netty.buffer.UnpooledUnsafeHeapByteBuf;
import io.netty.util.internal.PlatformDependent;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.Test;

public abstract class AbstractByteBufAllocatorTest<T extends AbstractByteBufAllocator>
extends ByteBufAllocatorTest {
    protected abstract T newAllocator(boolean var1);

    protected abstract T newUnpooledAllocator();

    @Override
    protected boolean isDirectExpected(boolean preferDirect) {
        return preferDirect && PlatformDependent.canReliabilyFreeDirectBuffers();
    }

    @Override
    protected final int defaultMaxCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected final int defaultMaxComponents() {
        return 16;
    }

    @Test
    public void testCalculateNewCapacity() {
        this.testCalculateNewCapacity(true);
        this.testCalculateNewCapacity(false);
    }

    private void testCalculateNewCapacity(boolean preferDirect) {
        T allocator = this.newAllocator(preferDirect);
        org.junit.jupiter.api.Assertions.assertEquals((int)8, (int)allocator.calculateNewCapacity(1, 8));
        org.junit.jupiter.api.Assertions.assertEquals((int)7, (int)allocator.calculateNewCapacity(1, 7));
        org.junit.jupiter.api.Assertions.assertEquals((int)64, (int)allocator.calculateNewCapacity(1, 129));
        org.junit.jupiter.api.Assertions.assertEquals((int)0x400000, (int)allocator.calculateNewCapacity(0x400000, 0x400001));
        org.junit.jupiter.api.Assertions.assertEquals((int)0x800000, (int)allocator.calculateNewCapacity(0x400001, 0x1000000));
        try {
            allocator.calculateNewCapacity(8, 7);
            org.junit.jupiter.api.Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            allocator.calculateNewCapacity(-1, 8);
            org.junit.jupiter.api.Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testUnsafeHeapBufferAndUnsafeDirectBuffer() {
        T allocator = this.newUnpooledAllocator();
        ByteBuf directBuffer = allocator.directBuffer();
        AbstractByteBufAllocatorTest.assertInstanceOf(directBuffer, PlatformDependent.hasUnsafe() ? UnpooledUnsafeDirectByteBuf.class : UnpooledDirectByteBuf.class);
        directBuffer.release();
        ByteBuf heapBuffer = allocator.heapBuffer();
        AbstractByteBufAllocatorTest.assertInstanceOf(heapBuffer, PlatformDependent.hasUnsafe() ? UnpooledUnsafeHeapByteBuf.class : UnpooledHeapByteBuf.class);
        heapBuffer.release();
    }

    protected static void assertInstanceOf(ByteBuf buffer, Class<? extends ByteBuf> clazz) {
        if (buffer instanceof SimpleLeakAwareByteBuf) {
            buffer = buffer.unwrap();
        }
        Assertions.assertThat((Comparable)buffer).isInstanceOf(clazz);
    }

    protected static void assertSameBuffer(ByteBuf expected, ByteBuf buffer) {
        org.junit.jupiter.api.Assertions.assertSame((Object)expected, (Object)(buffer instanceof SimpleLeakAwareByteBuf ? buffer.unwrap() : buffer));
    }

    @Test
    void directBuffersMustHaveMemoryAddress() throws Exception {
        org.junit.jupiter.api.Assumptions.assumeTrue((PlatformDependent.hasUnsafe() || PlatformDependent.javaVersion() >= 25 ? 1 : 0) != 0);
        T allocator = this.newAllocator(true);
        ByteBuf buf = allocator.directBuffer();
        try {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)buf.hasMemoryAddress());
            org.junit.jupiter.api.Assertions.assertNotEquals((long)0L, (long)buf.memoryAddress());
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void testUsedDirectMemory() {
        T allocator = this.newAllocator(true);
        ByteBufAllocatorMetric metric = ((ByteBufAllocatorMetricProvider)allocator).metric();
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)metric.usedDirectMemory());
        ByteBuf buffer = allocator.directBuffer(1024, 4096);
        int capacity = buffer.capacity();
        org.junit.jupiter.api.Assertions.assertEquals((long)this.expectedUsedMemory(allocator, capacity), (long)metric.usedDirectMemory());
        buffer.capacity(capacity << 1);
        capacity = buffer.capacity();
        org.junit.jupiter.api.Assertions.assertEquals((long)this.expectedUsedMemory(allocator, capacity), (long)metric.usedDirectMemory(), (String)buffer.toString());
        buffer.release();
        org.junit.jupiter.api.Assertions.assertEquals((long)this.expectedUsedMemoryAfterRelease(allocator, capacity), (long)metric.usedDirectMemory());
    }

    @Test
    public void testUsedDirectMemoryHuge() {
        T allocator = this.newAllocator(true);
        ByteBufAllocatorMetric metric = ((ByteBufAllocatorMetricProvider)allocator).metric();
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)metric.usedHeapMemory());
        int size = 0x2000000;
        ByteBuf buffer = allocator.directBuffer(size, size);
        org.junit.jupiter.api.Assertions.assertEquals((long)size, (long)metric.usedDirectMemory());
        buffer.release();
    }

    @Test
    public void testUsedHeapMemory() {
        T allocator = this.newAllocator(true);
        ByteBufAllocatorMetric metric = ((ByteBufAllocatorMetricProvider)allocator).metric();
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)metric.usedHeapMemory());
        ByteBuf buffer = allocator.heapBuffer(1024, 4096);
        int capacity = buffer.capacity();
        org.junit.jupiter.api.Assertions.assertEquals((long)this.expectedUsedMemory(allocator, capacity), (long)metric.usedHeapMemory());
        buffer.capacity(capacity << 1);
        capacity = buffer.capacity();
        org.junit.jupiter.api.Assertions.assertEquals((long)this.expectedUsedMemory(allocator, capacity), (long)metric.usedHeapMemory());
        buffer.release();
        org.junit.jupiter.api.Assertions.assertEquals((long)this.expectedUsedMemoryAfterRelease(allocator, capacity), (long)metric.usedHeapMemory());
    }

    @Test
    public void testUsedHeapMemoryHuge() {
        T allocator = this.newAllocator(true);
        ByteBufAllocatorMetric metric = ((ByteBufAllocatorMetricProvider)allocator).metric();
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)metric.usedHeapMemory());
        int size = 0x2000000;
        ByteBuf buffer = allocator.heapBuffer(size, size);
        org.junit.jupiter.api.Assertions.assertEquals((long)size, (long)metric.usedHeapMemory());
        buffer.release();
    }

    @Test
    public void shouldReuseChunks() throws Exception {
        int bufSize = 0x100000;
        T allocator = this.newAllocator(false);
        allocator.heapBuffer(bufSize, bufSize).release();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        Class<?> cls = null;
        try {
            cls = Class.forName("com.sun.management.ThreadMXBean");
        }
        catch (ClassNotFoundException e) {
            org.junit.jupiter.api.Assumptions.abort((String)"Internal ThreadMXBean not available");
        }
        Assumptions.assumeThat((Object)threadMXBean).isInstanceOf(cls);
        Method getThreadAllocatedBytes = cls.getDeclaredMethod("getThreadAllocatedBytes", Long.TYPE);
        long allocBefore = (Long)getThreadAllocatedBytes.invoke((Object)threadMXBean, Thread.currentThread().getId());
        org.junit.jupiter.api.Assumptions.assumeTrue((allocBefore != -1L ? 1 : 0) != 0);
        for (int i = 0; i < 100; ++i) {
            allocator.heapBuffer(bufSize, bufSize).release();
        }
        long allocAfter = (Long)getThreadAllocatedBytes.invoke((Object)threadMXBean, Thread.currentThread().getId());
        org.junit.jupiter.api.Assumptions.assumeTrue((allocAfter != -1L ? 1 : 0) != 0);
        ((AbstractLongAssert)Assertions.assertThat((long)(allocAfter - allocBefore)).as("allocated MB: %.3f", new Object[]{(double)(allocAfter - allocBefore) / 1024.0 / 1024.0})).isLessThan(0x800000L);
    }

    protected long expectedUsedMemory(T allocator, int capacity) {
        return capacity;
    }

    protected long expectedUsedMemoryAfterRelease(T allocator, int capacity) {
        return 0L;
    }

    protected void trimCaches(T allocator) {
    }
}

