/*
 * Decompiled with CFR 0.152.
 */
package monix.connect.mongodb;

import com.mongodb.connection.ClusterDescription;
import com.mongodb.reactivestreams.client.MongoClient;
import com.mongodb.reactivestreams.client.MongoDatabase;
import monix.connect.mongodb.MongoDb$;
import monix.connect.mongodb.internal.MongoDbImpl;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005Ut!\u0002\u0011\"\u0011\u0003Ac!\u0002\u0016\"\u0011\u0003Y\u0003\"\u0002\u001a\u0002\t\u0003\u0019\u0004\"\u0002\u001b\u0002\t\u0003)\u0004B\u0002/\u0002\t\u0003\n)\u0005\u0003\u0004x\u0003\u0011\u0005\u00131\n\u0005\u0007w\u0006!\t%a\u0014\t\u000f\u0005\r\u0011\u0001\"\u0011\u0002V!9\u0011qC\u0001\u0005B\u0005m\u0003bBA\u0010\u0003\u0011\u0005\u0013\u0011\r\u0005\b\u0003W\tA\u0011IA7\u0011\u001d\ty$\u0001C!\u0003c2AAK\u0011\u0001o!I\u0001\b\u0004BC\u0002\u0013\u0005\u0011%\u000f\u0005\t\t2\u0011\t\u0011)A\u0005u!IQ\t\u0004BC\u0002\u0013\u0005\u0011E\u0012\u0005\t\u00152\u0011\t\u0011)A\u0005\u000f\")!\u0007\u0004C\u0001\u0017\")a\n\u0004C\u0001\u001f\")A\f\u0004C\u0001;\")A\f\u0004C\u0001e\")q\u000f\u0004C\u0001q\")q\u000f\u0004C\u0001s\")1\u0010\u0004C\u0001y\")1\u0010\u0004C\u0001}\"9\u00111\u0001\u0007\u0005\u0002\u0005\u0015\u0001bBA\u0002\u0019\u0011\u0005\u0011\u0011\u0003\u0005\b\u0003/aA\u0011AA\r\u0011\u001d\ty\u0002\u0004C\u0001\u0003CAq!a\u000b\r\t\u0003\ti\u0003C\u0004\u0002,1!\t!a\u000f\t\u000f\u0005}B\u0002\"\u0001\u0002.\u00059Qj\u001c8h_\u0012\u0013'B\u0001\u0012$\u0003\u001diwN\\4pI\nT!\u0001J\u0013\u0002\u000f\r|gN\\3di*\ta%A\u0003n_:L\u0007p\u0001\u0001\u0011\u0005%\nQ\"A\u0011\u0003\u000f5{gnZ8EEN\u0011\u0011\u0001\f\t\u0003[Aj\u0011A\f\u0006\u0003_\u0005\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003c9\u00121\"T8oO>$%-S7qY\u00061A(\u001b8jiz\"\u0012\u0001K\u0001\u0006CB\u0004H.\u001f\u000b\u0006m\u0005\u0005\u00131\t\t\u0003S1\u0019\"\u0001\u0004\u0017\u0002\r\rd\u0017.\u001a8u+\u0005Q\u0004CA\u001eC\u001b\u0005a$B\u0001\u001d>\u0015\tqt(A\bsK\u0006\u001cG/\u001b<fgR\u0014X-Y7t\u0015\t\u0011\u0003IC\u0001B\u0003\r\u0019w.\\\u0005\u0003\u0007r\u00121\"T8oO>\u001cE.[3oi\u000691\r\\5f]R\u0004\u0013!C2veJ,g\u000e\u001e#c+\u00059\u0005CA\u001eI\u0013\tIEHA\u0007N_:<w\u000eR1uC\n\f7/Z\u0001\u000bGV\u0014(/\u001a8u\t\n\u0004Cc\u0001\u001cM\u001b\")\u0001(\u0005a\u0001u!)Q)\u0005a\u0001\u000f\u0006)r-\u001a;DYV\u001cH/\u001a:EKN\u001c'/\u001b9uS>tW#\u0001)\u0011\u0007E#f+D\u0001S\u0015\t\u0019V%\u0001\u0003fm\u0006d\u0017BA+S\u0005\u0011!\u0016m]6\u0011\u0005]SV\"\u0001-\u000b\u0005e{\u0014AC2p]:,7\r^5p]&\u00111\f\u0017\u0002\u0013\u00072,8\u000f^3s\t\u0016\u001c8M]5qi&|g.\u0001\tde\u0016\fG/Z\"pY2,7\r^5p]R\u0011a,\u001a\t\u0004#R{\u0006C\u00011d\u001b\u0005\t'\"\u00012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\f'\u0001B+oSRDQAZ\nA\u0002\u001d\fabY8mY\u0016\u001cG/[8o\u001d\u0006lW\r\u0005\u0002i_:\u0011\u0011.\u001c\t\u0003U\u0006l\u0011a\u001b\u0006\u0003Y\u001e\na\u0001\u0010:p_Rt\u0014B\u00018b\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001/\u001d\u0002\u0007'R\u0014\u0018N\\4\u000b\u00059\fGc\u00010tk\")A\u000f\u0006a\u0001O\u0006\u0011AM\u0019\u0005\u0006mR\u0001\raZ\u0001\u000bG>dG.Z2uS>t\u0017\u0001\u00043s_B$\u0015\r^1cCN,W#\u00010\u0015\u0005yS\b\"\u0002;\u0017\u0001\u00049\u0017A\u00043s_B\u001cu\u000e\u001c7fGRLwN\u001c\u000b\u0003=vDQA^\fA\u0002\u001d$BAX@\u0002\u0002!)A\u000f\u0007a\u0001O\")a\u000f\u0007a\u0001O\u0006\u0001R\r_5tiN\u001cu\u000e\u001c7fGRLwN\u001c\u000b\u0005\u0003\u000f\ty\u0001\u0005\u0003R)\u0006%\u0001c\u00011\u0002\f%\u0019\u0011QB1\u0003\u000f\t{w\u000e\\3b]\")a/\u0007a\u0001OR1\u0011qAA\n\u0003+AQ\u0001\u001e\u000eA\u0002\u001dDQA\u001e\u000eA\u0002\u001d\fa\"\u001a=jgR\u001cH)\u0019;bE\u0006\u001cX\r\u0006\u0003\u0002\b\u0005m\u0001BBA\u000f7\u0001\u0007q-\u0001\u0004eE:\u000bW.Z\u0001\u0011e\u0016t\u0017-\\3D_2dWm\u0019;j_:$b!a\u0002\u0002$\u0005\u001d\u0002BBA\u00139\u0001\u0007q-A\u0007pY\u0012\u001cu\u000e\u001c7fGRLwN\u001c\u0005\u0007\u0003Sa\u0002\u0019A4\u0002\u001b9,woQ8mY\u0016\u001cG/[8o\u0003=a\u0017n\u001d;D_2dWm\u0019;j_:\u001cXCAA\u0018!\u0015\t\t$a\u000eh\u001b\t\t\u0019DC\u0002\u00026\u0015\n\u0001B]3bGRLg/Z\u0005\u0005\u0003s\t\u0019D\u0001\u0006PEN,'O^1cY\u0016$B!a\f\u0002>!)AO\ba\u0001O\u0006iA.[:u\t\u0006$\u0018MY1tKNDQ\u0001O\u0002A\u0002iBQ\u0001^\u0002A\u0002\u001d#RAXA$\u0003\u0013BQ\u0001\u001e\u0003A\u0002\u001dCQA\u001a\u0003A\u0002\u001d$2AXA'\u0011\u0015!X\u00011\u0001H)\u0015q\u0016\u0011KA*\u0011\u0015!h\u00011\u0001H\u0011\u00151g\u00011\u0001h)\u0019\t9!a\u0016\u0002Z!)Ao\u0002a\u0001\u000f\")am\u0002a\u0001OR1\u0011qAA/\u0003?BQ\u0001\u000f\u0005A\u0002iBa!!\b\t\u0001\u00049G\u0003CA\u0004\u0003G\n)'!\u001b\t\u000bQL\u0001\u0019A$\t\r\u0005\u001d\u0014\u00021\u0001h\u0003EyG\u000eZ\"pY2,7\r^5p]:\u000bW.\u001a\u0005\u0007\u0003WJ\u0001\u0019A4\u0002#9,woQ8mY\u0016\u001cG/[8o\u001d\u0006lW\r\u0006\u0003\u00020\u0005=\u0004\"\u0002;\u000b\u0001\u00049E\u0003BA\u0018\u0003gBQ\u0001O\u0006A\u0002i\u0002")
public class MongoDb
extends MongoDbImpl {
    private final MongoClient client;
    private final MongoDatabase currentDb;

    public static MongoDb apply(MongoClient mongoClient, MongoDatabase mongoDatabase) {
        return MongoDb$.MODULE$.apply(mongoClient, mongoDatabase);
    }

    public MongoClient client() {
        return this.client;
    }

    public MongoDatabase currentDb() {
        return this.currentDb;
    }

    public Task<ClusterDescription> getClusterDescription() {
        return Task$.MODULE$.now((Object)this.client().getClusterDescription());
    }

    public Task<BoxedUnit> createCollection(String collectionName) {
        return super.createCollection(this.currentDb(), collectionName);
    }

    public Task<BoxedUnit> createCollection(String db, String collection) {
        return super.createCollection(this.client().getDatabase(db), collection);
    }

    public Task<BoxedUnit> dropDatabase() {
        return super.dropDatabase(this.currentDb());
    }

    public Task<BoxedUnit> dropDatabase(String db) {
        return Task$.MODULE$.fromReactivePublisher(this.client().getDatabase(db).drop()).void();
    }

    public Task<BoxedUnit> dropCollection(String collection) {
        return super.dropCollection(this.currentDb(), collection);
    }

    public Task<BoxedUnit> dropCollection(String db, String collection) {
        return Task$.MODULE$.fromReactivePublisher(this.client().getDatabase(db).getCollection(collection).drop()).void();
    }

    public Task<Object> existsCollection(String collection) {
        return super.existsCollection(this.currentDb(), collection);
    }

    public Task<Object> existsCollection(String db, String collection) {
        return super.existsCollection(this.client().getDatabase(db), collection);
    }

    public Task<Object> existsDatabase(String dbName) {
        return super.existsDatabase(this.client(), dbName);
    }

    public Task<Object> renameCollection(String oldCollection, String newCollection) {
        return super.renameCollection(this.currentDb(), oldCollection, newCollection);
    }

    public Observable<String> listCollections() {
        return super.listCollections(this.currentDb());
    }

    public Observable<String> listCollections(String db) {
        return super.listCollections(this.client().getDatabase(db));
    }

    public Observable<String> listDatabases() {
        return super.listDatabases(this.client());
    }

    public MongoDb(MongoClient client, MongoDatabase currentDb) {
        this.client = client;
        this.currentDb = currentDb;
    }
}

