/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.plotter.cli.internal;

import io.hotmoka.cli.AbstractCommand;
import io.hotmoka.cli.CommandException;
import io.hotmoka.crypto.Hex;
import io.mokamint.nonce.api.Prolog;
import io.mokamint.plotter.Plots;
import io.mokamint.plotter.api.Plot;
import jakarta.websocket.EncodeException;
import java.io.IOException;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import picocli.CommandLine;

@CommandLine.Command(name="show", description={"Show a plot file."}, showDefaultValues=true)
public class Show
extends AbstractCommand {
    @CommandLine.Parameters(index="0", description={"the path of the new plot file"})
    private Path path;
    @CommandLine.Option(names={"--json"}, description={"print the output in JSON"}, defaultValue="false")
    private boolean json;

    protected void execute() throws CommandException {
        block13: {
            try (Plot plot = Plots.load((Path)this.path);){
                Prolog prolog = plot.getProlog();
                if (this.json) {
                    try {
                        System.out.println(new Plots.Encoder().encode((Object)plot));
                        break block13;
                    }
                    catch (EncodeException e) {
                        throw new CommandException("Cannot encode the plot in JSON format!", (Throwable)e);
                    }
                }
                System.out.println("* prolog:");
                System.out.println("  * chain identifier: " + prolog.getChainId());
                System.out.println("  * node's public key for signing blocks: " + prolog.getPublicKeyForSigningBlocksBase58() + " (" + String.valueOf(prolog.getSignatureForBlocks()) + ", base58)");
                System.out.println("  * plot's public key for signing deadlines: " + prolog.getPublicKeyForSigningDeadlinesBase58() + " (" + String.valueOf(prolog.getSignatureForDeadlines()) + ", base58)");
                System.out.println("  * extra: " + Hex.toHexString((byte[])prolog.getExtra()));
                long start = plot.getStart();
                System.out.println("* nonces: [" + start + "," + (start + plot.getLength()) + ")");
                System.out.println("* hashing for deadlines: " + String.valueOf(plot.getHashing()));
            }
            catch (NoSuchAlgorithmException e) {
                throw new CommandException("The plot file uses an unknown cryptographic algorithm!", (Throwable)e);
            }
            catch (InterruptedException e) {
                throw new CommandException("Interrupted while waiting!", (Throwable)e);
            }
            catch (IOException e) {
                throw new CommandException("Cannot read the plot file!", (Throwable)e);
            }
        }
    }
}

