/*
 * Decompiled with CFR 0.152.
 */
package io.mindmaps.migration.sql;

import com.google.common.collect.Lists;
import io.mindmaps.MindmapsGraph;
import io.mindmaps.concept.ResourceType;
import io.mindmaps.engine.loader.Loader;
import io.mindmaps.graql.Graql;
import io.mindmaps.graql.Var;
import io.mindmaps.migration.sql.Namer;
import io.mindmaps.migration.sql.SQLModel;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class SQLSchemaMigrator
implements Closeable {
    private Namer namer = new Namer(){};
    private Connection connection;
    private SQLModel metadata;
    private MindmapsGraph graph;

    public SQLSchemaMigrator configure(Connection connection) {
        this.connection = connection;
        this.metadata = new SQLModel(connection);
        return this;
    }

    public SQLSchemaMigrator graph(MindmapsGraph graph) {
        this.graph = graph;
        return this;
    }

    public Collection<Var> migrate() {
        HashSet<Var> vars = new HashSet<Var>();
        for (SQLModel.SQLTable aMetadata : this.metadata) {
            vars.addAll(this.migrateAsEntity(aMetadata));
            vars.addAll(this.migrateColumns(aMetadata));
        }
        return vars;
    }

    public SQLSchemaMigrator migrate(Loader loader) {
        loader.addToQueue(this.migrate());
        loader.flush();
        loader.waitToFinish();
        return this;
    }

    @Override
    public void close() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private Collection<Var> migrateColumns(SQLModel.SQLTable currentTable) {
        ArrayList<Var> vars = new ArrayList<Var>();
        String tableType = currentTable.getEntityType();
        Map<String, ResourceType.DataType> columns = currentTable.getColumns();
        Map<String, String> foreignColumns = currentTable.getForeignKeyColumns();
        for (String column : columns.keySet()) {
            ResourceType.DataType columnType = columns.get(column);
            if (foreignColumns.containsKey(column)) {
                vars.addAll(this.migrateAsRelation(tableType, column, foreignColumns.get(column)));
                continue;
            }
            vars.addAll(this.migrateAsResource(tableType, columnType, column));
        }
        return vars;
    }

    private Collection<Var> migrateAsEntity(SQLModel.SQLTable currentTable) {
        Var type = Graql.var().isa("entity-type").id(currentTable.getEntityType());
        return Lists.newArrayList((Object[])new Var[]{type});
    }

    private Collection<Var> migrateAsResource(String ownerType, ResourceType.DataType columnType, String columnName) {
        String resourceName = this.namer.resourceName(ownerType, columnName);
        Var resourceType = Graql.var().id(resourceName).datatype(columnType).isa("resource-type");
        Var hasResource = Graql.var().id(ownerType).hasResource(resourceName);
        return Lists.newArrayList((Object[])new Var[]{resourceType, hasResource});
    }

    private Collection<Var> migrateAsRelation(String entityTypeParent, String columnType, String childType) {
        String roleParentName = this.namer.roleParentName(columnType);
        String roleChildName = this.namer.roleChildName(columnType);
        Var entityTypeChild = Graql.var().id(childType).isa("entity-type");
        Var roleTypeParent = Graql.var().id(roleParentName).isa("role-type");
        Var roleTypeChild = Graql.var().id(roleChildName).isa("role-type");
        Var relationType = Graql.var().id(this.namer.relationName(columnType)).isa("relation-type").hasRole(roleParentName).hasRole(roleChildName);
        Var entityTypeParentPlayingRole = Graql.var().id(entityTypeParent).playsRole(roleParentName);
        entityTypeChild.playsRole(roleChildName);
        return Lists.newArrayList((Object[])new Var[]{entityTypeChild, roleTypeParent, roleTypeChild, relationType, entityTypeParentPlayingRole});
    }
}

