/*
 * Decompiled with CFR 0.152.
 */
package io.mindmaps.migration.sql;

import com.google.common.collect.Lists;
import io.mindmaps.Mindmaps;
import io.mindmaps.MindmapsGraph;
import io.mindmaps.engine.loader.BlockingLoader;
import io.mindmaps.engine.loader.DistributedLoader;
import io.mindmaps.engine.loader.Loader;
import io.mindmaps.migration.sql.SQLDataMigrator;
import io.mindmaps.migration.sql.SQLSchemaMigrator;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Collection;

public class Main {
    static void die(String errorMsg) {
        System.out.println(errorMsg);
        System.out.println("\nSyntax: ./migration.sh sql -driver <jdbc driver> -database <database url> -user <username> -pass <password> [-engine <Mindmaps engine URL>] -graph <graph name>");
        System.exit(-1);
    }

    public static void main(String[] args) {
        String jdbcDriver = null;
        String jdbcDBUrl = null;
        String jdbcUser = null;
        String jdbcPass = null;
        String engineURL = null;
        String graphName = null;
        for (int i = 0; i < args.length; ++i) {
            if ("-driver".equals(args[i])) {
                jdbcDriver = args[++i];
                continue;
            }
            if ("-database".equals(args[i])) {
                jdbcDBUrl = args[++i];
                continue;
            }
            if ("-user".equals(args[i])) {
                jdbcUser = args[++i];
                continue;
            }
            if ("-password".equals(args[i])) {
                jdbcPass = args[++i];
                continue;
            }
            if ("-graph".equals(args[i])) {
                graphName = args[++i];
                continue;
            }
            if ("-engine".equals(args[i])) {
                engineURL = args[++i];
                continue;
            }
            if ("sql".equals(args[0])) continue;
            Main.die("Unknown option " + args[i]);
        }
        if (jdbcDriver == null) {
            Main.die("Please specify the JDBC diver on the classpath using -driver option");
        }
        if (jdbcDBUrl == null) {
            Main.die("Please specify the URL where the SQL db is running using -database option");
        }
        if (jdbcUser == null) {
            Main.die("Please specify the username of the database using the -user option");
        }
        if (jdbcPass == null) {
            Main.die("Please specify the password of the database using the -pass option");
        }
        if (graphName == null) {
            Main.die("Please specify the name of the graph using the -graph option");
        }
        System.out.println("Migrating " + jdbcDBUrl + " using MM Engine " + (engineURL == null ? "local" : engineURL) + " into graph " + graphName);
        SQLSchemaMigrator schemaMigrator = new SQLSchemaMigrator();
        SQLDataMigrator dataMigrator = new SQLDataMigrator();
        try {
            MindmapsGraph graph = engineURL == null ? Mindmaps.factory((String)"localhost:4567", (String)graphName).getGraph() : Mindmaps.factory((String)engineURL, (String)graphName).getGraph();
            BlockingLoader loader = engineURL == null ? new BlockingLoader(graphName) : new DistributedLoader(graphName, (Collection)Lists.newArrayList((Object[])new String[]{engineURL}));
            Class.forName(jdbcDriver).newInstance();
            Connection connection = DriverManager.getConnection(jdbcDBUrl, jdbcUser, jdbcPass);
            schemaMigrator.graph(graph).configure(connection).migrate((Loader)loader).close();
            System.out.println("Schema migration successful");
            dataMigrator.graph(graph).configure(connection).migrate((Loader)loader).close();
            System.out.println("DataType migration successful");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
        }
        System.exit(0);
    }
}

