/*
 * Decompiled with CFR 0.152.
 */
package io.mindmaps.migration.sql;

import io.mindmaps.concept.ResourceType;
import io.mindmaps.migration.sql.SQLType;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLModel
implements Iterable<SQLTable> {
    private static final Logger logger = LoggerFactory.getLogger(SQLModel.class);
    private Connection connection;
    private List<SQLTable> tables;

    public SQLModel(Connection connection) {
        this.connection = connection;
        this.tables = new ArrayList<SQLTable>();
        ResultSet results = null;
        try {
            results = connection.getMetaData().getTables(null, null, null, new String[]{"TABLE"});
            while (results.next()) {
                String tableName = results.getString("TABLE_NAME");
                this.tables.add(new SQLTable(tableName, connection));
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                SQLModel.closeQuietly(results);
                throw throwable;
            }
        }
        SQLModel.closeQuietly(results);
    }

    public static void closeQuietly(AutoCloseable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Exception e) {
            logger.error("An error occurred closing statement.", (Throwable)e);
        }
    }

    @Override
    public Iterator<SQLTable> iterator() {
        return new Iterator<SQLTable>(){
            int currentTableIndex = 0;

            @Override
            public boolean hasNext() {
                return this.currentTableIndex < SQLModel.this.tables.size();
            }

            @Override
            public SQLTable next() {
                return (SQLTable)SQLModel.this.tables.get(this.currentTableIndex++);
            }
        };
    }

    class SQLTable {
        private String type;
        private List<String> primaryKeyColumns;
        private Map<String, String> foreignKeyColumns;
        private Map<String, ResourceType.DataType> columnTypes;

        SQLTable(String type, Connection connection) {
            this.type = type;
            this.columnTypes = new HashMap<String, ResourceType.DataType>();
            this.primaryKeyColumns = new ArrayList<String>();
            this.foreignKeyColumns = new HashMap<String, String>();
            try {
                this.getColumns(connection);
                this.getPrimaryKeyColumns(connection);
                this.getForeignKeyColumns(connection);
            }
            catch (SQLException e) {
                logger.error("Error migrating metadata of table " + type);
                throw new RuntimeException(e);
            }
        }

        public String getEntityType() {
            return this.type;
        }

        public Connection getConnection() {
            return SQLModel.this.connection;
        }

        public List<String> getPrimaryKeyColumns() {
            return this.primaryKeyColumns;
        }

        public Map<String, String> getForeignKeyColumns() {
            return this.foreignKeyColumns;
        }

        public Map<String, ResourceType.DataType> getColumns() {
            return this.columnTypes;
        }

        private void getColumns(Connection connection) throws SQLException {
            ResultSet results = connection.getMetaData().getColumns(null, "public", this.type, null);
            results = !results.first() ? connection.getMetaData().getColumns(null, "PUBLIC", this.type, null) : connection.getMetaData().getColumns(null, "public", this.type, null);
            while (results.next()) {
                String name = results.getString("COLUMN_NAME");
                ResourceType.DataType type = SQLType.getDatatype(results.getInt("DATA_TYPE"));
                this.columnTypes.put(name, type);
            }
            SQLModel.closeQuietly(results);
        }

        private void getPrimaryKeyColumns(Connection connection) throws SQLException {
            ResultSet results = connection.getMetaData().getPrimaryKeys(null, null, this.type);
            while (results.next()) {
                if (results.getString("COLUMN_NAME") == null) continue;
                this.primaryKeyColumns.add(results.getString("COLUMN_NAME"));
            }
            SQLModel.closeQuietly(results);
        }

        private void getForeignKeyColumns(Connection connection) throws SQLException {
            ResultSet results = connection.getMetaData().getImportedKeys(null, null, this.type);
            while (results.next()) {
                String foreignKeyName = results.getString("FKCOLUMN_NAME");
                if (foreignKeyName == null) continue;
                String pkName = results.getString("PKTABLE_NAME");
                this.foreignKeyColumns.put(foreignKeyName, pkName);
            }
            SQLModel.closeQuietly(results);
        }

        public Collection<String> getPrimaryKeyValues(ResultSet row) throws SQLException {
            ArrayList<String> values = new ArrayList<String>();
            for (String key : this.primaryKeyColumns) {
                if (row.getObject(key) == null) continue;
                values.add(row.getObject(key).toString());
            }
            return values;
        }
    }
}

