/*
 * Decompiled with CFR 0.152.
 */
package io.mindmaps.migration.sql;

import com.google.common.base.Throwables;
import io.mindmaps.MindmapsGraph;
import io.mindmaps.concept.ResourceType;
import io.mindmaps.engine.loader.Loader;
import io.mindmaps.graql.Graql;
import io.mindmaps.graql.Var;
import io.mindmaps.migration.sql.Namer;
import io.mindmaps.migration.sql.SQLModel;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLDataMigrator
implements Iterable<Collection<Var>>,
Closeable {
    private final Logger logger = LoggerFactory.getLogger(SQLDataMigrator.class);
    private Namer namer = new Namer(){};
    private MindmapsGraph graph;
    private Connection connection;
    private SQLModel metadata;

    public SQLDataMigrator configure(Connection connection) {
        this.connection = connection;
        this.metadata = new SQLModel(connection);
        return this;
    }

    public SQLDataMigrator graph(MindmapsGraph graph) {
        this.graph = graph;
        return this;
    }

    public Collection<Var> migrate() {
        HashSet<Var> collection = new HashSet<Var>();
        for (Collection<Var> vars : this) {
            collection.addAll(vars);
        }
        return collection;
    }

    public SQLDataMigrator migrate(Loader loader) {
        for (Collection<Var> vars : this) {
            loader.addToQueue(vars);
        }
        loader.flush();
        loader.waitToFinish();
        return this;
    }

    @Override
    public Iterator<Collection<Var>> iterator() {
        return new Iterator<Collection<Var>>(){
            Iterator<SQLModel.SQLTable> tables;
            PreparedStatement currentStatement;
            SQLModel.SQLTable currentTable;
            ResultSet currentRow;
            {
                this.tables = SQLDataMigrator.this.metadata.iterator();
                this.currentStatement = null;
                this.currentTable = null;
                this.currentRow = null;
            }

            @Override
            public boolean hasNext() {
                try {
                    if (this.currentRow != null && !this.currentRow.isLast()) {
                        return true;
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                boolean tableExists = this.tables.hasNext();
                if (!tableExists) {
                    this.closeRows();
                }
                return tableExists;
            }

            @Override
            public Collection<Var> next() {
                try {
                    this.moveReferences();
                    return SQLDataMigrator.this.migrateRow(this.currentTable, this.currentRow);
                }
                catch (Throwable e) {
                    SQLDataMigrator.this.logger.error("Error migrating row " + this.currentRow + " from table " + this.currentTable);
                    SQLDataMigrator.this.logger.error(Throwables.getStackTraceAsString((Throwable)e));
                    return Collections.EMPTY_SET;
                }
            }

            public void moveReferences() throws SQLException {
                if (this.currentRow == null || this.currentRow.isLast()) {
                    this.nextTable();
                } else {
                    this.nextRow();
                }
            }

            public void nextRow() throws SQLException {
                this.currentRow.next();
            }

            public void nextTable() throws SQLException {
                if (this.tables.hasNext()) {
                    this.currentTable = this.tables.next();
                    this.openRows();
                }
            }

            private void openRows() {
                String statement = "select * from " + this.currentTable.getEntityType();
                try {
                    this.currentStatement = SQLDataMigrator.this.connection.prepareStatement(statement, 1004, 1008);
                    this.currentRow = this.currentStatement.executeQuery();
                    if (!this.currentRow.first()) {
                        this.nextTable();
                    }
                }
                catch (SQLException e) {
                    this.closeRows();
                    SQLDataMigrator.this.logger.error("Error in statement " + statement);
                    throw new RuntimeException(e);
                }
            }

            public void closeRows() {
                SQLModel.closeQuietly(this.currentRow);
                SQLModel.closeQuietly(this.currentStatement);
            }
        };
    }

    @Override
    public void close() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private Collection<Var> migrateRow(SQLModel.SQLTable currentTable, ResultSet row) throws SQLException {
        String tableType = currentTable.getEntityType();
        Collection<String> primaryKeyValues = currentTable.getPrimaryKeyValues(row);
        Var instance = Graql.var().isa(tableType).id(this.namer.primaryKey(tableType, primaryKeyValues));
        Collection<Var> vars = this.migrateColumns(currentTable, row, instance);
        vars.add(instance);
        return vars;
    }

    private Collection<Var> migrateColumns(SQLModel.SQLTable table, ResultSet row, Var instance) throws SQLException {
        String tableType = table.getEntityType();
        Map<String, ResourceType.DataType> columns = table.getColumns();
        Map<String, String> foreign = table.getForeignKeyColumns();
        ResultSetMetaData metadata = row.getMetaData();
        ArrayList<Var> vars = new ArrayList<Var>();
        for (int i = 1; i <= metadata.getColumnCount(); ++i) {
            String columnName = metadata.getColumnName(i);
            Object columnValue = row.getObject(columnName);
            ResourceType.DataType dataType = columns.get(columnName);
            String foreignKey = foreign.get(columnName);
            if (foreignKey != null) {
                vars.addAll(this.migrateColumnValueAsRelation(instance, columnName, foreignKey, columnValue));
                continue;
            }
            vars.addAll(this.migrateColumnValueAsResource(instance, columnName, this.cast(dataType, columnName, row), tableType));
        }
        return vars;
    }

    private Collection<Var> migrateColumnValueAsResource(Var instance, String columnName, Object columnValue, String tableName) {
        if (columnValue == null) {
            return Collections.emptyList();
        }
        return Collections.singleton(Graql.var().id(this.id(instance)).has(this.namer.resourceName(tableName, columnName), columnValue));
    }

    private Collection<Var> migrateColumnValueAsRelation(Var parent, String fkName, String childType, Object childId) {
        if (childId == null) {
            return Collections.emptyList();
        }
        String relationType = this.namer.relationName(fkName);
        String childRole = this.namer.roleChildName(fkName);
        String parentRole = this.namer.roleParentName(fkName);
        String foreignPrimaryKey = this.namer.primaryKey(childType, Collections.singleton(childId.toString()));
        Var child = Graql.var().isa(childType).id(foreignPrimaryKey);
        Var relation = Graql.var().rel(childRole, Graql.var().id(this.id(child))).rel(parentRole, Graql.var().id(this.id(parent))).isa(relationType);
        return Arrays.asList(child, relation);
    }

    private Object cast(ResourceType.DataType type, String column, ResultSet row) throws SQLException {
        if (ResourceType.DataType.BOOLEAN == type) {
            return row.getBoolean(column);
        }
        if (ResourceType.DataType.STRING == type) {
            return row.getString(column);
        }
        if (ResourceType.DataType.LONG == type) {
            return row.getLong(column);
        }
        if (ResourceType.DataType.DOUBLE == type) {
            return row.getDouble(column);
        }
        return null;
    }

    private String id(Var instance) {
        return (String)instance.admin().getId().get();
    }
}

