/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.channel;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Factory;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.http.netty.configuration.NettyGlobalConfiguration;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.NettyRuntime;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.FastThreadLocalThread;
import io.netty.util.internal.SystemPropertyUtil;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.concurrent.ThreadFactory;
import reactor.core.scheduler.NonBlocking;

@Singleton
@Factory
@TypeHint(value={NioServerSocketChannel.class, NioSocketChannel.class}, typeNames={"sun.security.ssl.SSLContextImpl$TLSContext"}, accessType={TypeHint.AccessType.ALL_DECLARED_CONSTRUCTORS, TypeHint.AccessType.ALL_DECLARED_FIELDS, TypeHint.AccessType.ALL_PUBLIC_CONSTRUCTORS})
@BootstrapContextCompatible
public class NettyThreadFactory {
    public static final String NAME = "netty";
    @Deprecated(forRemoval=true, since="4.2.0")
    public static final int DEFAULT_EVENT_LOOP_THREADS = 1;
    private final NettyGlobalConfiguration configuration;

    @Inject
    public NettyThreadFactory(NettyGlobalConfiguration configuration) {
        this.configuration = configuration;
    }

    @Deprecated
    public NettyThreadFactory() {
        this(new NettyGlobalConfiguration());
    }

    public static int getDefaultEventLoopThreads() {
        return EventLoopThreadsHolder.DEFAULT_EVENT_LOOP_THREADS;
    }

    @Singleton
    @Named(value="netty")
    @BootstrapContextCompatible
    protected ThreadFactory nettyThreadFactory() {
        String poolName = "default-" + DefaultThreadFactory.toPoolName(NioEventLoopGroup.class);
        if (this.configuration.isDefaultThreadFactoryReactorNonBlocking()) {
            return new DefaultThreadFactory(poolName, this.configuration.isDefaultThreadFactoryDaemon(), this.configuration.getDefaultThreadFactoryPriority()){

                protected Thread newThread(Runnable r, String name) {
                    return new NonBlockingFastThreadLocalThread(this.threadGroup, r, name);
                }
            };
        }
        return new DefaultThreadFactory(poolName, this.configuration.isDefaultThreadFactoryDaemon(), this.configuration.getDefaultThreadFactoryPriority());
    }

    private static final class EventLoopThreadsHolder {
        static final int DEFAULT_EVENT_LOOP_THREADS = Math.max(1, SystemPropertyUtil.getInt((String)"io.netty.eventLoopThreads", (int)(NettyRuntime.availableProcessors() * 2)));

        private EventLoopThreadsHolder() {
        }
    }

    private static final class NonBlockingFastThreadLocalThread
    extends FastThreadLocalThread
    implements NonBlocking {
        public NonBlockingFastThreadLocalThread(ThreadGroup group, Runnable target, String name) {
            super(group, target, name);
        }
    }
}

