/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.channel;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.netty.channel.EventLoopGroupConfiguration;
import io.micronaut.http.netty.channel.EventLoopGroupFactory;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import javax.inject.Singleton;

@Internal
@Singleton
@BootstrapContextCompatible
public class NioEventLoopGroupFactory
implements EventLoopGroupFactory {
    @Override
    public EventLoopGroup createEventLoopGroup(int threads, @Nullable Integer ioRatio) {
        return NioEventLoopGroupFactory.withIoRatio(new NioEventLoopGroup(threads), ioRatio);
    }

    @Override
    public EventLoopGroup createEventLoopGroup(int threads, ThreadFactory threadFactory, @Nullable Integer ioRatio) {
        return NioEventLoopGroupFactory.withIoRatio(new NioEventLoopGroup(threads, threadFactory), ioRatio);
    }

    @Override
    public EventLoopGroup createEventLoopGroup(int threads, Executor executor, @Nullable Integer ioRatio) {
        return NioEventLoopGroupFactory.withIoRatio(new NioEventLoopGroup(threads, executor), ioRatio);
    }

    @Override
    public EventLoopGroup createEventLoopGroup(@Nullable Integer ioRatio) {
        return NioEventLoopGroupFactory.withIoRatio(new NioEventLoopGroup(), ioRatio);
    }

    @Override
    public Class<? extends ServerSocketChannel> serverSocketChannelClass() {
        return NioServerSocketChannel.class;
    }

    public NioServerSocketChannel serverSocketChannelInstance(EventLoopGroupConfiguration configuration) {
        return new NioServerSocketChannel();
    }

    @Override
    @NonNull
    public Class<? extends SocketChannel> clientSocketChannelClass(@Nullable EventLoopGroupConfiguration configuration) {
        return NioSocketChannel.class;
    }

    @Override
    public SocketChannel clientSocketChannelInstance(EventLoopGroupConfiguration configuration) {
        return new NioSocketChannel();
    }

    private static NioEventLoopGroup withIoRatio(NioEventLoopGroup group, @Nullable Integer ioRatio) {
        if (ioRatio != null) {
            group.setIoRatio(ioRatio.intValue());
        }
        return group;
    }
}

