/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.executor;

import io.micronaut.context.ApplicationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.cli.CommandLine;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.function.LocalFunctionRegistry;
import io.micronaut.function.executor.AbstractExecutor;
import io.micronaut.function.executor.DefaultFunctionExitHandler;
import io.micronaut.function.executor.FunctionApplication;
import io.micronaut.function.executor.FunctionExitHandler;
import io.micronaut.function.executor.StreamFunctionExecutor;
import io.micronaut.http.MediaType;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import java.io.Closeable;
import java.io.IOException;
import java.util.function.Function;

public class FunctionInitializer
extends AbstractExecutor
implements Closeable,
AutoCloseable {
    protected final boolean closeContext;
    private FunctionExitHandler functionExitHandler = new DefaultFunctionExitHandler();

    public FunctionInitializer() {
        ApplicationContext applicationContext = this.buildApplicationContext(null);
        this.startThis(applicationContext);
        this.injectThis(applicationContext);
        applicationContext.registerSingleton((Object)this, false);
        this.closeContext = true;
    }

    protected FunctionInitializer(ApplicationContext applicationContext) {
        this(applicationContext, true);
    }

    protected FunctionInitializer(ApplicationContext applicationContext, boolean inject) {
        this.applicationContext = applicationContext;
        this.closeContext = false;
        if (inject) {
            this.injectThis(applicationContext);
        }
    }

    @Override
    @Internal
    public void close() throws IOException {
        if (this.closeContext && this.applicationContext != null) {
            this.applicationContext.close();
        }
    }

    public void run(String[] args, Function<ParseContext, ?> supplier) throws IOException {
        ApplicationContext applicationContext = this.applicationContext;
        this.functionExitHandler = applicationContext.findBean(FunctionExitHandler.class).orElse(this.functionExitHandler);
        ParseContext context = new ParseContext(args);
        try {
            Object result = supplier.apply(context);
            if (result != null) {
                LocalFunctionRegistry bean = (LocalFunctionRegistry)applicationContext.getBean(LocalFunctionRegistry.class);
                StreamFunctionExecutor.encode(applicationContext.getEnvironment(), bean, result.getClass(), result, System.out);
                this.functionExitHandler.exitWithSuccess();
            }
        }
        catch (Exception e) {
            this.functionExitHandler.exitWithError(e, context.debug);
        }
    }

    protected void startThis(ApplicationContext applicationContext) {
        this.startEnvironment(applicationContext);
    }

    protected void injectThis(ApplicationContext applicationContext) {
        if (applicationContext != null) {
            applicationContext.inject((Object)this);
        }
    }

    public class ParseContext {
        private final String data;
        private final boolean debug;

        ParseContext(String[] args) {
            CommandLine commandLine = FunctionApplication.parseCommandLine(args);
            this.debug = commandLine.hasOption("x");
            this.data = commandLine.hasOption("d") ? commandLine.optionValue("d").toString() : null;
        }

        public final <T> T get(Class<T> type) {
            if (ClassUtils.isJavaLangType(type)) {
                return FunctionInitializer.this.applicationContext.getConversionService().convert((Object)this.data, type).orElseThrow(() -> this.newIllegalArgument(type, this.data));
            }
            MediaTypeCodecRegistry codecRegistry = (MediaTypeCodecRegistry)FunctionInitializer.this.applicationContext.getBean(MediaTypeCodecRegistry.class);
            return (T)codecRegistry.findCodec(MediaType.APPLICATION_JSON_TYPE).map(codec -> {
                if (this.data != null) {
                    return codec.decode(type, this.data);
                }
                return codec.decode(type, System.in);
            }).orElseThrow(() -> this.newIllegalArgument(type, this.data));
        }

        private <T> IllegalArgumentException newIllegalArgument(Class<T> dataType, String data) {
            if (data != null) {
                return new IllegalArgumentException("Passed data [" + data + "] cannot be converted to type: " + dataType);
            }
            return new IllegalArgumentException("Input data cannot be converted to type: " + dataType);
        }
    }
}

