DROP TABLE IF EXISTS ${schema}.Issue;
DROP TABLE IF EXISTS ${schema}.IssueAttributes;
DROP TABLE IF EXISTS ${schema}.IssueWatcher;
DROP TABLE IF EXISTS ${schema}.IssueComment;
DROP TABLE IF EXISTS ${schema}.IssueFile;
DROP TABLE IF EXISTS ${schema}.IssueAssignee;

CREATE TABLE ${schema}.Issue (
  Id                 int                                     NOT NULL IDENTITY,
  CreatedAt          datetime2 DEFAULT getdate(),
  AuditUserId        int,
  Deleted            bit       DEFAULT 0,
  PeriodStart        datetime2 GENERATED ALWAYS AS ROW START NOT NULL,
  PeriodEnd          datetime2 GENERATED ALWAYS AS ROW END   NOT NULL,
  AuthorId           int,
  Number             nvarchar(512),
  Subject            nvarchar(max),
  Description        nvarchar(max),
  IssueDate          datetime2 DEFAULT getdate(),
  PlannedDate        datetime2,
  StatusCode         nvarchar(512),
  StatusDate         datetime2 DEFAULT getdate(),
  PriorityCode       nvarchar(512),
  ReferenceId        int,
  ReferenceType      nvarchar(512),
  TypeCode           nvarchar(512),
  ExternalUserId     nvarchar(512),
  CONSTRAINT Pk_Issue_Id PRIMARY KEY (Id),
  PERIOD FOR SYSTEM_TIME (PeriodStart, PeriodEnd)
)
WITH (
    SYSTEM_VERSIONING = ON (HISTORY_TABLE = ${auditSchema}.Issue, DATA_CONSISTENCY_CHECK = ON)
);

CREATE INDEX Idx_Issue_ReferenceId ON ${schema}.Issue (ReferenceId);
CREATE INDEX Idx_Issue_ReferenceType ON ${schema}.Issue (ReferenceType);
CREATE INDEX Idx_Issue_TypeCode ON ${schema}.Issue (TypeCode);

CREATE TABLE ${schema}.IssueAttributes (
  Id                 int                                     NOT NULL IDENTITY,
  CreatedAt          datetime2 DEFAULT getdate(),
  AuditUserId        int,
  Deleted            bit       DEFAULT 0,
  PeriodStart        datetime2 GENERATED ALWAYS AS ROW START NOT NULL,
  PeriodEnd          datetime2 GENERATED ALWAYS AS ROW END   NOT NULL,
  IssueId            int,
  Code               nvarchar(512),
  Type               nvarchar(512),
  StringValue        nvarchar(max),
  LongValue          int,
  DecimalValue       numeric(17,2),
  DateValue          datetime2,
  DateTimeValue      datetime2,
  CONSTRAINT Pk_IssueAttributes_Id PRIMARY KEY (Id),
  PERIOD FOR SYSTEM_TIME (PeriodStart, PeriodEnd)
)
WITH (
    SYSTEM_VERSIONING = ON (HISTORY_TABLE = ${auditSchema}.IssueAttributes, DATA_CONSISTENCY_CHECK = ON)
);


CREATE INDEX Idx_IssueAttributes_IssueId ON ${schema}.IssueAttributes (IssueId);
ALTER TABLE ${schema}.IssueAttributes
  ADD CONSTRAINT Fk_IssueAttributes_IssueId FOREIGN KEY (IssueId) REFERENCES ${schema}.Issue (Id)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;

CREATE TABLE ${schema}.IssueWatcher (
  Id                 int                                     NOT NULL IDENTITY,
  CreatedAt          datetime2 DEFAULT getdate(),
  AuditUserId        int,
  Deleted            bit       DEFAULT 0,
  PeriodStart        datetime2 GENERATED ALWAYS AS ROW START NOT NULL,
  PeriodEnd          datetime2 GENERATED ALWAYS AS ROW END   NOT NULL,
  IssueId            int,
  UserId             int,
  CONSTRAINT Pk_IssueWatcher_Id PRIMARY KEY (Id),
  PERIOD FOR SYSTEM_TIME (PeriodStart, PeriodEnd)
)
WITH (
    SYSTEM_VERSIONING = ON (HISTORY_TABLE = ${auditSchema}.IssueWatcher, DATA_CONSISTENCY_CHECK = ON)
);

CREATE INDEX Idx_IssueWatcher_IssueId
  ON ${schema}.IssueWatcher (IssueId);

ALTER TABLE ${schema}.IssueWatcher
  ADD CONSTRAINT Fk_IssueWatcher_IssueId FOREIGN KEY (IssueId) REFERENCES ${schema}.Issue (Id)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;

CREATE TABLE ${schema}.IssueComment (
  Id                 int                                     NOT NULL IDENTITY,
  CreatedAt          datetime2 DEFAULT getdate(),
  AuditUserId        int,
  Deleted            bit       DEFAULT 0,
  PeriodStart        datetime2 GENERATED ALWAYS AS ROW START NOT NULL,
  PeriodEnd          datetime2 GENERATED ALWAYS AS ROW END   NOT NULL,
  IssueId            int,
  AuthorId           int,
  CommentDate        datetime2 DEFAULT getdate(),
  Body               nvarchar(max),
  CONSTRAINT Pk_IssueComment_Id PRIMARY KEY (Id),
  PERIOD FOR SYSTEM_TIME (PeriodStart, PeriodEnd)
)
WITH (
    SYSTEM_VERSIONING = ON (HISTORY_TABLE = ${auditSchema}.IssueComment, DATA_CONSISTENCY_CHECK = ON)
);

CREATE INDEX Idx_IssueComment_Id
  ON ${schema}.IssueComment (IssueId);

ALTER TABLE ${schema}.IssueComment
  ADD CONSTRAINT Fk_IssueComment_IssueId FOREIGN KEY (IssueId) REFERENCES ${schema}.Issue (Id)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;

CREATE TABLE ${schema}.IssueFile (
  Id                 int                                     NOT NULL IDENTITY,
  CreatedAt          datetime2 DEFAULT getdate(),
  AuditUserId        int,
  Deleted            bit       DEFAULT 0,
  PeriodStart        datetime2 GENERATED ALWAYS AS ROW START NOT NULL,
  PeriodEnd          datetime2 GENERATED ALWAYS AS ROW END   NOT NULL,
  IssueId            int,
  CommentId          int,
  FileHash           nvarchar(512),
  CONSTRAINT Pk_IssueFile_Id PRIMARY KEY (Id),
  PERIOD FOR SYSTEM_TIME (PeriodStart, PeriodEnd)
)
WITH (
    SYSTEM_VERSIONING = ON (HISTORY_TABLE = ${auditSchema}.IssueFile, DATA_CONSISTENCY_CHECK = ON)
);

CREATE INDEX Idx_IssueFile_IssueId ON ${schema}.IssueFile (IssueId);
CREATE INDEX Idx_IssueFile_CommentId ON ${schema}.IssueFile (CommentId);

ALTER TABLE ${schema}.IssueFile
  ADD CONSTRAINT Fk_IssueFile_IssueId FOREIGN KEY (IssueId) REFERENCES ${schema}.Issue (Id)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;

ALTER TABLE ${schema}.IssueFile
  ADD CONSTRAINT Fk_IssueFile_CommentId FOREIGN KEY (CommentId) REFERENCES ${schema}.IssueComment (Id)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;



CREATE TABLE ${schema}.IssueAssignee (
  Id                 int                                     NOT NULL IDENTITY,
  CreatedAt          datetime2 DEFAULT getdate(),
  AuditUserId        int,
  Deleted            bit       DEFAULT 0,
  PeriodStart        datetime2 GENERATED ALWAYS AS ROW START NOT NULL,
  PeriodEnd          datetime2 GENERATED ALWAYS AS ROW END   NOT NULL,
  IssueId            int,
  UserId             int,
  CONSTRAINT Pk_IssueAssignee_Id PRIMARY KEY (Id),
  PERIOD FOR SYSTEM_TIME (PeriodStart, PeriodEnd)
)
WITH (
    SYSTEM_VERSIONING = ON (HISTORY_TABLE = ${auditSchema}.IssueAssignee, DATA_CONSISTENCY_CHECK = ON)
);

ALTER TABLE ${schema}.IssueAssignee
  ADD CONSTRAINT Fk_IssueAssignee_IssueId FOREIGN KEY (IssueId) REFERENCES ${schema}.Issue (Id);

