/*
 * Decompiled with CFR 0.152.
 */
package io.lsn.spring.issue.domain;

import io.lsn.spring.issue.configuration.IssueProperties;
import io.lsn.spring.issue.domain.EventDispatcher;
import io.lsn.spring.issue.domain.GenericIssueDao;
import io.lsn.spring.issue.domain.entity.Comment;
import io.lsn.spring.issue.domain.entity.Issue;
import io.lsn.spring.issue.domain.entity.UserInterface;
import io.lsn.spring.issue.domain.entity.event.IssueCreatedEvent;
import io.lsn.spring.issue.domain.entity.event.IssueUpdatedEvent;
import io.lsn.spring.issue.domain.entity.event.WatcherAddedEvent;
import io.lsn.spring.issue.domain.postgres.PostgresIssueDao;
import io.lsn.spring.issue.domain.sqlserver.SqlServerIssueDao;
import org.springframework.util.CollectionUtils;

public abstract class IssueAbstractService {
    private PostgresIssueDao postgresIssueDao;
    private SqlServerIssueDao sqlServerIssueDao;
    private EventDispatcher dispatcher;
    private IssueProperties properties;

    public IssueAbstractService(PostgresIssueDao postgresIssueDao, IssueProperties properties, EventDispatcher dispatcher) {
        this.postgresIssueDao = postgresIssueDao;
        this.properties = properties;
        this.dispatcher = dispatcher;
    }

    public IssueAbstractService(SqlServerIssueDao sqlServerIssueDao, IssueProperties properties, EventDispatcher dispatcher) {
        this.sqlServerIssueDao = sqlServerIssueDao;
        this.properties = properties;
        this.dispatcher = dispatcher;
    }

    protected GenericIssueDao getDao() {
        switch (this.properties.getProvider()) {
            case SQLSERVER: {
                return this.sqlServerIssueDao;
            }
        }
        return this.postgresIssueDao;
    }

    public abstract <T extends Issue> T getOne(Long var1, UserInterface var2);

    public <T extends Issue> T create(T issue, UserInterface user) {
        this.getDao().create(issue, user);
        issue.getFileHashList().forEach(f -> this.getDao().addIssueFile(issue, (String)f, user));
        this.getDao().addIssueWatcher(issue, issue.getAuthor().getId().longValue(), user);
        issue.getAssigneeList().forEach(a -> this.addAssignee(issue, a.getId().longValue(), user));
        if (!CollectionUtils.isEmpty(issue.getAttributeList())) {
            this.updateAttributeList(issue, user);
        }
        T created = this.getOne(issue.getId(), user);
        this.dispatcher.dispatch(new IssueCreatedEvent((Issue)created));
        return created;
    }

    public <T extends Issue> void updateAttributeList(T issue, UserInterface user) {
        this.getDao().updateAttributeList(issue, user);
    }

    public <T extends Issue> T updateIssue(T issue, UserInterface user) {
        this.getDao().updateIssue(issue, user);
        this.dispatcher.dispatch(new IssueUpdatedEvent(issue));
        return this.getOne(issue.getId(), user);
    }

    public <T extends Issue> T addIssueWatcher(T issue, Long userId, UserInterface user) {
        this.getDao().addIssueWatcher(issue, userId, user);
        this.dispatcher.dispatch(new WatcherAddedEvent(issue, userId));
        return this.getOne(issue.getId(), user);
    }

    public <T extends Issue> T removeIssueWatcher(T issue, Long userId, UserInterface user) {
        this.getDao().removeIssueWatcher(issue, userId, user);
        return this.getOne(issue.getId(), user);
    }

    public <T extends Issue> T addIssueFile(T issue, String fileHash, UserInterface user) {
        issue.getFileHashList().add(fileHash);
        this.getDao().addIssueFile(issue, fileHash, user);
        return this.getOne(issue.getId(), user);
    }

    public <T extends Issue> T removeIssueFile(T issue, String fileHash, UserInterface user) {
        this.getDao().removeIssueFile(issue, fileHash, user);
        return this.getOne(issue.getId(), user);
    }

    public <T extends Issue> T closeIssue(T issue, UserInterface user) {
        this.getDao().updateStatus(issue, this.properties.getStatus().getClosed(), user);
        return this.getOne(issue.getId(), user);
    }

    public <T extends Issue> T openIssue(T issue, UserInterface user) {
        this.getDao().updateStatus(issue, this.properties.getStatus().getOpen(), user);
        return this.getOne(issue.getId(), user);
    }

    public <T extends Issue> T addComment(T issue, Comment comment, UserInterface user) {
        comment.setIssueId(issue.getId());
        this.getDao().addComment(comment, user);
        this.addIssueWatcher(issue, comment.getAuthor().getId().longValue(), user);
        comment.getFileHashList().forEach(f -> this.getDao().addCommentFile(comment, (String)f, user));
        return this.getOne(issue.getId(), user);
    }

    public <T extends Issue> T removeComment(Comment comment, UserInterface user) {
        this.getDao().removeCommentFile(comment, user);
        this.getDao().removeComment(comment, user);
        return this.getOne(comment.getIssueId(), user);
    }

    public <T extends Issue> T updateComment(Comment comment, UserInterface user) {
        this.getDao().removeCommentFile(comment, user);
        comment.getFileHashList().forEach(f -> this.getDao().addCommentFile(comment, (String)f, user));
        this.getDao().updateComment(comment, user);
        return this.getOne(comment.getIssueId(), user);
    }

    public <T extends Issue> T addAssignee(T issue, Long assigneeId, UserInterface user) {
        this.getDao().addAssignee(issue, assigneeId, user);
        return this.getOne(issue.getId(), user);
    }

    public <T extends Issue> T setAssignee(T issue, Long assigneeId, UserInterface user) {
        this.getDao().setAssignee(issue, assigneeId, user);
        return this.getOne(issue.getId(), user);
    }

    public <T extends Issue> T clearAssignee(T issue, UserInterface user) {
        this.getDao().clearAssignee(issue, user);
        return this.getOne(issue.getId(), user);
    }

    public <T extends Issue> T removeAssignee(T issue, Long assigneeId, UserInterface user) {
        this.getDao().removeAssignee(issue, assigneeId, user);
        return this.getOne(issue.getId(), user);
    }

    public void closeAllByReference(Long referenceId, String referenceType, UserInterface user) {
        this.getDao().closeAllByReference(referenceId, referenceType, this.properties.getStatus().getClosed(), user);
    }
}

