/*
 * Decompiled with CFR 0.152.
 */
package io.lsn.spring.issue.domain;

import io.lsn.spring.issue.domain.entity.event.IssueCreatedEvent;
import io.lsn.spring.issue.domain.entity.event.IssueUpdatedEvent;
import io.lsn.spring.issue.domain.entity.event.WatcherAddedEvent;
import java.util.HashMap;
import java.util.Map;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class EventDispatcher {
    private Map<Class, RTopic> topicList = new HashMap<Class, RTopic>();

    public EventDispatcher(@Qualifier(value="io.lsn.spring.issue.redisson") RedissonClient client) {
        this.topicList.put(IssueCreatedEvent.class, client.getTopic(IssueCreatedEvent.RTOPIC_NAME));
        this.topicList.put(IssueUpdatedEvent.class, client.getTopic(IssueUpdatedEvent.RTOPIC_NAME));
        this.topicList.put(WatcherAddedEvent.class, client.getTopic(WatcherAddedEvent.RTOPIC_NAME));
    }

    public void dispatch(Object event) {
        if (this.topicList == null || this.topicList.isEmpty()) {
            return;
        }
        this.topicList.get(event.getClass()).publish(event);
    }
}

