/*
 * Decompiled with CFR 0.152.
 */
package io.lsn.spring.issue.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.lsn.spring.issue.configuration.IssueProperties;
import io.lsn.spring.utilities.cache.RedissonConfigurationHelper;
import org.mybatis.spring.annotation.MapperScan;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.codec.JsonJacksonCodec;
import org.redisson.config.Config;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={IssueProperties.class})
@MapperScan(value={"io.lsn.spring.issue"})
@ComponentScan(value={"io.lsn"})
public class IssueConfiguration {
    @Bean(name={"io.lsn.spring.issue.redisson"})
    @Autowired
    public RedissonClient redisConnectionFactoryResultCache(ObjectMapper objectMapper, RedisProperties redisProperties, IssueProperties properties) {
        Config config = RedissonConfigurationHelper.getDefaultConfiguration((RedisProperties)redisProperties, (Integer)properties.getCache().getDatabase()).setCodec((Codec)new JsonJacksonCodec(objectMapper));
        return Redisson.create((Config)config);
    }
}

