package io.lsn.spring.issue.domain.sqlserver;

import io.lsn.spring.issue.domain.GenericIssueDao;
import io.lsn.spring.issue.domain.entity.Comment;
import io.lsn.spring.issue.domain.entity.Issue;
import io.lsn.spring.issue.domain.entity.UserInterface;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface SqlServerIssueDao extends GenericIssueDao {
    void create(@Param("issue") Issue issue, @Param("user") UserInterface user);

    String getOneHeader(@Param("id") Long id);

    void updateIssue(@Param("issue") Issue issue, @Param("user") UserInterface user);

    void updateStatus(@Param("issue") Issue issue, @Param("statusCode") String statusCode, @Param("user") UserInterface user);

    void addIssueFile(@Param("issue") Issue issue, @Param("hash") String hash, @Param("user") UserInterface user);

    void removeIssueFile(@Param("issue") Issue issue, @Param("hash") String hash, @Param("user") UserInterface user);

    void addIssueWatcher(@Param("issue") Issue issue, @Param("userId") Long userId, @Param("user") UserInterface user);

    void removeIssueWatcher(@Param("issue") Issue issue, @Param("userId") Long userId, @Param("user") UserInterface user);

    void addComment(@Param("comment") Comment comment, @Param("user") UserInterface user);

    void removeComment(@Param("comment") Comment comment, @Param("user") UserInterface user);

    void addCommentFile(@Param("comment") Comment comment, @Param("hash") String hash, @Param("user") UserInterface user);

    void removeCommentFile(@Param("comment") Comment comment, @Param("user") UserInterface user);

    void updateComment(@Param("comment") Comment comment, @Param("user") UserInterface user);

    void addAssignee(@Param("issue") Issue issue, @Param("assigneeId") Long assigneeId, @Param("user") UserInterface user);

    void removeAssignee(@Param("issue") Issue issue, @Param("assigneeId") Long assigneeId, @Param("user") UserInterface user);

    void closeAllByReference(@Param("referenceId") Long referenceId, @Param("referenceType") String referenceType, @Param("statusCode") String statusCode, @Param("user") UserInterface userInterface);

    void updateAttributeList(@Param("issue") Issue issue, @Param("user") UserInterface user);

    void setAssignee(@Param("issue") Issue issue, @Param("assigneeId") Long assigneeId, @Param("user") UserInterface user);

    void clearAssignee(@Param("issue") Issue issue, @Param("user") UserInterface user);
}
