package io.lsn.spring.issue.domain.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonView;
import io.lsn.spring.issue.domain.IssueInterface;
import io.lsn.spring.utilities.json.views.JsonViews;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

@SuppressWarnings("squid:S1135")
@JsonIgnoreProperties(ignoreUnknown = true)
public abstract class Issue implements IssueInterface {

    private Long id;

    // issue number
    private String number;

    @JsonView(JsonViews.Internal.class)
    private Long uid;

    // issue subject
    private String subject;

    // issue body
    private String description;

    // issue registration date
    private LocalDateTime issueDate;

    // planned finish date for the task
    private LocalDateTime plannedDate;

    // list of additional attributes that describes issue
    private List<Attribute> attributeList;

    private Long referenceId;

    private String referenceType;

    private String externalUserId;

    /**
     * list of assigned users
     *
     * @return List
     */
    public abstract <U extends UserInterface> List<U> getAssigneeList();

    /**
     * list of assigned users
     *
     * @return List
     */
    public abstract <U extends UserInterface> List<U> getWatcherList();

    /**
     * returns type code
     *
     * @return
     */
    public abstract String getTypeCode();

    /**
     * get comment list
     *
     * @return
     */
    public abstract <U extends Comment> List<U> getCommentList();

    public Long getId() {
        return id;
    }

    public Issue setId(Long id) {
        this.id = id;
        return this;
    }

    public String getNumber() {
        return number;
    }

    public Issue setNumber(String number) {
        this.number = number;
        return this;
    }

    public Long getUid() {
        return uid;
    }

    public Issue setUid(Long uid) {
        this.uid = uid;
        return this;
    }

    public String getSubject() {
        return subject;
    }

    public Issue setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public String getDescription() {
        return description;
    }

    public Issue setDescription(String description) {
        this.description = description;
        return this;
    }

    public LocalDateTime getIssueDate() {
        if (issueDate == null) {
            issueDate = LocalDateTime.now();
        }
        return issueDate;
    }

    public Issue setIssueDate(LocalDateTime issueDate) {
        this.issueDate = issueDate;
        return this;
    }

    public LocalDateTime getPlannedDate() {
        return plannedDate;
    }

    public Issue setPlannedDate(LocalDateTime plannedDate) {
        this.plannedDate = plannedDate;
        return this;
    }

    public List<Attribute> getAttributeList() {
        if (attributeList == null) {
            attributeList = new ArrayList<>();
        }
        return attributeList;
    }

    public Issue setAttributeList(List<Attribute> attributeList) {
        this.attributeList = attributeList;
        return this;
    }

    public Long getReferenceId() {
        return referenceId;
    }

    public Issue setReferenceId(Long referenceId) {
        this.referenceId = referenceId;
        return this;
    }

    public String getReferenceType() {
        return referenceType;
    }

    public Issue setReferenceType(String referenceType) {
        this.referenceType = referenceType;
        return this;
    }

    public String getExternalUserId() {
        return externalUserId;
    }

    public Issue setExternalUserId(String externalUserId) {
        this.externalUserId = externalUserId;
        return this;
    }
}
