package io.lsn.spring.issue.domain;

import io.lsn.spring.issue.domain.entity.UserInterface;

import java.util.List;

/**
 * @author Patryk Szlagowski <patryksz@lsnova.pl>
 */
public interface IssueInterface {

    /**
     * returns issue author
     *
     * @return
     */
    UserInterface getAuthor();

    /**
     * get list of file hash codes
     *
     * @return
     */
    List<String> getFileHashList();

    /**
     * returns status code
     *
     * @return
     */
    String getStatusCode();

    /**
     * returns priority code
     *
     * @return
     */
    String getPriorityCode();

    /**
     * returns type code
     *
     * @return
     */
    String getTypeCode();
}
