package io.lsn.spring.issue.domain;

import io.lsn.spring.issue.domain.entity.event.IssueCreatedEvent;
import io.lsn.spring.issue.domain.entity.event.IssueUpdatedEvent;
import io.lsn.spring.issue.domain.entity.event.WatcherAddedEvent;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * wrapper for topic collection
 *
 * @author Patryk Szlagowski <patryksz@lsnova.pl>
 */
@Service
public class EventDispatcher {

    private Map<Class, RTopic> topicList = new HashMap<>();

    public EventDispatcher(@Qualifier("io.lsn.spring.issue.redisson") RedissonClient client) {
        topicList.put(IssueCreatedEvent.class, client.getTopic(IssueCreatedEvent.RTOPIC_NAME));
        topicList.put(IssueUpdatedEvent.class, client.getTopic(IssueUpdatedEvent.RTOPIC_NAME));
        topicList.put(WatcherAddedEvent.class, client.getTopic(WatcherAddedEvent.RTOPIC_NAME));
    }

    /**
     * get topic for specific event class and broadcast the event
     *
     * @param event
     */
    public void dispatch(Object event) {
        if (topicList == null || topicList.isEmpty()) {
            return;
        }

        topicList.get(event.getClass()).publish(event);
    }
}
