/*
 * Decompiled with CFR 0.152.
 */
package io.lsn.spring.issue.domain.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonView;
import io.lsn.spring.issue.domain.IssueInterface;
import io.lsn.spring.issue.domain.entity.Attribute;
import io.lsn.spring.issue.domain.entity.Comment;
import io.lsn.spring.issue.domain.entity.UserInterface;
import io.lsn.spring.utilities.json.views.JsonViews;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class Issue
implements IssueInterface {
    private Long id;
    private String number;
    @JsonView(value={JsonViews.Internal.class})
    private Long uid;
    private String subject;
    private String description;
    private LocalDateTime issueDate;
    private LocalDateTime plannedDate;
    private List<Attribute> attributeList;
    private Long referenceId;
    private String referenceType;
    private String externalUserId;

    public abstract <U extends UserInterface> List<U> getAssigneeList();

    public abstract <U extends UserInterface> List<U> getWatcherList();

    @Override
    public abstract String getTypeCode();

    public abstract <U extends Comment> List<U> getCommentList();

    public Long getId() {
        return this.id;
    }

    public Issue setId(Long id) {
        this.id = id;
        return this;
    }

    public String getNumber() {
        return this.number;
    }

    public Issue setNumber(String number) {
        this.number = number;
        return this;
    }

    public Long getUid() {
        return this.uid;
    }

    public Issue setUid(Long uid) {
        this.uid = uid;
        return this;
    }

    public String getSubject() {
        return this.subject;
    }

    public Issue setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Issue setDescription(String description) {
        this.description = description;
        return this;
    }

    public LocalDateTime getIssueDate() {
        if (this.issueDate == null) {
            this.issueDate = LocalDateTime.now();
        }
        return this.issueDate;
    }

    public Issue setIssueDate(LocalDateTime issueDate) {
        this.issueDate = issueDate;
        return this;
    }

    public LocalDateTime getPlannedDate() {
        return this.plannedDate;
    }

    public Issue setPlannedDate(LocalDateTime plannedDate) {
        this.plannedDate = plannedDate;
        return this;
    }

    public List<Attribute> getAttributeList() {
        if (this.attributeList == null) {
            this.attributeList = new ArrayList<Attribute>();
        }
        return this.attributeList;
    }

    public Issue setAttributeList(List<Attribute> attributeList) {
        this.attributeList = attributeList;
        return this;
    }

    public Long getReferenceId() {
        return this.referenceId;
    }

    public Issue setReferenceId(Long referenceId) {
        this.referenceId = referenceId;
        return this;
    }

    public String getReferenceType() {
        return this.referenceType;
    }

    public Issue setReferenceType(String referenceType) {
        this.referenceType = referenceType;
        return this;
    }

    public String getExternalUserId() {
        return this.externalUserId;
    }

    public Issue setExternalUserId(String externalUserId) {
        this.externalUserId = externalUserId;
        return this;
    }
}

