/*
 * Decompiled with CFR 0.152.
 */
package io.lsn.spring.issue.domain.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Attribute {
    private String code;
    private AttributeType type;
    private String stringValue;
    private Long longValue;
    private BigDecimal decimalValue;
    private LocalDate dateValue;
    private LocalDateTime dateTimeValue;

    public Attribute() {
    }

    public Attribute(String code, Object value, AttributeType type) {
        this.code = code;
        this.type = type;
        this.setAttributeValue(value);
    }

    public Attribute(String code, String value) {
        this.code = code;
        this.type = AttributeType.STRING;
        this.setAttributeValue(value);
    }

    public Attribute(String code, Long value) {
        this.code = code;
        this.type = AttributeType.LONG;
        this.setAttributeValue(value);
    }

    public Attribute(String code, BigDecimal value) {
        this.code = code;
        this.type = AttributeType.DECIMAL;
        this.setAttributeValue(value);
    }

    public Attribute(String code, LocalDate value) {
        this.code = code;
        this.type = AttributeType.DATE;
        this.setAttributeValue(value);
    }

    public Attribute(String code, LocalDateTime value) {
        this.code = code;
        this.type = AttributeType.DATETIME;
        this.setAttributeValue(value);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public AttributeType getType() {
        return this.type;
    }

    public void setType(AttributeType type) {
        this.type = type;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(String stringValue) {
        this.stringValue = stringValue;
    }

    public Long getLongValue() {
        return this.longValue;
    }

    public void setLongValue(Long longValue) {
        this.longValue = longValue;
    }

    public BigDecimal getDecimalValue() {
        return this.decimalValue;
    }

    public void setDecimalValue(BigDecimal decimalValue) {
        this.decimalValue = decimalValue;
    }

    public LocalDate getDateValue() {
        return this.dateValue;
    }

    public void setDateValue(LocalDate dateValue) {
        this.dateValue = dateValue;
    }

    public LocalDateTime getDateTimeValue() {
        return this.dateTimeValue;
    }

    public void setDateTimeValue(LocalDateTime dateTimeValue) {
        this.dateTimeValue = dateTimeValue;
    }

    @JsonIgnore
    public void setAttributeValue(Long value) {
        this.setLongValue(value);
    }

    @JsonIgnore
    public void setAttributeValue(String value) {
        this.setStringValue(value);
    }

    @JsonIgnore
    public void setAttributeValue(BigDecimal value) {
        this.setDecimalValue(value);
    }

    @JsonIgnore
    public void setAttributeValue(LocalDate value) {
        this.setDateValue(value);
    }

    @JsonIgnore
    public void setAttributeValue(LocalDateTime value) {
        this.setDateTimeValue(value);
    }

    @JsonIgnore
    public void setAttributeValue(Object value) {
        switch (this.type) {
            case STRING: {
                this.setStringValue((String)value);
                break;
            }
            case LONG: {
                this.setLongValue((Long)value);
                break;
            }
            case DECIMAL: {
                this.setDecimalValue((BigDecimal)value);
                break;
            }
            case DATE: {
                this.setDateValue((LocalDate)value);
                break;
            }
            case DATETIME: {
                this.setDateTimeValue((LocalDateTime)value);
                break;
            }
        }
    }

    @JsonIgnore
    public Object getAttributeValue() {
        switch (this.type) {
            case STRING: {
                return this.getStringValue();
            }
            case LONG: {
                return this.getLongValue();
            }
            case DECIMAL: {
                return this.getDecimalValue();
            }
            case DATE: {
                return this.getDateValue();
            }
            case DATETIME: {
                return this.getDateTimeValue();
            }
        }
        return null;
    }

    public static enum AttributeType {
        STRING,
        LONG,
        DECIMAL,
        DATE,
        DATETIME;

    }
}

