package io.lsn.spring.issue.configuration;

import org.springframework.boot.context.properties.ConfigurationProperties;
import io.lsn.spring.utilities.cache.entity.CacheProperties;
@ConfigurationProperties(prefix = "io.lsn.spring.issue")
public class IssueProperties {

    public enum Provider {
        POSTGRESQL("postgresql"),
        SQLSERVER("sqlserver");

        private String value;

        Provider(String value) {
            this.value = value;
        }
    }

    private StatusProperties status;

    private Provider provider = Provider.POSTGRESQL;

    private CacheProperties cache = new CacheProperties();

    public StatusProperties getStatus() {
        if (status == null) {
            status = new StatusProperties();
        }
        return status;
    }

    public void setStatus(StatusProperties status) {
        this.status = status;
    }

    public Provider getProvider() {
        return provider;
    }

    public void setProvider(Provider provider) {
        this.provider = provider;
    }

    public CacheProperties getCache() {
        return cache;
    }

    public void setCache(CacheProperties cache) {
        this.cache = cache;
    }
}
