package io.lsn.spring.issue.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.lsn.spring.utilities.cache.RedissonConfigurationHelper;
import org.mybatis.spring.annotation.MapperScan;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.codec.JsonJacksonCodec;
import org.redisson.config.Config;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties({IssueProperties.class})
@MapperScan({"io.lsn.spring.issue"})
@ComponentScan("io.lsn")
public class IssueConfiguration {

    @Bean(name = "io.lsn.spring.issue.redisson")
    @Autowired
    public RedissonClient redisConnectionFactoryResultCache(ObjectMapper objectMapper, RedisProperties redisProperties, IssueProperties properties) {
        Config config = RedissonConfigurationHelper.getDefaultConfiguration(redisProperties, properties.getCache().getDatabase())
                .setCodec(new JsonJacksonCodec(objectMapper));
        return Redisson.create(config);
    }
}
