package io.lsn.spring.issue.domain.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonView;
import io.lsn.spring.issue.domain.IssueInterface;
import io.lsn.spring.utilities.json.views.JsonViews;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

@SuppressWarnings("squid:S1135")
@JsonIgnoreProperties(ignoreUnknown = true)
public abstract class Issue implements IssueInterface {

    private Long id;

    // issue number
    private String number;

    @JsonView(JsonViews.Internal.class)
    private Long uid;

    // issue subject
    private String subject;

    // issue body
    private String description;

    // issue registration date
    private LocalDateTime issueDate;

    // planned finish date for the task
    private LocalDateTime plannedDate;

    // list of additional attributes that describes issue
    private List<Attribute> attributeList;

    private Long referenceId;

    private String referenceType;

    private String externalUserId;

    /**
     * list of assigned users
     *
     * @return List
     */
    public abstract <U extends UserInterface> List<U> getAssigneeList();

    /**
     * list of assigned users
     *
     * @return List
     */
    public abstract <U extends UserInterface> List<U> getWatcherList();

    /**
     * returns type code
     *
     * @return
     */
    public abstract String getTypeCode();

    /**
     * get comment list
     *
     * @return
     */
    public abstract <U extends Comment> List<U> getCommentList();

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Long getUid() {
        return uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public LocalDateTime getIssueDate() {
        if (issueDate == null) {
            issueDate = LocalDateTime.now();
        }
        return issueDate;
    }

    public void setIssueDate(LocalDateTime issueDate) {
        this.issueDate = issueDate;
    }

    public LocalDateTime getPlannedDate() {
        return plannedDate;
    }

    public void setPlannedDate(LocalDateTime plannedDate) {
        this.plannedDate = plannedDate;
    }

    public List<Attribute> getAttributeList() {
        if (attributeList == null) {
            attributeList = new ArrayList<>();
        }
        return attributeList;
    }

    public void setAttributeList(List<Attribute> attributeList) {
        this.attributeList = attributeList;
    }

    public Long getReferenceId() {
        return referenceId;
    }

    public void setReferenceId(Long referenceId) {
        this.referenceId = referenceId;
    }

    public String getReferenceType() {
        return referenceType;
    }

    public void setReferenceType(String referenceType) {
        this.referenceType = referenceType;
    }

    public String getExternalUserId() {
        return externalUserId;
    }

    public void setExternalUserId(String externalUserId) {
        this.externalUserId = externalUserId;
    }

}
