package io.lsn.spring.issue.domain.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;


@JsonIgnoreProperties(ignoreUnknown = true)
public class Attribute {

    public enum AttributeType {
        STRING,
        LONG,
        DECIMAL,
        DATE,
        DATETIME
    }

    public Attribute() {
    }

    public Attribute(String code, Object value, AttributeType type) {
        this.code = code;
        this.type = type;
        setAttributeValue(value);
    }

    public Attribute(String code, String value) {
        this.code = code;
        this.type = AttributeType.STRING;
        setAttributeValue(value);
    }

    public Attribute(String code, Long value) {
        this.code = code;
        this.type = AttributeType.LONG;
        setAttributeValue(value);
    }

    public Attribute(String code, BigDecimal value) {
        this.code = code;
        this.type = AttributeType.DECIMAL;
        setAttributeValue(value);
    }

    public Attribute(String code, LocalDate value) {
        this.code = code;
        this.type = AttributeType.DATE;
        setAttributeValue(value);
    }

    public Attribute(String code, LocalDateTime value) {
        this.code = code;
        this.type = AttributeType.DATETIME;
        setAttributeValue(value);
    }


    private String code;

    private AttributeType type;

    private String stringValue;

    private Long longValue;

    private BigDecimal decimalValue;

    private LocalDate dateValue;

    private LocalDateTime dateTimeValue;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public AttributeType getType() {
        return type;
    }

    public void setType(AttributeType type) {
        this.type = type;
    }

    public String getStringValue() {
        return stringValue;
    }

    public void setStringValue(String stringValue) {
        this.stringValue = stringValue;
    }

    public Long getLongValue() {
        return longValue;
    }

    public void setLongValue(Long longValue) {
        this.longValue = longValue;
    }

    public BigDecimal getDecimalValue() {
        return decimalValue;
    }

    public void setDecimalValue(BigDecimal decimalValue) {
        this.decimalValue = decimalValue;
    }

    public LocalDate getDateValue() {
        return dateValue;
    }

    public void setDateValue(LocalDate dateValue) {
        this.dateValue = dateValue;
    }

    public LocalDateTime getDateTimeValue() {
        return dateTimeValue;
    }

    public void setDateTimeValue(LocalDateTime dateTimeValue) {
        this.dateTimeValue = dateTimeValue;
    }


    // -- helper setters

    @JsonIgnore
    public void setAttributeValue(Long value) {
        setLongValue(value);
    }

    @JsonIgnore
    public void setAttributeValue(String value) {
        setStringValue(value);
    }

    @JsonIgnore
    public void setAttributeValue(BigDecimal value) {
        setDecimalValue(value);
    }

    @JsonIgnore
    public void setAttributeValue(LocalDate value) {
        setDateValue(value);
    }

    @JsonIgnore
    public void setAttributeValue(LocalDateTime value) {
        setDateTimeValue(value);
    }

    @JsonIgnore
    public void setAttributeValue(Object value) {
        switch (type) {
            case STRING:
                setStringValue((String) value);
                break;
            case LONG:
                setLongValue((Long) value);
                break;
            case DECIMAL:
                setDecimalValue((BigDecimal) value);
                break;
            case DATE:
                setDateValue((LocalDate) value);
                break;
            case DATETIME:
                setDateTimeValue((LocalDateTime) value);
                break;
            default:
                break;
        }
    }

    // -- helper getter

    @JsonIgnore
    public Object getAttributeValue() {
        switch (type) {
            case STRING:
                return getStringValue();
            case LONG:
                return getLongValue();
            case DECIMAL:
                return getDecimalValue();
            case DATE:
                return getDateValue();
            case DATETIME:
                return getDateTimeValue();
            default:
                return null;
        }
    }
}
