/*
 * Decompiled with CFR 0.152.
 */
package io.lsn.spring.issue.domain.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonView;
import io.lsn.spring.issue.domain.IssueInterface;
import io.lsn.spring.issue.domain.entity.Attribute;
import io.lsn.spring.issue.domain.entity.Comment;
import io.lsn.spring.issue.domain.entity.UserInterface;
import io.lsn.spring.utilities.json.views.JsonViews;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class Issue
implements IssueInterface {
    private Long id;
    private String number;
    @JsonView(value={JsonViews.Internal.class})
    private Long uid;
    private String subject;
    private String description;
    private LocalDateTime issueDate;
    private LocalDateTime plannedDate;
    private List<Attribute> attributeList;
    private Long referenceId;
    private String referenceType;
    private String externalUserId;

    public abstract <U extends UserInterface> List<U> getAssigneeList();

    public abstract <U extends UserInterface> List<U> getWatcherList();

    @Override
    public abstract String getTypeCode();

    public abstract <U extends Comment> List<U> getCommentList();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Long getUid() {
        return this.uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public LocalDateTime getIssueDate() {
        if (this.issueDate == null) {
            this.issueDate = LocalDateTime.now();
        }
        return this.issueDate;
    }

    public void setIssueDate(LocalDateTime issueDate) {
        this.issueDate = issueDate;
    }

    public LocalDateTime getPlannedDate() {
        return this.plannedDate;
    }

    public void setPlannedDate(LocalDateTime plannedDate) {
        this.plannedDate = plannedDate;
    }

    public List<Attribute> getAttributeList() {
        if (this.attributeList == null) {
            this.attributeList = new ArrayList<Attribute>();
        }
        return this.attributeList;
    }

    public void setAttributeList(List<Attribute> attributeList) {
        this.attributeList = attributeList;
    }

    public Long getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(Long referenceId) {
        this.referenceId = referenceId;
    }

    public String getReferenceType() {
        return this.referenceType;
    }

    public void setReferenceType(String referenceType) {
        this.referenceType = referenceType;
    }

    public String getExternalUserId() {
        return this.externalUserId;
    }

    public void setExternalUserId(String externalUserId) {
        this.externalUserId = externalUserId;
    }
}

