/*
 * Decompiled with CFR 0.152.
 */
package io.lsn.spring.issue.domain;

import io.lsn.spring.issue.configuration.IssueProperties;
import io.lsn.spring.issue.domain.EventDispatcher;
import io.lsn.spring.issue.domain.IssueDao;
import io.lsn.spring.issue.domain.entity.Comment;
import io.lsn.spring.issue.domain.entity.Issue;
import io.lsn.spring.issue.domain.entity.UserInterface;
import io.lsn.spring.issue.domain.entity.event.IssueCreatedEvent;
import io.lsn.spring.issue.domain.entity.event.IssueUpdatedEvent;
import io.lsn.spring.issue.domain.entity.event.WatcherAddedEvent;
import org.springframework.util.CollectionUtils;

public abstract class IssueAbstractService {
    private IssueDao dao;
    private EventDispatcher dispatcher;
    private IssueProperties properties;

    public IssueAbstractService(IssueDao dao, IssueProperties properties, EventDispatcher dispatcher) {
        this.dao = dao;
        this.properties = properties;
        this.dispatcher = dispatcher;
    }

    public abstract <T extends Issue> T getOne(Long var1, UserInterface var2);

    public <T extends Issue> T create(T issue, UserInterface user) {
        this.dao.create(issue, user);
        issue.getFileHashList().forEach(f -> this.dao.addIssueFile(issue, (String)f, user));
        this.dao.addIssueWatcher(issue, issue.getAuthor().getId().longValue(), user);
        issue.getAssigneeList().forEach(a -> this.addAssignee(issue, a.getId().longValue(), user));
        if (!CollectionUtils.isEmpty(issue.getAttributeList())) {
            this.updateAttributeList(issue, user);
        }
        T created = this.getOne(issue.getId(), user);
        this.dispatcher.dispatch(new IssueCreatedEvent((Issue)created));
        return created;
    }

    public <T extends Issue> void updateAttributeList(T issue, UserInterface user) {
        this.dao.updateAttributeList(issue, user);
    }

    public <T extends Issue> T updateIssue(T issue, UserInterface user) {
        this.dao.updateIssue(issue, user);
        this.dispatcher.dispatch(new IssueUpdatedEvent(issue));
        return this.getOne(issue.getId(), user);
    }

    public <T extends Issue> T addIssueWatcher(T issue, Long userId, UserInterface user) {
        this.dao.addIssueWatcher(issue, userId, user);
        this.dispatcher.dispatch(new WatcherAddedEvent(issue, userId));
        return this.getOne(issue.getId(), user);
    }

    public <T extends Issue> T removeIssueWatcher(T issue, Long userId, UserInterface user) {
        this.dao.removeIssueWatcher(issue, userId, user);
        return this.getOne(issue.getId(), user);
    }

    public <T extends Issue> T addIssueFile(T issue, String fileHash, UserInterface user) {
        issue.getFileHashList().add(fileHash);
        this.dao.addIssueFile(issue, fileHash, user);
        return this.getOne(issue.getId(), user);
    }

    public <T extends Issue> T removeIssueFile(T issue, String fileHash, UserInterface user) {
        this.dao.removeIssueFile(issue, fileHash, user);
        return this.getOne(issue.getId(), user);
    }

    public <T extends Issue> T closeIssue(T issue, UserInterface user) {
        this.dao.updateStatus(issue, this.properties.getStatus().getClosed(), user);
        return this.getOne(issue.getId(), user);
    }

    public <T extends Issue> T openIssue(T issue, UserInterface user) {
        this.dao.updateStatus(issue, this.properties.getStatus().getOpen(), user);
        return this.getOne(issue.getId(), user);
    }

    public <T extends Issue> T addComment(T issue, Comment comment, UserInterface user) {
        comment.setIssueId(issue.getId());
        this.dao.addComment(comment, user);
        this.addIssueWatcher(issue, comment.getAuthor().getId().longValue(), user);
        comment.getFileHashList().forEach(f -> this.dao.addCommentFile(comment, (String)f, user));
        return this.getOne(issue.getId(), user);
    }

    public <T extends Issue> T removeComment(Comment comment, UserInterface user) {
        this.dao.removeCommentFile(comment, user);
        this.dao.removeComment(comment, user);
        return this.getOne(comment.getIssueId(), user);
    }

    public <T extends Issue> T updateComment(Comment comment, UserInterface user) {
        this.dao.removeCommentFile(comment, user);
        comment.getFileHashList().forEach(f -> this.dao.addCommentFile(comment, (String)f, user));
        this.dao.updateComment(comment, user);
        return this.getOne(comment.getIssueId(), user);
    }

    public <T extends Issue> T addAssignee(T issue, Long assigneeId, UserInterface user) {
        this.dao.addAssignee(issue, assigneeId, user);
        return this.getOne(issue.getId(), user);
    }

    public <T extends Issue> T removeAssignee(T issue, Long assigneeId, UserInterface user) {
        this.dao.removeAssignee(issue, assigneeId, user);
        return this.getOne(issue.getId(), user);
    }

    public void closeAllByReference(Long referenceId, String referenceType, UserInterface user) {
        this.dao.closeAllByReference(referenceId, referenceType, this.properties.getStatus().getClosed(), user);
    }
}

