/*
 * Decompiled with CFR 0.152.
 */
package io.lsn.spring.issue.domain;

import io.lsn.spring.issue.domain.entity.event.IssueCreatedEvent;
import io.lsn.spring.issue.domain.entity.event.IssueUpdatedEvent;
import io.lsn.spring.issue.domain.entity.event.WatcherAddedEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.springframework.stereotype.Service;

@Service
public class EventDispatcher {
    private Map<Class, RTopic> topicList = new HashMap<Class, RTopic>();

    public EventDispatcher(Optional<RedissonClient> client) {
        client.ifPresent(c -> {
            this.topicList.put(IssueCreatedEvent.class, c.getTopic(IssueCreatedEvent.RTOPIC_NAME));
            this.topicList.put(IssueUpdatedEvent.class, c.getTopic(IssueUpdatedEvent.RTOPIC_NAME));
            this.topicList.put(WatcherAddedEvent.class, c.getTopic(WatcherAddedEvent.RTOPIC_NAME));
        });
    }

    public void dispatch(Object event) {
        if (this.topicList == null || this.topicList.isEmpty()) {
            return;
        }
        this.topicList.get(event.getClass()).publish(event);
    }
}

