package io.lsn.spring.issue.domain.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonView;
import io.lsn.spring.utilities.json.views.JsonViews;

import java.time.LocalDateTime;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown = true)
public abstract class Comment {

    @SuppressWarnings("squid:S1068")
    private Long id;

    @JsonView(JsonViews.Internal.class)
    @SuppressWarnings("squid:S1068")
    private Long uid;

    private Long issueId;

    private String body;

    private LocalDateTime commentDate;


    /**
     * get author of the comment
     *
     * @return
     */
    public abstract UserInterface getAuthor();


    /**
     * get list of file hash codes
     *
     * @return
     */
    public abstract List<String> getFileHashList();


    public Long getIssueId() {
        return issueId;
    }

    public void setIssueId(Long issueId) {
        this.issueId = issueId;
    }

    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }


    public LocalDateTime getCommentDate() {
        return commentDate;
    }

    public void setCommentDate(LocalDateTime commentDate) {
        this.commentDate = commentDate;
    }

}
