package io.lsn.spring.issue.domain;

import io.lsn.spring.issue.domain.entity.event.IssueCreatedEvent;
import io.lsn.spring.issue.domain.entity.event.IssueUpdatedEvent;
import io.lsn.spring.issue.domain.entity.event.WatcherAddedEvent;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

/**
 * wrapper for topic collection
 *
 * @author Patryk Szlagowski <patryksz@lsnova.pl>
 */
@Service
public class EventDispatcher {

    private Map<Class, RTopic> topicList = new HashMap<>();

    public EventDispatcher(Optional<RedissonClient> client) {
        client.ifPresent(c -> {
            topicList.put(IssueCreatedEvent.class, c.getTopic(IssueCreatedEvent.RTOPIC_NAME));
            topicList.put(IssueUpdatedEvent.class, c.getTopic(IssueUpdatedEvent.RTOPIC_NAME));
            topicList.put(WatcherAddedEvent.class, c.getTopic(WatcherAddedEvent.RTOPIC_NAME));
        });
    }

    /**
     * get topic for specific event class and broadcast the event
     *
     * @param event
     */
    public void dispatch(Object event) {
        if (topicList == null || topicList.isEmpty()) {
            return;
        }

        topicList.get(event.getClass()).publish(event);
    }
}
